/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a custom rewrite or redirect rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomRule implements SdkPojo, Serializable, ToCopyableBuilder<CustomRule.Builder, CustomRule> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(CustomRule::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("target")
            .getter(getter(CustomRule::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CustomRule::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("condition").getter(getter(CustomRule::condition)).setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, TARGET_FIELD,
            STATUS_FIELD, CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String source;

    private final String target;

    private final String status;

    private final String condition;

    private CustomRule(BuilderImpl builder) {
        this.source = builder.source;
        this.target = builder.target;
        this.status = builder.status;
        this.condition = builder.condition;
    }

    /**
     * <p>
     * The source pattern for a URL rewrite or redirect rule.
     * </p>
     * 
     * @return The source pattern for a URL rewrite or redirect rule.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The target pattern for a URL rewrite or redirect rule.
     * </p>
     * 
     * @return The target pattern for a URL rewrite or redirect rule.
     */
    public final String target() {
        return target;
    }

    /**
     * <p>
     * The status code for a URL rewrite or redirect rule.
     * </p>
     * <dl>
     * <dt>200</dt>
     * <dd>
     * <p>
     * Represents a 200 rewrite rule.
     * </p>
     * </dd>
     * <dt>301</dt>
     * <dd>
     * <p>
     * Represents a 301 (moved permanently) redirect rule. This and all future requests should be directed to the target
     * URL.
     * </p>
     * </dd>
     * <dt>302</dt>
     * <dd>
     * <p>
     * Represents a 302 temporary redirect rule.
     * </p>
     * </dd>
     * <dt>404</dt>
     * <dd>
     * <p>
     * Represents a 404 redirect rule.
     * </p>
     * </dd>
     * <dt>404-200</dt>
     * <dd>
     * <p>
     * Represents a 404 rewrite rule.
     * </p>
     * </dd>
     * </dl>
     * 
     * @return The status code for a URL rewrite or redirect rule. </p>
     *         <dl>
     *         <dt>200</dt>
     *         <dd>
     *         <p>
     *         Represents a 200 rewrite rule.
     *         </p>
     *         </dd>
     *         <dt>301</dt>
     *         <dd>
     *         <p>
     *         Represents a 301 (moved permanently) redirect rule. This and all future requests should be directed to
     *         the target URL.
     *         </p>
     *         </dd>
     *         <dt>302</dt>
     *         <dd>
     *         <p>
     *         Represents a 302 temporary redirect rule.
     *         </p>
     *         </dd>
     *         <dt>404</dt>
     *         <dd>
     *         <p>
     *         Represents a 404 redirect rule.
     *         </p>
     *         </dd>
     *         <dt>404-200</dt>
     *         <dd>
     *         <p>
     *         Represents a 404 rewrite rule.
     *         </p>
     *         </dd>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The condition for a URL rewrite or redirect rule, such as a country code.
     * </p>
     * 
     * @return The condition for a URL rewrite or redirect rule, such as a country code.
     */
    public final String condition() {
        return condition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomRule)) {
            return false;
        }
        CustomRule other = (CustomRule) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(target(), other.target())
                && Objects.equals(status(), other.status()) && Objects.equals(condition(), other.condition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomRule").add("Source", source()).add("Target", target()).add("Status", status())
                .add("Condition", condition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "condition":
            return Optional.ofNullable(clazz.cast(condition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("source", SOURCE_FIELD);
        map.put("target", TARGET_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("condition", CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomRule, T> g) {
        return obj -> g.apply((CustomRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomRule> {
        /**
         * <p>
         * The source pattern for a URL rewrite or redirect rule.
         * </p>
         * 
         * @param source
         *        The source pattern for a URL rewrite or redirect rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The target pattern for a URL rewrite or redirect rule.
         * </p>
         * 
         * @param target
         *        The target pattern for a URL rewrite or redirect rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * The status code for a URL rewrite or redirect rule.
         * </p>
         * <dl>
         * <dt>200</dt>
         * <dd>
         * <p>
         * Represents a 200 rewrite rule.
         * </p>
         * </dd>
         * <dt>301</dt>
         * <dd>
         * <p>
         * Represents a 301 (moved permanently) redirect rule. This and all future requests should be directed to the
         * target URL.
         * </p>
         * </dd>
         * <dt>302</dt>
         * <dd>
         * <p>
         * Represents a 302 temporary redirect rule.
         * </p>
         * </dd>
         * <dt>404</dt>
         * <dd>
         * <p>
         * Represents a 404 redirect rule.
         * </p>
         * </dd>
         * <dt>404-200</dt>
         * <dd>
         * <p>
         * Represents a 404 rewrite rule.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status code for a URL rewrite or redirect rule. </p>
         *        <dl>
         *        <dt>200</dt>
         *        <dd>
         *        <p>
         *        Represents a 200 rewrite rule.
         *        </p>
         *        </dd>
         *        <dt>301</dt>
         *        <dd>
         *        <p>
         *        Represents a 301 (moved permanently) redirect rule. This and all future requests should be directed to
         *        the target URL.
         *        </p>
         *        </dd>
         *        <dt>302</dt>
         *        <dd>
         *        <p>
         *        Represents a 302 temporary redirect rule.
         *        </p>
         *        </dd>
         *        <dt>404</dt>
         *        <dd>
         *        <p>
         *        Represents a 404 redirect rule.
         *        </p>
         *        </dd>
         *        <dt>404-200</dt>
         *        <dd>
         *        <p>
         *        Represents a 404 rewrite rule.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The condition for a URL rewrite or redirect rule, such as a country code.
         * </p>
         * 
         * @param condition
         *        The condition for a URL rewrite or redirect rule, such as a country code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(String condition);
    }

    static final class BuilderImpl implements Builder {
        private String source;

        private String target;

        private String status;

        private String condition;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomRule model) {
            source(model.source);
            target(model.target);
            status(model.status);
            condition(model.condition);
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getCondition() {
            return condition;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public CustomRule build() {
            return new CustomRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
