/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Electronic Data Interchange (EDI) entity as described in as defined in <a
 * href="https://datatracker.ietf.org/doc/html/rfc5280">Subject Alternative Name</a> in RFC 5280.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EdiPartyName implements SdkPojo, Serializable, ToCopyableBuilder<EdiPartyName.Builder, EdiPartyName> {
    private static final SdkField<String> PARTY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartyName").getter(getter(EdiPartyName::partyName)).setter(setter(Builder::partyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartyName").build()).build();

    private static final SdkField<String> NAME_ASSIGNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameAssigner").getter(getter(EdiPartyName::nameAssigner)).setter(setter(Builder::nameAssigner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameAssigner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTY_NAME_FIELD,
            NAME_ASSIGNER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String partyName;

    private final String nameAssigner;

    private EdiPartyName(BuilderImpl builder) {
        this.partyName = builder.partyName;
        this.nameAssigner = builder.nameAssigner;
    }

    /**
     * <p>
     * Specifies the party name.
     * </p>
     * 
     * @return Specifies the party name.
     */
    public final String partyName() {
        return partyName;
    }

    /**
     * <p>
     * Specifies the name assigner.
     * </p>
     * 
     * @return Specifies the name assigner.
     */
    public final String nameAssigner() {
        return nameAssigner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(partyName());
        hashCode = 31 * hashCode + Objects.hashCode(nameAssigner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdiPartyName)) {
            return false;
        }
        EdiPartyName other = (EdiPartyName) obj;
        return Objects.equals(partyName(), other.partyName()) && Objects.equals(nameAssigner(), other.nameAssigner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EdiPartyName").add("PartyName", partyName()).add("NameAssigner", nameAssigner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PartyName":
            return Optional.ofNullable(clazz.cast(partyName()));
        case "NameAssigner":
            return Optional.ofNullable(clazz.cast(nameAssigner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PartyName", PARTY_NAME_FIELD);
        map.put("NameAssigner", NAME_ASSIGNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EdiPartyName, T> g) {
        return obj -> g.apply((EdiPartyName) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EdiPartyName> {
        /**
         * <p>
         * Specifies the party name.
         * </p>
         * 
         * @param partyName
         *        Specifies the party name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partyName(String partyName);

        /**
         * <p>
         * Specifies the name assigner.
         * </p>
         * 
         * @param nameAssigner
         *        Specifies the name assigner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameAssigner(String nameAssigner);
    }

    static final class BuilderImpl implements Builder {
        private String partyName;

        private String nameAssigner;

        private BuilderImpl() {
        }

        private BuilderImpl(EdiPartyName model) {
            partyName(model.partyName);
            nameAssigner(model.nameAssigner);
        }

        public final String getPartyName() {
            return partyName;
        }

        public final void setPartyName(String partyName) {
            this.partyName = partyName;
        }

        @Override
        public final Builder partyName(String partyName) {
            this.partyName = partyName;
            return this;
        }

        public final String getNameAssigner() {
            return nameAssigner;
        }

        public final void setNameAssigner(String nameAssigner) {
            this.nameAssigner = nameAssigner;
        }

        @Override
        public final Builder nameAssigner(String nameAssigner) {
            this.nameAssigner = nameAssigner;
            return this;
        }

        @Override
        public EdiPartyName build() {
            return new EdiPartyName(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
