/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides access information used by the <code>authorityInfoAccess</code> and <code>subjectInfoAccess</code>
 * extensions described in <a href="https://datatracker.ietf.org/doc/html/rfc5280">RFC 5280</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessDescription.Builder, AccessDescription> {
    private static final SdkField<AccessMethod> ACCESS_METHOD_FIELD = SdkField.<AccessMethod> builder(MarshallingType.SDK_POJO)
            .memberName("AccessMethod").getter(getter(AccessDescription::accessMethod)).setter(setter(Builder::accessMethod))
            .constructor(AccessMethod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessMethod").build()).build();

    private static final SdkField<GeneralName> ACCESS_LOCATION_FIELD = SdkField.<GeneralName> builder(MarshallingType.SDK_POJO)
            .memberName("AccessLocation").getter(getter(AccessDescription::accessLocation))
            .setter(setter(Builder::accessLocation)).constructor(GeneralName::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_METHOD_FIELD,
            ACCESS_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AccessMethod accessMethod;

    private final GeneralName accessLocation;

    private AccessDescription(BuilderImpl builder) {
        this.accessMethod = builder.accessMethod;
        this.accessLocation = builder.accessLocation;
    }

    /**
     * <p>
     * The type and format of <code>AccessDescription</code> information.
     * </p>
     * 
     * @return The type and format of <code>AccessDescription</code> information.
     */
    public final AccessMethod accessMethod() {
        return accessMethod;
    }

    /**
     * <p>
     * The location of <code>AccessDescription</code> information.
     * </p>
     * 
     * @return The location of <code>AccessDescription</code> information.
     */
    public final GeneralName accessLocation() {
        return accessLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessMethod());
        hashCode = 31 * hashCode + Objects.hashCode(accessLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessDescription)) {
            return false;
        }
        AccessDescription other = (AccessDescription) obj;
        return Objects.equals(accessMethod(), other.accessMethod()) && Objects.equals(accessLocation(), other.accessLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessDescription").add("AccessMethod", accessMethod()).add("AccessLocation", accessLocation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessMethod":
            return Optional.ofNullable(clazz.cast(accessMethod()));
        case "AccessLocation":
            return Optional.ofNullable(clazz.cast(accessLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccessMethod", ACCESS_METHOD_FIELD);
        map.put("AccessLocation", ACCESS_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessDescription, T> g) {
        return obj -> g.apply((AccessDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessDescription> {
        /**
         * <p>
         * The type and format of <code>AccessDescription</code> information.
         * </p>
         * 
         * @param accessMethod
         *        The type and format of <code>AccessDescription</code> information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessMethod(AccessMethod accessMethod);

        /**
         * <p>
         * The type and format of <code>AccessDescription</code> information.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessMethod.Builder} avoiding the need
         * to create one manually via {@link AccessMethod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessMethod.Builder#build()} is called immediately and its
         * result is passed to {@link #accessMethod(AccessMethod)}.
         * 
         * @param accessMethod
         *        a consumer that will call methods on {@link AccessMethod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessMethod(AccessMethod)
         */
        default Builder accessMethod(Consumer<AccessMethod.Builder> accessMethod) {
            return accessMethod(AccessMethod.builder().applyMutation(accessMethod).build());
        }

        /**
         * <p>
         * The location of <code>AccessDescription</code> information.
         * </p>
         * 
         * @param accessLocation
         *        The location of <code>AccessDescription</code> information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessLocation(GeneralName accessLocation);

        /**
         * <p>
         * The location of <code>AccessDescription</code> information.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeneralName.Builder} avoiding the need to
         * create one manually via {@link GeneralName#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeneralName.Builder#build()} is called immediately and its result
         * is passed to {@link #accessLocation(GeneralName)}.
         * 
         * @param accessLocation
         *        a consumer that will call methods on {@link GeneralName.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessLocation(GeneralName)
         */
        default Builder accessLocation(Consumer<GeneralName.Builder> accessLocation) {
            return accessLocation(GeneralName.builder().applyMutation(accessLocation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AccessMethod accessMethod;

        private GeneralName accessLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessDescription model) {
            accessMethod(model.accessMethod);
            accessLocation(model.accessLocation);
        }

        public final AccessMethod.Builder getAccessMethod() {
            return accessMethod != null ? accessMethod.toBuilder() : null;
        }

        public final void setAccessMethod(AccessMethod.BuilderImpl accessMethod) {
            this.accessMethod = accessMethod != null ? accessMethod.build() : null;
        }

        @Override
        public final Builder accessMethod(AccessMethod accessMethod) {
            this.accessMethod = accessMethod;
            return this;
        }

        public final GeneralName.Builder getAccessLocation() {
            return accessLocation != null ? accessLocation.toBuilder() : null;
        }

        public final void setAccessLocation(GeneralName.BuilderImpl accessLocation) {
            this.accessLocation = accessLocation != null ? accessLocation.build() : null;
        }

        @Override
        public final Builder accessLocation(GeneralName accessLocation) {
            this.accessLocation = accessLocation;
            return this;
        }

        @Override
        public AccessDescription build() {
            return new AccessDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
