/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the certificate subject. The <code>Subject</code> field in the certificate identifies the
 * entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or
 * service. The <code>Subject </code>must contain an X.500 distinguished name (DN). A DN is a sequence of relative
 * distinguished names (RDNs). The RDNs are separated by commas in the certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ASN1Subject implements SdkPojo, Serializable, ToCopyableBuilder<ASN1Subject.Builder, ASN1Subject> {
    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Country")
            .getter(getter(ASN1Subject::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<String> ORGANIZATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Organization").getter(getter(ASN1Subject::organization)).setter(setter(Builder::organization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Organization").build()).build();

    private static final SdkField<String> ORGANIZATIONAL_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationalUnit").getter(getter(ASN1Subject::organizationalUnit))
            .setter(setter(Builder::organizationalUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnit").build())
            .build();

    private static final SdkField<String> DISTINGUISHED_NAME_QUALIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DistinguishedNameQualifier")
            .getter(getter(ASN1Subject::distinguishedNameQualifier))
            .setter(setter(Builder::distinguishedNameQualifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistinguishedNameQualifier").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ASN1Subject::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> COMMON_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CommonName").getter(getter(ASN1Subject::commonName)).setter(setter(Builder::commonName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonName").build()).build();

    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SerialNumber").getter(getter(ASN1Subject::serialNumber)).setter(setter(Builder::serialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()).build();

    private static final SdkField<String> LOCALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Locality").getter(getter(ASN1Subject::locality)).setter(setter(Builder::locality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locality").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(ASN1Subject::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> SURNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Surname")
            .getter(getter(ASN1Subject::surname)).setter(setter(Builder::surname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Surname").build()).build();

    private static final SdkField<String> GIVEN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GivenName").getter(getter(ASN1Subject::givenName)).setter(setter(Builder::givenName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GivenName").build()).build();

    private static final SdkField<String> INITIALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Initials").getter(getter(ASN1Subject::initials)).setter(setter(Builder::initials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Initials").build()).build();

    private static final SdkField<String> PSEUDONYM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Pseudonym").getter(getter(ASN1Subject::pseudonym)).setter(setter(Builder::pseudonym))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pseudonym").build()).build();

    private static final SdkField<String> GENERATION_QUALIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GenerationQualifier").getter(getter(ASN1Subject::generationQualifier))
            .setter(setter(Builder::generationQualifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationQualifier").build())
            .build();

    private static final SdkField<List<CustomAttribute>> CUSTOM_ATTRIBUTES_FIELD = SdkField
            .<List<CustomAttribute>> builder(MarshallingType.LIST)
            .memberName("CustomAttributes")
            .getter(getter(ASN1Subject::customAttributes))
            .setter(setter(Builder::customAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_FIELD,
            ORGANIZATION_FIELD, ORGANIZATIONAL_UNIT_FIELD, DISTINGUISHED_NAME_QUALIFIER_FIELD, STATE_FIELD, COMMON_NAME_FIELD,
            SERIAL_NUMBER_FIELD, LOCALITY_FIELD, TITLE_FIELD, SURNAME_FIELD, GIVEN_NAME_FIELD, INITIALS_FIELD, PSEUDONYM_FIELD,
            GENERATION_QUALIFIER_FIELD, CUSTOM_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String country;

    private final String organization;

    private final String organizationalUnit;

    private final String distinguishedNameQualifier;

    private final String state;

    private final String commonName;

    private final String serialNumber;

    private final String locality;

    private final String title;

    private final String surname;

    private final String givenName;

    private final String initials;

    private final String pseudonym;

    private final String generationQualifier;

    private final List<CustomAttribute> customAttributes;

    private ASN1Subject(BuilderImpl builder) {
        this.country = builder.country;
        this.organization = builder.organization;
        this.organizationalUnit = builder.organizationalUnit;
        this.distinguishedNameQualifier = builder.distinguishedNameQualifier;
        this.state = builder.state;
        this.commonName = builder.commonName;
        this.serialNumber = builder.serialNumber;
        this.locality = builder.locality;
        this.title = builder.title;
        this.surname = builder.surname;
        this.givenName = builder.givenName;
        this.initials = builder.initials;
        this.pseudonym = builder.pseudonym;
        this.generationQualifier = builder.generationQualifier;
        this.customAttributes = builder.customAttributes;
    }

    /**
     * <p>
     * Two-digit code that specifies the country in which the certificate subject located.
     * </p>
     * 
     * @return Two-digit code that specifies the country in which the certificate subject located.
     */
    public final String country() {
        return country;
    }

    /**
     * <p>
     * Legal name of the organization with which the certificate subject is affiliated.
     * </p>
     * 
     * @return Legal name of the organization with which the certificate subject is affiliated.
     */
    public final String organization() {
        return organization;
    }

    /**
     * <p>
     * A subdivision or unit of the organization (such as sales or finance) with which the certificate subject is
     * affiliated.
     * </p>
     * 
     * @return A subdivision or unit of the organization (such as sales or finance) with which the certificate subject
     *         is affiliated.
     */
    public final String organizationalUnit() {
        return organizationalUnit;
    }

    /**
     * <p>
     * Disambiguating information for the certificate subject.
     * </p>
     * 
     * @return Disambiguating information for the certificate subject.
     */
    public final String distinguishedNameQualifier() {
        return distinguishedNameQualifier;
    }

    /**
     * <p>
     * State in which the subject of the certificate is located.
     * </p>
     * 
     * @return State in which the subject of the certificate is located.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * For CA and end-entity certificates in a private PKI, the common name (CN) can be any string within the length
     * limit.
     * </p>
     * <p>
     * Note: In publicly trusted certificates, the common name must be a fully qualified domain name (FQDN) associated
     * with the certificate subject.
     * </p>
     * 
     * @return For CA and end-entity certificates in a private PKI, the common name (CN) can be any string within the
     *         length limit. </p>
     *         <p>
     *         Note: In publicly trusted certificates, the common name must be a fully qualified domain name (FQDN)
     *         associated with the certificate subject.
     */
    public final String commonName() {
        return commonName;
    }

    /**
     * <p>
     * The certificate serial number.
     * </p>
     * 
     * @return The certificate serial number.
     */
    public final String serialNumber() {
        return serialNumber;
    }

    /**
     * <p>
     * The locality (such as a city or town) in which the certificate subject is located.
     * </p>
     * 
     * @return The locality (such as a city or town) in which the certificate subject is located.
     */
    public final String locality() {
        return locality;
    }

    /**
     * <p>
     * A title such as Mr. or Ms., which is pre-pended to the name to refer formally to the certificate subject.
     * </p>
     * 
     * @return A title such as Mr. or Ms., which is pre-pended to the name to refer formally to the certificate subject.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * Family name. In the US and the UK, for example, the surname of an individual is ordered last. In Asian cultures
     * the surname is typically ordered first.
     * </p>
     * 
     * @return Family name. In the US and the UK, for example, the surname of an individual is ordered last. In Asian
     *         cultures the surname is typically ordered first.
     */
    public final String surname() {
        return surname;
    }

    /**
     * <p>
     * First name.
     * </p>
     * 
     * @return First name.
     */
    public final String givenName() {
        return givenName;
    }

    /**
     * <p>
     * Concatenation that typically contains the first letter of the <b>GivenName</b>, the first letter of the middle
     * name if one exists, and the first letter of the <b>Surname</b>.
     * </p>
     * 
     * @return Concatenation that typically contains the first letter of the <b>GivenName</b>, the first letter of the
     *         middle name if one exists, and the first letter of the <b>Surname</b>.
     */
    public final String initials() {
        return initials;
    }

    /**
     * <p>
     * Typically a shortened version of a longer <b>GivenName</b>. For example, Jonathan is often shortened to John.
     * Elizabeth is often shortened to Beth, Liz, or Eliza.
     * </p>
     * 
     * @return Typically a shortened version of a longer <b>GivenName</b>. For example, Jonathan is often shortened to
     *         John. Elizabeth is often shortened to Beth, Liz, or Eliza.
     */
    public final String pseudonym() {
        return pseudonym;
    }

    /**
     * <p>
     * Typically a qualifier appended to the name of an individual. Examples include Jr. for junior, Sr. for senior, and
     * III for third.
     * </p>
     * 
     * @return Typically a qualifier appended to the name of an individual. Examples include Jr. for junior, Sr. for
     *         senior, and III for third.
     */
    public final String generationQualifier() {
        return generationQualifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomAttributes() {
        return customAttributes != null && !(customAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Contains a sequence of one or more X.500 relative distinguished names (RDNs), each of which consists of an object
     * identifier (OID) and a value. For more information, see NIST’s definition of <a
     * href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.
     * </p>
     * <note>
     * <p>
     * Custom attributes cannot be used in combination with standard attributes.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomAttributes} method.
     * </p>
     * 
     * @return <p>
     *         Contains a sequence of one or more X.500 relative distinguished names (RDNs), each of which consists of
     *         an object identifier (OID) and a value. For more information, see NIST’s definition of <a
     *         href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.
     *         </p>
     *         <note>
     *         <p>
     *         Custom attributes cannot be used in combination with standard attributes.
     *         </p>
     */
    public final List<CustomAttribute> customAttributes() {
        return customAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(organization());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnit());
        hashCode = 31 * hashCode + Objects.hashCode(distinguishedNameQualifier());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(commonName());
        hashCode = 31 * hashCode + Objects.hashCode(serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(locality());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(surname());
        hashCode = 31 * hashCode + Objects.hashCode(givenName());
        hashCode = 31 * hashCode + Objects.hashCode(initials());
        hashCode = 31 * hashCode + Objects.hashCode(pseudonym());
        hashCode = 31 * hashCode + Objects.hashCode(generationQualifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomAttributes() ? customAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ASN1Subject)) {
            return false;
        }
        ASN1Subject other = (ASN1Subject) obj;
        return Objects.equals(country(), other.country()) && Objects.equals(organization(), other.organization())
                && Objects.equals(organizationalUnit(), other.organizationalUnit())
                && Objects.equals(distinguishedNameQualifier(), other.distinguishedNameQualifier())
                && Objects.equals(state(), other.state()) && Objects.equals(commonName(), other.commonName())
                && Objects.equals(serialNumber(), other.serialNumber()) && Objects.equals(locality(), other.locality())
                && Objects.equals(title(), other.title()) && Objects.equals(surname(), other.surname())
                && Objects.equals(givenName(), other.givenName()) && Objects.equals(initials(), other.initials())
                && Objects.equals(pseudonym(), other.pseudonym())
                && Objects.equals(generationQualifier(), other.generationQualifier())
                && hasCustomAttributes() == other.hasCustomAttributes()
                && Objects.equals(customAttributes(), other.customAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ASN1Subject").add("Country", country()).add("Organization", organization())
                .add("OrganizationalUnit", organizationalUnit()).add("DistinguishedNameQualifier", distinguishedNameQualifier())
                .add("State", state()).add("CommonName", commonName()).add("SerialNumber", serialNumber())
                .add("Locality", locality()).add("Title", title()).add("Surname", surname()).add("GivenName", givenName())
                .add("Initials", initials()).add("Pseudonym", pseudonym()).add("GenerationQualifier", generationQualifier())
                .add("CustomAttributes", hasCustomAttributes() ? customAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "Organization":
            return Optional.ofNullable(clazz.cast(organization()));
        case "OrganizationalUnit":
            return Optional.ofNullable(clazz.cast(organizationalUnit()));
        case "DistinguishedNameQualifier":
            return Optional.ofNullable(clazz.cast(distinguishedNameQualifier()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "CommonName":
            return Optional.ofNullable(clazz.cast(commonName()));
        case "SerialNumber":
            return Optional.ofNullable(clazz.cast(serialNumber()));
        case "Locality":
            return Optional.ofNullable(clazz.cast(locality()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Surname":
            return Optional.ofNullable(clazz.cast(surname()));
        case "GivenName":
            return Optional.ofNullable(clazz.cast(givenName()));
        case "Initials":
            return Optional.ofNullable(clazz.cast(initials()));
        case "Pseudonym":
            return Optional.ofNullable(clazz.cast(pseudonym()));
        case "GenerationQualifier":
            return Optional.ofNullable(clazz.cast(generationQualifier()));
        case "CustomAttributes":
            return Optional.ofNullable(clazz.cast(customAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Country", COUNTRY_FIELD);
        map.put("Organization", ORGANIZATION_FIELD);
        map.put("OrganizationalUnit", ORGANIZATIONAL_UNIT_FIELD);
        map.put("DistinguishedNameQualifier", DISTINGUISHED_NAME_QUALIFIER_FIELD);
        map.put("State", STATE_FIELD);
        map.put("CommonName", COMMON_NAME_FIELD);
        map.put("SerialNumber", SERIAL_NUMBER_FIELD);
        map.put("Locality", LOCALITY_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Surname", SURNAME_FIELD);
        map.put("GivenName", GIVEN_NAME_FIELD);
        map.put("Initials", INITIALS_FIELD);
        map.put("Pseudonym", PSEUDONYM_FIELD);
        map.put("GenerationQualifier", GENERATION_QUALIFIER_FIELD);
        map.put("CustomAttributes", CUSTOM_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ASN1Subject, T> g) {
        return obj -> g.apply((ASN1Subject) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ASN1Subject> {
        /**
         * <p>
         * Two-digit code that specifies the country in which the certificate subject located.
         * </p>
         * 
         * @param country
         *        Two-digit code that specifies the country in which the certificate subject located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * Legal name of the organization with which the certificate subject is affiliated.
         * </p>
         * 
         * @param organization
         *        Legal name of the organization with which the certificate subject is affiliated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organization(String organization);

        /**
         * <p>
         * A subdivision or unit of the organization (such as sales or finance) with which the certificate subject is
         * affiliated.
         * </p>
         * 
         * @param organizationalUnit
         *        A subdivision or unit of the organization (such as sales or finance) with which the certificate
         *        subject is affiliated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnit(String organizationalUnit);

        /**
         * <p>
         * Disambiguating information for the certificate subject.
         * </p>
         * 
         * @param distinguishedNameQualifier
         *        Disambiguating information for the certificate subject.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distinguishedNameQualifier(String distinguishedNameQualifier);

        /**
         * <p>
         * State in which the subject of the certificate is located.
         * </p>
         * 
         * @param state
         *        State in which the subject of the certificate is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * For CA and end-entity certificates in a private PKI, the common name (CN) can be any string within the length
         * limit.
         * </p>
         * <p>
         * Note: In publicly trusted certificates, the common name must be a fully qualified domain name (FQDN)
         * associated with the certificate subject.
         * </p>
         * 
         * @param commonName
         *        For CA and end-entity certificates in a private PKI, the common name (CN) can be any string within the
         *        length limit. </p>
         *        <p>
         *        Note: In publicly trusted certificates, the common name must be a fully qualified domain name (FQDN)
         *        associated with the certificate subject.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonName(String commonName);

        /**
         * <p>
         * The certificate serial number.
         * </p>
         * 
         * @param serialNumber
         *        The certificate serial number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serialNumber(String serialNumber);

        /**
         * <p>
         * The locality (such as a city or town) in which the certificate subject is located.
         * </p>
         * 
         * @param locality
         *        The locality (such as a city or town) in which the certificate subject is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locality(String locality);

        /**
         * <p>
         * A title such as Mr. or Ms., which is pre-pended to the name to refer formally to the certificate subject.
         * </p>
         * 
         * @param title
         *        A title such as Mr. or Ms., which is pre-pended to the name to refer formally to the certificate
         *        subject.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * Family name. In the US and the UK, for example, the surname of an individual is ordered last. In Asian
         * cultures the surname is typically ordered first.
         * </p>
         * 
         * @param surname
         *        Family name. In the US and the UK, for example, the surname of an individual is ordered last. In Asian
         *        cultures the surname is typically ordered first.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder surname(String surname);

        /**
         * <p>
         * First name.
         * </p>
         * 
         * @param givenName
         *        First name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder givenName(String givenName);

        /**
         * <p>
         * Concatenation that typically contains the first letter of the <b>GivenName</b>, the first letter of the
         * middle name if one exists, and the first letter of the <b>Surname</b>.
         * </p>
         * 
         * @param initials
         *        Concatenation that typically contains the first letter of the <b>GivenName</b>, the first letter of
         *        the middle name if one exists, and the first letter of the <b>Surname</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initials(String initials);

        /**
         * <p>
         * Typically a shortened version of a longer <b>GivenName</b>. For example, Jonathan is often shortened to John.
         * Elizabeth is often shortened to Beth, Liz, or Eliza.
         * </p>
         * 
         * @param pseudonym
         *        Typically a shortened version of a longer <b>GivenName</b>. For example, Jonathan is often shortened
         *        to John. Elizabeth is often shortened to Beth, Liz, or Eliza.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pseudonym(String pseudonym);

        /**
         * <p>
         * Typically a qualifier appended to the name of an individual. Examples include Jr. for junior, Sr. for senior,
         * and III for third.
         * </p>
         * 
         * @param generationQualifier
         *        Typically a qualifier appended to the name of an individual. Examples include Jr. for junior, Sr. for
         *        senior, and III for third.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationQualifier(String generationQualifier);

        /**
         * <p/>
         * <p>
         * Contains a sequence of one or more X.500 relative distinguished names (RDNs), each of which consists of an
         * object identifier (OID) and a value. For more information, see NIST’s definition of <a
         * href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.
         * </p>
         * <note>
         * <p>
         * Custom attributes cannot be used in combination with standard attributes.
         * </p>
         * </note>
         * 
         * @param customAttributes
         *        <p>
         *        Contains a sequence of one or more X.500 relative distinguished names (RDNs), each of which consists
         *        of an object identifier (OID) and a value. For more information, see NIST’s definition of <a
         *        href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.
         *        </p>
         *        <note>
         *        <p>
         *        Custom attributes cannot be used in combination with standard attributes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAttributes(Collection<CustomAttribute> customAttributes);

        /**
         * <p/>
         * <p>
         * Contains a sequence of one or more X.500 relative distinguished names (RDNs), each of which consists of an
         * object identifier (OID) and a value. For more information, see NIST’s definition of <a
         * href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.
         * </p>
         * <note>
         * <p>
         * Custom attributes cannot be used in combination with standard attributes.
         * </p>
         * </note>
         * 
         * @param customAttributes
         *        <p>
         *        Contains a sequence of one or more X.500 relative distinguished names (RDNs), each of which consists
         *        of an object identifier (OID) and a value. For more information, see NIST’s definition of <a
         *        href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.
         *        </p>
         *        <note>
         *        <p>
         *        Custom attributes cannot be used in combination with standard attributes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAttributes(CustomAttribute... customAttributes);

        /**
         * <p/>
         * <p>
         * Contains a sequence of one or more X.500 relative distinguished names (RDNs), each of which consists of an
         * object identifier (OID) and a value. For more information, see NIST’s definition of <a
         * href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.
         * </p>
         * <note>
         * <p>
         * Custom attributes cannot be used in combination with standard attributes.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.acmpca.model.CustomAttribute.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.acmpca.model.CustomAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.acmpca.model.CustomAttribute.Builder#build()} is called immediately
         * and its result is passed to {@link #customAttributes(List<CustomAttribute>)}.
         * 
         * @param customAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.acmpca.model.CustomAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customAttributes(java.util.Collection<CustomAttribute>)
         */
        Builder customAttributes(Consumer<CustomAttribute.Builder>... customAttributes);
    }

    static final class BuilderImpl implements Builder {
        private String country;

        private String organization;

        private String organizationalUnit;

        private String distinguishedNameQualifier;

        private String state;

        private String commonName;

        private String serialNumber;

        private String locality;

        private String title;

        private String surname;

        private String givenName;

        private String initials;

        private String pseudonym;

        private String generationQualifier;

        private List<CustomAttribute> customAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ASN1Subject model) {
            country(model.country);
            organization(model.organization);
            organizationalUnit(model.organizationalUnit);
            distinguishedNameQualifier(model.distinguishedNameQualifier);
            state(model.state);
            commonName(model.commonName);
            serialNumber(model.serialNumber);
            locality(model.locality);
            title(model.title);
            surname(model.surname);
            givenName(model.givenName);
            initials(model.initials);
            pseudonym(model.pseudonym);
            generationQualifier(model.generationQualifier);
            customAttributes(model.customAttributes);
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getOrganization() {
            return organization;
        }

        public final void setOrganization(String organization) {
            this.organization = organization;
        }

        @Override
        public final Builder organization(String organization) {
            this.organization = organization;
            return this;
        }

        public final String getOrganizationalUnit() {
            return organizationalUnit;
        }

        public final void setOrganizationalUnit(String organizationalUnit) {
            this.organizationalUnit = organizationalUnit;
        }

        @Override
        public final Builder organizationalUnit(String organizationalUnit) {
            this.organizationalUnit = organizationalUnit;
            return this;
        }

        public final String getDistinguishedNameQualifier() {
            return distinguishedNameQualifier;
        }

        public final void setDistinguishedNameQualifier(String distinguishedNameQualifier) {
            this.distinguishedNameQualifier = distinguishedNameQualifier;
        }

        @Override
        public final Builder distinguishedNameQualifier(String distinguishedNameQualifier) {
            this.distinguishedNameQualifier = distinguishedNameQualifier;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getCommonName() {
            return commonName;
        }

        public final void setCommonName(String commonName) {
            this.commonName = commonName;
        }

        @Override
        public final Builder commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public final String getSerialNumber() {
            return serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final String getLocality() {
            return locality;
        }

        public final void setLocality(String locality) {
            this.locality = locality;
        }

        @Override
        public final Builder locality(String locality) {
            this.locality = locality;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSurname() {
            return surname;
        }

        public final void setSurname(String surname) {
            this.surname = surname;
        }

        @Override
        public final Builder surname(String surname) {
            this.surname = surname;
            return this;
        }

        public final String getGivenName() {
            return givenName;
        }

        public final void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        @Override
        public final Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public final String getInitials() {
            return initials;
        }

        public final void setInitials(String initials) {
            this.initials = initials;
        }

        @Override
        public final Builder initials(String initials) {
            this.initials = initials;
            return this;
        }

        public final String getPseudonym() {
            return pseudonym;
        }

        public final void setPseudonym(String pseudonym) {
            this.pseudonym = pseudonym;
        }

        @Override
        public final Builder pseudonym(String pseudonym) {
            this.pseudonym = pseudonym;
            return this;
        }

        public final String getGenerationQualifier() {
            return generationQualifier;
        }

        public final void setGenerationQualifier(String generationQualifier) {
            this.generationQualifier = generationQualifier;
        }

        @Override
        public final Builder generationQualifier(String generationQualifier) {
            this.generationQualifier = generationQualifier;
            return this;
        }

        public final List<CustomAttribute.Builder> getCustomAttributes() {
            List<CustomAttribute.Builder> result = CustomAttributeListCopier.copyToBuilder(this.customAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomAttributes(Collection<CustomAttribute.BuilderImpl> customAttributes) {
            this.customAttributes = CustomAttributeListCopier.copyFromBuilder(customAttributes);
        }

        @Override
        public final Builder customAttributes(Collection<CustomAttribute> customAttributes) {
            this.customAttributes = CustomAttributeListCopier.copy(customAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAttributes(CustomAttribute... customAttributes) {
            customAttributes(Arrays.asList(customAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAttributes(Consumer<CustomAttribute.Builder>... customAttributes) {
            customAttributes(Stream.of(customAttributes).map(c -> CustomAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ASN1Subject build() {
            return new ASN1Subject(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
