/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.migrationhub.model.AccessDeniedException;
import software.amazon.awssdk.services.migrationhub.model.AssociateCreatedArtifactRequest;
import software.amazon.awssdk.services.migrationhub.model.AssociateCreatedArtifactResponse;
import software.amazon.awssdk.services.migrationhub.model.AssociateDiscoveredResourceRequest;
import software.amazon.awssdk.services.migrationhub.model.AssociateDiscoveredResourceResponse;
import software.amazon.awssdk.services.migrationhub.model.CreateProgressUpdateStreamRequest;
import software.amazon.awssdk.services.migrationhub.model.CreateProgressUpdateStreamResponse;
import software.amazon.awssdk.services.migrationhub.model.DeleteProgressUpdateStreamRequest;
import software.amazon.awssdk.services.migrationhub.model.DeleteProgressUpdateStreamResponse;
import software.amazon.awssdk.services.migrationhub.model.DescribeApplicationStateRequest;
import software.amazon.awssdk.services.migrationhub.model.DescribeApplicationStateResponse;
import software.amazon.awssdk.services.migrationhub.model.DescribeMigrationTaskRequest;
import software.amazon.awssdk.services.migrationhub.model.DescribeMigrationTaskResponse;
import software.amazon.awssdk.services.migrationhub.model.DisassociateCreatedArtifactRequest;
import software.amazon.awssdk.services.migrationhub.model.DisassociateCreatedArtifactResponse;
import software.amazon.awssdk.services.migrationhub.model.DisassociateDiscoveredResourceRequest;
import software.amazon.awssdk.services.migrationhub.model.DisassociateDiscoveredResourceResponse;
import software.amazon.awssdk.services.migrationhub.model.DryRunOperationException;
import software.amazon.awssdk.services.migrationhub.model.HomeRegionNotSetException;
import software.amazon.awssdk.services.migrationhub.model.ImportMigrationTaskRequest;
import software.amazon.awssdk.services.migrationhub.model.ImportMigrationTaskResponse;
import software.amazon.awssdk.services.migrationhub.model.InternalServerErrorException;
import software.amazon.awssdk.services.migrationhub.model.InvalidInputException;
import software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesRequest;
import software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesResponse;
import software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsRequest;
import software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsResponse;
import software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest;
import software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesResponse;
import software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest;
import software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksResponse;
import software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest;
import software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsResponse;
import software.amazon.awssdk.services.migrationhub.model.MigrationHubException;
import software.amazon.awssdk.services.migrationhub.model.NotifyApplicationStateRequest;
import software.amazon.awssdk.services.migrationhub.model.NotifyApplicationStateResponse;
import software.amazon.awssdk.services.migrationhub.model.NotifyMigrationTaskStateRequest;
import software.amazon.awssdk.services.migrationhub.model.NotifyMigrationTaskStateResponse;
import software.amazon.awssdk.services.migrationhub.model.PolicyErrorException;
import software.amazon.awssdk.services.migrationhub.model.PutResourceAttributesRequest;
import software.amazon.awssdk.services.migrationhub.model.PutResourceAttributesResponse;
import software.amazon.awssdk.services.migrationhub.model.ResourceNotFoundException;
import software.amazon.awssdk.services.migrationhub.model.ServiceUnavailableException;
import software.amazon.awssdk.services.migrationhub.model.ThrottlingException;
import software.amazon.awssdk.services.migrationhub.model.UnauthorizedOperationException;
import software.amazon.awssdk.services.migrationhub.paginators.ListApplicationStatesIterable;
import software.amazon.awssdk.services.migrationhub.paginators.ListCreatedArtifactsIterable;
import software.amazon.awssdk.services.migrationhub.paginators.ListDiscoveredResourcesIterable;
import software.amazon.awssdk.services.migrationhub.paginators.ListMigrationTasksIterable;
import software.amazon.awssdk.services.migrationhub.paginators.ListProgressUpdateStreamsIterable;

/**
 * Service client for accessing AWS Migration Hub. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * The AWS Migration Hub API methods help to obtain server and application migration status and integrate your
 * resource-specific migration tool by providing a programmatic interface to Migration Hub.
 * </p>
 * <p>
 * Remember that you must set your AWS Migration Hub home region before you call any of these APIs, or a
 * <code>HomeRegionNotSetException</code> error will be returned. Also, you must make the API calls while in your home
 * region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MigrationHubClient extends AwsClient {
    String SERVICE_NAME = "mgh";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "mgh";

    /**
     * <p>
     * Associates a created artifact of an AWS cloud resource, the target receiving the migration, with the migration
     * task performed by a migration tool. This API has the following traits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Migration tools can call the <code>AssociateCreatedArtifact</code> operation to indicate which AWS artifact is
     * associated with a migration task.
     * </p>
     * </li>
     * <li>
     * <p>
     * The created artifact name must be provided in ARN (Amazon Resource Name) format which will contain information
     * about type and region; for example: <code>arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Examples of the AWS resource behind the created artifact are, AMI's, EC2 instance, or DMS endpoint, etc.
     * </p>
     * </li>
     * </ul>
     *
     * @param associateCreatedArtifactRequest
     * @return Result of the AssociateCreatedArtifact operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws DryRunOperationException
     *         Exception raised to indicate a successfully authorized action when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws UnauthorizedOperationException
     *         Exception raised to indicate a request was not authorized when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.AssociateCreatedArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/AssociateCreatedArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateCreatedArtifactResponse associateCreatedArtifact(
            AssociateCreatedArtifactRequest associateCreatedArtifactRequest) throws AccessDeniedException, ThrottlingException,
            InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException,
            InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            MigrationHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a created artifact of an AWS cloud resource, the target receiving the migration, with the migration
     * task performed by a migration tool. This API has the following traits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Migration tools can call the <code>AssociateCreatedArtifact</code> operation to indicate which AWS artifact is
     * associated with a migration task.
     * </p>
     * </li>
     * <li>
     * <p>
     * The created artifact name must be provided in ARN (Amazon Resource Name) format which will contain information
     * about type and region; for example: <code>arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Examples of the AWS resource behind the created artifact are, AMI's, EC2 instance, or DMS endpoint, etc.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateCreatedArtifactRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateCreatedArtifactRequest#builder()}
     * </p>
     *
     * @param associateCreatedArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.AssociateCreatedArtifactRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateCreatedArtifact operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws DryRunOperationException
     *         Exception raised to indicate a successfully authorized action when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws UnauthorizedOperationException
     *         Exception raised to indicate a request was not authorized when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.AssociateCreatedArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/AssociateCreatedArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateCreatedArtifactResponse associateCreatedArtifact(
            Consumer<AssociateCreatedArtifactRequest.Builder> associateCreatedArtifactRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException,
            UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, MigrationHubException {
        return associateCreatedArtifact(AssociateCreatedArtifactRequest.builder().applyMutation(associateCreatedArtifactRequest)
                .build());
    }

    /**
     * <p>
     * Associates a discovered resource ID from Application Discovery Service with a migration task.
     * </p>
     *
     * @param associateDiscoveredResourceRequest
     * @return Result of the AssociateDiscoveredResource operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws DryRunOperationException
     *         Exception raised to indicate a successfully authorized action when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws UnauthorizedOperationException
     *         Exception raised to indicate a request was not authorized when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws PolicyErrorException
     *         Exception raised when there are problems accessing Application Discovery Service (Application Discovery
     *         Service); most likely due to a misconfigured policy or the <code>migrationhub-discovery</code> role is
     *         missing or not configured correctly.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.AssociateDiscoveredResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/AssociateDiscoveredResource"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDiscoveredResourceResponse associateDiscoveredResource(
            AssociateDiscoveredResourceRequest associateDiscoveredResourceRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException,
            UnauthorizedOperationException, InvalidInputException, PolicyErrorException, ResourceNotFoundException,
            HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a discovered resource ID from Application Discovery Service with a migration task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDiscoveredResourceRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateDiscoveredResourceRequest#builder()}
     * </p>
     *
     * @param associateDiscoveredResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.AssociateDiscoveredResourceRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateDiscoveredResource operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws DryRunOperationException
     *         Exception raised to indicate a successfully authorized action when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws UnauthorizedOperationException
     *         Exception raised to indicate a request was not authorized when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws PolicyErrorException
     *         Exception raised when there are problems accessing Application Discovery Service (Application Discovery
     *         Service); most likely due to a misconfigured policy or the <code>migrationhub-discovery</code> role is
     *         missing or not configured correctly.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.AssociateDiscoveredResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/AssociateDiscoveredResource"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDiscoveredResourceResponse associateDiscoveredResource(
            Consumer<AssociateDiscoveredResourceRequest.Builder> associateDiscoveredResourceRequest)
            throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException,
            DryRunOperationException, UnauthorizedOperationException, InvalidInputException, PolicyErrorException,
            ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        return associateDiscoveredResource(AssociateDiscoveredResourceRequest.builder()
                .applyMutation(associateDiscoveredResourceRequest).build());
    }

    /**
     * <p>
     * Creates a progress update stream which is an AWS resource used for access control as well as a namespace for
     * migration task names that is implicitly linked to your AWS account. It must uniquely identify the migration tool
     * as it is used for all updates made by the tool; however, it does not need to be unique for each AWS account
     * because it is scoped to the AWS account.
     * </p>
     *
     * @param createProgressUpdateStreamRequest
     * @return Result of the CreateProgressUpdateStream operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws DryRunOperationException
     *         Exception raised to indicate a successfully authorized action when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws UnauthorizedOperationException
     *         Exception raised to indicate a request was not authorized when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.CreateProgressUpdateStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/CreateProgressUpdateStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProgressUpdateStreamResponse createProgressUpdateStream(
            CreateProgressUpdateStreamRequest createProgressUpdateStreamRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException,
            UnauthorizedOperationException, InvalidInputException, HomeRegionNotSetException, AwsServiceException,
            SdkClientException, MigrationHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a progress update stream which is an AWS resource used for access control as well as a namespace for
     * migration task names that is implicitly linked to your AWS account. It must uniquely identify the migration tool
     * as it is used for all updates made by the tool; however, it does not need to be unique for each AWS account
     * because it is scoped to the AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProgressUpdateStreamRequest.Builder} avoiding
     * the need to create one manually via {@link CreateProgressUpdateStreamRequest#builder()}
     * </p>
     *
     * @param createProgressUpdateStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.CreateProgressUpdateStreamRequest.Builder} to
     *        create a request.
     * @return Result of the CreateProgressUpdateStream operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws DryRunOperationException
     *         Exception raised to indicate a successfully authorized action when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws UnauthorizedOperationException
     *         Exception raised to indicate a request was not authorized when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.CreateProgressUpdateStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/CreateProgressUpdateStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProgressUpdateStreamResponse createProgressUpdateStream(
            Consumer<CreateProgressUpdateStreamRequest.Builder> createProgressUpdateStreamRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException,
            UnauthorizedOperationException, InvalidInputException, HomeRegionNotSetException, AwsServiceException,
            SdkClientException, MigrationHubException {
        return createProgressUpdateStream(CreateProgressUpdateStreamRequest.builder()
                .applyMutation(createProgressUpdateStreamRequest).build());
    }

    /**
     * <p>
     * Deletes a progress update stream, including all of its tasks, which was previously created as an AWS resource
     * used for access control. This API has the following traits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The only parameter needed for <code>DeleteProgressUpdateStream</code> is the stream name (same as a
     * <code>CreateProgressUpdateStream</code> call).
     * </p>
     * </li>
     * <li>
     * <p>
     * The call will return, and a background process will asynchronously delete the stream and all of its resources
     * (tasks, associated resources, resource attributes, created artifacts).
     * </p>
     * </li>
     * <li>
     * <p>
     * If the stream takes time to be deleted, it might still show up on a <code>ListProgressUpdateStreams</code> call.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreateProgressUpdateStream</code>, <code>ImportMigrationTask</code>, <code>NotifyMigrationTaskState</code>,
     * and all Associate[*] APIs related to the tasks belonging to the stream will throw "InvalidInputException" if the
     * stream of the same name is in the process of being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * Once the stream and all of its resources are deleted, <code>CreateProgressUpdateStream</code> for a stream of the
     * same name will succeed, and that stream will be an entirely new logical resource (without any resources
     * associated with the old stream).
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteProgressUpdateStreamRequest
     * @return Result of the DeleteProgressUpdateStream operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws DryRunOperationException
     *         Exception raised to indicate a successfully authorized action when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws UnauthorizedOperationException
     *         Exception raised to indicate a request was not authorized when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.DeleteProgressUpdateStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DeleteProgressUpdateStream"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProgressUpdateStreamResponse deleteProgressUpdateStream(
            DeleteProgressUpdateStreamRequest deleteProgressUpdateStreamRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException,
            UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, MigrationHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a progress update stream, including all of its tasks, which was previously created as an AWS resource
     * used for access control. This API has the following traits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The only parameter needed for <code>DeleteProgressUpdateStream</code> is the stream name (same as a
     * <code>CreateProgressUpdateStream</code> call).
     * </p>
     * </li>
     * <li>
     * <p>
     * The call will return, and a background process will asynchronously delete the stream and all of its resources
     * (tasks, associated resources, resource attributes, created artifacts).
     * </p>
     * </li>
     * <li>
     * <p>
     * If the stream takes time to be deleted, it might still show up on a <code>ListProgressUpdateStreams</code> call.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreateProgressUpdateStream</code>, <code>ImportMigrationTask</code>, <code>NotifyMigrationTaskState</code>,
     * and all Associate[*] APIs related to the tasks belonging to the stream will throw "InvalidInputException" if the
     * stream of the same name is in the process of being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * Once the stream and all of its resources are deleted, <code>CreateProgressUpdateStream</code> for a stream of the
     * same name will succeed, and that stream will be an entirely new logical resource (without any resources
     * associated with the old stream).
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProgressUpdateStreamRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteProgressUpdateStreamRequest#builder()}
     * </p>
     *
     * @param deleteProgressUpdateStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.DeleteProgressUpdateStreamRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteProgressUpdateStream operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws DryRunOperationException
     *         Exception raised to indicate a successfully authorized action when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws UnauthorizedOperationException
     *         Exception raised to indicate a request was not authorized when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.DeleteProgressUpdateStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DeleteProgressUpdateStream"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProgressUpdateStreamResponse deleteProgressUpdateStream(
            Consumer<DeleteProgressUpdateStreamRequest.Builder> deleteProgressUpdateStreamRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException,
            UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, MigrationHubException {
        return deleteProgressUpdateStream(DeleteProgressUpdateStreamRequest.builder()
                .applyMutation(deleteProgressUpdateStreamRequest).build());
    }

    /**
     * <p>
     * Gets the migration status of an application.
     * </p>
     *
     * @param describeApplicationStateRequest
     * @return Result of the DescribeApplicationState operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws PolicyErrorException
     *         Exception raised when there are problems accessing Application Discovery Service (Application Discovery
     *         Service); most likely due to a misconfigured policy or the <code>migrationhub-discovery</code> role is
     *         missing or not configured correctly.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.DescribeApplicationState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DescribeApplicationState"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationStateResponse describeApplicationState(
            DescribeApplicationStateRequest describeApplicationStateRequest) throws AccessDeniedException, ThrottlingException,
            InternalServerErrorException, ServiceUnavailableException, InvalidInputException, PolicyErrorException,
            ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the migration status of an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationStateRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeApplicationStateRequest#builder()}
     * </p>
     *
     * @param describeApplicationStateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.DescribeApplicationStateRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeApplicationState operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws PolicyErrorException
     *         Exception raised when there are problems accessing Application Discovery Service (Application Discovery
     *         Service); most likely due to a misconfigured policy or the <code>migrationhub-discovery</code> role is
     *         missing or not configured correctly.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.DescribeApplicationState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DescribeApplicationState"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationStateResponse describeApplicationState(
            Consumer<DescribeApplicationStateRequest.Builder> describeApplicationStateRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException,
            PolicyErrorException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            MigrationHubException {
        return describeApplicationState(DescribeApplicationStateRequest.builder().applyMutation(describeApplicationStateRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of all attributes associated with a specific migration task.
     * </p>
     *
     * @param describeMigrationTaskRequest
     * @return Result of the DescribeMigrationTask operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.DescribeMigrationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DescribeMigrationTask"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMigrationTaskResponse describeMigrationTask(DescribeMigrationTaskRequest describeMigrationTaskRequest)
            throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException,
            InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            MigrationHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all attributes associated with a specific migration task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMigrationTaskRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeMigrationTaskRequest#builder()}
     * </p>
     *
     * @param describeMigrationTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.DescribeMigrationTaskRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeMigrationTask operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.DescribeMigrationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DescribeMigrationTask"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMigrationTaskResponse describeMigrationTask(
            Consumer<DescribeMigrationTaskRequest.Builder> describeMigrationTaskRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException,
            ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        return describeMigrationTask(DescribeMigrationTaskRequest.builder().applyMutation(describeMigrationTaskRequest).build());
    }

    /**
     * <p>
     * Disassociates a created artifact of an AWS resource with a migration task performed by a migration tool that was
     * previously associated. This API has the following traits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A migration user can call the <code>DisassociateCreatedArtifacts</code> operation to disassociate a created AWS
     * Artifact from a migration task.
     * </p>
     * </li>
     * <li>
     * <p>
     * The created artifact name must be provided in ARN (Amazon Resource Name) format which will contain information
     * about type and region; for example: <code>arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Examples of the AWS resource behind the created artifact are, AMI's, EC2 instance, or RDS instance, etc.
     * </p>
     * </li>
     * </ul>
     *
     * @param disassociateCreatedArtifactRequest
     * @return Result of the DisassociateCreatedArtifact operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws DryRunOperationException
     *         Exception raised to indicate a successfully authorized action when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws UnauthorizedOperationException
     *         Exception raised to indicate a request was not authorized when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.DisassociateCreatedArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DisassociateCreatedArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateCreatedArtifactResponse disassociateCreatedArtifact(
            DisassociateCreatedArtifactRequest disassociateCreatedArtifactRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException,
            UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, MigrationHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a created artifact of an AWS resource with a migration task performed by a migration tool that was
     * previously associated. This API has the following traits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A migration user can call the <code>DisassociateCreatedArtifacts</code> operation to disassociate a created AWS
     * Artifact from a migration task.
     * </p>
     * </li>
     * <li>
     * <p>
     * The created artifact name must be provided in ARN (Amazon Resource Name) format which will contain information
     * about type and region; for example: <code>arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Examples of the AWS resource behind the created artifact are, AMI's, EC2 instance, or RDS instance, etc.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateCreatedArtifactRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateCreatedArtifactRequest#builder()}
     * </p>
     *
     * @param disassociateCreatedArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.DisassociateCreatedArtifactRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateCreatedArtifact operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws DryRunOperationException
     *         Exception raised to indicate a successfully authorized action when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws UnauthorizedOperationException
     *         Exception raised to indicate a request was not authorized when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.DisassociateCreatedArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DisassociateCreatedArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateCreatedArtifactResponse disassociateCreatedArtifact(
            Consumer<DisassociateCreatedArtifactRequest.Builder> disassociateCreatedArtifactRequest)
            throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException,
            DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException,
            HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        return disassociateCreatedArtifact(DisassociateCreatedArtifactRequest.builder()
                .applyMutation(disassociateCreatedArtifactRequest).build());
    }

    /**
     * <p>
     * Disassociate an Application Discovery Service discovered resource from a migration task.
     * </p>
     *
     * @param disassociateDiscoveredResourceRequest
     * @return Result of the DisassociateDiscoveredResource operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws DryRunOperationException
     *         Exception raised to indicate a successfully authorized action when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws UnauthorizedOperationException
     *         Exception raised to indicate a request was not authorized when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.DisassociateDiscoveredResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DisassociateDiscoveredResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateDiscoveredResourceResponse disassociateDiscoveredResource(
            DisassociateDiscoveredResourceRequest disassociateDiscoveredResourceRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException,
            UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, MigrationHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociate an Application Discovery Service discovered resource from a migration task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateDiscoveredResourceRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateDiscoveredResourceRequest#builder()}
     * </p>
     *
     * @param disassociateDiscoveredResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.DisassociateDiscoveredResourceRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateDiscoveredResource operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws DryRunOperationException
     *         Exception raised to indicate a successfully authorized action when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws UnauthorizedOperationException
     *         Exception raised to indicate a request was not authorized when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.DisassociateDiscoveredResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DisassociateDiscoveredResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateDiscoveredResourceResponse disassociateDiscoveredResource(
            Consumer<DisassociateDiscoveredResourceRequest.Builder> disassociateDiscoveredResourceRequest)
            throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException,
            DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException,
            HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        return disassociateDiscoveredResource(DisassociateDiscoveredResourceRequest.builder()
                .applyMutation(disassociateDiscoveredResourceRequest).build());
    }

    /**
     * <p>
     * Registers a new migration task which represents a server, database, etc., being migrated to AWS by a migration
     * tool.
     * </p>
     * <p>
     * This API is a prerequisite to calling the <code>NotifyMigrationTaskState</code> API as the migration tool must
     * first register the migration task with Migration Hub.
     * </p>
     *
     * @param importMigrationTaskRequest
     * @return Result of the ImportMigrationTask operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws DryRunOperationException
     *         Exception raised to indicate a successfully authorized action when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws UnauthorizedOperationException
     *         Exception raised to indicate a request was not authorized when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ImportMigrationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ImportMigrationTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportMigrationTaskResponse importMigrationTask(ImportMigrationTaskRequest importMigrationTaskRequest)
            throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException,
            DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException,
            HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a new migration task which represents a server, database, etc., being migrated to AWS by a migration
     * tool.
     * </p>
     * <p>
     * This API is a prerequisite to calling the <code>NotifyMigrationTaskState</code> API as the migration tool must
     * first register the migration task with Migration Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportMigrationTaskRequest.Builder} avoiding the
     * need to create one manually via {@link ImportMigrationTaskRequest#builder()}
     * </p>
     *
     * @param importMigrationTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.ImportMigrationTaskRequest.Builder} to create a
     *        request.
     * @return Result of the ImportMigrationTask operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws DryRunOperationException
     *         Exception raised to indicate a successfully authorized action when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws UnauthorizedOperationException
     *         Exception raised to indicate a request was not authorized when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ImportMigrationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ImportMigrationTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportMigrationTaskResponse importMigrationTask(
            Consumer<ImportMigrationTaskRequest.Builder> importMigrationTaskRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException,
            UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, MigrationHubException {
        return importMigrationTask(ImportMigrationTaskRequest.builder().applyMutation(importMigrationTaskRequest).build());
    }

    /**
     * <p>
     * Lists all the migration statuses for your applications. If you use the optional <code>ApplicationIds</code>
     * parameter, only the migration statuses for those applications will be returned.
     * </p>
     *
     * @param listApplicationStatesRequest
     * @return Result of the ListApplicationStates operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ListApplicationStates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListApplicationStates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationStatesResponse listApplicationStates(ListApplicationStatesRequest listApplicationStatesRequest)
            throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException,
            InvalidInputException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the migration statuses for your applications. If you use the optional <code>ApplicationIds</code>
     * parameter, only the migration statuses for those applications will be returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationStatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListApplicationStatesRequest#builder()}
     * </p>
     *
     * @param listApplicationStatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesRequest.Builder} to create
     *        a request.
     * @return Result of the ListApplicationStates operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ListApplicationStates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListApplicationStates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationStatesResponse listApplicationStates(
            Consumer<ListApplicationStatesRequest.Builder> listApplicationStatesRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException,
            HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        return listApplicationStates(ListApplicationStatesRequest.builder().applyMutation(listApplicationStatesRequest).build());
    }

    /**
     * <p>
     * Lists all the migration statuses for your applications. If you use the optional <code>ApplicationIds</code>
     * parameter, only the migration statuses for those applications will be returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplicationStates(software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhub.paginators.ListApplicationStatesIterable responses = client.listApplicationStatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhub.paginators.ListApplicationStatesIterable responses = client
     *             .listApplicationStatesPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhub.paginators.ListApplicationStatesIterable responses = client.listApplicationStatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationStates(software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationStatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ListApplicationStates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListApplicationStates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationStatesIterable listApplicationStatesPaginator(ListApplicationStatesRequest listApplicationStatesRequest)
            throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException,
            InvalidInputException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        return new ListApplicationStatesIterable(this, listApplicationStatesRequest);
    }

    /**
     * <p>
     * Lists all the migration statuses for your applications. If you use the optional <code>ApplicationIds</code>
     * parameter, only the migration statuses for those applications will be returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplicationStates(software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhub.paginators.ListApplicationStatesIterable responses = client.listApplicationStatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhub.paginators.ListApplicationStatesIterable responses = client
     *             .listApplicationStatesPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhub.paginators.ListApplicationStatesIterable responses = client.listApplicationStatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationStates(software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationStatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListApplicationStatesRequest#builder()}
     * </p>
     *
     * @param listApplicationStatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ListApplicationStates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListApplicationStates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationStatesIterable listApplicationStatesPaginator(
            Consumer<ListApplicationStatesRequest.Builder> listApplicationStatesRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException,
            HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        return listApplicationStatesPaginator(ListApplicationStatesRequest.builder().applyMutation(listApplicationStatesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the created artifacts attached to a given migration task in an update stream. This API has the following
     * traits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Gets the list of the created artifacts while migration is taking place.
     * </p>
     * </li>
     * <li>
     * <p>
     * Shows the artifacts created by the migration tool that was associated by the
     * <code>AssociateCreatedArtifact</code> API.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lists created artifacts in a paginated interface.
     * </p>
     * </li>
     * </ul>
     *
     * @param listCreatedArtifactsRequest
     * @return Result of the ListCreatedArtifacts operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ListCreatedArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListCreatedArtifacts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCreatedArtifactsResponse listCreatedArtifacts(ListCreatedArtifactsRequest listCreatedArtifactsRequest)
            throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException,
            InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            MigrationHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the created artifacts attached to a given migration task in an update stream. This API has the following
     * traits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Gets the list of the created artifacts while migration is taking place.
     * </p>
     * </li>
     * <li>
     * <p>
     * Shows the artifacts created by the migration tool that was associated by the
     * <code>AssociateCreatedArtifact</code> API.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lists created artifacts in a paginated interface.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCreatedArtifactsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCreatedArtifactsRequest#builder()}
     * </p>
     *
     * @param listCreatedArtifactsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsRequest.Builder} to create a
     *        request.
     * @return Result of the ListCreatedArtifacts operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ListCreatedArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListCreatedArtifacts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCreatedArtifactsResponse listCreatedArtifacts(
            Consumer<ListCreatedArtifactsRequest.Builder> listCreatedArtifactsRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException,
            ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        return listCreatedArtifacts(ListCreatedArtifactsRequest.builder().applyMutation(listCreatedArtifactsRequest).build());
    }

    /**
     * <p>
     * Lists the created artifacts attached to a given migration task in an update stream. This API has the following
     * traits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Gets the list of the created artifacts while migration is taking place.
     * </p>
     * </li>
     * <li>
     * <p>
     * Shows the artifacts created by the migration tool that was associated by the
     * <code>AssociateCreatedArtifact</code> API.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lists created artifacts in a paginated interface.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCreatedArtifacts(software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhub.paginators.ListCreatedArtifactsIterable responses = client.listCreatedArtifactsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhub.paginators.ListCreatedArtifactsIterable responses = client
     *             .listCreatedArtifactsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhub.paginators.ListCreatedArtifactsIterable responses = client.listCreatedArtifactsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCreatedArtifacts(software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCreatedArtifactsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ListCreatedArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListCreatedArtifacts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCreatedArtifactsIterable listCreatedArtifactsPaginator(ListCreatedArtifactsRequest listCreatedArtifactsRequest)
            throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException,
            InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            MigrationHubException {
        return new ListCreatedArtifactsIterable(this, listCreatedArtifactsRequest);
    }

    /**
     * <p>
     * Lists the created artifacts attached to a given migration task in an update stream. This API has the following
     * traits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Gets the list of the created artifacts while migration is taking place.
     * </p>
     * </li>
     * <li>
     * <p>
     * Shows the artifacts created by the migration tool that was associated by the
     * <code>AssociateCreatedArtifact</code> API.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lists created artifacts in a paginated interface.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCreatedArtifacts(software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhub.paginators.ListCreatedArtifactsIterable responses = client.listCreatedArtifactsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhub.paginators.ListCreatedArtifactsIterable responses = client
     *             .listCreatedArtifactsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhub.paginators.ListCreatedArtifactsIterable responses = client.listCreatedArtifactsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCreatedArtifacts(software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCreatedArtifactsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCreatedArtifactsRequest#builder()}
     * </p>
     *
     * @param listCreatedArtifactsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.ListCreatedArtifactsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ListCreatedArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListCreatedArtifacts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCreatedArtifactsIterable listCreatedArtifactsPaginator(
            Consumer<ListCreatedArtifactsRequest.Builder> listCreatedArtifactsRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException,
            ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        return listCreatedArtifactsPaginator(ListCreatedArtifactsRequest.builder().applyMutation(listCreatedArtifactsRequest)
                .build());
    }

    /**
     * <p>
     * Lists discovered resources associated with the given <code>MigrationTask</code>.
     * </p>
     *
     * @param listDiscoveredResourcesRequest
     * @return Result of the ListDiscoveredResources operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ListDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDiscoveredResourcesResponse listDiscoveredResources(ListDiscoveredResourcesRequest listDiscoveredResourcesRequest)
            throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException,
            InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            MigrationHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists discovered resources associated with the given <code>MigrationTask</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDiscoveredResourcesRequest.Builder} avoiding
     * the need to create one manually via {@link ListDiscoveredResourcesRequest#builder()}
     * </p>
     *
     * @param listDiscoveredResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest.Builder} to
     *        create a request.
     * @return Result of the ListDiscoveredResources operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ListDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDiscoveredResourcesResponse listDiscoveredResources(
            Consumer<ListDiscoveredResourcesRequest.Builder> listDiscoveredResourcesRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException,
            ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        return listDiscoveredResources(ListDiscoveredResourcesRequest.builder().applyMutation(listDiscoveredResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Lists discovered resources associated with the given <code>MigrationTask</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDiscoveredResources(software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhub.paginators.ListDiscoveredResourcesIterable responses = client.listDiscoveredResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhub.paginators.ListDiscoveredResourcesIterable responses = client
     *             .listDiscoveredResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhub.paginators.ListDiscoveredResourcesIterable responses = client.listDiscoveredResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDiscoveredResources(software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDiscoveredResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ListDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDiscoveredResourcesIterable listDiscoveredResourcesPaginator(
            ListDiscoveredResourcesRequest listDiscoveredResourcesRequest) throws AccessDeniedException, ThrottlingException,
            InternalServerErrorException, ServiceUnavailableException, InvalidInputException, ResourceNotFoundException,
            HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        return new ListDiscoveredResourcesIterable(this, listDiscoveredResourcesRequest);
    }

    /**
     * <p>
     * Lists discovered resources associated with the given <code>MigrationTask</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDiscoveredResources(software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhub.paginators.ListDiscoveredResourcesIterable responses = client.listDiscoveredResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhub.paginators.ListDiscoveredResourcesIterable responses = client
     *             .listDiscoveredResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhub.paginators.ListDiscoveredResourcesIterable responses = client.listDiscoveredResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDiscoveredResources(software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDiscoveredResourcesRequest.Builder} avoiding
     * the need to create one manually via {@link ListDiscoveredResourcesRequest#builder()}
     * </p>
     *
     * @param listDiscoveredResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.ListDiscoveredResourcesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ListDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDiscoveredResourcesIterable listDiscoveredResourcesPaginator(
            Consumer<ListDiscoveredResourcesRequest.Builder> listDiscoveredResourcesRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException,
            ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        return listDiscoveredResourcesPaginator(ListDiscoveredResourcesRequest.builder()
                .applyMutation(listDiscoveredResourcesRequest).build());
    }

    /**
     * <p>
     * Lists all, or filtered by resource name, migration tasks associated with the user account making this call. This
     * API has the following traits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can show a summary list of the most recent migration tasks.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can show a summary list of migration tasks associated with a given discovered resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lists migration tasks in a paginated interface.
     * </p>
     * </li>
     * </ul>
     *
     * @param listMigrationTasksRequest
     * @return Result of the ListMigrationTasks operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws PolicyErrorException
     *         Exception raised when there are problems accessing Application Discovery Service (Application Discovery
     *         Service); most likely due to a misconfigured policy or the <code>migrationhub-discovery</code> role is
     *         missing or not configured correctly.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ListMigrationTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListMigrationTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMigrationTasksResponse listMigrationTasks(ListMigrationTasksRequest listMigrationTasksRequest)
            throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException,
            InvalidInputException, PolicyErrorException, ResourceNotFoundException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, MigrationHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all, or filtered by resource name, migration tasks associated with the user account making this call. This
     * API has the following traits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can show a summary list of the most recent migration tasks.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can show a summary list of migration tasks associated with a given discovered resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lists migration tasks in a paginated interface.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMigrationTasksRequest.Builder} avoiding the
     * need to create one manually via {@link ListMigrationTasksRequest#builder()}
     * </p>
     *
     * @param listMigrationTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest.Builder} to create a
     *        request.
     * @return Result of the ListMigrationTasks operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws PolicyErrorException
     *         Exception raised when there are problems accessing Application Discovery Service (Application Discovery
     *         Service); most likely due to a misconfigured policy or the <code>migrationhub-discovery</code> role is
     *         missing or not configured correctly.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ListMigrationTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListMigrationTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMigrationTasksResponse listMigrationTasks(Consumer<ListMigrationTasksRequest.Builder> listMigrationTasksRequest)
            throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException,
            InvalidInputException, PolicyErrorException, ResourceNotFoundException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, MigrationHubException {
        return listMigrationTasks(ListMigrationTasksRequest.builder().applyMutation(listMigrationTasksRequest).build());
    }

    /**
     * <p>
     * Lists all, or filtered by resource name, migration tasks associated with the user account making this call. This
     * API has the following traits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can show a summary list of the most recent migration tasks.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can show a summary list of migration tasks associated with a given discovered resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lists migration tasks in a paginated interface.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMigrationTasks(software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhub.paginators.ListMigrationTasksIterable responses = client.listMigrationTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhub.paginators.ListMigrationTasksIterable responses = client
     *             .listMigrationTasksPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhub.paginators.ListMigrationTasksIterable responses = client.listMigrationTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMigrationTasks(software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMigrationTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws PolicyErrorException
     *         Exception raised when there are problems accessing Application Discovery Service (Application Discovery
     *         Service); most likely due to a misconfigured policy or the <code>migrationhub-discovery</code> role is
     *         missing or not configured correctly.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ListMigrationTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListMigrationTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMigrationTasksIterable listMigrationTasksPaginator(ListMigrationTasksRequest listMigrationTasksRequest)
            throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException,
            InvalidInputException, PolicyErrorException, ResourceNotFoundException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, MigrationHubException {
        return new ListMigrationTasksIterable(this, listMigrationTasksRequest);
    }

    /**
     * <p>
     * Lists all, or filtered by resource name, migration tasks associated with the user account making this call. This
     * API has the following traits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can show a summary list of the most recent migration tasks.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can show a summary list of migration tasks associated with a given discovered resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lists migration tasks in a paginated interface.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMigrationTasks(software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhub.paginators.ListMigrationTasksIterable responses = client.listMigrationTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhub.paginators.ListMigrationTasksIterable responses = client
     *             .listMigrationTasksPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhub.paginators.ListMigrationTasksIterable responses = client.listMigrationTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMigrationTasks(software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMigrationTasksRequest.Builder} avoiding the
     * need to create one manually via {@link ListMigrationTasksRequest#builder()}
     * </p>
     *
     * @param listMigrationTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.ListMigrationTasksRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws PolicyErrorException
     *         Exception raised when there are problems accessing Application Discovery Service (Application Discovery
     *         Service); most likely due to a misconfigured policy or the <code>migrationhub-discovery</code> role is
     *         missing or not configured correctly.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ListMigrationTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListMigrationTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMigrationTasksIterable listMigrationTasksPaginator(
            Consumer<ListMigrationTasksRequest.Builder> listMigrationTasksRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException,
            PolicyErrorException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            MigrationHubException {
        return listMigrationTasksPaginator(ListMigrationTasksRequest.builder().applyMutation(listMigrationTasksRequest).build());
    }

    /**
     * <p>
     * Lists progress update streams associated with the user account making this call.
     * </p>
     *
     * @param listProgressUpdateStreamsRequest
     * @return Result of the ListProgressUpdateStreams operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ListProgressUpdateStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListProgressUpdateStreams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProgressUpdateStreamsResponse listProgressUpdateStreams(
            ListProgressUpdateStreamsRequest listProgressUpdateStreamsRequest) throws AccessDeniedException, ThrottlingException,
            InternalServerErrorException, ServiceUnavailableException, InvalidInputException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, MigrationHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists progress update streams associated with the user account making this call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProgressUpdateStreamsRequest.Builder} avoiding
     * the need to create one manually via {@link ListProgressUpdateStreamsRequest#builder()}
     * </p>
     *
     * @param listProgressUpdateStreamsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest.Builder} to
     *        create a request.
     * @return Result of the ListProgressUpdateStreams operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ListProgressUpdateStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListProgressUpdateStreams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProgressUpdateStreamsResponse listProgressUpdateStreams(
            Consumer<ListProgressUpdateStreamsRequest.Builder> listProgressUpdateStreamsRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException,
            HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        return listProgressUpdateStreams(ListProgressUpdateStreamsRequest.builder()
                .applyMutation(listProgressUpdateStreamsRequest).build());
    }

    /**
     * <p>
     * Lists progress update streams associated with the user account making this call.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProgressUpdateStreams(software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhub.paginators.ListProgressUpdateStreamsIterable responses = client.listProgressUpdateStreamsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhub.paginators.ListProgressUpdateStreamsIterable responses = client
     *             .listProgressUpdateStreamsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhub.paginators.ListProgressUpdateStreamsIterable responses = client.listProgressUpdateStreamsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProgressUpdateStreams(software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProgressUpdateStreamsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ListProgressUpdateStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListProgressUpdateStreams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProgressUpdateStreamsIterable listProgressUpdateStreamsPaginator(
            ListProgressUpdateStreamsRequest listProgressUpdateStreamsRequest) throws AccessDeniedException, ThrottlingException,
            InternalServerErrorException, ServiceUnavailableException, InvalidInputException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, MigrationHubException {
        return new ListProgressUpdateStreamsIterable(this, listProgressUpdateStreamsRequest);
    }

    /**
     * <p>
     * Lists progress update streams associated with the user account making this call.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProgressUpdateStreams(software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhub.paginators.ListProgressUpdateStreamsIterable responses = client.listProgressUpdateStreamsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.migrationhub.paginators.ListProgressUpdateStreamsIterable responses = client
     *             .listProgressUpdateStreamsPaginator(request);
     *     for (software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.migrationhub.paginators.ListProgressUpdateStreamsIterable responses = client.listProgressUpdateStreamsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProgressUpdateStreams(software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProgressUpdateStreamsRequest.Builder} avoiding
     * the need to create one manually via {@link ListProgressUpdateStreamsRequest#builder()}
     * </p>
     *
     * @param listProgressUpdateStreamsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.ListProgressUpdateStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListProgressUpdateStreams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProgressUpdateStreamsIterable listProgressUpdateStreamsPaginator(
            Consumer<ListProgressUpdateStreamsRequest.Builder> listProgressUpdateStreamsRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, InvalidInputException,
            HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        return listProgressUpdateStreamsPaginator(ListProgressUpdateStreamsRequest.builder()
                .applyMutation(listProgressUpdateStreamsRequest).build());
    }

    /**
     * <p>
     * Sets the migration state of an application. For a given application identified by the value passed to
     * <code>ApplicationId</code>, its status is set or updated by passing one of three values to <code>Status</code>:
     * <code>NOT_STARTED | IN_PROGRESS | COMPLETED</code>.
     * </p>
     *
     * @param notifyApplicationStateRequest
     * @return Result of the NotifyApplicationState operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws DryRunOperationException
     *         Exception raised to indicate a successfully authorized action when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws UnauthorizedOperationException
     *         Exception raised to indicate a request was not authorized when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws PolicyErrorException
     *         Exception raised when there are problems accessing Application Discovery Service (Application Discovery
     *         Service); most likely due to a misconfigured policy or the <code>migrationhub-discovery</code> role is
     *         missing or not configured correctly.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.NotifyApplicationState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/NotifyApplicationState"
     *      target="_top">AWS API Documentation</a>
     */
    default NotifyApplicationStateResponse notifyApplicationState(NotifyApplicationStateRequest notifyApplicationStateRequest)
            throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException,
            DryRunOperationException, UnauthorizedOperationException, InvalidInputException, PolicyErrorException,
            ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the migration state of an application. For a given application identified by the value passed to
     * <code>ApplicationId</code>, its status is set or updated by passing one of three values to <code>Status</code>:
     * <code>NOT_STARTED | IN_PROGRESS | COMPLETED</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link NotifyApplicationStateRequest.Builder} avoiding the
     * need to create one manually via {@link NotifyApplicationStateRequest#builder()}
     * </p>
     *
     * @param notifyApplicationStateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.NotifyApplicationStateRequest.Builder} to create
     *        a request.
     * @return Result of the NotifyApplicationState operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws DryRunOperationException
     *         Exception raised to indicate a successfully authorized action when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws UnauthorizedOperationException
     *         Exception raised to indicate a request was not authorized when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws PolicyErrorException
     *         Exception raised when there are problems accessing Application Discovery Service (Application Discovery
     *         Service); most likely due to a misconfigured policy or the <code>migrationhub-discovery</code> role is
     *         missing or not configured correctly.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.NotifyApplicationState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/NotifyApplicationState"
     *      target="_top">AWS API Documentation</a>
     */
    default NotifyApplicationStateResponse notifyApplicationState(
            Consumer<NotifyApplicationStateRequest.Builder> notifyApplicationStateRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException,
            UnauthorizedOperationException, InvalidInputException, PolicyErrorException, ResourceNotFoundException,
            HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        return notifyApplicationState(NotifyApplicationStateRequest.builder().applyMutation(notifyApplicationStateRequest)
                .build());
    }

    /**
     * <p>
     * Notifies Migration Hub of the current status, progress, or other detail regarding a migration task. This API has
     * the following traits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Migration tools will call the <code>NotifyMigrationTaskState</code> API to share the latest progress and status.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MigrationTaskName</code> is used for addressing updates to the correct target.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ProgressUpdateStream</code> is used for access control and to provide a namespace for each migration tool.
     * </p>
     * </li>
     * </ul>
     *
     * @param notifyMigrationTaskStateRequest
     * @return Result of the NotifyMigrationTaskState operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws DryRunOperationException
     *         Exception raised to indicate a successfully authorized action when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws UnauthorizedOperationException
     *         Exception raised to indicate a request was not authorized when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.NotifyMigrationTaskState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/NotifyMigrationTaskState"
     *      target="_top">AWS API Documentation</a>
     */
    default NotifyMigrationTaskStateResponse notifyMigrationTaskState(
            NotifyMigrationTaskStateRequest notifyMigrationTaskStateRequest) throws AccessDeniedException, ThrottlingException,
            InternalServerErrorException, ServiceUnavailableException, DryRunOperationException, UnauthorizedOperationException,
            InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException,
            MigrationHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Notifies Migration Hub of the current status, progress, or other detail regarding a migration task. This API has
     * the following traits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Migration tools will call the <code>NotifyMigrationTaskState</code> API to share the latest progress and status.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MigrationTaskName</code> is used for addressing updates to the correct target.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ProgressUpdateStream</code> is used for access control and to provide a namespace for each migration tool.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link NotifyMigrationTaskStateRequest.Builder} avoiding
     * the need to create one manually via {@link NotifyMigrationTaskStateRequest#builder()}
     * </p>
     *
     * @param notifyMigrationTaskStateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.NotifyMigrationTaskStateRequest.Builder} to
     *        create a request.
     * @return Result of the NotifyMigrationTaskState operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws DryRunOperationException
     *         Exception raised to indicate a successfully authorized action when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws UnauthorizedOperationException
     *         Exception raised to indicate a request was not authorized when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.NotifyMigrationTaskState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/NotifyMigrationTaskState"
     *      target="_top">AWS API Documentation</a>
     */
    default NotifyMigrationTaskStateResponse notifyMigrationTaskState(
            Consumer<NotifyMigrationTaskStateRequest.Builder> notifyMigrationTaskStateRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException,
            UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, MigrationHubException {
        return notifyMigrationTaskState(NotifyMigrationTaskStateRequest.builder().applyMutation(notifyMigrationTaskStateRequest)
                .build());
    }

    /**
     * <p>
     * Provides identifying details of the resource being migrated so that it can be associated in the Application
     * Discovery Service repository. This association occurs asynchronously after <code>PutResourceAttributes</code>
     * returns.
     * </p>
     * <important>
     * <ul>
     * <li>
     * <p>
     * Keep in mind that subsequent calls to PutResourceAttributes will override previously stored attributes. For
     * example, if it is first called with a MAC address, but later, it is desired to <i>add</i> an IP address, it will
     * then be required to call it with <i>both</i> the IP and MAC addresses to prevent overriding the MAC address.
     * </p>
     * </li>
     * <li>
     * <p>
     * Note the instructions regarding the special use case of the <a href=
     * "https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#migrationhub-PutResourceAttributes-request-ResourceAttributeList"
     * > <code>ResourceAttributeList</code> </a> parameter when specifying any "VM" related value.
     * </p>
     * </li>
     * </ul>
     * </important> <note>
     * <p>
     * Because this is an asynchronous call, it will always return 200, whether an association occurs or not. To confirm
     * if an association was found based on the provided details, call <code>ListDiscoveredResources</code>.
     * </p>
     * </note>
     *
     * @param putResourceAttributesRequest
     * @return Result of the PutResourceAttributes operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws DryRunOperationException
     *         Exception raised to indicate a successfully authorized action when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws UnauthorizedOperationException
     *         Exception raised to indicate a request was not authorized when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.PutResourceAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/PutResourceAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourceAttributesResponse putResourceAttributes(PutResourceAttributesRequest putResourceAttributesRequest)
            throws AccessDeniedException, ThrottlingException, InternalServerErrorException, ServiceUnavailableException,
            DryRunOperationException, UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException,
            HomeRegionNotSetException, AwsServiceException, SdkClientException, MigrationHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides identifying details of the resource being migrated so that it can be associated in the Application
     * Discovery Service repository. This association occurs asynchronously after <code>PutResourceAttributes</code>
     * returns.
     * </p>
     * <important>
     * <ul>
     * <li>
     * <p>
     * Keep in mind that subsequent calls to PutResourceAttributes will override previously stored attributes. For
     * example, if it is first called with a MAC address, but later, it is desired to <i>add</i> an IP address, it will
     * then be required to call it with <i>both</i> the IP and MAC addresses to prevent overriding the MAC address.
     * </p>
     * </li>
     * <li>
     * <p>
     * Note the instructions regarding the special use case of the <a href=
     * "https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#migrationhub-PutResourceAttributes-request-ResourceAttributeList"
     * > <code>ResourceAttributeList</code> </a> parameter when specifying any "VM" related value.
     * </p>
     * </li>
     * </ul>
     * </important> <note>
     * <p>
     * Because this is an asynchronous call, it will always return 200, whether an association occurs or not. To confirm
     * if an association was found based on the provided details, call <code>ListDiscoveredResources</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourceAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link PutResourceAttributesRequest#builder()}
     * </p>
     *
     * @param putResourceAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.migrationhub.model.PutResourceAttributesRequest.Builder} to create
     *        a request.
     * @return Result of the PutResourceAttributes operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerErrorException
     *         Exception raised when an internal, configuration, or dependency error is encountered.
     * @throws ServiceUnavailableException
     *         Exception raised when there is an internal, configuration, or dependency error encountered.
     * @throws DryRunOperationException
     *         Exception raised to indicate a successfully authorized action when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws UnauthorizedOperationException
     *         Exception raised to indicate a request was not authorized when the <code>DryRun</code> flag is set to
     *         "true".
     * @throws InvalidInputException
     *         Exception raised when the provided input violates a policy constraint or is entered in the wrong format
     *         or data type.
     * @throws ResourceNotFoundException
     *         Exception raised when the request references a resource (Application Discovery Service configuration,
     *         update stream, migration task, etc.) that does not exist in Application Discovery Service (Application
     *         Discovery Service) or in Migration Hub's repository.
     * @throws HomeRegionNotSetException
     *         The home region is not set. Set the home region to continue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MigrationHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MigrationHubClient.PutResourceAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/PutResourceAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourceAttributesResponse putResourceAttributes(
            Consumer<PutResourceAttributesRequest.Builder> putResourceAttributesRequest) throws AccessDeniedException,
            ThrottlingException, InternalServerErrorException, ServiceUnavailableException, DryRunOperationException,
            UnauthorizedOperationException, InvalidInputException, ResourceNotFoundException, HomeRegionNotSetException,
            AwsServiceException, SdkClientException, MigrationHubException {
        return putResourceAttributes(PutResourceAttributesRequest.builder().applyMutation(putResourceAttributesRequest).build());
    }

    /**
     * Create a {@link MigrationHubClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MigrationHubClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MigrationHubClient}.
     */
    static MigrationHubClientBuilder builder() {
        return new DefaultMigrationHubClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default MigrationHubServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
