/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to update a channel.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateChannelRequest extends MediaLiveRequest implements
        ToCopyableBuilder<UpdateChannelRequest.Builder, UpdateChannelRequest> {
    private static final SdkField<CdiInputSpecification> CDI_INPUT_SPECIFICATION_FIELD = SdkField
            .<CdiInputSpecification> builder(MarshallingType.SDK_POJO).memberName("CdiInputSpecification")
            .getter(getter(UpdateChannelRequest::cdiInputSpecification)).setter(setter(Builder::cdiInputSpecification))
            .constructor(CdiInputSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cdiInputSpecification").build())
            .build();

    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelId").getter(getter(UpdateChannelRequest::channelId)).setter(setter(Builder::channelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelId").build()).build();

    private static final SdkField<List<OutputDestination>> DESTINATIONS_FIELD = SdkField
            .<List<OutputDestination>> builder(MarshallingType.LIST)
            .memberName("Destinations")
            .getter(getter(UpdateChannelRequest::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EncoderSettings> ENCODER_SETTINGS_FIELD = SdkField
            .<EncoderSettings> builder(MarshallingType.SDK_POJO).memberName("EncoderSettings")
            .getter(getter(UpdateChannelRequest::encoderSettings)).setter(setter(Builder::encoderSettings))
            .constructor(EncoderSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoderSettings").build()).build();

    private static final SdkField<List<InputAttachment>> INPUT_ATTACHMENTS_FIELD = SdkField
            .<List<InputAttachment>> builder(MarshallingType.LIST)
            .memberName("InputAttachments")
            .getter(getter(UpdateChannelRequest::inputAttachments))
            .setter(setter(Builder::inputAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAttachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputAttachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputAttachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InputSpecification> INPUT_SPECIFICATION_FIELD = SdkField
            .<InputSpecification> builder(MarshallingType.SDK_POJO).memberName("InputSpecification")
            .getter(getter(UpdateChannelRequest::inputSpecification)).setter(setter(Builder::inputSpecification))
            .constructor(InputSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSpecification").build())
            .build();

    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogLevel").getter(getter(UpdateChannelRequest::logLevelAsString)).setter(setter(Builder::logLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()).build();

    private static final SdkField<MaintenanceUpdateSettings> MAINTENANCE_FIELD = SdkField
            .<MaintenanceUpdateSettings> builder(MarshallingType.SDK_POJO).memberName("Maintenance")
            .getter(getter(UpdateChannelRequest::maintenance)).setter(setter(Builder::maintenance))
            .constructor(MaintenanceUpdateSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenance").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateChannelRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdateChannelRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CDI_INPUT_SPECIFICATION_FIELD,
            CHANNEL_ID_FIELD, DESTINATIONS_FIELD, ENCODER_SETTINGS_FIELD, INPUT_ATTACHMENTS_FIELD, INPUT_SPECIFICATION_FIELD,
            LOG_LEVEL_FIELD, MAINTENANCE_FIELD, NAME_FIELD, ROLE_ARN_FIELD));

    private final CdiInputSpecification cdiInputSpecification;

    private final String channelId;

    private final List<OutputDestination> destinations;

    private final EncoderSettings encoderSettings;

    private final List<InputAttachment> inputAttachments;

    private final InputSpecification inputSpecification;

    private final String logLevel;

    private final MaintenanceUpdateSettings maintenance;

    private final String name;

    private final String roleArn;

    private UpdateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.cdiInputSpecification = builder.cdiInputSpecification;
        this.channelId = builder.channelId;
        this.destinations = builder.destinations;
        this.encoderSettings = builder.encoderSettings;
        this.inputAttachments = builder.inputAttachments;
        this.inputSpecification = builder.inputSpecification;
        this.logLevel = builder.logLevel;
        this.maintenance = builder.maintenance;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
    }

    /**
     * Specification of CDI inputs for this channel
     * 
     * @return Specification of CDI inputs for this channel
     */
    public final CdiInputSpecification cdiInputSpecification() {
        return cdiInputSpecification;
    }

    /**
     * channel ID
     * 
     * @return channel ID
     */
    public final String channelId() {
        return channelId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * A list of output destinations for this channel.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinations} method.
     * </p>
     * 
     * @return A list of output destinations for this channel.
     */
    public final List<OutputDestination> destinations() {
        return destinations;
    }

    /**
     * The encoder settings for this channel.
     * 
     * @return The encoder settings for this channel.
     */
    public final EncoderSettings encoderSettings() {
        return encoderSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputAttachments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputAttachments() {
        return inputAttachments != null && !(inputAttachments instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the InputAttachments property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputAttachments} method.
     * </p>
     * 
     * @return The value of the InputAttachments property for this object.
     */
    public final List<InputAttachment> inputAttachments() {
        return inputAttachments;
    }

    /**
     * Specification of network and file inputs for this channel
     * 
     * @return Specification of network and file inputs for this channel
     */
    public final InputSpecification inputSpecification() {
        return inputSpecification;
    }

    /**
     * The log level to write to CloudWatch Logs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The log level to write to CloudWatch Logs.
     * @see LogLevel
     */
    public final LogLevel logLevel() {
        return LogLevel.fromValue(logLevel);
    }

    /**
     * The log level to write to CloudWatch Logs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The log level to write to CloudWatch Logs.
     * @see LogLevel
     */
    public final String logLevelAsString() {
        return logLevel;
    }

    /**
     * Maintenance settings for this channel.
     * 
     * @return Maintenance settings for this channel.
     */
    public final MaintenanceUpdateSettings maintenance() {
        return maintenance;
    }

    /**
     * The name of the channel.
     * 
     * @return The name of the channel.
     */
    public final String name() {
        return name;
    }

    /**
     * An optional Amazon Resource Name (ARN) of the role to assume when running the Channel. If you do not specify this
     * on an update call but the role was previously set that role will be removed.
     * 
     * @return An optional Amazon Resource Name (ARN) of the role to assume when running the Channel. If you do not
     *         specify this on an update call but the role was previously set that role will be removed.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cdiInputSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(channelId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(encoderSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputAttachments() ? inputAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inputSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maintenance());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelRequest)) {
            return false;
        }
        UpdateChannelRequest other = (UpdateChannelRequest) obj;
        return Objects.equals(cdiInputSpecification(), other.cdiInputSpecification())
                && Objects.equals(channelId(), other.channelId()) && hasDestinations() == other.hasDestinations()
                && Objects.equals(destinations(), other.destinations())
                && Objects.equals(encoderSettings(), other.encoderSettings())
                && hasInputAttachments() == other.hasInputAttachments()
                && Objects.equals(inputAttachments(), other.inputAttachments())
                && Objects.equals(inputSpecification(), other.inputSpecification())
                && Objects.equals(logLevelAsString(), other.logLevelAsString())
                && Objects.equals(maintenance(), other.maintenance()) && Objects.equals(name(), other.name())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateChannelRequest").add("CdiInputSpecification", cdiInputSpecification())
                .add("ChannelId", channelId()).add("Destinations", hasDestinations() ? destinations() : null)
                .add("EncoderSettings", encoderSettings())
                .add("InputAttachments", hasInputAttachments() ? inputAttachments() : null)
                .add("InputSpecification", inputSpecification()).add("LogLevel", logLevelAsString())
                .add("Maintenance", maintenance()).add("Name", name()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CdiInputSpecification":
            return Optional.ofNullable(clazz.cast(cdiInputSpecification()));
        case "ChannelId":
            return Optional.ofNullable(clazz.cast(channelId()));
        case "Destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        case "EncoderSettings":
            return Optional.ofNullable(clazz.cast(encoderSettings()));
        case "InputAttachments":
            return Optional.ofNullable(clazz.cast(inputAttachments()));
        case "InputSpecification":
            return Optional.ofNullable(clazz.cast(inputSpecification()));
        case "LogLevel":
            return Optional.ofNullable(clazz.cast(logLevelAsString()));
        case "Maintenance":
            return Optional.ofNullable(clazz.cast(maintenance()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateChannelRequest, T> g) {
        return obj -> g.apply((UpdateChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateChannelRequest> {
        /**
         * Specification of CDI inputs for this channel
         * 
         * @param cdiInputSpecification
         *        Specification of CDI inputs for this channel
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdiInputSpecification(CdiInputSpecification cdiInputSpecification);

        /**
         * Specification of CDI inputs for this channel This is a convenience method that creates an instance of the
         * {@link CdiInputSpecification.Builder} avoiding the need to create one manually via
         * {@link CdiInputSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CdiInputSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #cdiInputSpecification(CdiInputSpecification)}.
         * 
         * @param cdiInputSpecification
         *        a consumer that will call methods on {@link CdiInputSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cdiInputSpecification(CdiInputSpecification)
         */
        default Builder cdiInputSpecification(Consumer<CdiInputSpecification.Builder> cdiInputSpecification) {
            return cdiInputSpecification(CdiInputSpecification.builder().applyMutation(cdiInputSpecification).build());
        }

        /**
         * channel ID
         * 
         * @param channelId
         *        channel ID
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelId(String channelId);

        /**
         * A list of output destinations for this channel.
         * 
         * @param destinations
         *        A list of output destinations for this channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<OutputDestination> destinations);

        /**
         * A list of output destinations for this channel.
         * 
         * @param destinations
         *        A list of output destinations for this channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(OutputDestination... destinations);

        /**
         * A list of output destinations for this channel. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.OutputDestination.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.medialive.model.OutputDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.OutputDestination.Builder#build()} is called
         * immediately and its result is passed to {@link #destinations(List<OutputDestination>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.OutputDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(java.util.Collection<OutputDestination>)
         */
        Builder destinations(Consumer<OutputDestination.Builder>... destinations);

        /**
         * The encoder settings for this channel.
         * 
         * @param encoderSettings
         *        The encoder settings for this channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encoderSettings(EncoderSettings encoderSettings);

        /**
         * The encoder settings for this channel. This is a convenience method that creates an instance of the
         * {@link EncoderSettings.Builder} avoiding the need to create one manually via
         * {@link EncoderSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncoderSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #encoderSettings(EncoderSettings)}.
         * 
         * @param encoderSettings
         *        a consumer that will call methods on {@link EncoderSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encoderSettings(EncoderSettings)
         */
        default Builder encoderSettings(Consumer<EncoderSettings.Builder> encoderSettings) {
            return encoderSettings(EncoderSettings.builder().applyMutation(encoderSettings).build());
        }

        /**
         * Sets the value of the InputAttachments property for this object.
         *
         * @param inputAttachments
         *        The new value for the InputAttachments property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputAttachments(Collection<InputAttachment> inputAttachments);

        /**
         * Sets the value of the InputAttachments property for this object.
         *
         * @param inputAttachments
         *        The new value for the InputAttachments property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputAttachments(InputAttachment... inputAttachments);

        /**
         * Sets the value of the InputAttachments property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.InputAttachment.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.medialive.model.InputAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.InputAttachment.Builder#build()} is called immediately
         * and its result is passed to {@link #inputAttachments(List<InputAttachment>)}.
         * 
         * @param inputAttachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.InputAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputAttachments(java.util.Collection<InputAttachment>)
         */
        Builder inputAttachments(Consumer<InputAttachment.Builder>... inputAttachments);

        /**
         * Specification of network and file inputs for this channel
         * 
         * @param inputSpecification
         *        Specification of network and file inputs for this channel
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSpecification(InputSpecification inputSpecification);

        /**
         * Specification of network and file inputs for this channel This is a convenience method that creates an
         * instance of the {@link InputSpecification.Builder} avoiding the need to create one manually via
         * {@link InputSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputSpecification.Builder#build()} is called immediately and its
         * result is passed to {@link #inputSpecification(InputSpecification)}.
         * 
         * @param inputSpecification
         *        a consumer that will call methods on {@link InputSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputSpecification(InputSpecification)
         */
        default Builder inputSpecification(Consumer<InputSpecification.Builder> inputSpecification) {
            return inputSpecification(InputSpecification.builder().applyMutation(inputSpecification).build());
        }

        /**
         * The log level to write to CloudWatch Logs.
         * 
         * @param logLevel
         *        The log level to write to CloudWatch Logs.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(String logLevel);

        /**
         * The log level to write to CloudWatch Logs.
         * 
         * @param logLevel
         *        The log level to write to CloudWatch Logs.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(LogLevel logLevel);

        /**
         * Maintenance settings for this channel.
         * 
         * @param maintenance
         *        Maintenance settings for this channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenance(MaintenanceUpdateSettings maintenance);

        /**
         * Maintenance settings for this channel. This is a convenience method that creates an instance of the
         * {@link MaintenanceUpdateSettings.Builder} avoiding the need to create one manually via
         * {@link MaintenanceUpdateSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaintenanceUpdateSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #maintenance(MaintenanceUpdateSettings)}.
         * 
         * @param maintenance
         *        a consumer that will call methods on {@link MaintenanceUpdateSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenance(MaintenanceUpdateSettings)
         */
        default Builder maintenance(Consumer<MaintenanceUpdateSettings.Builder> maintenance) {
            return maintenance(MaintenanceUpdateSettings.builder().applyMutation(maintenance).build());
        }

        /**
         * The name of the channel.
         * 
         * @param name
         *        The name of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * An optional Amazon Resource Name (ARN) of the role to assume when running the Channel. If you do not specify
         * this on an update call but the role was previously set that role will be removed.
         * 
         * @param roleArn
         *        An optional Amazon Resource Name (ARN) of the role to assume when running the Channel. If you do not
         *        specify this on an update call but the role was previously set that role will be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private CdiInputSpecification cdiInputSpecification;

        private String channelId;

        private List<OutputDestination> destinations = DefaultSdkAutoConstructList.getInstance();

        private EncoderSettings encoderSettings;

        private List<InputAttachment> inputAttachments = DefaultSdkAutoConstructList.getInstance();

        private InputSpecification inputSpecification;

        private String logLevel;

        private MaintenanceUpdateSettings maintenance;

        private String name;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChannelRequest model) {
            super(model);
            cdiInputSpecification(model.cdiInputSpecification);
            channelId(model.channelId);
            destinations(model.destinations);
            encoderSettings(model.encoderSettings);
            inputAttachments(model.inputAttachments);
            inputSpecification(model.inputSpecification);
            logLevel(model.logLevel);
            maintenance(model.maintenance);
            name(model.name);
            roleArn(model.roleArn);
        }

        public final CdiInputSpecification.Builder getCdiInputSpecification() {
            return cdiInputSpecification != null ? cdiInputSpecification.toBuilder() : null;
        }

        public final void setCdiInputSpecification(CdiInputSpecification.BuilderImpl cdiInputSpecification) {
            this.cdiInputSpecification = cdiInputSpecification != null ? cdiInputSpecification.build() : null;
        }

        @Override
        public final Builder cdiInputSpecification(CdiInputSpecification cdiInputSpecification) {
            this.cdiInputSpecification = cdiInputSpecification;
            return this;
        }

        public final String getChannelId() {
            return channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final List<OutputDestination.Builder> getDestinations() {
            List<OutputDestination.Builder> result = ___listOfOutputDestinationCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<OutputDestination.BuilderImpl> destinations) {
            this.destinations = ___listOfOutputDestinationCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<OutputDestination> destinations) {
            this.destinations = ___listOfOutputDestinationCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(OutputDestination... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<OutputDestination.Builder>... destinations) {
            destinations(Stream.of(destinations).map(c -> OutputDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final EncoderSettings.Builder getEncoderSettings() {
            return encoderSettings != null ? encoderSettings.toBuilder() : null;
        }

        public final void setEncoderSettings(EncoderSettings.BuilderImpl encoderSettings) {
            this.encoderSettings = encoderSettings != null ? encoderSettings.build() : null;
        }

        @Override
        public final Builder encoderSettings(EncoderSettings encoderSettings) {
            this.encoderSettings = encoderSettings;
            return this;
        }

        public final List<InputAttachment.Builder> getInputAttachments() {
            List<InputAttachment.Builder> result = ___listOfInputAttachmentCopier.copyToBuilder(this.inputAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputAttachments(Collection<InputAttachment.BuilderImpl> inputAttachments) {
            this.inputAttachments = ___listOfInputAttachmentCopier.copyFromBuilder(inputAttachments);
        }

        @Override
        public final Builder inputAttachments(Collection<InputAttachment> inputAttachments) {
            this.inputAttachments = ___listOfInputAttachmentCopier.copy(inputAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttachments(InputAttachment... inputAttachments) {
            inputAttachments(Arrays.asList(inputAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttachments(Consumer<InputAttachment.Builder>... inputAttachments) {
            inputAttachments(Stream.of(inputAttachments).map(c -> InputAttachment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InputSpecification.Builder getInputSpecification() {
            return inputSpecification != null ? inputSpecification.toBuilder() : null;
        }

        public final void setInputSpecification(InputSpecification.BuilderImpl inputSpecification) {
            this.inputSpecification = inputSpecification != null ? inputSpecification.build() : null;
        }

        @Override
        public final Builder inputSpecification(InputSpecification inputSpecification) {
            this.inputSpecification = inputSpecification;
            return this;
        }

        public final String getLogLevel() {
            return logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final MaintenanceUpdateSettings.Builder getMaintenance() {
            return maintenance != null ? maintenance.toBuilder() : null;
        }

        public final void setMaintenance(MaintenanceUpdateSettings.BuilderImpl maintenance) {
            this.maintenance = maintenance != null ? maintenance.build() : null;
        }

        @Override
        public final Builder maintenance(MaintenanceUpdateSettings maintenance) {
            this.maintenance = maintenance;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChannelRequest build() {
            return new UpdateChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
