/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to reboot an AWS Elemental device.
 */
@Generated("software.amazon.awssdk:codegen")
public final class RebootInputDeviceRequest extends MediaLiveRequest implements
        ToCopyableBuilder<RebootInputDeviceRequest.Builder, RebootInputDeviceRequest> {
    private static final SdkField<String> FORCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Force")
            .getter(getter(RebootInputDeviceRequest::forceAsString)).setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("force").build()).build();

    private static final SdkField<String> INPUT_DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputDeviceId").getter(getter(RebootInputDeviceRequest::inputDeviceId))
            .setter(setter(Builder::inputDeviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("inputDeviceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORCE_FIELD,
            INPUT_DEVICE_ID_FIELD));

    private final String force;

    private final String inputDeviceId;

    private RebootInputDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.force = builder.force;
        this.inputDeviceId = builder.inputDeviceId;
    }

    /**
     * Force a reboot of an input device. If the device is streaming, it will stop streaming and begin rebooting within
     * a few seconds of sending the command. If the device was streaming prior to the reboot, the device will resume
     * streaming when the reboot completes.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #force} will return
     * {@link RebootInputDeviceForce#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #forceAsString}.
     * </p>
     * 
     * @return Force a reboot of an input device. If the device is streaming, it will stop streaming and begin rebooting
     *         within a few seconds of sending the command. If the device was streaming prior to the reboot, the device
     *         will resume streaming when the reboot completes.
     * @see RebootInputDeviceForce
     */
    public final RebootInputDeviceForce force() {
        return RebootInputDeviceForce.fromValue(force);
    }

    /**
     * Force a reboot of an input device. If the device is streaming, it will stop streaming and begin rebooting within
     * a few seconds of sending the command. If the device was streaming prior to the reboot, the device will resume
     * streaming when the reboot completes.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #force} will return
     * {@link RebootInputDeviceForce#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #forceAsString}.
     * </p>
     * 
     * @return Force a reboot of an input device. If the device is streaming, it will stop streaming and begin rebooting
     *         within a few seconds of sending the command. If the device was streaming prior to the reboot, the device
     *         will resume streaming when the reboot completes.
     * @see RebootInputDeviceForce
     */
    public final String forceAsString() {
        return force;
    }

    /**
     * The unique ID of the input device to reboot. For example, hd-123456789abcdef.
     * 
     * @return The unique ID of the input device to reboot. For example, hd-123456789abcdef.
     */
    public final String inputDeviceId() {
        return inputDeviceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(forceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputDeviceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebootInputDeviceRequest)) {
            return false;
        }
        RebootInputDeviceRequest other = (RebootInputDeviceRequest) obj;
        return Objects.equals(forceAsString(), other.forceAsString()) && Objects.equals(inputDeviceId(), other.inputDeviceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RebootInputDeviceRequest").add("Force", forceAsString()).add("InputDeviceId", inputDeviceId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Force":
            return Optional.ofNullable(clazz.cast(forceAsString()));
        case "InputDeviceId":
            return Optional.ofNullable(clazz.cast(inputDeviceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RebootInputDeviceRequest, T> g) {
        return obj -> g.apply((RebootInputDeviceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, RebootInputDeviceRequest> {
        /**
         * Force a reboot of an input device. If the device is streaming, it will stop streaming and begin rebooting
         * within a few seconds of sending the command. If the device was streaming prior to the reboot, the device will
         * resume streaming when the reboot completes.
         * 
         * @param force
         *        Force a reboot of an input device. If the device is streaming, it will stop streaming and begin
         *        rebooting within a few seconds of sending the command. If the device was streaming prior to the
         *        reboot, the device will resume streaming when the reboot completes.
         * @see RebootInputDeviceForce
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RebootInputDeviceForce
         */
        Builder force(String force);

        /**
         * Force a reboot of an input device. If the device is streaming, it will stop streaming and begin rebooting
         * within a few seconds of sending the command. If the device was streaming prior to the reboot, the device will
         * resume streaming when the reboot completes.
         * 
         * @param force
         *        Force a reboot of an input device. If the device is streaming, it will stop streaming and begin
         *        rebooting within a few seconds of sending the command. If the device was streaming prior to the
         *        reboot, the device will resume streaming when the reboot completes.
         * @see RebootInputDeviceForce
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RebootInputDeviceForce
         */
        Builder force(RebootInputDeviceForce force);

        /**
         * The unique ID of the input device to reboot. For example, hd-123456789abcdef.
         * 
         * @param inputDeviceId
         *        The unique ID of the input device to reboot. For example, hd-123456789abcdef.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDeviceId(String inputDeviceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String force;

        private String inputDeviceId;

        private BuilderImpl() {
        }

        private BuilderImpl(RebootInputDeviceRequest model) {
            super(model);
            force(model.force);
            inputDeviceId(model.inputDeviceId);
        }

        public final String getForce() {
            return force;
        }

        public final void setForce(String force) {
            this.force = force;
        }

        @Override
        public final Builder force(String force) {
            this.force = force;
            return this;
        }

        @Override
        public final Builder force(RebootInputDeviceForce force) {
            this.force(force == null ? null : force.toString());
            return this;
        }

        public final String getInputDeviceId() {
            return inputDeviceId;
        }

        public final void setInputDeviceId(String inputDeviceId) {
            this.inputDeviceId = inputDeviceId;
        }

        @Override
        public final Builder inputDeviceId(String inputDeviceId) {
            this.inputDeviceId = inputDeviceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RebootInputDeviceRequest build() {
            return new RebootInputDeviceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
