/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for PurchaseOfferingRequest
 */
@Generated("software.amazon.awssdk:codegen")
public final class PurchaseOfferingRequest extends MediaLiveRequest implements
        ToCopyableBuilder<PurchaseOfferingRequest.Builder, PurchaseOfferingRequest> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Count")
            .getter(getter(PurchaseOfferingRequest::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PurchaseOfferingRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OfferingId").getter(getter(PurchaseOfferingRequest::offeringId)).setter(setter(Builder::offeringId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("offeringId").build()).build();

    private static final SdkField<RenewalSettings> RENEWAL_SETTINGS_FIELD = SdkField
            .<RenewalSettings> builder(MarshallingType.SDK_POJO).memberName("RenewalSettings")
            .getter(getter(PurchaseOfferingRequest::renewalSettings)).setter(setter(Builder::renewalSettings))
            .constructor(RenewalSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renewalSettings").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RequestId")
            .getter(getter(PurchaseOfferingRequest::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> START_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Start")
            .getter(getter(PurchaseOfferingRequest::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(PurchaseOfferingRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, NAME_FIELD,
            OFFERING_ID_FIELD, RENEWAL_SETTINGS_FIELD, REQUEST_ID_FIELD, START_FIELD, TAGS_FIELD));

    private final Integer count;

    private final String name;

    private final String offeringId;

    private final RenewalSettings renewalSettings;

    private final String requestId;

    private final String start;

    private final Map<String, String> tags;

    private PurchaseOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.count = builder.count;
        this.name = builder.name;
        this.offeringId = builder.offeringId;
        this.renewalSettings = builder.renewalSettings;
        this.requestId = builder.requestId;
        this.start = builder.start;
        this.tags = builder.tags;
    }

    /**
     * Number of resources
     * 
     * @return Number of resources
     */
    public final Integer count() {
        return count;
    }

    /**
     * Name for the new reservation
     * 
     * @return Name for the new reservation
     */
    public final String name() {
        return name;
    }

    /**
     * Offering to purchase, e.g. '87654321'
     * 
     * @return Offering to purchase, e.g. '87654321'
     */
    public final String offeringId() {
        return offeringId;
    }

    /**
     * Renewal settings for the reservation
     * 
     * @return Renewal settings for the reservation
     */
    public final RenewalSettings renewalSettings() {
        return renewalSettings;
    }

    /**
     * Unique request ID to be specified. This is needed to prevent retries from creating multiple resources.
     * 
     * @return Unique request ID to be specified. This is needed to prevent retries from creating multiple resources.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * Requested reservation start time (UTC) in ISO-8601 format. The specified time must be between the first day of
     * the current month and one year from now. If no value is given, the default is now.
     * 
     * @return Requested reservation start time (UTC) in ISO-8601 format. The specified time must be between the first
     *         day of the current month and one year from now. If no value is given, the default is now.
     */
    public final String start() {
        return start;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * A collection of key-value pairs
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A collection of key-value pairs
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(renewalSettings());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseOfferingRequest)) {
            return false;
        }
        PurchaseOfferingRequest other = (PurchaseOfferingRequest) obj;
        return Objects.equals(count(), other.count()) && Objects.equals(name(), other.name())
                && Objects.equals(offeringId(), other.offeringId()) && Objects.equals(renewalSettings(), other.renewalSettings())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(start(), other.start())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PurchaseOfferingRequest").add("Count", count()).add("Name", name())
                .add("OfferingId", offeringId()).add("RenewalSettings", renewalSettings()).add("RequestId", requestId())
                .add("Start", start()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OfferingId":
            return Optional.ofNullable(clazz.cast(offeringId()));
        case "RenewalSettings":
            return Optional.ofNullable(clazz.cast(renewalSettings()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Start":
            return Optional.ofNullable(clazz.cast(start()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseOfferingRequest, T> g) {
        return obj -> g.apply((PurchaseOfferingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, PurchaseOfferingRequest> {
        /**
         * Number of resources
         * 
         * @param count
         *        Number of resources
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * Name for the new reservation
         * 
         * @param name
         *        Name for the new reservation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Offering to purchase, e.g. '87654321'
         * 
         * @param offeringId
         *        Offering to purchase, e.g. '87654321'
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        /**
         * Renewal settings for the reservation
         * 
         * @param renewalSettings
         *        Renewal settings for the reservation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renewalSettings(RenewalSettings renewalSettings);

        /**
         * Renewal settings for the reservation This is a convenience method that creates an instance of the
         * {@link RenewalSettings.Builder} avoiding the need to create one manually via
         * {@link RenewalSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RenewalSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #renewalSettings(RenewalSettings)}.
         * 
         * @param renewalSettings
         *        a consumer that will call methods on {@link RenewalSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #renewalSettings(RenewalSettings)
         */
        default Builder renewalSettings(Consumer<RenewalSettings.Builder> renewalSettings) {
            return renewalSettings(RenewalSettings.builder().applyMutation(renewalSettings).build());
        }

        /**
         * Unique request ID to be specified. This is needed to prevent retries from creating multiple resources.
         * 
         * @param requestId
         *        Unique request ID to be specified. This is needed to prevent retries from creating multiple resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * Requested reservation start time (UTC) in ISO-8601 format. The specified time must be between the first day
         * of the current month and one year from now. If no value is given, the default is now.
         * 
         * @param start
         *        Requested reservation start time (UTC) in ISO-8601 format. The specified time must be between the
         *        first day of the current month and one year from now. If no value is given, the default is now.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(String start);

        /**
         * A collection of key-value pairs
         * 
         * @param tags
         *        A collection of key-value pairs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private Integer count;

        private String name;

        private String offeringId;

        private RenewalSettings renewalSettings;

        private String requestId;

        private String start;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseOfferingRequest model) {
            super(model);
            count(model.count);
            name(model.name);
            offeringId(model.offeringId);
            renewalSettings(model.renewalSettings);
            requestId(model.requestId);
            start(model.start);
            tags(model.tags);
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOfferingId() {
            return offeringId;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final RenewalSettings.Builder getRenewalSettings() {
            return renewalSettings != null ? renewalSettings.toBuilder() : null;
        }

        public final void setRenewalSettings(RenewalSettings.BuilderImpl renewalSettings) {
            this.renewalSettings = renewalSettings != null ? renewalSettings.build() : null;
        }

        @Override
        public final Builder renewalSettings(RenewalSettings renewalSettings) {
            this.renewalSettings = renewalSettings;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getStart() {
            return start;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseOfferingRequest build() {
            return new PurchaseOfferingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
