/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for the action to emit HLS metadata
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsTimedMetadataScheduleActionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<HlsTimedMetadataScheduleActionSettings.Builder, HlsTimedMetadataScheduleActionSettings> {
    private static final SdkField<String> ID3_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id3")
            .getter(getter(HlsTimedMetadataScheduleActionSettings::id3)).setter(setter(Builder::id3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id3").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID3_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id3;

    private HlsTimedMetadataScheduleActionSettings(BuilderImpl builder) {
        this.id3 = builder.id3;
    }

    /**
     * Base64 string formatted according to the ID3 specification: http://id3.org/id3v2.4.0-structure
     * 
     * @return Base64 string formatted according to the ID3 specification: http://id3.org/id3v2.4.0-structure
     */
    public final String id3() {
        return id3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id3());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsTimedMetadataScheduleActionSettings)) {
            return false;
        }
        HlsTimedMetadataScheduleActionSettings other = (HlsTimedMetadataScheduleActionSettings) obj;
        return Objects.equals(id3(), other.id3());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HlsTimedMetadataScheduleActionSettings").add("Id3", id3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id3":
            return Optional.ofNullable(clazz.cast(id3()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsTimedMetadataScheduleActionSettings, T> g) {
        return obj -> g.apply((HlsTimedMetadataScheduleActionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsTimedMetadataScheduleActionSettings> {
        /**
         * Base64 string formatted according to the ID3 specification: http://id3.org/id3v2.4.0-structure
         * 
         * @param id3
         *        Base64 string formatted according to the ID3 specification: http://id3.org/id3v2.4.0-structure
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id3(String id3);
    }

    static final class BuilderImpl implements Builder {
        private String id3;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsTimedMetadataScheduleActionSettings model) {
            id3(model.id3);
        }

        public final String getId3() {
            return id3;
        }

        public final void setId3(String id3) {
            this.id3 = id3;
        }

        @Override
        public final Builder id3(String id3) {
            this.id3 = id3;
            return this;
        }

        @Override
        public HlsTimedMetadataScheduleActionSettings build() {
            return new HlsTimedMetadataScheduleActionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
