/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings related to video encoding of your output. The specific video settings depend on the video codec that you
 * choose.
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoDescription.Builder, VideoDescription> {
    private static final SdkField<String> AFD_SIGNALING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AfdSignaling").getter(getter(VideoDescription::afdSignalingAsString))
            .setter(setter(Builder::afdSignaling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afdSignaling").build()).build();

    private static final SdkField<String> ANTI_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AntiAlias").getter(getter(VideoDescription::antiAliasAsString)).setter(setter(Builder::antiAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antiAlias").build()).build();

    private static final SdkField<VideoCodecSettings> CODEC_SETTINGS_FIELD = SdkField
            .<VideoCodecSettings> builder(MarshallingType.SDK_POJO).memberName("CodecSettings")
            .getter(getter(VideoDescription::codecSettings)).setter(setter(Builder::codecSettings))
            .constructor(VideoCodecSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecSettings").build()).build();

    private static final SdkField<String> COLOR_METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColorMetadata").getter(getter(VideoDescription::colorMetadataAsString))
            .setter(setter(Builder::colorMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorMetadata").build()).build();

    private static final SdkField<Rectangle> CROP_FIELD = SdkField.<Rectangle> builder(MarshallingType.SDK_POJO)
            .memberName("Crop").getter(getter(VideoDescription::crop)).setter(setter(Builder::crop))
            .constructor(Rectangle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crop").build()).build();

    private static final SdkField<String> DROP_FRAME_TIMECODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DropFrameTimecode").getter(getter(VideoDescription::dropFrameTimecodeAsString))
            .setter(setter(Builder::dropFrameTimecode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dropFrameTimecode").build()).build();

    private static final SdkField<Integer> FIXED_AFD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FixedAfd").getter(getter(VideoDescription::fixedAfd)).setter(setter(Builder::fixedAfd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedAfd").build()).build();

    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Height").getter(getter(VideoDescription::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()).build();

    private static final SdkField<Rectangle> POSITION_FIELD = SdkField.<Rectangle> builder(MarshallingType.SDK_POJO)
            .memberName("Position").getter(getter(VideoDescription::position)).setter(setter(Builder::position))
            .constructor(Rectangle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()).build();

    private static final SdkField<String> RESPOND_TO_AFD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RespondToAfd").getter(getter(VideoDescription::respondToAfdAsString))
            .setter(setter(Builder::respondToAfd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("respondToAfd").build()).build();

    private static final SdkField<String> SCALING_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScalingBehavior").getter(getter(VideoDescription::scalingBehaviorAsString))
            .setter(setter(Builder::scalingBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingBehavior").build()).build();

    private static final SdkField<Integer> SHARPNESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Sharpness").getter(getter(VideoDescription::sharpness)).setter(setter(Builder::sharpness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharpness").build()).build();

    private static final SdkField<String> TIMECODE_INSERTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimecodeInsertion").getter(getter(VideoDescription::timecodeInsertionAsString))
            .setter(setter(Builder::timecodeInsertion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeInsertion").build()).build();

    private static final SdkField<VideoPreprocessor> VIDEO_PREPROCESSORS_FIELD = SdkField
            .<VideoPreprocessor> builder(MarshallingType.SDK_POJO).memberName("VideoPreprocessors")
            .getter(getter(VideoDescription::videoPreprocessors)).setter(setter(Builder::videoPreprocessors))
            .constructor(VideoPreprocessor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoPreprocessors").build())
            .build();

    private static final SdkField<Integer> WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Width")
            .getter(getter(VideoDescription::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFD_SIGNALING_FIELD,
            ANTI_ALIAS_FIELD, CODEC_SETTINGS_FIELD, COLOR_METADATA_FIELD, CROP_FIELD, DROP_FRAME_TIMECODE_FIELD, FIXED_AFD_FIELD,
            HEIGHT_FIELD, POSITION_FIELD, RESPOND_TO_AFD_FIELD, SCALING_BEHAVIOR_FIELD, SHARPNESS_FIELD,
            TIMECODE_INSERTION_FIELD, VIDEO_PREPROCESSORS_FIELD, WIDTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String afdSignaling;

    private final String antiAlias;

    private final VideoCodecSettings codecSettings;

    private final String colorMetadata;

    private final Rectangle crop;

    private final String dropFrameTimecode;

    private final Integer fixedAfd;

    private final Integer height;

    private final Rectangle position;

    private final String respondToAfd;

    private final String scalingBehavior;

    private final Integer sharpness;

    private final String timecodeInsertion;

    private final VideoPreprocessor videoPreprocessors;

    private final Integer width;

    private VideoDescription(BuilderImpl builder) {
        this.afdSignaling = builder.afdSignaling;
        this.antiAlias = builder.antiAlias;
        this.codecSettings = builder.codecSettings;
        this.colorMetadata = builder.colorMetadata;
        this.crop = builder.crop;
        this.dropFrameTimecode = builder.dropFrameTimecode;
        this.fixedAfd = builder.fixedAfd;
        this.height = builder.height;
        this.position = builder.position;
        this.respondToAfd = builder.respondToAfd;
        this.scalingBehavior = builder.scalingBehavior;
        this.sharpness = builder.sharpness;
        this.timecodeInsertion = builder.timecodeInsertion;
        this.videoPreprocessors = builder.videoPreprocessors;
        this.width = builder.width;
    }

    /**
     * This setting only applies to H.264, H.265, and MPEG2 outputs. Use Insert AFD signaling to specify whether the
     * service includes AFD values in the output video data and what those values are. * Choose None to remove all AFD
     * values from this output. * Choose Fixed to ignore input AFD values and instead encode the value specified in the
     * job. * Choose Auto to calculate output AFD values based on the input AFD scaler data.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #afdSignaling} will
     * return {@link AfdSignaling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #afdSignalingAsString}.
     * </p>
     * 
     * @return This setting only applies to H.264, H.265, and MPEG2 outputs. Use Insert AFD signaling to specify whether
     *         the service includes AFD values in the output video data and what those values are. * Choose None to
     *         remove all AFD values from this output. * Choose Fixed to ignore input AFD values and instead encode the
     *         value specified in the job. * Choose Auto to calculate output AFD values based on the input AFD scaler
     *         data.
     * @see AfdSignaling
     */
    public final AfdSignaling afdSignaling() {
        return AfdSignaling.fromValue(afdSignaling);
    }

    /**
     * This setting only applies to H.264, H.265, and MPEG2 outputs. Use Insert AFD signaling to specify whether the
     * service includes AFD values in the output video data and what those values are. * Choose None to remove all AFD
     * values from this output. * Choose Fixed to ignore input AFD values and instead encode the value specified in the
     * job. * Choose Auto to calculate output AFD values based on the input AFD scaler data.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #afdSignaling} will
     * return {@link AfdSignaling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #afdSignalingAsString}.
     * </p>
     * 
     * @return This setting only applies to H.264, H.265, and MPEG2 outputs. Use Insert AFD signaling to specify whether
     *         the service includes AFD values in the output video data and what those values are. * Choose None to
     *         remove all AFD values from this output. * Choose Fixed to ignore input AFD values and instead encode the
     *         value specified in the job. * Choose Auto to calculate output AFD values based on the input AFD scaler
     *         data.
     * @see AfdSignaling
     */
    public final String afdSignalingAsString() {
        return afdSignaling;
    }

    /**
     * The anti-alias filter is automatically applied to all outputs. The service no longer accepts the value DISABLED
     * for AntiAlias. If you specify that in your job, the service will ignore the setting.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #antiAlias} will
     * return {@link AntiAlias#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #antiAliasAsString}.
     * </p>
     * 
     * @return The anti-alias filter is automatically applied to all outputs. The service no longer accepts the value
     *         DISABLED for AntiAlias. If you specify that in your job, the service will ignore the setting.
     * @see AntiAlias
     */
    public final AntiAlias antiAlias() {
        return AntiAlias.fromValue(antiAlias);
    }

    /**
     * The anti-alias filter is automatically applied to all outputs. The service no longer accepts the value DISABLED
     * for AntiAlias. If you specify that in your job, the service will ignore the setting.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #antiAlias} will
     * return {@link AntiAlias#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #antiAliasAsString}.
     * </p>
     * 
     * @return The anti-alias filter is automatically applied to all outputs. The service no longer accepts the value
     *         DISABLED for AntiAlias. If you specify that in your job, the service will ignore the setting.
     * @see AntiAlias
     */
    public final String antiAliasAsString() {
        return antiAlias;
    }

    /**
     * Video codec settings contains the group of settings related to video encoding. The settings in this group vary
     * depending on the value that you choose for Video codec. For each codec enum that you choose, define the
     * corresponding settings object. The following lists the codec enum, settings object pairs. * AV1, Av1Settings *
     * AVC_INTRA, AvcIntraSettings * FRAME_CAPTURE, FrameCaptureSettings * H_264, H264Settings * H_265, H265Settings *
     * MPEG2, Mpeg2Settings * PRORES, ProresSettings * VC3, Vc3Settings * VP8, Vp8Settings * VP9, Vp9Settings * XAVC,
     * XavcSettings
     * 
     * @return Video codec settings contains the group of settings related to video encoding. The settings in this group
     *         vary depending on the value that you choose for Video codec. For each codec enum that you choose, define
     *         the corresponding settings object. The following lists the codec enum, settings object pairs. * AV1,
     *         Av1Settings * AVC_INTRA, AvcIntraSettings * FRAME_CAPTURE, FrameCaptureSettings * H_264, H264Settings *
     *         H_265, H265Settings * MPEG2, Mpeg2Settings * PRORES, ProresSettings * VC3, Vc3Settings * VP8, Vp8Settings
     *         * VP9, Vp9Settings * XAVC, XavcSettings
     */
    public final VideoCodecSettings codecSettings() {
        return codecSettings;
    }

    /**
     * Choose Insert for this setting to include color metadata in this output. Choose Ignore to exclude color metadata
     * from this output. If you don't specify a value, the service sets this to Insert by default.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorMetadata}
     * will return {@link ColorMetadata#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #colorMetadataAsString}.
     * </p>
     * 
     * @return Choose Insert for this setting to include color metadata in this output. Choose Ignore to exclude color
     *         metadata from this output. If you don't specify a value, the service sets this to Insert by default.
     * @see ColorMetadata
     */
    public final ColorMetadata colorMetadata() {
        return ColorMetadata.fromValue(colorMetadata);
    }

    /**
     * Choose Insert for this setting to include color metadata in this output. Choose Ignore to exclude color metadata
     * from this output. If you don't specify a value, the service sets this to Insert by default.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorMetadata}
     * will return {@link ColorMetadata#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #colorMetadataAsString}.
     * </p>
     * 
     * @return Choose Insert for this setting to include color metadata in this output. Choose Ignore to exclude color
     *         metadata from this output. If you don't specify a value, the service sets this to Insert by default.
     * @see ColorMetadata
     */
    public final String colorMetadataAsString() {
        return colorMetadata;
    }

    /**
     * Use Cropping selection to specify the video area that the service will include in the output video frame.
     * 
     * @return Use Cropping selection to specify the video area that the service will include in the output video frame.
     */
    public final Rectangle crop() {
        return crop;
    }

    /**
     * Applies only to 29.97 fps outputs. When this feature is enabled, the service will use drop-frame timecode on
     * outputs. If it is not possible to use drop-frame timecode, the system will fall back to non-drop-frame. This
     * setting is enabled by default when Timecode insertion is enabled.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dropFrameTimecode}
     * will return {@link DropFrameTimecode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dropFrameTimecodeAsString}.
     * </p>
     * 
     * @return Applies only to 29.97 fps outputs. When this feature is enabled, the service will use drop-frame timecode
     *         on outputs. If it is not possible to use drop-frame timecode, the system will fall back to
     *         non-drop-frame. This setting is enabled by default when Timecode insertion is enabled.
     * @see DropFrameTimecode
     */
    public final DropFrameTimecode dropFrameTimecode() {
        return DropFrameTimecode.fromValue(dropFrameTimecode);
    }

    /**
     * Applies only to 29.97 fps outputs. When this feature is enabled, the service will use drop-frame timecode on
     * outputs. If it is not possible to use drop-frame timecode, the system will fall back to non-drop-frame. This
     * setting is enabled by default when Timecode insertion is enabled.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dropFrameTimecode}
     * will return {@link DropFrameTimecode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dropFrameTimecodeAsString}.
     * </p>
     * 
     * @return Applies only to 29.97 fps outputs. When this feature is enabled, the service will use drop-frame timecode
     *         on outputs. If it is not possible to use drop-frame timecode, the system will fall back to
     *         non-drop-frame. This setting is enabled by default when Timecode insertion is enabled.
     * @see DropFrameTimecode
     */
    public final String dropFrameTimecodeAsString() {
        return dropFrameTimecode;
    }

    /**
     * Applies only if you set AFD Signaling to Fixed. Use Fixed to specify a four-bit AFD value which the service will
     * write on all frames of this video output.
     * 
     * @return Applies only if you set AFD Signaling to Fixed. Use Fixed to specify a four-bit AFD value which the
     *         service will write on all frames of this video output.
     */
    public final Integer fixedAfd() {
        return fixedAfd;
    }

    /**
     * Use Height to define the video resolution height, in pixels, for this output. To use the same resolution as your
     * input: Leave both Width and Height blank. To evenly scale from your input resolution: Leave Height blank and
     * enter a value for Width. For example, if your input is 1920x1080 and you set Width to 1280, your output will be
     * 1280x720.
     * 
     * @return Use Height to define the video resolution height, in pixels, for this output. To use the same resolution
     *         as your input: Leave both Width and Height blank. To evenly scale from your input resolution: Leave
     *         Height blank and enter a value for Width. For example, if your input is 1920x1080 and you set Width to
     *         1280, your output will be 1280x720.
     */
    public final Integer height() {
        return height;
    }

    /**
     * Use Selection placement to define the video area in your output frame. The area outside of the rectangle that you
     * specify here is black.
     * 
     * @return Use Selection placement to define the video area in your output frame. The area outside of the rectangle
     *         that you specify here is black.
     */
    public final Rectangle position() {
        return position;
    }

    /**
     * Use Respond to AFD to specify how the service changes the video itself in response to AFD values in the input. *
     * Choose Respond to clip the input video frame according to the AFD value, input display aspect ratio, and output
     * display aspect ratio. * Choose Passthrough to include the input AFD values. Do not choose this when AfdSignaling
     * is set to NONE. A preferred implementation of this workflow is to set RespondToAfd to and set AfdSignaling to
     * AUTO. * Choose None to remove all input AFD values from this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #respondToAfd} will
     * return {@link RespondToAfd#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #respondToAfdAsString}.
     * </p>
     * 
     * @return Use Respond to AFD to specify how the service changes the video itself in response to AFD values in the
     *         input. * Choose Respond to clip the input video frame according to the AFD value, input display aspect
     *         ratio, and output display aspect ratio. * Choose Passthrough to include the input AFD values. Do not
     *         choose this when AfdSignaling is set to NONE. A preferred implementation of this workflow is to set
     *         RespondToAfd to and set AfdSignaling to AUTO. * Choose None to remove all input AFD values from this
     *         output.
     * @see RespondToAfd
     */
    public final RespondToAfd respondToAfd() {
        return RespondToAfd.fromValue(respondToAfd);
    }

    /**
     * Use Respond to AFD to specify how the service changes the video itself in response to AFD values in the input. *
     * Choose Respond to clip the input video frame according to the AFD value, input display aspect ratio, and output
     * display aspect ratio. * Choose Passthrough to include the input AFD values. Do not choose this when AfdSignaling
     * is set to NONE. A preferred implementation of this workflow is to set RespondToAfd to and set AfdSignaling to
     * AUTO. * Choose None to remove all input AFD values from this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #respondToAfd} will
     * return {@link RespondToAfd#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #respondToAfdAsString}.
     * </p>
     * 
     * @return Use Respond to AFD to specify how the service changes the video itself in response to AFD values in the
     *         input. * Choose Respond to clip the input video frame according to the AFD value, input display aspect
     *         ratio, and output display aspect ratio. * Choose Passthrough to include the input AFD values. Do not
     *         choose this when AfdSignaling is set to NONE. A preferred implementation of this workflow is to set
     *         RespondToAfd to and set AfdSignaling to AUTO. * Choose None to remove all input AFD values from this
     *         output.
     * @see RespondToAfd
     */
    public final String respondToAfdAsString() {
        return respondToAfd;
    }

    /**
     * Specify how the service handles outputs that have a different aspect ratio from the input aspect ratio. Choose
     * Stretch to output to have the service stretch your video image to fit. Keep the setting Default to have the
     * service letterbox your video instead. This setting overrides any value that you specify for the setting Selection
     * placement in this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalingBehavior}
     * will return {@link ScalingBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scalingBehaviorAsString}.
     * </p>
     * 
     * @return Specify how the service handles outputs that have a different aspect ratio from the input aspect ratio.
     *         Choose Stretch to output to have the service stretch your video image to fit. Keep the setting Default to
     *         have the service letterbox your video instead. This setting overrides any value that you specify for the
     *         setting Selection placement in this output.
     * @see ScalingBehavior
     */
    public final ScalingBehavior scalingBehavior() {
        return ScalingBehavior.fromValue(scalingBehavior);
    }

    /**
     * Specify how the service handles outputs that have a different aspect ratio from the input aspect ratio. Choose
     * Stretch to output to have the service stretch your video image to fit. Keep the setting Default to have the
     * service letterbox your video instead. This setting overrides any value that you specify for the setting Selection
     * placement in this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalingBehavior}
     * will return {@link ScalingBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scalingBehaviorAsString}.
     * </p>
     * 
     * @return Specify how the service handles outputs that have a different aspect ratio from the input aspect ratio.
     *         Choose Stretch to output to have the service stretch your video image to fit. Keep the setting Default to
     *         have the service letterbox your video instead. This setting overrides any value that you specify for the
     *         setting Selection placement in this output.
     * @see ScalingBehavior
     */
    public final String scalingBehaviorAsString() {
        return scalingBehavior;
    }

    /**
     * Use Sharpness setting to specify the strength of anti-aliasing. This setting changes the width of the anti-alias
     * filter kernel used for scaling. Sharpness only applies if your output resolution is different from your input
     * resolution. 0 is the softest setting, 100 the sharpest, and 50 recommended for most content.
     * 
     * @return Use Sharpness setting to specify the strength of anti-aliasing. This setting changes the width of the
     *         anti-alias filter kernel used for scaling. Sharpness only applies if your output resolution is different
     *         from your input resolution. 0 is the softest setting, 100 the sharpest, and 50 recommended for most
     *         content.
     */
    public final Integer sharpness() {
        return sharpness;
    }

    /**
     * Applies only to H.264, H.265, MPEG2, and ProRes outputs. Only enable Timecode insertion when the input frame rate
     * is identical to the output frame rate. To include timecodes in this output, set Timecode insertion to
     * PIC_TIMING_SEI. To leave them out, set it to DISABLED. Default is DISABLED. When the service inserts timecodes in
     * an output, by default, it uses any embedded timecodes from the input. If none are present, the service will set
     * the timecode for the first output frame to zero. To change this default behavior, adjust the settings under
     * Timecode configuration. In the console, these settings are located under Job > Job settings > Timecode
     * configuration. Note - Timecode source under input settings does not affect the timecodes that are inserted in the
     * output. Source under Job settings > Timecode configuration does.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timecodeInsertion}
     * will return {@link VideoTimecodeInsertion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timecodeInsertionAsString}.
     * </p>
     * 
     * @return Applies only to H.264, H.265, MPEG2, and ProRes outputs. Only enable Timecode insertion when the input
     *         frame rate is identical to the output frame rate. To include timecodes in this output, set Timecode
     *         insertion to PIC_TIMING_SEI. To leave them out, set it to DISABLED. Default is DISABLED. When the service
     *         inserts timecodes in an output, by default, it uses any embedded timecodes from the input. If none are
     *         present, the service will set the timecode for the first output frame to zero. To change this default
     *         behavior, adjust the settings under Timecode configuration. In the console, these settings are located
     *         under Job > Job settings > Timecode configuration. Note - Timecode source under input settings does not
     *         affect the timecodes that are inserted in the output. Source under Job settings > Timecode configuration
     *         does.
     * @see VideoTimecodeInsertion
     */
    public final VideoTimecodeInsertion timecodeInsertion() {
        return VideoTimecodeInsertion.fromValue(timecodeInsertion);
    }

    /**
     * Applies only to H.264, H.265, MPEG2, and ProRes outputs. Only enable Timecode insertion when the input frame rate
     * is identical to the output frame rate. To include timecodes in this output, set Timecode insertion to
     * PIC_TIMING_SEI. To leave them out, set it to DISABLED. Default is DISABLED. When the service inserts timecodes in
     * an output, by default, it uses any embedded timecodes from the input. If none are present, the service will set
     * the timecode for the first output frame to zero. To change this default behavior, adjust the settings under
     * Timecode configuration. In the console, these settings are located under Job > Job settings > Timecode
     * configuration. Note - Timecode source under input settings does not affect the timecodes that are inserted in the
     * output. Source under Job settings > Timecode configuration does.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timecodeInsertion}
     * will return {@link VideoTimecodeInsertion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timecodeInsertionAsString}.
     * </p>
     * 
     * @return Applies only to H.264, H.265, MPEG2, and ProRes outputs. Only enable Timecode insertion when the input
     *         frame rate is identical to the output frame rate. To include timecodes in this output, set Timecode
     *         insertion to PIC_TIMING_SEI. To leave them out, set it to DISABLED. Default is DISABLED. When the service
     *         inserts timecodes in an output, by default, it uses any embedded timecodes from the input. If none are
     *         present, the service will set the timecode for the first output frame to zero. To change this default
     *         behavior, adjust the settings under Timecode configuration. In the console, these settings are located
     *         under Job > Job settings > Timecode configuration. Note - Timecode source under input settings does not
     *         affect the timecodes that are inserted in the output. Source under Job settings > Timecode configuration
     *         does.
     * @see VideoTimecodeInsertion
     */
    public final String timecodeInsertionAsString() {
        return timecodeInsertion;
    }

    /**
     * Find additional transcoding features under Preprocessors. Enable the features at each output individually. These
     * features are disabled by default.
     * 
     * @return Find additional transcoding features under Preprocessors. Enable the features at each output
     *         individually. These features are disabled by default.
     */
    public final VideoPreprocessor videoPreprocessors() {
        return videoPreprocessors;
    }

    /**
     * Use Width to define the video resolution width, in pixels, for this output. To use the same resolution as your
     * input: Leave both Width and Height blank. To evenly scale from your input resolution: Leave Width blank and enter
     * a value for Height. For example, if your input is 1920x1080 and you set Height to 720, your output will be
     * 1280x720.
     * 
     * @return Use Width to define the video resolution width, in pixels, for this output. To use the same resolution as
     *         your input: Leave both Width and Height blank. To evenly scale from your input resolution: Leave Width
     *         blank and enter a value for Height. For example, if your input is 1920x1080 and you set Height to 720,
     *         your output will be 1280x720.
     */
    public final Integer width() {
        return width;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(afdSignalingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(antiAliasAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codecSettings());
        hashCode = 31 * hashCode + Objects.hashCode(colorMetadataAsString());
        hashCode = 31 * hashCode + Objects.hashCode(crop());
        hashCode = 31 * hashCode + Objects.hashCode(dropFrameTimecodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fixedAfd());
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(respondToAfdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scalingBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sharpness());
        hashCode = 31 * hashCode + Objects.hashCode(timecodeInsertionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(videoPreprocessors());
        hashCode = 31 * hashCode + Objects.hashCode(width());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoDescription)) {
            return false;
        }
        VideoDescription other = (VideoDescription) obj;
        return Objects.equals(afdSignalingAsString(), other.afdSignalingAsString())
                && Objects.equals(antiAliasAsString(), other.antiAliasAsString())
                && Objects.equals(codecSettings(), other.codecSettings())
                && Objects.equals(colorMetadataAsString(), other.colorMetadataAsString()) && Objects.equals(crop(), other.crop())
                && Objects.equals(dropFrameTimecodeAsString(), other.dropFrameTimecodeAsString())
                && Objects.equals(fixedAfd(), other.fixedAfd()) && Objects.equals(height(), other.height())
                && Objects.equals(position(), other.position())
                && Objects.equals(respondToAfdAsString(), other.respondToAfdAsString())
                && Objects.equals(scalingBehaviorAsString(), other.scalingBehaviorAsString())
                && Objects.equals(sharpness(), other.sharpness())
                && Objects.equals(timecodeInsertionAsString(), other.timecodeInsertionAsString())
                && Objects.equals(videoPreprocessors(), other.videoPreprocessors()) && Objects.equals(width(), other.width());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoDescription").add("AfdSignaling", afdSignalingAsString())
                .add("AntiAlias", antiAliasAsString()).add("CodecSettings", codecSettings())
                .add("ColorMetadata", colorMetadataAsString()).add("Crop", crop())
                .add("DropFrameTimecode", dropFrameTimecodeAsString()).add("FixedAfd", fixedAfd()).add("Height", height())
                .add("Position", position()).add("RespondToAfd", respondToAfdAsString())
                .add("ScalingBehavior", scalingBehaviorAsString()).add("Sharpness", sharpness())
                .add("TimecodeInsertion", timecodeInsertionAsString()).add("VideoPreprocessors", videoPreprocessors())
                .add("Width", width()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AfdSignaling":
            return Optional.ofNullable(clazz.cast(afdSignalingAsString()));
        case "AntiAlias":
            return Optional.ofNullable(clazz.cast(antiAliasAsString()));
        case "CodecSettings":
            return Optional.ofNullable(clazz.cast(codecSettings()));
        case "ColorMetadata":
            return Optional.ofNullable(clazz.cast(colorMetadataAsString()));
        case "Crop":
            return Optional.ofNullable(clazz.cast(crop()));
        case "DropFrameTimecode":
            return Optional.ofNullable(clazz.cast(dropFrameTimecodeAsString()));
        case "FixedAfd":
            return Optional.ofNullable(clazz.cast(fixedAfd()));
        case "Height":
            return Optional.ofNullable(clazz.cast(height()));
        case "Position":
            return Optional.ofNullable(clazz.cast(position()));
        case "RespondToAfd":
            return Optional.ofNullable(clazz.cast(respondToAfdAsString()));
        case "ScalingBehavior":
            return Optional.ofNullable(clazz.cast(scalingBehaviorAsString()));
        case "Sharpness":
            return Optional.ofNullable(clazz.cast(sharpness()));
        case "TimecodeInsertion":
            return Optional.ofNullable(clazz.cast(timecodeInsertionAsString()));
        case "VideoPreprocessors":
            return Optional.ofNullable(clazz.cast(videoPreprocessors()));
        case "Width":
            return Optional.ofNullable(clazz.cast(width()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoDescription, T> g) {
        return obj -> g.apply((VideoDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoDescription> {
        /**
         * This setting only applies to H.264, H.265, and MPEG2 outputs. Use Insert AFD signaling to specify whether the
         * service includes AFD values in the output video data and what those values are. * Choose None to remove all
         * AFD values from this output. * Choose Fixed to ignore input AFD values and instead encode the value specified
         * in the job. * Choose Auto to calculate output AFD values based on the input AFD scaler data.
         * 
         * @param afdSignaling
         *        This setting only applies to H.264, H.265, and MPEG2 outputs. Use Insert AFD signaling to specify
         *        whether the service includes AFD values in the output video data and what those values are. * Choose
         *        None to remove all AFD values from this output. * Choose Fixed to ignore input AFD values and instead
         *        encode the value specified in the job. * Choose Auto to calculate output AFD values based on the input
         *        AFD scaler data.
         * @see AfdSignaling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AfdSignaling
         */
        Builder afdSignaling(String afdSignaling);

        /**
         * This setting only applies to H.264, H.265, and MPEG2 outputs. Use Insert AFD signaling to specify whether the
         * service includes AFD values in the output video data and what those values are. * Choose None to remove all
         * AFD values from this output. * Choose Fixed to ignore input AFD values and instead encode the value specified
         * in the job. * Choose Auto to calculate output AFD values based on the input AFD scaler data.
         * 
         * @param afdSignaling
         *        This setting only applies to H.264, H.265, and MPEG2 outputs. Use Insert AFD signaling to specify
         *        whether the service includes AFD values in the output video data and what those values are. * Choose
         *        None to remove all AFD values from this output. * Choose Fixed to ignore input AFD values and instead
         *        encode the value specified in the job. * Choose Auto to calculate output AFD values based on the input
         *        AFD scaler data.
         * @see AfdSignaling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AfdSignaling
         */
        Builder afdSignaling(AfdSignaling afdSignaling);

        /**
         * The anti-alias filter is automatically applied to all outputs. The service no longer accepts the value
         * DISABLED for AntiAlias. If you specify that in your job, the service will ignore the setting.
         * 
         * @param antiAlias
         *        The anti-alias filter is automatically applied to all outputs. The service no longer accepts the value
         *        DISABLED for AntiAlias. If you specify that in your job, the service will ignore the setting.
         * @see AntiAlias
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AntiAlias
         */
        Builder antiAlias(String antiAlias);

        /**
         * The anti-alias filter is automatically applied to all outputs. The service no longer accepts the value
         * DISABLED for AntiAlias. If you specify that in your job, the service will ignore the setting.
         * 
         * @param antiAlias
         *        The anti-alias filter is automatically applied to all outputs. The service no longer accepts the value
         *        DISABLED for AntiAlias. If you specify that in your job, the service will ignore the setting.
         * @see AntiAlias
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AntiAlias
         */
        Builder antiAlias(AntiAlias antiAlias);

        /**
         * Video codec settings contains the group of settings related to video encoding. The settings in this group
         * vary depending on the value that you choose for Video codec. For each codec enum that you choose, define the
         * corresponding settings object. The following lists the codec enum, settings object pairs. * AV1, Av1Settings
         * * AVC_INTRA, AvcIntraSettings * FRAME_CAPTURE, FrameCaptureSettings * H_264, H264Settings * H_265,
         * H265Settings * MPEG2, Mpeg2Settings * PRORES, ProresSettings * VC3, Vc3Settings * VP8, Vp8Settings * VP9,
         * Vp9Settings * XAVC, XavcSettings
         * 
         * @param codecSettings
         *        Video codec settings contains the group of settings related to video encoding. The settings in this
         *        group vary depending on the value that you choose for Video codec. For each codec enum that you
         *        choose, define the corresponding settings object. The following lists the codec enum, settings object
         *        pairs. * AV1, Av1Settings * AVC_INTRA, AvcIntraSettings * FRAME_CAPTURE, FrameCaptureSettings * H_264,
         *        H264Settings * H_265, H265Settings * MPEG2, Mpeg2Settings * PRORES, ProresSettings * VC3, Vc3Settings
         *        * VP8, Vp8Settings * VP9, Vp9Settings * XAVC, XavcSettings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codecSettings(VideoCodecSettings codecSettings);

        /**
         * Video codec settings contains the group of settings related to video encoding. The settings in this group
         * vary depending on the value that you choose for Video codec. For each codec enum that you choose, define the
         * corresponding settings object. The following lists the codec enum, settings object pairs. * AV1, Av1Settings
         * * AVC_INTRA, AvcIntraSettings * FRAME_CAPTURE, FrameCaptureSettings * H_264, H264Settings * H_265,
         * H265Settings * MPEG2, Mpeg2Settings * PRORES, ProresSettings * VC3, Vc3Settings * VP8, Vp8Settings * VP9,
         * Vp9Settings * XAVC, XavcSettings This is a convenience method that creates an instance of the
         * {@link VideoCodecSettings.Builder} avoiding the need to create one manually via
         * {@link VideoCodecSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoCodecSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #codecSettings(VideoCodecSettings)}.
         * 
         * @param codecSettings
         *        a consumer that will call methods on {@link VideoCodecSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codecSettings(VideoCodecSettings)
         */
        default Builder codecSettings(Consumer<VideoCodecSettings.Builder> codecSettings) {
            return codecSettings(VideoCodecSettings.builder().applyMutation(codecSettings).build());
        }

        /**
         * Choose Insert for this setting to include color metadata in this output. Choose Ignore to exclude color
         * metadata from this output. If you don't specify a value, the service sets this to Insert by default.
         * 
         * @param colorMetadata
         *        Choose Insert for this setting to include color metadata in this output. Choose Ignore to exclude
         *        color metadata from this output. If you don't specify a value, the service sets this to Insert by
         *        default.
         * @see ColorMetadata
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColorMetadata
         */
        Builder colorMetadata(String colorMetadata);

        /**
         * Choose Insert for this setting to include color metadata in this output. Choose Ignore to exclude color
         * metadata from this output. If you don't specify a value, the service sets this to Insert by default.
         * 
         * @param colorMetadata
         *        Choose Insert for this setting to include color metadata in this output. Choose Ignore to exclude
         *        color metadata from this output. If you don't specify a value, the service sets this to Insert by
         *        default.
         * @see ColorMetadata
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColorMetadata
         */
        Builder colorMetadata(ColorMetadata colorMetadata);

        /**
         * Use Cropping selection to specify the video area that the service will include in the output video frame.
         * 
         * @param crop
         *        Use Cropping selection to specify the video area that the service will include in the output video
         *        frame.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crop(Rectangle crop);

        /**
         * Use Cropping selection to specify the video area that the service will include in the output video frame.
         * This is a convenience method that creates an instance of the {@link Rectangle.Builder} avoiding the need to
         * create one manually via {@link Rectangle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Rectangle.Builder#build()} is called immediately and its result
         * is passed to {@link #crop(Rectangle)}.
         * 
         * @param crop
         *        a consumer that will call methods on {@link Rectangle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crop(Rectangle)
         */
        default Builder crop(Consumer<Rectangle.Builder> crop) {
            return crop(Rectangle.builder().applyMutation(crop).build());
        }

        /**
         * Applies only to 29.97 fps outputs. When this feature is enabled, the service will use drop-frame timecode on
         * outputs. If it is not possible to use drop-frame timecode, the system will fall back to non-drop-frame. This
         * setting is enabled by default when Timecode insertion is enabled.
         * 
         * @param dropFrameTimecode
         *        Applies only to 29.97 fps outputs. When this feature is enabled, the service will use drop-frame
         *        timecode on outputs. If it is not possible to use drop-frame timecode, the system will fall back to
         *        non-drop-frame. This setting is enabled by default when Timecode insertion is enabled.
         * @see DropFrameTimecode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DropFrameTimecode
         */
        Builder dropFrameTimecode(String dropFrameTimecode);

        /**
         * Applies only to 29.97 fps outputs. When this feature is enabled, the service will use drop-frame timecode on
         * outputs. If it is not possible to use drop-frame timecode, the system will fall back to non-drop-frame. This
         * setting is enabled by default when Timecode insertion is enabled.
         * 
         * @param dropFrameTimecode
         *        Applies only to 29.97 fps outputs. When this feature is enabled, the service will use drop-frame
         *        timecode on outputs. If it is not possible to use drop-frame timecode, the system will fall back to
         *        non-drop-frame. This setting is enabled by default when Timecode insertion is enabled.
         * @see DropFrameTimecode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DropFrameTimecode
         */
        Builder dropFrameTimecode(DropFrameTimecode dropFrameTimecode);

        /**
         * Applies only if you set AFD Signaling to Fixed. Use Fixed to specify a four-bit AFD value which the service
         * will write on all frames of this video output.
         * 
         * @param fixedAfd
         *        Applies only if you set AFD Signaling to Fixed. Use Fixed to specify a four-bit AFD value which the
         *        service will write on all frames of this video output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedAfd(Integer fixedAfd);

        /**
         * Use Height to define the video resolution height, in pixels, for this output. To use the same resolution as
         * your input: Leave both Width and Height blank. To evenly scale from your input resolution: Leave Height blank
         * and enter a value for Width. For example, if your input is 1920x1080 and you set Width to 1280, your output
         * will be 1280x720.
         * 
         * @param height
         *        Use Height to define the video resolution height, in pixels, for this output. To use the same
         *        resolution as your input: Leave both Width and Height blank. To evenly scale from your input
         *        resolution: Leave Height blank and enter a value for Width. For example, if your input is 1920x1080
         *        and you set Width to 1280, your output will be 1280x720.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(Integer height);

        /**
         * Use Selection placement to define the video area in your output frame. The area outside of the rectangle that
         * you specify here is black.
         * 
         * @param position
         *        Use Selection placement to define the video area in your output frame. The area outside of the
         *        rectangle that you specify here is black.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Rectangle position);

        /**
         * Use Selection placement to define the video area in your output frame. The area outside of the rectangle that
         * you specify here is black. This is a convenience method that creates an instance of the
         * {@link Rectangle.Builder} avoiding the need to create one manually via {@link Rectangle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Rectangle.Builder#build()} is called immediately and its result
         * is passed to {@link #position(Rectangle)}.
         * 
         * @param position
         *        a consumer that will call methods on {@link Rectangle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #position(Rectangle)
         */
        default Builder position(Consumer<Rectangle.Builder> position) {
            return position(Rectangle.builder().applyMutation(position).build());
        }

        /**
         * Use Respond to AFD to specify how the service changes the video itself in response to AFD values in the
         * input. * Choose Respond to clip the input video frame according to the AFD value, input display aspect ratio,
         * and output display aspect ratio. * Choose Passthrough to include the input AFD values. Do not choose this
         * when AfdSignaling is set to NONE. A preferred implementation of this workflow is to set RespondToAfd to and
         * set AfdSignaling to AUTO. * Choose None to remove all input AFD values from this output.
         * 
         * @param respondToAfd
         *        Use Respond to AFD to specify how the service changes the video itself in response to AFD values in
         *        the input. * Choose Respond to clip the input video frame according to the AFD value, input display
         *        aspect ratio, and output display aspect ratio. * Choose Passthrough to include the input AFD values.
         *        Do not choose this when AfdSignaling is set to NONE. A preferred implementation of this workflow is to
         *        set RespondToAfd to and set AfdSignaling to AUTO. * Choose None to remove all input AFD values from
         *        this output.
         * @see RespondToAfd
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RespondToAfd
         */
        Builder respondToAfd(String respondToAfd);

        /**
         * Use Respond to AFD to specify how the service changes the video itself in response to AFD values in the
         * input. * Choose Respond to clip the input video frame according to the AFD value, input display aspect ratio,
         * and output display aspect ratio. * Choose Passthrough to include the input AFD values. Do not choose this
         * when AfdSignaling is set to NONE. A preferred implementation of this workflow is to set RespondToAfd to and
         * set AfdSignaling to AUTO. * Choose None to remove all input AFD values from this output.
         * 
         * @param respondToAfd
         *        Use Respond to AFD to specify how the service changes the video itself in response to AFD values in
         *        the input. * Choose Respond to clip the input video frame according to the AFD value, input display
         *        aspect ratio, and output display aspect ratio. * Choose Passthrough to include the input AFD values.
         *        Do not choose this when AfdSignaling is set to NONE. A preferred implementation of this workflow is to
         *        set RespondToAfd to and set AfdSignaling to AUTO. * Choose None to remove all input AFD values from
         *        this output.
         * @see RespondToAfd
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RespondToAfd
         */
        Builder respondToAfd(RespondToAfd respondToAfd);

        /**
         * Specify how the service handles outputs that have a different aspect ratio from the input aspect ratio.
         * Choose Stretch to output to have the service stretch your video image to fit. Keep the setting Default to
         * have the service letterbox your video instead. This setting overrides any value that you specify for the
         * setting Selection placement in this output.
         * 
         * @param scalingBehavior
         *        Specify how the service handles outputs that have a different aspect ratio from the input aspect
         *        ratio. Choose Stretch to output to have the service stretch your video image to fit. Keep the setting
         *        Default to have the service letterbox your video instead. This setting overrides any value that you
         *        specify for the setting Selection placement in this output.
         * @see ScalingBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingBehavior
         */
        Builder scalingBehavior(String scalingBehavior);

        /**
         * Specify how the service handles outputs that have a different aspect ratio from the input aspect ratio.
         * Choose Stretch to output to have the service stretch your video image to fit. Keep the setting Default to
         * have the service letterbox your video instead. This setting overrides any value that you specify for the
         * setting Selection placement in this output.
         * 
         * @param scalingBehavior
         *        Specify how the service handles outputs that have a different aspect ratio from the input aspect
         *        ratio. Choose Stretch to output to have the service stretch your video image to fit. Keep the setting
         *        Default to have the service letterbox your video instead. This setting overrides any value that you
         *        specify for the setting Selection placement in this output.
         * @see ScalingBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingBehavior
         */
        Builder scalingBehavior(ScalingBehavior scalingBehavior);

        /**
         * Use Sharpness setting to specify the strength of anti-aliasing. This setting changes the width of the
         * anti-alias filter kernel used for scaling. Sharpness only applies if your output resolution is different from
         * your input resolution. 0 is the softest setting, 100 the sharpest, and 50 recommended for most content.
         * 
         * @param sharpness
         *        Use Sharpness setting to specify the strength of anti-aliasing. This setting changes the width of the
         *        anti-alias filter kernel used for scaling. Sharpness only applies if your output resolution is
         *        different from your input resolution. 0 is the softest setting, 100 the sharpest, and 50 recommended
         *        for most content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharpness(Integer sharpness);

        /**
         * Applies only to H.264, H.265, MPEG2, and ProRes outputs. Only enable Timecode insertion when the input frame
         * rate is identical to the output frame rate. To include timecodes in this output, set Timecode insertion to
         * PIC_TIMING_SEI. To leave them out, set it to DISABLED. Default is DISABLED. When the service inserts
         * timecodes in an output, by default, it uses any embedded timecodes from the input. If none are present, the
         * service will set the timecode for the first output frame to zero. To change this default behavior, adjust the
         * settings under Timecode configuration. In the console, these settings are located under Job > Job settings >
         * Timecode configuration. Note - Timecode source under input settings does not affect the timecodes that are
         * inserted in the output. Source under Job settings > Timecode configuration does.
         * 
         * @param timecodeInsertion
         *        Applies only to H.264, H.265, MPEG2, and ProRes outputs. Only enable Timecode insertion when the input
         *        frame rate is identical to the output frame rate. To include timecodes in this output, set Timecode
         *        insertion to PIC_TIMING_SEI. To leave them out, set it to DISABLED. Default is DISABLED. When the
         *        service inserts timecodes in an output, by default, it uses any embedded timecodes from the input. If
         *        none are present, the service will set the timecode for the first output frame to zero. To change this
         *        default behavior, adjust the settings under Timecode configuration. In the console, these settings are
         *        located under Job > Job settings > Timecode configuration. Note - Timecode source under input settings
         *        does not affect the timecodes that are inserted in the output. Source under Job settings > Timecode
         *        configuration does.
         * @see VideoTimecodeInsertion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoTimecodeInsertion
         */
        Builder timecodeInsertion(String timecodeInsertion);

        /**
         * Applies only to H.264, H.265, MPEG2, and ProRes outputs. Only enable Timecode insertion when the input frame
         * rate is identical to the output frame rate. To include timecodes in this output, set Timecode insertion to
         * PIC_TIMING_SEI. To leave them out, set it to DISABLED. Default is DISABLED. When the service inserts
         * timecodes in an output, by default, it uses any embedded timecodes from the input. If none are present, the
         * service will set the timecode for the first output frame to zero. To change this default behavior, adjust the
         * settings under Timecode configuration. In the console, these settings are located under Job > Job settings >
         * Timecode configuration. Note - Timecode source under input settings does not affect the timecodes that are
         * inserted in the output. Source under Job settings > Timecode configuration does.
         * 
         * @param timecodeInsertion
         *        Applies only to H.264, H.265, MPEG2, and ProRes outputs. Only enable Timecode insertion when the input
         *        frame rate is identical to the output frame rate. To include timecodes in this output, set Timecode
         *        insertion to PIC_TIMING_SEI. To leave them out, set it to DISABLED. Default is DISABLED. When the
         *        service inserts timecodes in an output, by default, it uses any embedded timecodes from the input. If
         *        none are present, the service will set the timecode for the first output frame to zero. To change this
         *        default behavior, adjust the settings under Timecode configuration. In the console, these settings are
         *        located under Job > Job settings > Timecode configuration. Note - Timecode source under input settings
         *        does not affect the timecodes that are inserted in the output. Source under Job settings > Timecode
         *        configuration does.
         * @see VideoTimecodeInsertion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoTimecodeInsertion
         */
        Builder timecodeInsertion(VideoTimecodeInsertion timecodeInsertion);

        /**
         * Find additional transcoding features under Preprocessors. Enable the features at each output individually.
         * These features are disabled by default.
         * 
         * @param videoPreprocessors
         *        Find additional transcoding features under Preprocessors. Enable the features at each output
         *        individually. These features are disabled by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoPreprocessors(VideoPreprocessor videoPreprocessors);

        /**
         * Find additional transcoding features under Preprocessors. Enable the features at each output individually.
         * These features are disabled by default. This is a convenience method that creates an instance of the
         * {@link VideoPreprocessor.Builder} avoiding the need to create one manually via
         * {@link VideoPreprocessor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoPreprocessor.Builder#build()} is called immediately and its
         * result is passed to {@link #videoPreprocessors(VideoPreprocessor)}.
         * 
         * @param videoPreprocessors
         *        a consumer that will call methods on {@link VideoPreprocessor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoPreprocessors(VideoPreprocessor)
         */
        default Builder videoPreprocessors(Consumer<VideoPreprocessor.Builder> videoPreprocessors) {
            return videoPreprocessors(VideoPreprocessor.builder().applyMutation(videoPreprocessors).build());
        }

        /**
         * Use Width to define the video resolution width, in pixels, for this output. To use the same resolution as
         * your input: Leave both Width and Height blank. To evenly scale from your input resolution: Leave Width blank
         * and enter a value for Height. For example, if your input is 1920x1080 and you set Height to 720, your output
         * will be 1280x720.
         * 
         * @param width
         *        Use Width to define the video resolution width, in pixels, for this output. To use the same resolution
         *        as your input: Leave both Width and Height blank. To evenly scale from your input resolution: Leave
         *        Width blank and enter a value for Height. For example, if your input is 1920x1080 and you set Height
         *        to 720, your output will be 1280x720.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(Integer width);
    }

    static final class BuilderImpl implements Builder {
        private String afdSignaling;

        private String antiAlias;

        private VideoCodecSettings codecSettings;

        private String colorMetadata;

        private Rectangle crop;

        private String dropFrameTimecode;

        private Integer fixedAfd;

        private Integer height;

        private Rectangle position;

        private String respondToAfd;

        private String scalingBehavior;

        private Integer sharpness;

        private String timecodeInsertion;

        private VideoPreprocessor videoPreprocessors;

        private Integer width;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoDescription model) {
            afdSignaling(model.afdSignaling);
            antiAlias(model.antiAlias);
            codecSettings(model.codecSettings);
            colorMetadata(model.colorMetadata);
            crop(model.crop);
            dropFrameTimecode(model.dropFrameTimecode);
            fixedAfd(model.fixedAfd);
            height(model.height);
            position(model.position);
            respondToAfd(model.respondToAfd);
            scalingBehavior(model.scalingBehavior);
            sharpness(model.sharpness);
            timecodeInsertion(model.timecodeInsertion);
            videoPreprocessors(model.videoPreprocessors);
            width(model.width);
        }

        public final String getAfdSignaling() {
            return afdSignaling;
        }

        public final void setAfdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
        }

        @Override
        public final Builder afdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
            return this;
        }

        @Override
        public final Builder afdSignaling(AfdSignaling afdSignaling) {
            this.afdSignaling(afdSignaling == null ? null : afdSignaling.toString());
            return this;
        }

        public final String getAntiAlias() {
            return antiAlias;
        }

        public final void setAntiAlias(String antiAlias) {
            this.antiAlias = antiAlias;
        }

        @Override
        public final Builder antiAlias(String antiAlias) {
            this.antiAlias = antiAlias;
            return this;
        }

        @Override
        public final Builder antiAlias(AntiAlias antiAlias) {
            this.antiAlias(antiAlias == null ? null : antiAlias.toString());
            return this;
        }

        public final VideoCodecSettings.Builder getCodecSettings() {
            return codecSettings != null ? codecSettings.toBuilder() : null;
        }

        public final void setCodecSettings(VideoCodecSettings.BuilderImpl codecSettings) {
            this.codecSettings = codecSettings != null ? codecSettings.build() : null;
        }

        @Override
        public final Builder codecSettings(VideoCodecSettings codecSettings) {
            this.codecSettings = codecSettings;
            return this;
        }

        public final String getColorMetadata() {
            return colorMetadata;
        }

        public final void setColorMetadata(String colorMetadata) {
            this.colorMetadata = colorMetadata;
        }

        @Override
        public final Builder colorMetadata(String colorMetadata) {
            this.colorMetadata = colorMetadata;
            return this;
        }

        @Override
        public final Builder colorMetadata(ColorMetadata colorMetadata) {
            this.colorMetadata(colorMetadata == null ? null : colorMetadata.toString());
            return this;
        }

        public final Rectangle.Builder getCrop() {
            return crop != null ? crop.toBuilder() : null;
        }

        public final void setCrop(Rectangle.BuilderImpl crop) {
            this.crop = crop != null ? crop.build() : null;
        }

        @Override
        public final Builder crop(Rectangle crop) {
            this.crop = crop;
            return this;
        }

        public final String getDropFrameTimecode() {
            return dropFrameTimecode;
        }

        public final void setDropFrameTimecode(String dropFrameTimecode) {
            this.dropFrameTimecode = dropFrameTimecode;
        }

        @Override
        public final Builder dropFrameTimecode(String dropFrameTimecode) {
            this.dropFrameTimecode = dropFrameTimecode;
            return this;
        }

        @Override
        public final Builder dropFrameTimecode(DropFrameTimecode dropFrameTimecode) {
            this.dropFrameTimecode(dropFrameTimecode == null ? null : dropFrameTimecode.toString());
            return this;
        }

        public final Integer getFixedAfd() {
            return fixedAfd;
        }

        public final void setFixedAfd(Integer fixedAfd) {
            this.fixedAfd = fixedAfd;
        }

        @Override
        public final Builder fixedAfd(Integer fixedAfd) {
            this.fixedAfd = fixedAfd;
            return this;
        }

        public final Integer getHeight() {
            return height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final Rectangle.Builder getPosition() {
            return position != null ? position.toBuilder() : null;
        }

        public final void setPosition(Rectangle.BuilderImpl position) {
            this.position = position != null ? position.build() : null;
        }

        @Override
        public final Builder position(Rectangle position) {
            this.position = position;
            return this;
        }

        public final String getRespondToAfd() {
            return respondToAfd;
        }

        public final void setRespondToAfd(String respondToAfd) {
            this.respondToAfd = respondToAfd;
        }

        @Override
        public final Builder respondToAfd(String respondToAfd) {
            this.respondToAfd = respondToAfd;
            return this;
        }

        @Override
        public final Builder respondToAfd(RespondToAfd respondToAfd) {
            this.respondToAfd(respondToAfd == null ? null : respondToAfd.toString());
            return this;
        }

        public final String getScalingBehavior() {
            return scalingBehavior;
        }

        public final void setScalingBehavior(String scalingBehavior) {
            this.scalingBehavior = scalingBehavior;
        }

        @Override
        public final Builder scalingBehavior(String scalingBehavior) {
            this.scalingBehavior = scalingBehavior;
            return this;
        }

        @Override
        public final Builder scalingBehavior(ScalingBehavior scalingBehavior) {
            this.scalingBehavior(scalingBehavior == null ? null : scalingBehavior.toString());
            return this;
        }

        public final Integer getSharpness() {
            return sharpness;
        }

        public final void setSharpness(Integer sharpness) {
            this.sharpness = sharpness;
        }

        @Override
        public final Builder sharpness(Integer sharpness) {
            this.sharpness = sharpness;
            return this;
        }

        public final String getTimecodeInsertion() {
            return timecodeInsertion;
        }

        public final void setTimecodeInsertion(String timecodeInsertion) {
            this.timecodeInsertion = timecodeInsertion;
        }

        @Override
        public final Builder timecodeInsertion(String timecodeInsertion) {
            this.timecodeInsertion = timecodeInsertion;
            return this;
        }

        @Override
        public final Builder timecodeInsertion(VideoTimecodeInsertion timecodeInsertion) {
            this.timecodeInsertion(timecodeInsertion == null ? null : timecodeInsertion.toString());
            return this;
        }

        public final VideoPreprocessor.Builder getVideoPreprocessors() {
            return videoPreprocessors != null ? videoPreprocessors.toBuilder() : null;
        }

        public final void setVideoPreprocessors(VideoPreprocessor.BuilderImpl videoPreprocessors) {
            this.videoPreprocessors = videoPreprocessors != null ? videoPreprocessors.build() : null;
        }

        @Override
        public final Builder videoPreprocessors(VideoPreprocessor videoPreprocessors) {
            this.videoPreprocessors = videoPreprocessors;
            return this;
        }

        public final Integer getWidth() {
            return width;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        @Override
        public VideoDescription build() {
            return new VideoDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
