/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify how you want your data keys managed. AWS uses data keys to encrypt your content. AWS also encrypts the data
 * keys themselves, using a customer master key (CMK), and then stores the encrypted data keys alongside your encrypted
 * content. Use this setting to specify which AWS service manages the CMK. For simplest set up, choose Amazon S3. If you
 * want your master key to be managed by AWS Key Management Service (KMS), choose AWS KMS. By default, when you choose
 * AWS KMS, KMS uses the AWS managed customer master key (CMK) associated with Amazon S3 to encrypt your data keys. You
 * can optionally choose to specify a different, customer managed CMK. Do so by specifying the Amazon Resource Name
 * (ARN) of the key for the setting KMS ARN.
 */
@Generated("software.amazon.awssdk:codegen")
public enum S3ServerSideEncryptionType {
    SERVER_SIDE_ENCRYPTION_S3("SERVER_SIDE_ENCRYPTION_S3"),

    SERVER_SIDE_ENCRYPTION_KMS("SERVER_SIDE_ENCRYPTION_KMS"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3ServerSideEncryptionType> VALUE_MAP = EnumUtils.uniqueIndex(
            S3ServerSideEncryptionType.class, S3ServerSideEncryptionType::toString);

    private final String value;

    private S3ServerSideEncryptionType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return S3ServerSideEncryptionType corresponding to the value
     */
    public static S3ServerSideEncryptionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link S3ServerSideEncryptionType}s
     */
    public static Set<S3ServerSideEncryptionType> knownValues() {
        Set<S3ServerSideEncryptionType> knownValues = EnumSet.allOf(S3ServerSideEncryptionType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
