/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * When set to XDCAM, writes MPEG2 video streams into the QuickTime file using XDCAM fourcc codes. This increases
 * compatibility with Apple editors and players, but may decrease compatibility with other players. Only applicable when
 * the video codec is MPEG2.
 */
@Generated("software.amazon.awssdk:codegen")
public enum MovMpeg2FourCCControl {
    XDCAM("XDCAM"),

    MPEG("MPEG"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MovMpeg2FourCCControl> VALUE_MAP = EnumUtils.uniqueIndex(MovMpeg2FourCCControl.class,
            MovMpeg2FourCCControl::toString);

    private final String value;

    private MovMpeg2FourCCControl(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return MovMpeg2FourCCControl corresponding to the value
     */
    public static MovMpeg2FourCCControl fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link MovMpeg2FourCCControl}s
     */
    public static Set<MovMpeg2FourCCControl> knownValues() {
        Set<MovMpeg2FourCCControl> knownValues = EnumSet.allOf(MovMpeg2FourCCControl.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
