/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * For SCTE-35 markers from your input-- Choose Passthrough if you want SCTE-35 markers that appear in your input to
 * also appear in this output. Choose None if you don't want SCTE-35 markers in this output. For SCTE-35 markers from an
 * ESAM XML document-- Choose None. Also provide the ESAM XML as a string in the setting Signal processing notification
 * XML. Also enable ESAM SCTE-35 (include the property scte35Esam).
 */
@Generated("software.amazon.awssdk:codegen")
public enum M2tsScte35Source {
    PASSTHROUGH("PASSTHROUGH"),

    NONE("NONE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, M2tsScte35Source> VALUE_MAP = EnumUtils.uniqueIndex(M2tsScte35Source.class,
            M2tsScte35Source::toString);

    private final String value;

    private M2tsScte35Source(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return M2tsScte35Source corresponding to the value
     */
    public static M2tsScte35Source fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link M2tsScte35Source}s
     */
    public static Set<M2tsScte35Source> knownValues() {
        Set<M2tsScte35Source> knownValues = EnumSet.allOf(M2tsScte35Source.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
