/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Container specific settings.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerSettings.Builder, ContainerSettings> {
    private static final SdkField<CmfcSettings> CMFC_SETTINGS_FIELD = SdkField.<CmfcSettings> builder(MarshallingType.SDK_POJO)
            .memberName("CmfcSettings").getter(getter(ContainerSettings::cmfcSettings)).setter(setter(Builder::cmfcSettings))
            .constructor(CmfcSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cmfcSettings").build()).build();

    private static final SdkField<String> CONTAINER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Container").getter(getter(ContainerSettings::containerAsString)).setter(setter(Builder::container))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("container").build()).build();

    private static final SdkField<F4vSettings> F4_V_SETTINGS_FIELD = SdkField.<F4vSettings> builder(MarshallingType.SDK_POJO)
            .memberName("F4vSettings").getter(getter(ContainerSettings::f4vSettings)).setter(setter(Builder::f4vSettings))
            .constructor(F4vSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("f4vSettings").build()).build();

    private static final SdkField<M2tsSettings> M2_TS_SETTINGS_FIELD = SdkField.<M2tsSettings> builder(MarshallingType.SDK_POJO)
            .memberName("M2tsSettings").getter(getter(ContainerSettings::m2tsSettings)).setter(setter(Builder::m2tsSettings))
            .constructor(M2tsSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m2tsSettings").build()).build();

    private static final SdkField<M3u8Settings> M3_U8_SETTINGS_FIELD = SdkField.<M3u8Settings> builder(MarshallingType.SDK_POJO)
            .memberName("M3u8Settings").getter(getter(ContainerSettings::m3u8Settings)).setter(setter(Builder::m3u8Settings))
            .constructor(M3u8Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m3u8Settings").build()).build();

    private static final SdkField<MovSettings> MOV_SETTINGS_FIELD = SdkField.<MovSettings> builder(MarshallingType.SDK_POJO)
            .memberName("MovSettings").getter(getter(ContainerSettings::movSettings)).setter(setter(Builder::movSettings))
            .constructor(MovSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("movSettings").build()).build();

    private static final SdkField<Mp4Settings> MP4_SETTINGS_FIELD = SdkField.<Mp4Settings> builder(MarshallingType.SDK_POJO)
            .memberName("Mp4Settings").getter(getter(ContainerSettings::mp4Settings)).setter(setter(Builder::mp4Settings))
            .constructor(Mp4Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mp4Settings").build()).build();

    private static final SdkField<MpdSettings> MPD_SETTINGS_FIELD = SdkField.<MpdSettings> builder(MarshallingType.SDK_POJO)
            .memberName("MpdSettings").getter(getter(ContainerSettings::mpdSettings)).setter(setter(Builder::mpdSettings))
            .constructor(MpdSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mpdSettings").build()).build();

    private static final SdkField<MxfSettings> MXF_SETTINGS_FIELD = SdkField.<MxfSettings> builder(MarshallingType.SDK_POJO)
            .memberName("MxfSettings").getter(getter(ContainerSettings::mxfSettings)).setter(setter(Builder::mxfSettings))
            .constructor(MxfSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mxfSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CMFC_SETTINGS_FIELD,
            CONTAINER_FIELD, F4_V_SETTINGS_FIELD, M2_TS_SETTINGS_FIELD, M3_U8_SETTINGS_FIELD, MOV_SETTINGS_FIELD,
            MP4_SETTINGS_FIELD, MPD_SETTINGS_FIELD, MXF_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final CmfcSettings cmfcSettings;

    private final String container;

    private final F4vSettings f4vSettings;

    private final M2tsSettings m2tsSettings;

    private final M3u8Settings m3u8Settings;

    private final MovSettings movSettings;

    private final Mp4Settings mp4Settings;

    private final MpdSettings mpdSettings;

    private final MxfSettings mxfSettings;

    private ContainerSettings(BuilderImpl builder) {
        this.cmfcSettings = builder.cmfcSettings;
        this.container = builder.container;
        this.f4vSettings = builder.f4vSettings;
        this.m2tsSettings = builder.m2tsSettings;
        this.m3u8Settings = builder.m3u8Settings;
        this.movSettings = builder.movSettings;
        this.mp4Settings = builder.mp4Settings;
        this.mpdSettings = builder.mpdSettings;
        this.mxfSettings = builder.mxfSettings;
    }

    /**
     * These settings relate to the fragmented MP4 container for the segments in your CMAF outputs.
     * 
     * @return These settings relate to the fragmented MP4 container for the segments in your CMAF outputs.
     */
    public final CmfcSettings cmfcSettings() {
        return cmfcSettings;
    }

    /**
     * Container for this output. Some containers require a container settings object. If not specified, the default
     * object will be created.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #container} will
     * return {@link ContainerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #containerAsString}.
     * </p>
     * 
     * @return Container for this output. Some containers require a container settings object. If not specified, the
     *         default object will be created.
     * @see ContainerType
     */
    public final ContainerType container() {
        return ContainerType.fromValue(container);
    }

    /**
     * Container for this output. Some containers require a container settings object. If not specified, the default
     * object will be created.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #container} will
     * return {@link ContainerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #containerAsString}.
     * </p>
     * 
     * @return Container for this output. Some containers require a container settings object. If not specified, the
     *         default object will be created.
     * @see ContainerType
     */
    public final String containerAsString() {
        return container;
    }

    /**
     * Settings for F4v container
     * 
     * @return Settings for F4v container
     */
    public final F4vSettings f4vSettings() {
        return f4vSettings;
    }

    /**
     * MPEG-2 TS container settings. These apply to outputs in a File output group when the output's container is MPEG-2
     * Transport Stream (M2TS). In these assets, data is organized by the program map table (PMT). Each transport stream
     * program contains subsets of data, including audio, video, and metadata. Each of these subsets of data has a
     * numerical label called a packet identifier (PID). Each transport stream program corresponds to one MediaConvert
     * output. The PMT lists the types of data in a program along with their PID. Downstream systems and players use the
     * program map table to look up the PID for each type of data it accesses and then uses the PIDs to locate specific
     * data within the asset.
     * 
     * @return MPEG-2 TS container settings. These apply to outputs in a File output group when the output's container
     *         is MPEG-2 Transport Stream (M2TS). In these assets, data is organized by the program map table (PMT).
     *         Each transport stream program contains subsets of data, including audio, video, and metadata. Each of
     *         these subsets of data has a numerical label called a packet identifier (PID). Each transport stream
     *         program corresponds to one MediaConvert output. The PMT lists the types of data in a program along with
     *         their PID. Downstream systems and players use the program map table to look up the PID for each type of
     *         data it accesses and then uses the PIDs to locate specific data within the asset.
     */
    public final M2tsSettings m2tsSettings() {
        return m2tsSettings;
    }

    /**
     * These settings relate to the MPEG-2 transport stream (MPEG2-TS) container for the MPEG2-TS segments in your HLS
     * outputs.
     * 
     * @return These settings relate to the MPEG-2 transport stream (MPEG2-TS) container for the MPEG2-TS segments in
     *         your HLS outputs.
     */
    public final M3u8Settings m3u8Settings() {
        return m3u8Settings;
    }

    /**
     * These settings relate to your QuickTime MOV output container.
     * 
     * @return These settings relate to your QuickTime MOV output container.
     */
    public final MovSettings movSettings() {
        return movSettings;
    }

    /**
     * These settings relate to your MP4 output container. You can create audio only outputs with this container. For
     * more information, see
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/supported-codecs-containers-audio-only.html
     * #output-codecs-and-containers-supported-for-audio-only.
     * 
     * @return These settings relate to your MP4 output container. You can create audio only outputs with this
     *         container. For more information, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/supported-codecs-containers
     *         -audio-only.html#output-codecs-and-containers-supported-for-audio-only.
     */
    public final Mp4Settings mp4Settings() {
        return mp4Settings;
    }

    /**
     * These settings relate to the fragmented MP4 container for the segments in your DASH outputs.
     * 
     * @return These settings relate to the fragmented MP4 container for the segments in your DASH outputs.
     */
    public final MpdSettings mpdSettings() {
        return mpdSettings;
    }

    /**
     * These settings relate to your MXF output container.
     * 
     * @return These settings relate to your MXF output container.
     */
    public final MxfSettings mxfSettings() {
        return mxfSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cmfcSettings());
        hashCode = 31 * hashCode + Objects.hashCode(containerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(f4vSettings());
        hashCode = 31 * hashCode + Objects.hashCode(m2tsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(m3u8Settings());
        hashCode = 31 * hashCode + Objects.hashCode(movSettings());
        hashCode = 31 * hashCode + Objects.hashCode(mp4Settings());
        hashCode = 31 * hashCode + Objects.hashCode(mpdSettings());
        hashCode = 31 * hashCode + Objects.hashCode(mxfSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerSettings)) {
            return false;
        }
        ContainerSettings other = (ContainerSettings) obj;
        return Objects.equals(cmfcSettings(), other.cmfcSettings())
                && Objects.equals(containerAsString(), other.containerAsString())
                && Objects.equals(f4vSettings(), other.f4vSettings()) && Objects.equals(m2tsSettings(), other.m2tsSettings())
                && Objects.equals(m3u8Settings(), other.m3u8Settings()) && Objects.equals(movSettings(), other.movSettings())
                && Objects.equals(mp4Settings(), other.mp4Settings()) && Objects.equals(mpdSettings(), other.mpdSettings())
                && Objects.equals(mxfSettings(), other.mxfSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerSettings").add("CmfcSettings", cmfcSettings()).add("Container", containerAsString())
                .add("F4vSettings", f4vSettings()).add("M2tsSettings", m2tsSettings()).add("M3u8Settings", m3u8Settings())
                .add("MovSettings", movSettings()).add("Mp4Settings", mp4Settings()).add("MpdSettings", mpdSettings())
                .add("MxfSettings", mxfSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CmfcSettings":
            return Optional.ofNullable(clazz.cast(cmfcSettings()));
        case "Container":
            return Optional.ofNullable(clazz.cast(containerAsString()));
        case "F4vSettings":
            return Optional.ofNullable(clazz.cast(f4vSettings()));
        case "M2tsSettings":
            return Optional.ofNullable(clazz.cast(m2tsSettings()));
        case "M3u8Settings":
            return Optional.ofNullable(clazz.cast(m3u8Settings()));
        case "MovSettings":
            return Optional.ofNullable(clazz.cast(movSettings()));
        case "Mp4Settings":
            return Optional.ofNullable(clazz.cast(mp4Settings()));
        case "MpdSettings":
            return Optional.ofNullable(clazz.cast(mpdSettings()));
        case "MxfSettings":
            return Optional.ofNullable(clazz.cast(mxfSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerSettings, T> g) {
        return obj -> g.apply((ContainerSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerSettings> {
        /**
         * These settings relate to the fragmented MP4 container for the segments in your CMAF outputs.
         * 
         * @param cmfcSettings
         *        These settings relate to the fragmented MP4 container for the segments in your CMAF outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cmfcSettings(CmfcSettings cmfcSettings);

        /**
         * These settings relate to the fragmented MP4 container for the segments in your CMAF outputs. This is a
         * convenience method that creates an instance of the {@link CmfcSettings.Builder} avoiding the need to create
         * one manually via {@link CmfcSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CmfcSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #cmfcSettings(CmfcSettings)}.
         * 
         * @param cmfcSettings
         *        a consumer that will call methods on {@link CmfcSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cmfcSettings(CmfcSettings)
         */
        default Builder cmfcSettings(Consumer<CmfcSettings.Builder> cmfcSettings) {
            return cmfcSettings(CmfcSettings.builder().applyMutation(cmfcSettings).build());
        }

        /**
         * Container for this output. Some containers require a container settings object. If not specified, the default
         * object will be created.
         * 
         * @param container
         *        Container for this output. Some containers require a container settings object. If not specified, the
         *        default object will be created.
         * @see ContainerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerType
         */
        Builder container(String container);

        /**
         * Container for this output. Some containers require a container settings object. If not specified, the default
         * object will be created.
         * 
         * @param container
         *        Container for this output. Some containers require a container settings object. If not specified, the
         *        default object will be created.
         * @see ContainerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerType
         */
        Builder container(ContainerType container);

        /**
         * Settings for F4v container
         * 
         * @param f4vSettings
         *        Settings for F4v container
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder f4vSettings(F4vSettings f4vSettings);

        /**
         * Settings for F4v container This is a convenience method that creates an instance of the
         * {@link F4vSettings.Builder} avoiding the need to create one manually via {@link F4vSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link F4vSettings.Builder#build()} is called immediately and its result
         * is passed to {@link #f4vSettings(F4vSettings)}.
         * 
         * @param f4vSettings
         *        a consumer that will call methods on {@link F4vSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #f4vSettings(F4vSettings)
         */
        default Builder f4vSettings(Consumer<F4vSettings.Builder> f4vSettings) {
            return f4vSettings(F4vSettings.builder().applyMutation(f4vSettings).build());
        }

        /**
         * MPEG-2 TS container settings. These apply to outputs in a File output group when the output's container is
         * MPEG-2 Transport Stream (M2TS). In these assets, data is organized by the program map table (PMT). Each
         * transport stream program contains subsets of data, including audio, video, and metadata. Each of these
         * subsets of data has a numerical label called a packet identifier (PID). Each transport stream program
         * corresponds to one MediaConvert output. The PMT lists the types of data in a program along with their PID.
         * Downstream systems and players use the program map table to look up the PID for each type of data it accesses
         * and then uses the PIDs to locate specific data within the asset.
         * 
         * @param m2tsSettings
         *        MPEG-2 TS container settings. These apply to outputs in a File output group when the output's
         *        container is MPEG-2 Transport Stream (M2TS). In these assets, data is organized by the program map
         *        table (PMT). Each transport stream program contains subsets of data, including audio, video, and
         *        metadata. Each of these subsets of data has a numerical label called a packet identifier (PID). Each
         *        transport stream program corresponds to one MediaConvert output. The PMT lists the types of data in a
         *        program along with their PID. Downstream systems and players use the program map table to look up the
         *        PID for each type of data it accesses and then uses the PIDs to locate specific data within the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder m2tsSettings(M2tsSettings m2tsSettings);

        /**
         * MPEG-2 TS container settings. These apply to outputs in a File output group when the output's container is
         * MPEG-2 Transport Stream (M2TS). In these assets, data is organized by the program map table (PMT). Each
         * transport stream program contains subsets of data, including audio, video, and metadata. Each of these
         * subsets of data has a numerical label called a packet identifier (PID). Each transport stream program
         * corresponds to one MediaConvert output. The PMT lists the types of data in a program along with their PID.
         * Downstream systems and players use the program map table to look up the PID for each type of data it accesses
         * and then uses the PIDs to locate specific data within the asset. This is a convenience method that creates an
         * instance of the {@link M2tsSettings.Builder} avoiding the need to create one manually via
         * {@link M2tsSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link M2tsSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #m2tsSettings(M2tsSettings)}.
         * 
         * @param m2tsSettings
         *        a consumer that will call methods on {@link M2tsSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #m2tsSettings(M2tsSettings)
         */
        default Builder m2tsSettings(Consumer<M2tsSettings.Builder> m2tsSettings) {
            return m2tsSettings(M2tsSettings.builder().applyMutation(m2tsSettings).build());
        }

        /**
         * These settings relate to the MPEG-2 transport stream (MPEG2-TS) container for the MPEG2-TS segments in your
         * HLS outputs.
         * 
         * @param m3u8Settings
         *        These settings relate to the MPEG-2 transport stream (MPEG2-TS) container for the MPEG2-TS segments in
         *        your HLS outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder m3u8Settings(M3u8Settings m3u8Settings);

        /**
         * These settings relate to the MPEG-2 transport stream (MPEG2-TS) container for the MPEG2-TS segments in your
         * HLS outputs. This is a convenience method that creates an instance of the {@link M3u8Settings.Builder}
         * avoiding the need to create one manually via {@link M3u8Settings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link M3u8Settings.Builder#build()} is called immediately and its
         * result is passed to {@link #m3u8Settings(M3u8Settings)}.
         * 
         * @param m3u8Settings
         *        a consumer that will call methods on {@link M3u8Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #m3u8Settings(M3u8Settings)
         */
        default Builder m3u8Settings(Consumer<M3u8Settings.Builder> m3u8Settings) {
            return m3u8Settings(M3u8Settings.builder().applyMutation(m3u8Settings).build());
        }

        /**
         * These settings relate to your QuickTime MOV output container.
         * 
         * @param movSettings
         *        These settings relate to your QuickTime MOV output container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder movSettings(MovSettings movSettings);

        /**
         * These settings relate to your QuickTime MOV output container. This is a convenience method that creates an
         * instance of the {@link MovSettings.Builder} avoiding the need to create one manually via
         * {@link MovSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MovSettings.Builder#build()} is called immediately and its result
         * is passed to {@link #movSettings(MovSettings)}.
         * 
         * @param movSettings
         *        a consumer that will call methods on {@link MovSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #movSettings(MovSettings)
         */
        default Builder movSettings(Consumer<MovSettings.Builder> movSettings) {
            return movSettings(MovSettings.builder().applyMutation(movSettings).build());
        }

        /**
         * These settings relate to your MP4 output container. You can create audio only outputs with this container.
         * For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/supported-codecs-containers-audio
         * -only.html#output-codecs-and-containers-supported-for-audio-only.
         * 
         * @param mp4Settings
         *        These settings relate to your MP4 output container. You can create audio only outputs with this
         *        container. For more information, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/supported-codecs
         *        -containers-audio-only.html#output-codecs-and-containers-supported-for-audio-only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mp4Settings(Mp4Settings mp4Settings);

        /**
         * These settings relate to your MP4 output container. You can create audio only outputs with this container.
         * For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/supported-codecs-containers-audio
         * -only.html#output-codecs-and-containers-supported-for-audio-only. This is a convenience method that creates
         * an instance of the {@link Mp4Settings.Builder} avoiding the need to create one manually via
         * {@link Mp4Settings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Mp4Settings.Builder#build()} is called immediately and its result
         * is passed to {@link #mp4Settings(Mp4Settings)}.
         * 
         * @param mp4Settings
         *        a consumer that will call methods on {@link Mp4Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mp4Settings(Mp4Settings)
         */
        default Builder mp4Settings(Consumer<Mp4Settings.Builder> mp4Settings) {
            return mp4Settings(Mp4Settings.builder().applyMutation(mp4Settings).build());
        }

        /**
         * These settings relate to the fragmented MP4 container for the segments in your DASH outputs.
         * 
         * @param mpdSettings
         *        These settings relate to the fragmented MP4 container for the segments in your DASH outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mpdSettings(MpdSettings mpdSettings);

        /**
         * These settings relate to the fragmented MP4 container for the segments in your DASH outputs. This is a
         * convenience method that creates an instance of the {@link MpdSettings.Builder} avoiding the need to create
         * one manually via {@link MpdSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MpdSettings.Builder#build()} is called immediately and its result
         * is passed to {@link #mpdSettings(MpdSettings)}.
         * 
         * @param mpdSettings
         *        a consumer that will call methods on {@link MpdSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mpdSettings(MpdSettings)
         */
        default Builder mpdSettings(Consumer<MpdSettings.Builder> mpdSettings) {
            return mpdSettings(MpdSettings.builder().applyMutation(mpdSettings).build());
        }

        /**
         * These settings relate to your MXF output container.
         * 
         * @param mxfSettings
         *        These settings relate to your MXF output container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mxfSettings(MxfSettings mxfSettings);

        /**
         * These settings relate to your MXF output container. This is a convenience method that creates an instance of
         * the {@link MxfSettings.Builder} avoiding the need to create one manually via {@link MxfSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MxfSettings.Builder#build()} is called immediately and its result
         * is passed to {@link #mxfSettings(MxfSettings)}.
         * 
         * @param mxfSettings
         *        a consumer that will call methods on {@link MxfSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mxfSettings(MxfSettings)
         */
        default Builder mxfSettings(Consumer<MxfSettings.Builder> mxfSettings) {
            return mxfSettings(MxfSettings.builder().applyMutation(mxfSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CmfcSettings cmfcSettings;

        private String container;

        private F4vSettings f4vSettings;

        private M2tsSettings m2tsSettings;

        private M3u8Settings m3u8Settings;

        private MovSettings movSettings;

        private Mp4Settings mp4Settings;

        private MpdSettings mpdSettings;

        private MxfSettings mxfSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerSettings model) {
            cmfcSettings(model.cmfcSettings);
            container(model.container);
            f4vSettings(model.f4vSettings);
            m2tsSettings(model.m2tsSettings);
            m3u8Settings(model.m3u8Settings);
            movSettings(model.movSettings);
            mp4Settings(model.mp4Settings);
            mpdSettings(model.mpdSettings);
            mxfSettings(model.mxfSettings);
        }

        public final CmfcSettings.Builder getCmfcSettings() {
            return cmfcSettings != null ? cmfcSettings.toBuilder() : null;
        }

        public final void setCmfcSettings(CmfcSettings.BuilderImpl cmfcSettings) {
            this.cmfcSettings = cmfcSettings != null ? cmfcSettings.build() : null;
        }

        @Override
        public final Builder cmfcSettings(CmfcSettings cmfcSettings) {
            this.cmfcSettings = cmfcSettings;
            return this;
        }

        public final String getContainer() {
            return container;
        }

        public final void setContainer(String container) {
            this.container = container;
        }

        @Override
        public final Builder container(String container) {
            this.container = container;
            return this;
        }

        @Override
        public final Builder container(ContainerType container) {
            this.container(container == null ? null : container.toString());
            return this;
        }

        public final F4vSettings.Builder getF4vSettings() {
            return f4vSettings != null ? f4vSettings.toBuilder() : null;
        }

        public final void setF4vSettings(F4vSettings.BuilderImpl f4vSettings) {
            this.f4vSettings = f4vSettings != null ? f4vSettings.build() : null;
        }

        @Override
        public final Builder f4vSettings(F4vSettings f4vSettings) {
            this.f4vSettings = f4vSettings;
            return this;
        }

        public final M2tsSettings.Builder getM2tsSettings() {
            return m2tsSettings != null ? m2tsSettings.toBuilder() : null;
        }

        public final void setM2tsSettings(M2tsSettings.BuilderImpl m2tsSettings) {
            this.m2tsSettings = m2tsSettings != null ? m2tsSettings.build() : null;
        }

        @Override
        public final Builder m2tsSettings(M2tsSettings m2tsSettings) {
            this.m2tsSettings = m2tsSettings;
            return this;
        }

        public final M3u8Settings.Builder getM3u8Settings() {
            return m3u8Settings != null ? m3u8Settings.toBuilder() : null;
        }

        public final void setM3u8Settings(M3u8Settings.BuilderImpl m3u8Settings) {
            this.m3u8Settings = m3u8Settings != null ? m3u8Settings.build() : null;
        }

        @Override
        public final Builder m3u8Settings(M3u8Settings m3u8Settings) {
            this.m3u8Settings = m3u8Settings;
            return this;
        }

        public final MovSettings.Builder getMovSettings() {
            return movSettings != null ? movSettings.toBuilder() : null;
        }

        public final void setMovSettings(MovSettings.BuilderImpl movSettings) {
            this.movSettings = movSettings != null ? movSettings.build() : null;
        }

        @Override
        public final Builder movSettings(MovSettings movSettings) {
            this.movSettings = movSettings;
            return this;
        }

        public final Mp4Settings.Builder getMp4Settings() {
            return mp4Settings != null ? mp4Settings.toBuilder() : null;
        }

        public final void setMp4Settings(Mp4Settings.BuilderImpl mp4Settings) {
            this.mp4Settings = mp4Settings != null ? mp4Settings.build() : null;
        }

        @Override
        public final Builder mp4Settings(Mp4Settings mp4Settings) {
            this.mp4Settings = mp4Settings;
            return this;
        }

        public final MpdSettings.Builder getMpdSettings() {
            return mpdSettings != null ? mpdSettings.toBuilder() : null;
        }

        public final void setMpdSettings(MpdSettings.BuilderImpl mpdSettings) {
            this.mpdSettings = mpdSettings != null ? mpdSettings.build() : null;
        }

        @Override
        public final Builder mpdSettings(MpdSettings mpdSettings) {
            this.mpdSettings = mpdSettings;
            return this;
        }

        public final MxfSettings.Builder getMxfSettings() {
            return mxfSettings != null ? mxfSettings.toBuilder() : null;
        }

        public final void setMxfSettings(MxfSettings.BuilderImpl mxfSettings) {
            this.mxfSettings = mxfSettings != null ? mxfSettings.build() : null;
        }

        @Override
        public final Builder mxfSettings(MxfSettings mxfSettings) {
            this.mxfSettings = mxfSettings;
            return this;
        }

        @Override
        public ContainerSettings build() {
            return new ContainerSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
