/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Use this setting to control the values that MediaConvert puts in your HLS parent playlist to control how the client
 * player selects which audio track to play. Choose Audio-only variant stream (AUDIO_ONLY_VARIANT_STREAM) for any
 * variant that you want to prohibit the client from playing with video. This causes MediaConvert to represent the
 * variant as an EXT-X-STREAM-INF in the HLS manifest. The other options for this setting determine the values that
 * MediaConvert writes for the DEFAULT and AUTOSELECT attributes of the EXT-X-MEDIA entry for the audio variant. For
 * more information about these attributes, see the Apple documentation article
 * https://developer.apple.com/documentation
 * /http_live_streaming/example_playlists_for_http_live_streaming/adding_alternate_media_to_a_playlist. Choose Alternate
 * audio, auto select, default to set DEFAULT=YES and AUTOSELECT=YES. Choose this value for only one variant in your
 * output group. Choose Alternate audio, auto select, not default to set DEFAULT=NO and AUTOSELECT=YES. Choose Alternate
 * Audio, Not Auto Select to set DEFAULT=NO and AUTOSELECT=NO. When you don't specify a value for this setting,
 * MediaConvert defaults to Alternate audio, auto select, default. When there is more than one variant in your output
 * group, you must explicitly choose a value for this setting.
 */
@Generated("software.amazon.awssdk:codegen")
public enum CmfcAudioTrackType {
    ALTERNATE_AUDIO_AUTO_SELECT_DEFAULT("ALTERNATE_AUDIO_AUTO_SELECT_DEFAULT"),

    ALTERNATE_AUDIO_AUTO_SELECT("ALTERNATE_AUDIO_AUTO_SELECT"),

    ALTERNATE_AUDIO_NOT_AUTO_SELECT("ALTERNATE_AUDIO_NOT_AUTO_SELECT"),

    AUDIO_ONLY_VARIANT_STREAM("AUDIO_ONLY_VARIANT_STREAM"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CmfcAudioTrackType> VALUE_MAP = EnumUtils.uniqueIndex(CmfcAudioTrackType.class,
            CmfcAudioTrackType::toString);

    private final String value;

    private CmfcAudioTrackType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return CmfcAudioTrackType corresponding to the value
     */
    public static CmfcAudioTrackType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link CmfcAudioTrackType}s
     */
    public static Set<CmfcAudioTrackType> knownValues() {
        Set<CmfcAudioTrackType> knownValues = EnumSet.allOf(CmfcAudioTrackType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
