/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to purchase a offering.
 */
@Generated("software.amazon.awssdk:codegen")
public final class PurchaseOfferingRequest extends MediaConnectRequest implements
        ToCopyableBuilder<PurchaseOfferingRequest.Builder, PurchaseOfferingRequest> {
    private static final SdkField<String> OFFERING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OfferingArn").getter(getter(PurchaseOfferingRequest::offeringArn)).setter(setter(Builder::offeringArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("offeringArn").build()).build();

    private static final SdkField<String> RESERVATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservationName").getter(getter(PurchaseOfferingRequest::reservationName))
            .setter(setter(Builder::reservationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationName").build()).build();

    private static final SdkField<String> START_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Start")
            .getter(getter(PurchaseOfferingRequest::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERING_ARN_FIELD,
            RESERVATION_NAME_FIELD, START_FIELD));

    private final String offeringArn;

    private final String reservationName;

    private final String start;

    private PurchaseOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.offeringArn = builder.offeringArn;
        this.reservationName = builder.reservationName;
        this.start = builder.start;
    }

    /**
     * The Amazon Resource Name (ARN) of the offering.
     * 
     * @return The Amazon Resource Name (ARN) of the offering.
     */
    public final String offeringArn() {
        return offeringArn;
    }

    /**
     * The name that you want to use for the reservation.
     * 
     * @return The name that you want to use for the reservation.
     */
    public final String reservationName() {
        return reservationName;
    }

    /**
     * The date and time that you want the reservation to begin, in Coordinated Universal Time (UTC). You can specify
     * any date and time between 12:00am on the first day of the current month to the current time on today's date,
     * inclusive. Specify the start in a 24-hour notation. Use the following format: YYYY-MM-DDTHH:mm:SSZ, where T and Z
     * are literal characters. For example, to specify 11:30pm on March 5, 2020, enter 2020-03-05T23:30:00Z.
     * 
     * @return The date and time that you want the reservation to begin, in Coordinated Universal Time (UTC). You can
     *         specify any date and time between 12:00am on the first day of the current month to the current time on
     *         today's date, inclusive. Specify the start in a 24-hour notation. Use the following format:
     *         YYYY-MM-DDTHH:mm:SSZ, where T and Z are literal characters. For example, to specify 11:30pm on March 5,
     *         2020, enter 2020-03-05T23:30:00Z.
     */
    public final String start() {
        return start;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(offeringArn());
        hashCode = 31 * hashCode + Objects.hashCode(reservationName());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseOfferingRequest)) {
            return false;
        }
        PurchaseOfferingRequest other = (PurchaseOfferingRequest) obj;
        return Objects.equals(offeringArn(), other.offeringArn()) && Objects.equals(reservationName(), other.reservationName())
                && Objects.equals(start(), other.start());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PurchaseOfferingRequest").add("OfferingArn", offeringArn())
                .add("ReservationName", reservationName()).add("Start", start()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OfferingArn":
            return Optional.ofNullable(clazz.cast(offeringArn()));
        case "ReservationName":
            return Optional.ofNullable(clazz.cast(reservationName()));
        case "Start":
            return Optional.ofNullable(clazz.cast(start()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseOfferingRequest, T> g) {
        return obj -> g.apply((PurchaseOfferingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, PurchaseOfferingRequest> {
        /**
         * The Amazon Resource Name (ARN) of the offering.
         * 
         * @param offeringArn
         *        The Amazon Resource Name (ARN) of the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringArn(String offeringArn);

        /**
         * The name that you want to use for the reservation.
         * 
         * @param reservationName
         *        The name that you want to use for the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationName(String reservationName);

        /**
         * The date and time that you want the reservation to begin, in Coordinated Universal Time (UTC). You can
         * specify any date and time between 12:00am on the first day of the current month to the current time on
         * today's date, inclusive. Specify the start in a 24-hour notation. Use the following format:
         * YYYY-MM-DDTHH:mm:SSZ, where T and Z are literal characters. For example, to specify 11:30pm on March 5, 2020,
         * enter 2020-03-05T23:30:00Z.
         * 
         * @param start
         *        The date and time that you want the reservation to begin, in Coordinated Universal Time (UTC). You can
         *        specify any date and time between 12:00am on the first day of the current month to the current time on
         *        today's date, inclusive. Specify the start in a 24-hour notation. Use the following format:
         *        YYYY-MM-DDTHH:mm:SSZ, where T and Z are literal characters. For example, to specify 11:30pm on March
         *        5, 2020, enter 2020-03-05T23:30:00Z.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(String start);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private String offeringArn;

        private String reservationName;

        private String start;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseOfferingRequest model) {
            super(model);
            offeringArn(model.offeringArn);
            reservationName(model.reservationName);
            start(model.start);
        }

        public final String getOfferingArn() {
            return offeringArn;
        }

        public final void setOfferingArn(String offeringArn) {
            this.offeringArn = offeringArn;
        }

        @Override
        public final Builder offeringArn(String offeringArn) {
            this.offeringArn = offeringArn;
            return this;
        }

        public final String getReservationName() {
            return reservationName;
        }

        public final void setReservationName(String reservationName) {
            this.reservationName = reservationName;
        }

        @Override
        public final Builder reservationName(String reservationName) {
            this.reservationName = reservationName;
            return this;
        }

        public final String getStart() {
            return start;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseOfferingRequest build() {
            return new PurchaseOfferingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
