/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the delegation state of an Amazon Route 53 registered domain to Amazon Lightsail.
 * </p>
 * <p>
 * When you delegate an Amazon Route 53 registered domain to Lightsail, you can manage the DNS of the domain using a
 * Lightsail DNS zone. You no longer use the Route 53 hosted zone to manage the DNS of the domain. To delegate the
 * domain, Lightsail automatically updates the domain's name servers in Route 53 to the name servers of the Lightsail
 * DNS zone. Then, Lightsail automatically deletes the Route 53 hosted zone for the domain.
 * </p>
 * <p>
 * All of the following conditions must be true for automatic domain delegation to be successful:
 * </p>
 * <ul>
 * <li>
 * <p>
 * The registered domain must be in the same Amazon Web Services account as the Lightsail account making the request.
 * </p>
 * </li>
 * <li>
 * <p>
 * The user or entity making the request must have permission to manage domains in Route 53.
 * </p>
 * </li>
 * <li>
 * <p>
 * The Route 53 hosted zone for the domain must be empty. It cannot contain DNS records other than start of authority
 * (SOA) and name server records.
 * </p>
 * </li>
 * </ul>
 * <p>
 * If automatic domain delegation fails, or if you manage the DNS of your domain using a service other than Route 53,
 * then you must manually add the Lightsail DNS zone name servers to your domain in order to delegate management of its
 * DNS to Lightsail. For more information, see <a
 * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/lightsail-how-to-create-dns-entry">Creating a DNS zone
 * to manage your domain’s records in Amazon Lightsail</a> in the <i>Amazon Lightsail Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisteredDomainDelegationInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<RegisteredDomainDelegationInfo.Builder, RegisteredDomainDelegationInfo> {
    private static final SdkField<NameServersUpdateState> NAME_SERVERS_UPDATE_STATE_FIELD = SdkField
            .<NameServersUpdateState> builder(MarshallingType.SDK_POJO).memberName("nameServersUpdateState")
            .getter(getter(RegisteredDomainDelegationInfo::nameServersUpdateState))
            .setter(setter(Builder::nameServersUpdateState)).constructor(NameServersUpdateState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nameServersUpdateState").build())
            .build();

    private static final SdkField<R53HostedZoneDeletionState> R53_HOSTED_ZONE_DELETION_STATE_FIELD = SdkField
            .<R53HostedZoneDeletionState> builder(MarshallingType.SDK_POJO)
            .memberName("r53HostedZoneDeletionState")
            .getter(getter(RegisteredDomainDelegationInfo::r53HostedZoneDeletionState))
            .setter(setter(Builder::r53HostedZoneDeletionState))
            .constructor(R53HostedZoneDeletionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("r53HostedZoneDeletionState").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NAME_SERVERS_UPDATE_STATE_FIELD, R53_HOSTED_ZONE_DELETION_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final NameServersUpdateState nameServersUpdateState;

    private final R53HostedZoneDeletionState r53HostedZoneDeletionState;

    private RegisteredDomainDelegationInfo(BuilderImpl builder) {
        this.nameServersUpdateState = builder.nameServersUpdateState;
        this.r53HostedZoneDeletionState = builder.r53HostedZoneDeletionState;
    }

    /**
     * <p>
     * An object that describes the state of the name server records that are automatically added to the Route 53 domain
     * by Lightsail.
     * </p>
     * 
     * @return An object that describes the state of the name server records that are automatically added to the
     *         Route 53 domain by Lightsail.
     */
    public final NameServersUpdateState nameServersUpdateState() {
        return nameServersUpdateState;
    }

    /**
     * <p>
     * Describes the deletion state of an Amazon Route 53 hosted zone for a domain that is being automatically delegated
     * to an Amazon Lightsail DNS zone.
     * </p>
     * 
     * @return Describes the deletion state of an Amazon Route 53 hosted zone for a domain that is being automatically
     *         delegated to an Amazon Lightsail DNS zone.
     */
    public final R53HostedZoneDeletionState r53HostedZoneDeletionState() {
        return r53HostedZoneDeletionState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameServersUpdateState());
        hashCode = 31 * hashCode + Objects.hashCode(r53HostedZoneDeletionState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisteredDomainDelegationInfo)) {
            return false;
        }
        RegisteredDomainDelegationInfo other = (RegisteredDomainDelegationInfo) obj;
        return Objects.equals(nameServersUpdateState(), other.nameServersUpdateState())
                && Objects.equals(r53HostedZoneDeletionState(), other.r53HostedZoneDeletionState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisteredDomainDelegationInfo").add("NameServersUpdateState", nameServersUpdateState())
                .add("R53HostedZoneDeletionState", r53HostedZoneDeletionState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nameServersUpdateState":
            return Optional.ofNullable(clazz.cast(nameServersUpdateState()));
        case "r53HostedZoneDeletionState":
            return Optional.ofNullable(clazz.cast(r53HostedZoneDeletionState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisteredDomainDelegationInfo, T> g) {
        return obj -> g.apply((RegisteredDomainDelegationInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegisteredDomainDelegationInfo> {
        /**
         * <p>
         * An object that describes the state of the name server records that are automatically added to the Route 53
         * domain by Lightsail.
         * </p>
         * 
         * @param nameServersUpdateState
         *        An object that describes the state of the name server records that are automatically added to the
         *        Route 53 domain by Lightsail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameServersUpdateState(NameServersUpdateState nameServersUpdateState);

        /**
         * <p>
         * An object that describes the state of the name server records that are automatically added to the Route 53
         * domain by Lightsail.
         * </p>
         * This is a convenience method that creates an instance of the {@link NameServersUpdateState.Builder} avoiding
         * the need to create one manually via {@link NameServersUpdateState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NameServersUpdateState.Builder#build()} is called immediately and
         * its result is passed to {@link #nameServersUpdateState(NameServersUpdateState)}.
         * 
         * @param nameServersUpdateState
         *        a consumer that will call methods on {@link NameServersUpdateState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nameServersUpdateState(NameServersUpdateState)
         */
        default Builder nameServersUpdateState(Consumer<NameServersUpdateState.Builder> nameServersUpdateState) {
            return nameServersUpdateState(NameServersUpdateState.builder().applyMutation(nameServersUpdateState).build());
        }

        /**
         * <p>
         * Describes the deletion state of an Amazon Route 53 hosted zone for a domain that is being automatically
         * delegated to an Amazon Lightsail DNS zone.
         * </p>
         * 
         * @param r53HostedZoneDeletionState
         *        Describes the deletion state of an Amazon Route 53 hosted zone for a domain that is being
         *        automatically delegated to an Amazon Lightsail DNS zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder r53HostedZoneDeletionState(R53HostedZoneDeletionState r53HostedZoneDeletionState);

        /**
         * <p>
         * Describes the deletion state of an Amazon Route 53 hosted zone for a domain that is being automatically
         * delegated to an Amazon Lightsail DNS zone.
         * </p>
         * This is a convenience method that creates an instance of the {@link R53HostedZoneDeletionState.Builder}
         * avoiding the need to create one manually via {@link R53HostedZoneDeletionState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link R53HostedZoneDeletionState.Builder#build()} is called immediately
         * and its result is passed to {@link #r53HostedZoneDeletionState(R53HostedZoneDeletionState)}.
         * 
         * @param r53HostedZoneDeletionState
         *        a consumer that will call methods on {@link R53HostedZoneDeletionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #r53HostedZoneDeletionState(R53HostedZoneDeletionState)
         */
        default Builder r53HostedZoneDeletionState(Consumer<R53HostedZoneDeletionState.Builder> r53HostedZoneDeletionState) {
            return r53HostedZoneDeletionState(R53HostedZoneDeletionState.builder().applyMutation(r53HostedZoneDeletionState)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NameServersUpdateState nameServersUpdateState;

        private R53HostedZoneDeletionState r53HostedZoneDeletionState;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisteredDomainDelegationInfo model) {
            nameServersUpdateState(model.nameServersUpdateState);
            r53HostedZoneDeletionState(model.r53HostedZoneDeletionState);
        }

        public final NameServersUpdateState.Builder getNameServersUpdateState() {
            return nameServersUpdateState != null ? nameServersUpdateState.toBuilder() : null;
        }

        public final void setNameServersUpdateState(NameServersUpdateState.BuilderImpl nameServersUpdateState) {
            this.nameServersUpdateState = nameServersUpdateState != null ? nameServersUpdateState.build() : null;
        }

        @Override
        public final Builder nameServersUpdateState(NameServersUpdateState nameServersUpdateState) {
            this.nameServersUpdateState = nameServersUpdateState;
            return this;
        }

        public final R53HostedZoneDeletionState.Builder getR53HostedZoneDeletionState() {
            return r53HostedZoneDeletionState != null ? r53HostedZoneDeletionState.toBuilder() : null;
        }

        public final void setR53HostedZoneDeletionState(R53HostedZoneDeletionState.BuilderImpl r53HostedZoneDeletionState) {
            this.r53HostedZoneDeletionState = r53HostedZoneDeletionState != null ? r53HostedZoneDeletionState.build() : null;
        }

        @Override
        public final Builder r53HostedZoneDeletionState(R53HostedZoneDeletionState r53HostedZoneDeletionState) {
            this.r53HostedZoneDeletionState = r53HostedZoneDeletionState;
            return this;
        }

        @Override
        public RegisteredDomainDelegationInfo build() {
            return new RegisteredDomainDelegationInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
