/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum MetricUnit {
    SECONDS("Seconds"),

    MICROSECONDS("Microseconds"),

    MILLISECONDS("Milliseconds"),

    BYTES("Bytes"),

    KILOBYTES("Kilobytes"),

    MEGABYTES("Megabytes"),

    GIGABYTES("Gigabytes"),

    TERABYTES("Terabytes"),

    BITS("Bits"),

    KILOBITS("Kilobits"),

    MEGABITS("Megabits"),

    GIGABITS("Gigabits"),

    TERABITS("Terabits"),

    PERCENT("Percent"),

    COUNT("Count"),

    BYTES_SECOND("Bytes/Second"),

    KILOBYTES_SECOND("Kilobytes/Second"),

    MEGABYTES_SECOND("Megabytes/Second"),

    GIGABYTES_SECOND("Gigabytes/Second"),

    TERABYTES_SECOND("Terabytes/Second"),

    BITS_SECOND("Bits/Second"),

    KILOBITS_SECOND("Kilobits/Second"),

    MEGABITS_SECOND("Megabits/Second"),

    GIGABITS_SECOND("Gigabits/Second"),

    TERABITS_SECOND("Terabits/Second"),

    COUNT_SECOND("Count/Second"),

    NONE("None"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MetricUnit> VALUE_MAP = EnumUtils.uniqueIndex(MetricUnit.class, MetricUnit::toString);

    private final String value;

    private MetricUnit(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return MetricUnit corresponding to the value
     */
    public static MetricUnit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link MetricUnit}s
     */
    public static Set<MetricUnit> knownValues() {
        Set<MetricUnit> knownValues = EnumSet.allOf(MetricUnit.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
