/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDistributionLatestCacheResetResponse extends LightsailResponse implements
        ToCopyableBuilder<GetDistributionLatestCacheResetResponse.Builder, GetDistributionLatestCacheResetResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetDistributionLatestCacheResetResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(GetDistributionLatestCacheResetResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            CREATE_TIME_FIELD));

    private final String status;

    private final Instant createTime;

    private GetDistributionLatestCacheResetResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.createTime = builder.createTime;
    }

    /**
     * <p>
     * The status of the last cache reset.
     * </p>
     * 
     * @return The status of the last cache reset.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The timestamp of the last cache reset (e.g., <code>1479734909.17</code>) in Unix time format.
     * </p>
     * 
     * @return The timestamp of the last cache reset (e.g., <code>1479734909.17</code>) in Unix time format.
     */
    public final Instant createTime() {
        return createTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDistributionLatestCacheResetResponse)) {
            return false;
        }
        GetDistributionLatestCacheResetResponse other = (GetDistributionLatestCacheResetResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(createTime(), other.createTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDistributionLatestCacheResetResponse").add("Status", status())
                .add("CreateTime", createTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDistributionLatestCacheResetResponse, T> g) {
        return obj -> g.apply((GetDistributionLatestCacheResetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDistributionLatestCacheResetResponse> {
        /**
         * <p>
         * The status of the last cache reset.
         * </p>
         * 
         * @param status
         *        The status of the last cache reset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The timestamp of the last cache reset (e.g., <code>1479734909.17</code>) in Unix time format.
         * </p>
         * 
         * @param createTime
         *        The timestamp of the last cache reset (e.g., <code>1479734909.17</code>) in Unix time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private String status;

        private Instant createTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDistributionLatestCacheResetResponse model) {
            super(model);
            status(model.status);
            createTime(model.createTime);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        @Override
        public GetDistributionLatestCacheResetResponse build() {
            return new GetDistributionLatestCacheResetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
