/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteLoadBalancerTlsCertificateRequest extends LightsailRequest implements
        ToCopyableBuilder<DeleteLoadBalancerTlsCertificateRequest.Builder, DeleteLoadBalancerTlsCertificateRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("loadBalancerName").getter(getter(DeleteLoadBalancerTlsCertificateRequest::loadBalancerName))
            .setter(setter(Builder::loadBalancerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerName").build()).build();

    private static final SdkField<String> CERTIFICATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateName").getter(getter(DeleteLoadBalancerTlsCertificateRequest::certificateName))
            .setter(setter(Builder::certificateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateName").build()).build();

    private static final SdkField<Boolean> FORCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("force")
            .getter(getter(DeleteLoadBalancerTlsCertificateRequest::force)).setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("force").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD,
            CERTIFICATE_NAME_FIELD, FORCE_FIELD));

    private final String loadBalancerName;

    private final String certificateName;

    private final Boolean force;

    private DeleteLoadBalancerTlsCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.certificateName = builder.certificateName;
        this.force = builder.force;
    }

    /**
     * <p>
     * The load balancer name.
     * </p>
     * 
     * @return The load balancer name.
     */
    public final String loadBalancerName() {
        return loadBalancerName;
    }

    /**
     * <p>
     * The SSL/TLS certificate name.
     * </p>
     * 
     * @return The SSL/TLS certificate name.
     */
    public final String certificateName() {
        return certificateName;
    }

    /**
     * <p>
     * When <code>true</code>, forces the deletion of an SSL/TLS certificate.
     * </p>
     * <p>
     * There can be two certificates associated with a Lightsail load balancer: the primary and the backup. The
     * <code>force</code> parameter is required when the primary SSL/TLS certificate is in use by an instance attached
     * to the load balancer.
     * </p>
     * 
     * @return When <code>true</code>, forces the deletion of an SSL/TLS certificate.</p>
     *         <p>
     *         There can be two certificates associated with a Lightsail load balancer: the primary and the backup. The
     *         <code>force</code> parameter is required when the primary SSL/TLS certificate is in use by an instance
     *         attached to the load balancer.
     */
    public final Boolean force() {
        return force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLoadBalancerTlsCertificateRequest)) {
            return false;
        }
        DeleteLoadBalancerTlsCertificateRequest other = (DeleteLoadBalancerTlsCertificateRequest) obj;
        return Objects.equals(loadBalancerName(), other.loadBalancerName())
                && Objects.equals(certificateName(), other.certificateName()) && Objects.equals(force(), other.force());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteLoadBalancerTlsCertificateRequest").add("LoadBalancerName", loadBalancerName())
                .add("CertificateName", certificateName()).add("Force", force()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "loadBalancerName":
            return Optional.ofNullable(clazz.cast(loadBalancerName()));
        case "certificateName":
            return Optional.ofNullable(clazz.cast(certificateName()));
        case "force":
            return Optional.ofNullable(clazz.cast(force()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteLoadBalancerTlsCertificateRequest, T> g) {
        return obj -> g.apply((DeleteLoadBalancerTlsCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteLoadBalancerTlsCertificateRequest> {
        /**
         * <p>
         * The load balancer name.
         * </p>
         * 
         * @param loadBalancerName
         *        The load balancer name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerName(String loadBalancerName);

        /**
         * <p>
         * The SSL/TLS certificate name.
         * </p>
         * 
         * @param certificateName
         *        The SSL/TLS certificate name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateName(String certificateName);

        /**
         * <p>
         * When <code>true</code>, forces the deletion of an SSL/TLS certificate.
         * </p>
         * <p>
         * There can be two certificates associated with a Lightsail load balancer: the primary and the backup. The
         * <code>force</code> parameter is required when the primary SSL/TLS certificate is in use by an instance
         * attached to the load balancer.
         * </p>
         * 
         * @param force
         *        When <code>true</code>, forces the deletion of an SSL/TLS certificate.</p>
         *        <p>
         *        There can be two certificates associated with a Lightsail load balancer: the primary and the backup.
         *        The <code>force</code> parameter is required when the primary SSL/TLS certificate is in use by an
         *        instance attached to the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String loadBalancerName;

        private String certificateName;

        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLoadBalancerTlsCertificateRequest model) {
            super(model);
            loadBalancerName(model.loadBalancerName);
            certificateName(model.certificateName);
            force(model.force);
        }

        public final String getLoadBalancerName() {
            return loadBalancerName;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final String getCertificateName() {
            return certificateName;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final Boolean getForce() {
            return force;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteLoadBalancerTlsCertificateRequest build() {
            return new DeleteLoadBalancerTlsCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
