/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The sentiment expressed in an utterance.
 * </p>
 * <p>
 * When the bot is configured to send utterances to Amazon Comprehend for sentiment analysis, this field structure
 * contains the result of the analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SentimentResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<SentimentResponse.Builder, SentimentResponse> {
    private static final SdkField<String> SENTIMENT_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sentimentLabel").getter(getter(SentimentResponse::sentimentLabel))
            .setter(setter(Builder::sentimentLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sentimentLabel").build()).build();

    private static final SdkField<String> SENTIMENT_SCORE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sentimentScore").getter(getter(SentimentResponse::sentimentScore))
            .setter(setter(Builder::sentimentScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sentimentScore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SENTIMENT_LABEL_FIELD,
            SENTIMENT_SCORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sentimentLabel;

    private final String sentimentScore;

    private SentimentResponse(BuilderImpl builder) {
        this.sentimentLabel = builder.sentimentLabel;
        this.sentimentScore = builder.sentimentScore;
    }

    /**
     * <p>
     * The inferred sentiment that Amazon Comprehend has the highest confidence in.
     * </p>
     * 
     * @return The inferred sentiment that Amazon Comprehend has the highest confidence in.
     */
    public final String sentimentLabel() {
        return sentimentLabel;
    }

    /**
     * <p>
     * The likelihood that the sentiment was correctly inferred.
     * </p>
     * 
     * @return The likelihood that the sentiment was correctly inferred.
     */
    public final String sentimentScore() {
        return sentimentScore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sentimentLabel());
        hashCode = 31 * hashCode + Objects.hashCode(sentimentScore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SentimentResponse)) {
            return false;
        }
        SentimentResponse other = (SentimentResponse) obj;
        return Objects.equals(sentimentLabel(), other.sentimentLabel())
                && Objects.equals(sentimentScore(), other.sentimentScore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SentimentResponse").add("SentimentLabel", sentimentLabel())
                .add("SentimentScore", sentimentScore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sentimentLabel":
            return Optional.ofNullable(clazz.cast(sentimentLabel()));
        case "sentimentScore":
            return Optional.ofNullable(clazz.cast(sentimentScore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SentimentResponse, T> g) {
        return obj -> g.apply((SentimentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SentimentResponse> {
        /**
         * <p>
         * The inferred sentiment that Amazon Comprehend has the highest confidence in.
         * </p>
         * 
         * @param sentimentLabel
         *        The inferred sentiment that Amazon Comprehend has the highest confidence in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sentimentLabel(String sentimentLabel);

        /**
         * <p>
         * The likelihood that the sentiment was correctly inferred.
         * </p>
         * 
         * @param sentimentScore
         *        The likelihood that the sentiment was correctly inferred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sentimentScore(String sentimentScore);
    }

    static final class BuilderImpl implements Builder {
        private String sentimentLabel;

        private String sentimentScore;

        private BuilderImpl() {
        }

        private BuilderImpl(SentimentResponse model) {
            sentimentLabel(model.sentimentLabel);
            sentimentScore(model.sentimentScore);
        }

        public final String getSentimentLabel() {
            return sentimentLabel;
        }

        public final void setSentimentLabel(String sentimentLabel) {
            this.sentimentLabel = sentimentLabel;
        }

        @Override
        public final Builder sentimentLabel(String sentimentLabel) {
            this.sentimentLabel = sentimentLabel;
            return this;
        }

        public final String getSentimentScore() {
            return sentimentScore;
        }

        public final void setSentimentScore(String sentimentScore) {
            this.sentimentScore = sentimentScore;
        }

        @Override
        public final Builder sentimentScore(String sentimentScore) {
            this.sentimentScore = sentimentScore;
            return this;
        }

        @Override
        public SentimentResponse build() {
            return new SentimentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
