/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSlotTypeRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<PutSlotTypeRequest.Builder, PutSlotTypeRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(PutSlotTypeRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(PutSlotTypeRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<EnumerationValue>> ENUMERATION_VALUES_FIELD = SdkField
            .<List<EnumerationValue>> builder(MarshallingType.LIST)
            .memberName("enumerationValues")
            .getter(getter(PutSlotTypeRequest::enumerationValues))
            .setter(setter(Builder::enumerationValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enumerationValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnumerationValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnumerationValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("checksum").getter(getter(PutSlotTypeRequest::checksum)).setter(setter(Builder::checksum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checksum").build()).build();

    private static final SdkField<String> VALUE_SELECTION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("valueSelectionStrategy").getter(getter(PutSlotTypeRequest::valueSelectionStrategyAsString))
            .setter(setter(Builder::valueSelectionStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueSelectionStrategy").build())
            .build();

    private static final SdkField<Boolean> CREATE_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("createVersion").getter(getter(PutSlotTypeRequest::createVersion)).setter(setter(Builder::createVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createVersion").build()).build();

    private static final SdkField<String> PARENT_SLOT_TYPE_SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentSlotTypeSignature").getter(getter(PutSlotTypeRequest::parentSlotTypeSignature))
            .setter(setter(Builder::parentSlotTypeSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentSlotTypeSignature").build())
            .build();

    private static final SdkField<List<SlotTypeConfiguration>> SLOT_TYPE_CONFIGURATIONS_FIELD = SdkField
            .<List<SlotTypeConfiguration>> builder(MarshallingType.LIST)
            .memberName("slotTypeConfigurations")
            .getter(getter(PutSlotTypeRequest::slotTypeConfigurations))
            .setter(setter(Builder::slotTypeConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SlotTypeConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SlotTypeConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            ENUMERATION_VALUES_FIELD, CHECKSUM_FIELD, VALUE_SELECTION_STRATEGY_FIELD, CREATE_VERSION_FIELD,
            PARENT_SLOT_TYPE_SIGNATURE_FIELD, SLOT_TYPE_CONFIGURATIONS_FIELD));

    private final String name;

    private final String description;

    private final List<EnumerationValue> enumerationValues;

    private final String checksum;

    private final String valueSelectionStrategy;

    private final Boolean createVersion;

    private final String parentSlotTypeSignature;

    private final List<SlotTypeConfiguration> slotTypeConfigurations;

    private PutSlotTypeRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.enumerationValues = builder.enumerationValues;
        this.checksum = builder.checksum;
        this.valueSelectionStrategy = builder.valueSelectionStrategy;
        this.createVersion = builder.createVersion;
        this.parentSlotTypeSignature = builder.parentSlotTypeSignature;
        this.slotTypeConfigurations = builder.slotTypeConfigurations;
    }

    /**
     * <p>
     * The name of the slot type. The name is <i>not</i> case sensitive.
     * </p>
     * <p>
     * The name can't match a built-in slot type name, or a built-in slot type name with "AMAZON." removed. For example,
     * because there is a built-in slot type called <code>AMAZON.DATE</code>, you can't create a custom slot type called
     * <code>DATE</code>.
     * </p>
     * <p>
     * For a list of built-in slot types, see <a href=
     * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
     * >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
     * </p>
     * 
     * @return The name of the slot type. The name is <i>not</i> case sensitive. </p>
     *         <p>
     *         The name can't match a built-in slot type name, or a built-in slot type name with "AMAZON." removed. For
     *         example, because there is a built-in slot type called <code>AMAZON.DATE</code>, you can't create a custom
     *         slot type called <code>DATE</code>.
     *         </p>
     *         <p>
     *         For a list of built-in slot types, see <a href=
     *         "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
     *         >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the slot type.
     * </p>
     * 
     * @return A description of the slot type.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnumerationValues property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnumerationValues() {
        return enumerationValues != null && !(enumerationValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take. Each value
     * can have a list of <code>synonyms</code>, which are additional values that help train the machine learning model
     * about the values that it resolves for a slot.
     * </p>
     * <p>
     * A regular expression slot type doesn't require enumeration values. All other slot types require a list of
     * enumeration values.
     * </p>
     * <p>
     * When Amazon Lex resolves a slot value, it generates a resolution list that contains up to five possible values
     * for the slot. If you are using a Lambda function, this resolution list is passed to the function. If you are not
     * using a Lambda function you can choose to return the value that the user entered or the first value in the
     * resolution list as the slot value. The <code>valueSelectionStrategy</code> field indicates the option to use.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnumerationValues} method.
     * </p>
     * 
     * @return A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take. Each
     *         value can have a list of <code>synonyms</code>, which are additional values that help train the machine
     *         learning model about the values that it resolves for a slot. </p>
     *         <p>
     *         A regular expression slot type doesn't require enumeration values. All other slot types require a list of
     *         enumeration values.
     *         </p>
     *         <p>
     *         When Amazon Lex resolves a slot value, it generates a resolution list that contains up to five possible
     *         values for the slot. If you are using a Lambda function, this resolution list is passed to the function.
     *         If you are not using a Lambda function you can choose to return the value that the user entered or the
     *         first value in the resolution list as the slot value. The <code>valueSelectionStrategy</code> field
     *         indicates the option to use.
     */
    public final List<EnumerationValue> enumerationValues() {
        return enumerationValues;
    }

    /**
     * <p>
     * Identifies a specific revision of the <code>$LATEST</code> version.
     * </p>
     * <p>
     * When you create a new slot type, leave the <code>checksum</code> field blank. If you specify a checksum you get a
     * <code>BadRequestException</code> exception.
     * </p>
     * <p>
     * When you want to update a slot type, set the <code>checksum</code> field to the checksum of the most recent
     * revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if the
     * checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code>
     * exception.
     * </p>
     * 
     * @return Identifies a specific revision of the <code>$LATEST</code> version.</p>
     *         <p>
     *         When you create a new slot type, leave the <code>checksum</code> field blank. If you specify a checksum
     *         you get a <code>BadRequestException</code> exception.
     *         </p>
     *         <p>
     *         When you want to update a slot type, set the <code>checksum</code> field to the checksum of the most
     *         recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code>
     *         field, or if the checksum does not match the <code>$LATEST</code> version, you get a
     *         <code>PreconditionFailedException</code> exception.
     */
    public final String checksum() {
        return checksum;
    }

    /**
     * <p>
     * Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set to
     * one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot
     * value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
     * resolution list as the slot type value. If there is no resolution list, null is returned.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #valueSelectionStrategy} will return {@link SlotValueSelectionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #valueSelectionStrategyAsString}.
     * </p>
     * 
     * @return Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be
     *         set to one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the
     *         slot value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
     *         resolution list as the slot type value. If there is no resolution list, null is returned.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.
     * @see SlotValueSelectionStrategy
     */
    public final SlotValueSelectionStrategy valueSelectionStrategy() {
        return SlotValueSelectionStrategy.fromValue(valueSelectionStrategy);
    }

    /**
     * <p>
     * Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set to
     * one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot
     * value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
     * resolution list as the slot type value. If there is no resolution list, null is returned.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #valueSelectionStrategy} will return {@link SlotValueSelectionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #valueSelectionStrategyAsString}.
     * </p>
     * 
     * @return Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be
     *         set to one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the
     *         slot value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
     *         resolution list as the slot type value. If there is no resolution list, null is returned.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.
     * @see SlotValueSelectionStrategy
     */
    public final String valueSelectionStrategyAsString() {
        return valueSelectionStrategy;
    }

    /**
     * <p>
     * When set to <code>true</code> a new numbered version of the slot type is created. This is the same as calling the
     * <code>CreateSlotTypeVersion</code> operation. If you do not specify <code>createVersion</code>, the default is
     * <code>false</code>.
     * </p>
     * 
     * @return When set to <code>true</code> a new numbered version of the slot type is created. This is the same as
     *         calling the <code>CreateSlotTypeVersion</code> operation. If you do not specify
     *         <code>createVersion</code>, the default is <code>false</code>.
     */
    public final Boolean createVersion() {
        return createVersion;
    }

    /**
     * <p>
     * The built-in slot type used as the parent of the slot type. When you define a parent slot type, the new slot type
     * has all of the same configuration as the parent.
     * </p>
     * <p>
     * Only <code>AMAZON.AlphaNumeric</code> is supported.
     * </p>
     * 
     * @return The built-in slot type used as the parent of the slot type. When you define a parent slot type, the new
     *         slot type has all of the same configuration as the parent.</p>
     *         <p>
     *         Only <code>AMAZON.AlphaNumeric</code> is supported.
     */
    public final String parentSlotTypeSignature() {
        return parentSlotTypeSignature;
    }

    /**
     * For responses, this returns true if the service returned a value for the SlotTypeConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSlotTypeConfigurations() {
        return slotTypeConfigurations != null && !(slotTypeConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration information that extends the parent built-in slot type. The configuration is added to the settings
     * for the parent slot type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlotTypeConfigurations} method.
     * </p>
     * 
     * @return Configuration information that extends the parent built-in slot type. The configuration is added to the
     *         settings for the parent slot type.
     */
    public final List<SlotTypeConfiguration> slotTypeConfigurations() {
        return slotTypeConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnumerationValues() ? enumerationValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        hashCode = 31 * hashCode + Objects.hashCode(valueSelectionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createVersion());
        hashCode = 31 * hashCode + Objects.hashCode(parentSlotTypeSignature());
        hashCode = 31 * hashCode + Objects.hashCode(hasSlotTypeConfigurations() ? slotTypeConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSlotTypeRequest)) {
            return false;
        }
        PutSlotTypeRequest other = (PutSlotTypeRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasEnumerationValues() == other.hasEnumerationValues()
                && Objects.equals(enumerationValues(), other.enumerationValues()) && Objects.equals(checksum(), other.checksum())
                && Objects.equals(valueSelectionStrategyAsString(), other.valueSelectionStrategyAsString())
                && Objects.equals(createVersion(), other.createVersion())
                && Objects.equals(parentSlotTypeSignature(), other.parentSlotTypeSignature())
                && hasSlotTypeConfigurations() == other.hasSlotTypeConfigurations()
                && Objects.equals(slotTypeConfigurations(), other.slotTypeConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSlotTypeRequest").add("Name", name()).add("Description", description())
                .add("EnumerationValues", hasEnumerationValues() ? enumerationValues() : null).add("Checksum", checksum())
                .add("ValueSelectionStrategy", valueSelectionStrategyAsString()).add("CreateVersion", createVersion())
                .add("ParentSlotTypeSignature", parentSlotTypeSignature())
                .add("SlotTypeConfigurations", hasSlotTypeConfigurations() ? slotTypeConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "enumerationValues":
            return Optional.ofNullable(clazz.cast(enumerationValues()));
        case "checksum":
            return Optional.ofNullable(clazz.cast(checksum()));
        case "valueSelectionStrategy":
            return Optional.ofNullable(clazz.cast(valueSelectionStrategyAsString()));
        case "createVersion":
            return Optional.ofNullable(clazz.cast(createVersion()));
        case "parentSlotTypeSignature":
            return Optional.ofNullable(clazz.cast(parentSlotTypeSignature()));
        case "slotTypeConfigurations":
            return Optional.ofNullable(clazz.cast(slotTypeConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSlotTypeRequest, T> g) {
        return obj -> g.apply((PutSlotTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutSlotTypeRequest> {
        /**
         * <p>
         * The name of the slot type. The name is <i>not</i> case sensitive.
         * </p>
         * <p>
         * The name can't match a built-in slot type name, or a built-in slot type name with "AMAZON." removed. For
         * example, because there is a built-in slot type called <code>AMAZON.DATE</code>, you can't create a custom
         * slot type called <code>DATE</code>.
         * </p>
         * <p>
         * For a list of built-in slot types, see <a href=
         * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
         * >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
         * </p>
         * 
         * @param name
         *        The name of the slot type. The name is <i>not</i> case sensitive. </p>
         *        <p>
         *        The name can't match a built-in slot type name, or a built-in slot type name with "AMAZON." removed.
         *        For example, because there is a built-in slot type called <code>AMAZON.DATE</code>, you can't create a
         *        custom slot type called <code>DATE</code>.
         *        </p>
         *        <p>
         *        For a list of built-in slot types, see <a href=
         *        "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
         *        >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the slot type.
         * </p>
         * 
         * @param description
         *        A description of the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take. Each
         * value can have a list of <code>synonyms</code>, which are additional values that help train the machine
         * learning model about the values that it resolves for a slot.
         * </p>
         * <p>
         * A regular expression slot type doesn't require enumeration values. All other slot types require a list of
         * enumeration values.
         * </p>
         * <p>
         * When Amazon Lex resolves a slot value, it generates a resolution list that contains up to five possible
         * values for the slot. If you are using a Lambda function, this resolution list is passed to the function. If
         * you are not using a Lambda function you can choose to return the value that the user entered or the first
         * value in the resolution list as the slot value. The <code>valueSelectionStrategy</code> field indicates the
         * option to use.
         * </p>
         * 
         * @param enumerationValues
         *        A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         *        Each value can have a list of <code>synonyms</code>, which are additional values that help train the
         *        machine learning model about the values that it resolves for a slot. </p>
         *        <p>
         *        A regular expression slot type doesn't require enumeration values. All other slot types require a list
         *        of enumeration values.
         *        </p>
         *        <p>
         *        When Amazon Lex resolves a slot value, it generates a resolution list that contains up to five
         *        possible values for the slot. If you are using a Lambda function, this resolution list is passed to
         *        the function. If you are not using a Lambda function you can choose to return the value that the user
         *        entered or the first value in the resolution list as the slot value. The
         *        <code>valueSelectionStrategy</code> field indicates the option to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enumerationValues(Collection<EnumerationValue> enumerationValues);

        /**
         * <p>
         * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take. Each
         * value can have a list of <code>synonyms</code>, which are additional values that help train the machine
         * learning model about the values that it resolves for a slot.
         * </p>
         * <p>
         * A regular expression slot type doesn't require enumeration values. All other slot types require a list of
         * enumeration values.
         * </p>
         * <p>
         * When Amazon Lex resolves a slot value, it generates a resolution list that contains up to five possible
         * values for the slot. If you are using a Lambda function, this resolution list is passed to the function. If
         * you are not using a Lambda function you can choose to return the value that the user entered or the first
         * value in the resolution list as the slot value. The <code>valueSelectionStrategy</code> field indicates the
         * option to use.
         * </p>
         * 
         * @param enumerationValues
         *        A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         *        Each value can have a list of <code>synonyms</code>, which are additional values that help train the
         *        machine learning model about the values that it resolves for a slot. </p>
         *        <p>
         *        A regular expression slot type doesn't require enumeration values. All other slot types require a list
         *        of enumeration values.
         *        </p>
         *        <p>
         *        When Amazon Lex resolves a slot value, it generates a resolution list that contains up to five
         *        possible values for the slot. If you are using a Lambda function, this resolution list is passed to
         *        the function. If you are not using a Lambda function you can choose to return the value that the user
         *        entered or the first value in the resolution list as the slot value. The
         *        <code>valueSelectionStrategy</code> field indicates the option to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enumerationValues(EnumerationValue... enumerationValues);

        /**
         * <p>
         * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take. Each
         * value can have a list of <code>synonyms</code>, which are additional values that help train the machine
         * learning model about the values that it resolves for a slot.
         * </p>
         * <p>
         * A regular expression slot type doesn't require enumeration values. All other slot types require a list of
         * enumeration values.
         * </p>
         * <p>
         * When Amazon Lex resolves a slot value, it generates a resolution list that contains up to five possible
         * values for the slot. If you are using a Lambda function, this resolution list is passed to the function. If
         * you are not using a Lambda function you can choose to return the value that the user entered or the first
         * value in the resolution list as the slot value. The <code>valueSelectionStrategy</code> field indicates the
         * option to use.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.EnumerationValue.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.EnumerationValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.EnumerationValue.Builder#build()} is called
         * immediately and its result is passed to {@link #enumerationValues(List<EnumerationValue>)}.
         * 
         * @param enumerationValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelbuilding.model.EnumerationValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enumerationValues(java.util.Collection<EnumerationValue>)
         */
        Builder enumerationValues(Consumer<EnumerationValue.Builder>... enumerationValues);

        /**
         * <p>
         * Identifies a specific revision of the <code>$LATEST</code> version.
         * </p>
         * <p>
         * When you create a new slot type, leave the <code>checksum</code> field blank. If you specify a checksum you
         * get a <code>BadRequestException</code> exception.
         * </p>
         * <p>
         * When you want to update a slot type, set the <code>checksum</code> field to the checksum of the most recent
         * revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if
         * the checksum does not match the <code>$LATEST</code> version, you get a
         * <code>PreconditionFailedException</code> exception.
         * </p>
         * 
         * @param checksum
         *        Identifies a specific revision of the <code>$LATEST</code> version.</p>
         *        <p>
         *        When you create a new slot type, leave the <code>checksum</code> field blank. If you specify a
         *        checksum you get a <code>BadRequestException</code> exception.
         *        </p>
         *        <p>
         *        When you want to update a slot type, set the <code>checksum</code> field to the checksum of the most
         *        recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code>
         *        field, or if the checksum does not match the <code>$LATEST</code> version, you get a
         *        <code>PreconditionFailedException</code> exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);

        /**
         * <p>
         * Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set
         * to one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
         * resolution list as the slot type value. If there is no resolution list, null is returned.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.
         * </p>
         * 
         * @param valueSelectionStrategy
         *        Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can
         *        be set to one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to
         *        the slot value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in
         *        the resolution list as the slot type value. If there is no resolution list, null is returned.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify the <code>valueSelectionStrategy</code>, the default is
         *        <code>ORIGINAL_VALUE</code>.
         * @see SlotValueSelectionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotValueSelectionStrategy
         */
        Builder valueSelectionStrategy(String valueSelectionStrategy);

        /**
         * <p>
         * Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set
         * to one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the
         * resolution list as the slot type value. If there is no resolution list, null is returned.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.
         * </p>
         * 
         * @param valueSelectionStrategy
         *        Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can
         *        be set to one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to
         *        the slot value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in
         *        the resolution list as the slot type value. If there is no resolution list, null is returned.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify the <code>valueSelectionStrategy</code>, the default is
         *        <code>ORIGINAL_VALUE</code>.
         * @see SlotValueSelectionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotValueSelectionStrategy
         */
        Builder valueSelectionStrategy(SlotValueSelectionStrategy valueSelectionStrategy);

        /**
         * <p>
         * When set to <code>true</code> a new numbered version of the slot type is created. This is the same as calling
         * the <code>CreateSlotTypeVersion</code> operation. If you do not specify <code>createVersion</code>, the
         * default is <code>false</code>.
         * </p>
         * 
         * @param createVersion
         *        When set to <code>true</code> a new numbered version of the slot type is created. This is the same as
         *        calling the <code>CreateSlotTypeVersion</code> operation. If you do not specify
         *        <code>createVersion</code>, the default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createVersion(Boolean createVersion);

        /**
         * <p>
         * The built-in slot type used as the parent of the slot type. When you define a parent slot type, the new slot
         * type has all of the same configuration as the parent.
         * </p>
         * <p>
         * Only <code>AMAZON.AlphaNumeric</code> is supported.
         * </p>
         * 
         * @param parentSlotTypeSignature
         *        The built-in slot type used as the parent of the slot type. When you define a parent slot type, the
         *        new slot type has all of the same configuration as the parent.</p>
         *        <p>
         *        Only <code>AMAZON.AlphaNumeric</code> is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentSlotTypeSignature(String parentSlotTypeSignature);

        /**
         * <p>
         * Configuration information that extends the parent built-in slot type. The configuration is added to the
         * settings for the parent slot type.
         * </p>
         * 
         * @param slotTypeConfigurations
         *        Configuration information that extends the parent built-in slot type. The configuration is added to
         *        the settings for the parent slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeConfigurations(Collection<SlotTypeConfiguration> slotTypeConfigurations);

        /**
         * <p>
         * Configuration information that extends the parent built-in slot type. The configuration is added to the
         * settings for the parent slot type.
         * </p>
         * 
         * @param slotTypeConfigurations
         *        Configuration information that extends the parent built-in slot type. The configuration is added to
         *        the settings for the parent slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeConfigurations(SlotTypeConfiguration... slotTypeConfigurations);

        /**
         * <p>
         * Configuration information that extends the parent built-in slot type. The configuration is added to the
         * settings for the parent slot type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.SlotTypeConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.SlotTypeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.SlotTypeConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link #slotTypeConfigurations(List<SlotTypeConfiguration>)}.
         * 
         * @param slotTypeConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelbuilding.model.SlotTypeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slotTypeConfigurations(java.util.Collection<SlotTypeConfiguration>)
         */
        Builder slotTypeConfigurations(Consumer<SlotTypeConfiguration.Builder>... slotTypeConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<EnumerationValue> enumerationValues = DefaultSdkAutoConstructList.getInstance();

        private String checksum;

        private String valueSelectionStrategy;

        private Boolean createVersion;

        private String parentSlotTypeSignature;

        private List<SlotTypeConfiguration> slotTypeConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutSlotTypeRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            enumerationValues(model.enumerationValues);
            checksum(model.checksum);
            valueSelectionStrategy(model.valueSelectionStrategy);
            createVersion(model.createVersion);
            parentSlotTypeSignature(model.parentSlotTypeSignature);
            slotTypeConfigurations(model.slotTypeConfigurations);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<EnumerationValue.Builder> getEnumerationValues() {
            List<EnumerationValue.Builder> result = EnumerationValuesCopier.copyToBuilder(this.enumerationValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnumerationValues(Collection<EnumerationValue.BuilderImpl> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copyFromBuilder(enumerationValues);
        }

        @Override
        public final Builder enumerationValues(Collection<EnumerationValue> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copy(enumerationValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enumerationValues(EnumerationValue... enumerationValues) {
            enumerationValues(Arrays.asList(enumerationValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enumerationValues(Consumer<EnumerationValue.Builder>... enumerationValues) {
            enumerationValues(Stream.of(enumerationValues).map(c -> EnumerationValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getChecksum() {
            return checksum;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final String getValueSelectionStrategy() {
            return valueSelectionStrategy;
        }

        public final void setValueSelectionStrategy(String valueSelectionStrategy) {
            this.valueSelectionStrategy = valueSelectionStrategy;
        }

        @Override
        public final Builder valueSelectionStrategy(String valueSelectionStrategy) {
            this.valueSelectionStrategy = valueSelectionStrategy;
            return this;
        }

        @Override
        public final Builder valueSelectionStrategy(SlotValueSelectionStrategy valueSelectionStrategy) {
            this.valueSelectionStrategy(valueSelectionStrategy == null ? null : valueSelectionStrategy.toString());
            return this;
        }

        public final Boolean getCreateVersion() {
            return createVersion;
        }

        public final void setCreateVersion(Boolean createVersion) {
            this.createVersion = createVersion;
        }

        @Override
        public final Builder createVersion(Boolean createVersion) {
            this.createVersion = createVersion;
            return this;
        }

        public final String getParentSlotTypeSignature() {
            return parentSlotTypeSignature;
        }

        public final void setParentSlotTypeSignature(String parentSlotTypeSignature) {
            this.parentSlotTypeSignature = parentSlotTypeSignature;
        }

        @Override
        public final Builder parentSlotTypeSignature(String parentSlotTypeSignature) {
            this.parentSlotTypeSignature = parentSlotTypeSignature;
            return this;
        }

        public final List<SlotTypeConfiguration.Builder> getSlotTypeConfigurations() {
            List<SlotTypeConfiguration.Builder> result = SlotTypeConfigurationsCopier.copyToBuilder(this.slotTypeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlotTypeConfigurations(Collection<SlotTypeConfiguration.BuilderImpl> slotTypeConfigurations) {
            this.slotTypeConfigurations = SlotTypeConfigurationsCopier.copyFromBuilder(slotTypeConfigurations);
        }

        @Override
        public final Builder slotTypeConfigurations(Collection<SlotTypeConfiguration> slotTypeConfigurations) {
            this.slotTypeConfigurations = SlotTypeConfigurationsCopier.copy(slotTypeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypeConfigurations(SlotTypeConfiguration... slotTypeConfigurations) {
            slotTypeConfigurations(Arrays.asList(slotTypeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypeConfigurations(Consumer<SlotTypeConfiguration.Builder>... slotTypeConfigurations) {
            slotTypeConfigurations(Stream.of(slotTypeConfigurations)
                    .map(c -> SlotTypeConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSlotTypeRequest build() {
            return new PutSlotTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
