/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the <code>Timestamp</code>, <code>Error</code>, and <code>ImageContent</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Image implements SdkPojo, Serializable, ToCopyableBuilder<Image.Builder, Image> {
    private static final SdkField<Instant> TIME_STAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TimeStamp").getter(getter(Image::timeStamp)).setter(setter(Builder::timeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeStamp").build()).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Error")
            .getter(getter(Image::errorAsString)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<String> IMAGE_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageContent").getter(getter(Image::imageContent)).setter(setter(Builder::imageContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageContent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_STAMP_FIELD, ERROR_FIELD,
            IMAGE_CONTENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant timeStamp;

    private final String error;

    private final String imageContent;

    private Image(BuilderImpl builder) {
        this.timeStamp = builder.timeStamp;
        this.error = builder.error;
        this.imageContent = builder.imageContent;
    }

    /**
     * <p>
     * An attribute of the <code>Image</code> object that is used to extract an image from the video stream. This field
     * is used to manage gaps on images or to better understand the pagination window.
     * </p>
     * 
     * @return An attribute of the <code>Image</code> object that is used to extract an image from the video stream.
     *         This field is used to manage gaps on images or to better understand the pagination window.
     */
    public final Instant timeStamp() {
        return timeStamp;
    }

    /**
     * <p>
     * The error message shown when the image for the provided timestamp was not extracted due to a non-tryable error.
     * An error will be returned if:
     * </p>
     * <ul>
     * <li>
     * <p>
     * There is no media that exists for the specified <code>Timestamp</code>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * The media for the specified time does not allow an image to be extracted. In this case the media is audio only,
     * or the incorrect media has been ingested.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #error} will return
     * {@link ImageError#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorAsString}.
     * </p>
     * 
     * @return The error message shown when the image for the provided timestamp was not extracted due to a non-tryable
     *         error. An error will be returned if: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There is no media that exists for the specified <code>Timestamp</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         The media for the specified time does not allow an image to be extracted. In this case the media is audio
     *         only, or the incorrect media has been ingested.
     *         </p>
     *         </li>
     * @see ImageError
     */
    public final ImageError error() {
        return ImageError.fromValue(error);
    }

    /**
     * <p>
     * The error message shown when the image for the provided timestamp was not extracted due to a non-tryable error.
     * An error will be returned if:
     * </p>
     * <ul>
     * <li>
     * <p>
     * There is no media that exists for the specified <code>Timestamp</code>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * The media for the specified time does not allow an image to be extracted. In this case the media is audio only,
     * or the incorrect media has been ingested.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #error} will return
     * {@link ImageError#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorAsString}.
     * </p>
     * 
     * @return The error message shown when the image for the provided timestamp was not extracted due to a non-tryable
     *         error. An error will be returned if: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There is no media that exists for the specified <code>Timestamp</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         The media for the specified time does not allow an image to be extracted. In this case the media is audio
     *         only, or the incorrect media has been ingested.
     *         </p>
     *         </li>
     * @see ImageError
     */
    public final String errorAsString() {
        return error;
    }

    /**
     * <p>
     * An attribute of the <code>Image</code> object that is Base64 encoded.
     * </p>
     * 
     * @return An attribute of the <code>Image</code> object that is Base64 encoded.
     */
    public final String imageContent() {
        return imageContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(errorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageContent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image) obj;
        return Objects.equals(timeStamp(), other.timeStamp()) && Objects.equals(errorAsString(), other.errorAsString())
                && Objects.equals(imageContent(), other.imageContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Image").add("TimeStamp", timeStamp()).add("Error", errorAsString())
                .add("ImageContent", imageContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeStamp":
            return Optional.ofNullable(clazz.cast(timeStamp()));
        case "Error":
            return Optional.ofNullable(clazz.cast(errorAsString()));
        case "ImageContent":
            return Optional.ofNullable(clazz.cast(imageContent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Image, T> g) {
        return obj -> g.apply((Image) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Image> {
        /**
         * <p>
         * An attribute of the <code>Image</code> object that is used to extract an image from the video stream. This
         * field is used to manage gaps on images or to better understand the pagination window.
         * </p>
         * 
         * @param timeStamp
         *        An attribute of the <code>Image</code> object that is used to extract an image from the video stream.
         *        This field is used to manage gaps on images or to better understand the pagination window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeStamp(Instant timeStamp);

        /**
         * <p>
         * The error message shown when the image for the provided timestamp was not extracted due to a non-tryable
         * error. An error will be returned if:
         * </p>
         * <ul>
         * <li>
         * <p>
         * There is no media that exists for the specified <code>Timestamp</code>.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * The media for the specified time does not allow an image to be extracted. In this case the media is audio
         * only, or the incorrect media has been ingested.
         * </p>
         * </li>
         * </ul>
         * 
         * @param error
         *        The error message shown when the image for the provided timestamp was not extracted due to a
         *        non-tryable error. An error will be returned if: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        There is no media that exists for the specified <code>Timestamp</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        The media for the specified time does not allow an image to be extracted. In this case the media is
         *        audio only, or the incorrect media has been ingested.
         *        </p>
         *        </li>
         * @see ImageError
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageError
         */
        Builder error(String error);

        /**
         * <p>
         * The error message shown when the image for the provided timestamp was not extracted due to a non-tryable
         * error. An error will be returned if:
         * </p>
         * <ul>
         * <li>
         * <p>
         * There is no media that exists for the specified <code>Timestamp</code>.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * The media for the specified time does not allow an image to be extracted. In this case the media is audio
         * only, or the incorrect media has been ingested.
         * </p>
         * </li>
         * </ul>
         * 
         * @param error
         *        The error message shown when the image for the provided timestamp was not extracted due to a
         *        non-tryable error. An error will be returned if: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        There is no media that exists for the specified <code>Timestamp</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        The media for the specified time does not allow an image to be extracted. In this case the media is
         *        audio only, or the incorrect media has been ingested.
         *        </p>
         *        </li>
         * @see ImageError
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageError
         */
        Builder error(ImageError error);

        /**
         * <p>
         * An attribute of the <code>Image</code> object that is Base64 encoded.
         * </p>
         * 
         * @param imageContent
         *        An attribute of the <code>Image</code> object that is Base64 encoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageContent(String imageContent);
    }

    static final class BuilderImpl implements Builder {
        private Instant timeStamp;

        private String error;

        private String imageContent;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            timeStamp(model.timeStamp);
            error(model.error);
            imageContent(model.imageContent);
        }

        public final Instant getTimeStamp() {
            return timeStamp;
        }

        public final void setTimeStamp(Instant timeStamp) {
            this.timeStamp = timeStamp;
        }

        @Override
        public final Builder timeStamp(Instant timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @Override
        public final Builder error(ImageError error) {
            this.error(error == null ? null : error.toString());
            return this;
        }

        public final String getImageContent() {
            return imageContent;
        }

        public final void setImageContent(String imageContent) {
            this.imageContent = imageContent;
        }

        @Override
        public final Builder imageContent(String imageContent) {
            this.imageContent = imageContent;
            return this;
        }

        @Override
        public Image build() {
            return new Image(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
