/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeApplicationVersionResponse extends KinesisAnalyticsV2Response implements
        ToCopyableBuilder<DescribeApplicationVersionResponse.Builder, DescribeApplicationVersionResponse> {
    private static final SdkField<ApplicationDetail> APPLICATION_VERSION_DETAIL_FIELD = SdkField
            .<ApplicationDetail> builder(MarshallingType.SDK_POJO).memberName("ApplicationVersionDetail")
            .getter(getter(DescribeApplicationVersionResponse::applicationVersionDetail))
            .setter(setter(Builder::applicationVersionDetail)).constructor(ApplicationDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionDetail").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APPLICATION_VERSION_DETAIL_FIELD));

    private final ApplicationDetail applicationVersionDetail;

    private DescribeApplicationVersionResponse(BuilderImpl builder) {
        super(builder);
        this.applicationVersionDetail = builder.applicationVersionDetail;
    }

    /**
     * Returns the value of the ApplicationVersionDetail property for this object.
     * 
     * @return The value of the ApplicationVersionDetail property for this object.
     */
    public final ApplicationDetail applicationVersionDetail() {
        return applicationVersionDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersionDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationVersionResponse)) {
            return false;
        }
        DescribeApplicationVersionResponse other = (DescribeApplicationVersionResponse) obj;
        return Objects.equals(applicationVersionDetail(), other.applicationVersionDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeApplicationVersionResponse").add("ApplicationVersionDetail", applicationVersionDetail())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationVersionDetail":
            return Optional.ofNullable(clazz.cast(applicationVersionDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationVersionResponse, T> g) {
        return obj -> g.apply((DescribeApplicationVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeApplicationVersionResponse> {
        /**
         * Sets the value of the ApplicationVersionDetail property for this object.
         *
         * @param applicationVersionDetail
         *        The new value for the ApplicationVersionDetail property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersionDetail(ApplicationDetail applicationVersionDetail);

        /**
         * Sets the value of the ApplicationVersionDetail property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ApplicationDetail.Builder} avoiding the
         * need to create one manually via {@link ApplicationDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #applicationVersionDetail(ApplicationDetail)}.
         * 
         * @param applicationVersionDetail
         *        a consumer that will call methods on {@link ApplicationDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationVersionDetail(ApplicationDetail)
         */
        default Builder applicationVersionDetail(Consumer<ApplicationDetail.Builder> applicationVersionDetail) {
            return applicationVersionDetail(ApplicationDetail.builder().applyMutation(applicationVersionDetail).build());
        }
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Response.BuilderImpl implements Builder {
        private ApplicationDetail applicationVersionDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationVersionResponse model) {
            super(model);
            applicationVersionDetail(model.applicationVersionDetail);
        }

        public final ApplicationDetail.Builder getApplicationVersionDetail() {
            return applicationVersionDetail != null ? applicationVersionDetail.toBuilder() : null;
        }

        public final void setApplicationVersionDetail(ApplicationDetail.BuilderImpl applicationVersionDetail) {
            this.applicationVersionDetail = applicationVersionDetail != null ? applicationVersionDetail.build() : null;
        }

        @Override
        public final Builder applicationVersionDetail(ApplicationDetail applicationVersionDetail) {
            this.applicationVersionDetail = applicationVersionDetail;
            return this;
        }

        @Override
        public DescribeApplicationVersionResponse build() {
            return new DescribeApplicationVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
