/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the updated maintenance configuration for the application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationMaintenanceConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationMaintenanceConfigurationUpdate.Builder, ApplicationMaintenanceConfigurationUpdate> {
    private static final SdkField<String> APPLICATION_MAINTENANCE_WINDOW_START_TIME_UPDATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApplicationMaintenanceWindowStartTimeUpdate")
            .getter(getter(ApplicationMaintenanceConfigurationUpdate::applicationMaintenanceWindowStartTimeUpdate))
            .setter(setter(Builder::applicationMaintenanceWindowStartTimeUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ApplicationMaintenanceWindowStartTimeUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APPLICATION_MAINTENANCE_WINDOW_START_TIME_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationMaintenanceWindowStartTimeUpdate;

    private ApplicationMaintenanceConfigurationUpdate(BuilderImpl builder) {
        this.applicationMaintenanceWindowStartTimeUpdate = builder.applicationMaintenanceWindowStartTimeUpdate;
    }

    /**
     * <p>
     * The updated start time for the maintenance window.
     * </p>
     * 
     * @return The updated start time for the maintenance window.
     */
    public final String applicationMaintenanceWindowStartTimeUpdate() {
        return applicationMaintenanceWindowStartTimeUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationMaintenanceWindowStartTimeUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationMaintenanceConfigurationUpdate)) {
            return false;
        }
        ApplicationMaintenanceConfigurationUpdate other = (ApplicationMaintenanceConfigurationUpdate) obj;
        return Objects.equals(applicationMaintenanceWindowStartTimeUpdate(), other.applicationMaintenanceWindowStartTimeUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationMaintenanceConfigurationUpdate")
                .add("ApplicationMaintenanceWindowStartTimeUpdate", applicationMaintenanceWindowStartTimeUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationMaintenanceWindowStartTimeUpdate":
            return Optional.ofNullable(clazz.cast(applicationMaintenanceWindowStartTimeUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationMaintenanceConfigurationUpdate, T> g) {
        return obj -> g.apply((ApplicationMaintenanceConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationMaintenanceConfigurationUpdate> {
        /**
         * <p>
         * The updated start time for the maintenance window.
         * </p>
         * 
         * @param applicationMaintenanceWindowStartTimeUpdate
         *        The updated start time for the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationMaintenanceWindowStartTimeUpdate(String applicationMaintenanceWindowStartTimeUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String applicationMaintenanceWindowStartTimeUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationMaintenanceConfigurationUpdate model) {
            applicationMaintenanceWindowStartTimeUpdate(model.applicationMaintenanceWindowStartTimeUpdate);
        }

        public final String getApplicationMaintenanceWindowStartTimeUpdate() {
            return applicationMaintenanceWindowStartTimeUpdate;
        }

        public final void setApplicationMaintenanceWindowStartTimeUpdate(String applicationMaintenanceWindowStartTimeUpdate) {
            this.applicationMaintenanceWindowStartTimeUpdate = applicationMaintenanceWindowStartTimeUpdate;
        }

        @Override
        public final Builder applicationMaintenanceWindowStartTimeUpdate(String applicationMaintenanceWindowStartTimeUpdate) {
            this.applicationMaintenanceWindowStartTimeUpdate = applicationMaintenanceWindowStartTimeUpdate;
            return this;
        }

        @Override
        public ApplicationMaintenanceConfigurationUpdate build() {
            return new ApplicationMaintenanceConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
