/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration information of the Parquet format.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParquetConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ParquetConfiguration.Builder, ParquetConfiguration> {
    private static final SdkField<SchemaDefinition> SCHEMA_DEFINITION_FIELD = SdkField
            .<SchemaDefinition> builder(MarshallingType.SDK_POJO).memberName("schemaDefinition")
            .getter(getter(ParquetConfiguration::schemaDefinition)).setter(setter(Builder::schemaDefinition))
            .constructor(SchemaDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final SchemaDefinition schemaDefinition;

    private ParquetConfiguration(BuilderImpl builder) {
        this.schemaDefinition = builder.schemaDefinition;
    }

    /**
     * <p>
     * Information needed to define a schema.
     * </p>
     * 
     * @return Information needed to define a schema.
     */
    public final SchemaDefinition schemaDefinition() {
        return schemaDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schemaDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParquetConfiguration)) {
            return false;
        }
        ParquetConfiguration other = (ParquetConfiguration) obj;
        return Objects.equals(schemaDefinition(), other.schemaDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParquetConfiguration").add("SchemaDefinition", schemaDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "schemaDefinition":
            return Optional.ofNullable(clazz.cast(schemaDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParquetConfiguration, T> g) {
        return obj -> g.apply((ParquetConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParquetConfiguration> {
        /**
         * <p>
         * Information needed to define a schema.
         * </p>
         * 
         * @param schemaDefinition
         *        Information needed to define a schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaDefinition(SchemaDefinition schemaDefinition);

        /**
         * <p>
         * Information needed to define a schema.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchemaDefinition.Builder} avoiding the
         * need to create one manually via {@link SchemaDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #schemaDefinition(SchemaDefinition)}.
         * 
         * @param schemaDefinition
         *        a consumer that will call methods on {@link SchemaDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaDefinition(SchemaDefinition)
         */
        default Builder schemaDefinition(Consumer<SchemaDefinition.Builder> schemaDefinition) {
            return schemaDefinition(SchemaDefinition.builder().applyMutation(schemaDefinition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SchemaDefinition schemaDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(ParquetConfiguration model) {
            schemaDefinition(model.schemaDefinition);
        }

        public final SchemaDefinition.Builder getSchemaDefinition() {
            return schemaDefinition != null ? schemaDefinition.toBuilder() : null;
        }

        public final void setSchemaDefinition(SchemaDefinition.BuilderImpl schemaDefinition) {
            this.schemaDefinition = schemaDefinition != null ? schemaDefinition.build() : null;
        }

        @Override
        public final Builder schemaDefinition(SchemaDefinition schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
            return this;
        }

        @Override
        public ParquetConfiguration build() {
            return new ParquetConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
