/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDatasetContentResponse extends IoTAnalyticsResponse implements
        ToCopyableBuilder<GetDatasetContentResponse.Builder, GetDatasetContentResponse> {
    private static final SdkField<List<DatasetEntry>> ENTRIES_FIELD = SdkField
            .<List<DatasetEntry>> builder(MarshallingType.LIST)
            .memberName("entries")
            .getter(getter(GetDatasetContentResponse::entries))
            .setter(setter(Builder::entries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatasetEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasetEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("timestamp").getter(getter(GetDatasetContentResponse::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<DatasetContentStatus> STATUS_FIELD = SdkField
            .<DatasetContentStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(GetDatasetContentResponse::status)).setter(setter(Builder::status))
            .constructor(DatasetContentStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRIES_FIELD,
            TIMESTAMP_FIELD, STATUS_FIELD));

    private final List<DatasetEntry> entries;

    private final Instant timestamp;

    private final DatasetContentStatus status;

    private GetDatasetContentResponse(BuilderImpl builder) {
        super(builder);
        this.entries = builder.entries;
        this.timestamp = builder.timestamp;
        this.status = builder.status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntries() {
        return entries != null && !(entries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DatasetEntry</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntries} method.
     * </p>
     * 
     * @return A list of <code>DatasetEntry</code> objects.
     */
    public final List<DatasetEntry> entries() {
        return entries;
    }

    /**
     * <p>
     * The time when the request was made.
     * </p>
     * 
     * @return The time when the request was made.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The status of the dataset content.
     * </p>
     * 
     * @return The status of the dataset content.
     */
    public final DatasetContentStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEntries() ? entries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDatasetContentResponse)) {
            return false;
        }
        GetDatasetContentResponse other = (GetDatasetContentResponse) obj;
        return hasEntries() == other.hasEntries() && Objects.equals(entries(), other.entries())
                && Objects.equals(timestamp(), other.timestamp()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDatasetContentResponse").add("Entries", hasEntries() ? entries() : null)
                .add("Timestamp", timestamp()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entries":
            return Optional.ofNullable(clazz.cast(entries()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDatasetContentResponse, T> g) {
        return obj -> g.apply((GetDatasetContentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTAnalyticsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDatasetContentResponse> {
        /**
         * <p>
         * A list of <code>DatasetEntry</code> objects.
         * </p>
         * 
         * @param entries
         *        A list of <code>DatasetEntry</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<DatasetEntry> entries);

        /**
         * <p>
         * A list of <code>DatasetEntry</code> objects.
         * </p>
         * 
         * @param entries
         *        A list of <code>DatasetEntry</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(DatasetEntry... entries);

        /**
         * <p>
         * A list of <code>DatasetEntry</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotanalytics.model.DatasetEntry.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotanalytics.model.DatasetEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotanalytics.model.DatasetEntry.Builder#build()} is called immediately
         * and its result is passed to {@link #entries(List<DatasetEntry>)}.
         * 
         * @param entries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotanalytics.model.DatasetEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entries(java.util.Collection<DatasetEntry>)
         */
        Builder entries(Consumer<DatasetEntry.Builder>... entries);

        /**
         * <p>
         * The time when the request was made.
         * </p>
         * 
         * @param timestamp
         *        The time when the request was made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The status of the dataset content.
         * </p>
         * 
         * @param status
         *        The status of the dataset content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(DatasetContentStatus status);

        /**
         * <p>
         * The status of the dataset content.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatasetContentStatus.Builder} avoiding
         * the need to create one manually via {@link DatasetContentStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatasetContentStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #status(DatasetContentStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link DatasetContentStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(DatasetContentStatus)
         */
        default Builder status(Consumer<DatasetContentStatus.Builder> status) {
            return status(DatasetContentStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl extends IoTAnalyticsResponse.BuilderImpl implements Builder {
        private List<DatasetEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private Instant timestamp;

        private DatasetContentStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDatasetContentResponse model) {
            super(model);
            entries(model.entries);
            timestamp(model.timestamp);
            status(model.status);
        }

        public final List<DatasetEntry.Builder> getEntries() {
            List<DatasetEntry.Builder> result = DatasetEntriesCopier.copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntries(Collection<DatasetEntry.BuilderImpl> entries) {
            this.entries = DatasetEntriesCopier.copyFromBuilder(entries);
        }

        @Override
        public final Builder entries(Collection<DatasetEntry> entries) {
            this.entries = DatasetEntriesCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(DatasetEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<DatasetEntry.Builder>... entries) {
            entries(Stream.of(entries).map(c -> DatasetEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final DatasetContentStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(DatasetContentStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(DatasetContentStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public GetDatasetContentResponse build() {
            return new GetDatasetContentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
