/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage. You can't change the choice of Amazon
 * S3 storage after your data store is created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatastoreIotSiteWiseMultiLayerStorage implements SdkPojo, Serializable,
        ToCopyableBuilder<DatastoreIotSiteWiseMultiLayerStorage.Builder, DatastoreIotSiteWiseMultiLayerStorage> {
    private static final SdkField<IotSiteWiseCustomerManagedDatastoreS3Storage> CUSTOMER_MANAGED_S3_STORAGE_FIELD = SdkField
            .<IotSiteWiseCustomerManagedDatastoreS3Storage> builder(MarshallingType.SDK_POJO)
            .memberName("customerManagedS3Storage")
            .getter(getter(DatastoreIotSiteWiseMultiLayerStorage::customerManagedS3Storage))
            .setter(setter(Builder::customerManagedS3Storage)).constructor(IotSiteWiseCustomerManagedDatastoreS3Storage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedS3Storage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CUSTOMER_MANAGED_S3_STORAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final IotSiteWiseCustomerManagedDatastoreS3Storage customerManagedS3Storage;

    private DatastoreIotSiteWiseMultiLayerStorage(BuilderImpl builder) {
        this.customerManagedS3Storage = builder.customerManagedS3Storage;
    }

    /**
     * <p>
     * Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage.
     * </p>
     * 
     * @return Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage.
     */
    public final IotSiteWiseCustomerManagedDatastoreS3Storage customerManagedS3Storage() {
        return customerManagedS3Storage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customerManagedS3Storage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastoreIotSiteWiseMultiLayerStorage)) {
            return false;
        }
        DatastoreIotSiteWiseMultiLayerStorage other = (DatastoreIotSiteWiseMultiLayerStorage) obj;
        return Objects.equals(customerManagedS3Storage(), other.customerManagedS3Storage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatastoreIotSiteWiseMultiLayerStorage")
                .add("CustomerManagedS3Storage", customerManagedS3Storage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customerManagedS3Storage":
            return Optional.ofNullable(clazz.cast(customerManagedS3Storage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatastoreIotSiteWiseMultiLayerStorage, T> g) {
        return obj -> g.apply((DatastoreIotSiteWiseMultiLayerStorage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatastoreIotSiteWiseMultiLayerStorage> {
        /**
         * <p>
         * Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage.
         * </p>
         * 
         * @param customerManagedS3Storage
         *        Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManagedS3Storage(IotSiteWiseCustomerManagedDatastoreS3Storage customerManagedS3Storage);

        /**
         * <p>
         * Used to store data used by IoT SiteWise in an Amazon S3 bucket that you manage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IotSiteWiseCustomerManagedDatastoreS3Storage.Builder} avoiding the need to create one manually via
         * {@link IotSiteWiseCustomerManagedDatastoreS3Storage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IotSiteWiseCustomerManagedDatastoreS3Storage.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #customerManagedS3Storage(IotSiteWiseCustomerManagedDatastoreS3Storage)}.
         * 
         * @param customerManagedS3Storage
         *        a consumer that will call methods on {@link IotSiteWiseCustomerManagedDatastoreS3Storage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerManagedS3Storage(IotSiteWiseCustomerManagedDatastoreS3Storage)
         */
        default Builder customerManagedS3Storage(
                Consumer<IotSiteWiseCustomerManagedDatastoreS3Storage.Builder> customerManagedS3Storage) {
            return customerManagedS3Storage(IotSiteWiseCustomerManagedDatastoreS3Storage.builder()
                    .applyMutation(customerManagedS3Storage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IotSiteWiseCustomerManagedDatastoreS3Storage customerManagedS3Storage;

        private BuilderImpl() {
        }

        private BuilderImpl(DatastoreIotSiteWiseMultiLayerStorage model) {
            customerManagedS3Storage(model.customerManagedS3Storage);
        }

        public final IotSiteWiseCustomerManagedDatastoreS3Storage.Builder getCustomerManagedS3Storage() {
            return customerManagedS3Storage != null ? customerManagedS3Storage.toBuilder() : null;
        }

        public final void setCustomerManagedS3Storage(
                IotSiteWiseCustomerManagedDatastoreS3Storage.BuilderImpl customerManagedS3Storage) {
            this.customerManagedS3Storage = customerManagedS3Storage != null ? customerManagedS3Storage.build() : null;
        }

        @Override
        public final Builder customerManagedS3Storage(IotSiteWiseCustomerManagedDatastoreS3Storage customerManagedS3Storage) {
            this.customerManagedS3Storage = customerManagedS3Storage;
            return this;
        }

        @Override
        public DatastoreIotSiteWiseMultiLayerStorage build() {
            return new DatastoreIotSiteWiseMultiLayerStorage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
