/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration to manage IoT Job's package version reporting. If configured, Jobs updates the thing's reserved named
 * shadow with the package version information up on successful job completion.
 * </p>
 * <p>
 * <b>Note:</b> For each job, the destinationPackageVersions attribute has to be set with the correct data for Jobs to
 * report to the thing shadow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VersionUpdateByJobsConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<VersionUpdateByJobsConfig.Builder, VersionUpdateByJobsConfig> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(VersionUpdateByJobsConfig::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(VersionUpdateByJobsConfig::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ENABLED_FIELD, ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String roleArn;

    private VersionUpdateByJobsConfig(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * Indicates whether the Job is enabled or not.
     * </p>
     * 
     * @return Indicates whether the Job is enabled or not.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role that grants permission to the IoT jobs service to update the reserved
     * named shadow when the job successfully completes.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role that grants permission to the IoT jobs service to update the
     *         reserved named shadow when the job successfully completes.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersionUpdateByJobsConfig)) {
            return false;
        }
        VersionUpdateByJobsConfig other = (VersionUpdateByJobsConfig) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VersionUpdateByJobsConfig").add("Enabled", enabled()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VersionUpdateByJobsConfig, T> g) {
        return obj -> g.apply((VersionUpdateByJobsConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VersionUpdateByJobsConfig> {
        /**
         * <p>
         * Indicates whether the Job is enabled or not.
         * </p>
         * 
         * @param enabled
         *        Indicates whether the Job is enabled or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role that grants permission to the IoT jobs service to update the
         * reserved named shadow when the job successfully completes.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role that grants permission to the IoT jobs service to update
         *        the reserved named shadow when the job successfully completes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(VersionUpdateByJobsConfig model) {
            enabled(model.enabled);
            roleArn(model.roleArn);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public VersionUpdateByJobsConfig build() {
            return new VersionUpdateByJobsConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
