/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class EventConfigurationsCopier {
    static Map<String, Configuration> copy(Map<String, ? extends Configuration> eventConfigurationsParam) {
        Map<String, Configuration> map;
        if (eventConfigurationsParam == null || eventConfigurationsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Configuration> modifiableMap = new LinkedHashMap<>();
            eventConfigurationsParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Configuration> copyFromBuilder(Map<String, ? extends Configuration.Builder> eventConfigurationsParam) {
        Map<String, Configuration> map;
        if (eventConfigurationsParam == null || eventConfigurationsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Configuration> modifiableMap = new LinkedHashMap<>();
            eventConfigurationsParam.forEach((key, value) -> {
                Configuration member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Configuration.Builder> copyToBuilder(Map<String, ? extends Configuration> eventConfigurationsParam) {
        Map<String, Configuration.Builder> map;
        if (eventConfigurationsParam == null || eventConfigurationsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Configuration.Builder> modifiableMap = new LinkedHashMap<>();
            eventConfigurationsParam.forEach((key, value) -> {
                Configuration.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Configuration> copyEnumToString(Map<EventType, ? extends Configuration> eventConfigurationsParam) {
        Map<String, Configuration> map;
        if (eventConfigurationsParam == null || eventConfigurationsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Configuration> modifiableMap = new LinkedHashMap<>();
            eventConfigurationsParam.forEach((key, value) -> {
                String result = key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<EventType, Configuration> copyStringToEnum(Map<String, ? extends Configuration> eventConfigurationsParam) {
        Map<EventType, Configuration> map;
        if (eventConfigurationsParam == null || eventConfigurationsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<EventType, Configuration> modifiableMap = new LinkedHashMap<>();
            eventConfigurationsParam.forEach((key, value) -> {
                EventType result = EventType.fromValue(key);
                if (result != EventType.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
