/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFleetMetricRequest extends IotRequest implements
        ToCopyableBuilder<CreateFleetMetricRequest.Builder, CreateFleetMetricRequest> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricName").getter(getter(CreateFleetMetricRequest::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("metricName").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryString").getter(getter(CreateFleetMetricRequest::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()).build();

    private static final SdkField<AggregationType> AGGREGATION_TYPE_FIELD = SdkField
            .<AggregationType> builder(MarshallingType.SDK_POJO).memberName("aggregationType")
            .getter(getter(CreateFleetMetricRequest::aggregationType)).setter(setter(Builder::aggregationType))
            .constructor(AggregationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationType").build()).build();

    private static final SdkField<Integer> PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("period").getter(getter(CreateFleetMetricRequest::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()).build();

    private static final SdkField<String> AGGREGATION_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aggregationField").getter(getter(CreateFleetMetricRequest::aggregationField))
            .setter(setter(Builder::aggregationField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationField").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateFleetMetricRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> QUERY_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryVersion").getter(getter(CreateFleetMetricRequest::queryVersion))
            .setter(setter(Builder::queryVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryVersion").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexName").getter(getter(CreateFleetMetricRequest::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(CreateFleetMetricRequest::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateFleetMetricRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD,
            QUERY_STRING_FIELD, AGGREGATION_TYPE_FIELD, PERIOD_FIELD, AGGREGATION_FIELD_FIELD, DESCRIPTION_FIELD,
            QUERY_VERSION_FIELD, INDEX_NAME_FIELD, UNIT_FIELD, TAGS_FIELD));

    private final String metricName;

    private final String queryString;

    private final AggregationType aggregationType;

    private final Integer period;

    private final String aggregationField;

    private final String description;

    private final String queryVersion;

    private final String indexName;

    private final String unit;

    private final List<Tag> tags;

    private CreateFleetMetricRequest(BuilderImpl builder) {
        super(builder);
        this.metricName = builder.metricName;
        this.queryString = builder.queryString;
        this.aggregationType = builder.aggregationType;
        this.period = builder.period;
        this.aggregationField = builder.aggregationField;
        this.description = builder.description;
        this.queryVersion = builder.queryVersion;
        this.indexName = builder.indexName;
        this.unit = builder.unit;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the fleet metric to create.
     * </p>
     * 
     * @return The name of the fleet metric to create.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The search query string.
     * </p>
     * 
     * @return The search query string.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The type of the aggregation query.
     * </p>
     * 
     * @return The type of the aggregation query.
     */
    public final AggregationType aggregationType() {
        return aggregationType;
    }

    /**
     * <p>
     * The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be multiple of 60.
     * </p>
     * 
     * @return The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be multiple
     *         of 60.
     */
    public final Integer period() {
        return period;
    }

    /**
     * <p>
     * The field to aggregate.
     * </p>
     * 
     * @return The field to aggregate.
     */
    public final String aggregationField() {
        return aggregationField;
    }

    /**
     * <p>
     * The fleet metric description.
     * </p>
     * 
     * @return The fleet metric description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The query version.
     * </p>
     * 
     * @return The query version.
     */
    public final String queryVersion() {
        return queryVersion;
    }

    /**
     * <p>
     * The name of the index to search.
     * </p>
     * 
     * @return The name of the index to search.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">CW metric</a>.
     * Default to null.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link FleetMetricUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">CW
     *         metric</a>. Default to null.
     * @see FleetMetricUnit
     */
    public final FleetMetricUnit unit() {
        return FleetMetricUnit.fromValue(unit);
    }

    /**
     * <p>
     * Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">CW metric</a>.
     * Default to null.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link FleetMetricUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">CW
     *         metric</a>. Default to null.
     * @see FleetMetricUnit
     */
    public final String unitAsString() {
        return unit;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata, which can be used to manage the fleet metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata, which can be used to manage the fleet metric.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationType());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationField());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(queryVersion());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetMetricRequest)) {
            return false;
        }
        CreateFleetMetricRequest other = (CreateFleetMetricRequest) obj;
        return Objects.equals(metricName(), other.metricName()) && Objects.equals(queryString(), other.queryString())
                && Objects.equals(aggregationType(), other.aggregationType()) && Objects.equals(period(), other.period())
                && Objects.equals(aggregationField(), other.aggregationField())
                && Objects.equals(description(), other.description()) && Objects.equals(queryVersion(), other.queryVersion())
                && Objects.equals(indexName(), other.indexName()) && Objects.equals(unitAsString(), other.unitAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFleetMetricRequest").add("MetricName", metricName()).add("QueryString", queryString())
                .add("AggregationType", aggregationType()).add("Period", period()).add("AggregationField", aggregationField())
                .add("Description", description()).add("QueryVersion", queryVersion()).add("IndexName", indexName())
                .add("Unit", unitAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "queryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "aggregationType":
            return Optional.ofNullable(clazz.cast(aggregationType()));
        case "period":
            return Optional.ofNullable(clazz.cast(period()));
        case "aggregationField":
            return Optional.ofNullable(clazz.cast(aggregationField()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "queryVersion":
            return Optional.ofNullable(clazz.cast(queryVersion()));
        case "indexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetMetricRequest, T> g) {
        return obj -> g.apply((CreateFleetMetricRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFleetMetricRequest> {
        /**
         * <p>
         * The name of the fleet metric to create.
         * </p>
         * 
         * @param metricName
         *        The name of the fleet metric to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The search query string.
         * </p>
         * 
         * @param queryString
         *        The search query string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The type of the aggregation query.
         * </p>
         * 
         * @param aggregationType
         *        The type of the aggregation query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationType(AggregationType aggregationType);

        /**
         * <p>
         * The type of the aggregation query.
         * </p>
         * This is a convenience method that creates an instance of the {@link AggregationType.Builder} avoiding the
         * need to create one manually via {@link AggregationType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregationType.Builder#build()} is called immediately and its
         * result is passed to {@link #aggregationType(AggregationType)}.
         * 
         * @param aggregationType
         *        a consumer that will call methods on {@link AggregationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationType(AggregationType)
         */
        default Builder aggregationType(Consumer<AggregationType.Builder> aggregationType) {
            return aggregationType(AggregationType.builder().applyMutation(aggregationType).build());
        }

        /**
         * <p>
         * The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be multiple of
         * 60.
         * </p>
         * 
         * @param period
         *        The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be
         *        multiple of 60.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * <p>
         * The field to aggregate.
         * </p>
         * 
         * @param aggregationField
         *        The field to aggregate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationField(String aggregationField);

        /**
         * <p>
         * The fleet metric description.
         * </p>
         * 
         * @param description
         *        The fleet metric description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The query version.
         * </p>
         * 
         * @param queryVersion
         *        The query version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryVersion(String queryVersion);

        /**
         * <p>
         * The name of the index to search.
         * </p>
         * 
         * @param indexName
         *        The name of the index to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">CW metric</a>.
         * Default to null.
         * </p>
         * 
         * @param unit
         *        Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">CW
         *        metric</a>. Default to null.
         * @see FleetMetricUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetMetricUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">CW metric</a>.
         * Default to null.
         * </p>
         * 
         * @param unit
         *        Used to support unit transformation such as milliseconds to seconds. The unit must be supported by <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">CW
         *        metric</a>. Default to null.
         * @see FleetMetricUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetMetricUnit
         */
        Builder unit(FleetMetricUnit unit);

        /**
         * <p>
         * Metadata, which can be used to manage the fleet metric.
         * </p>
         * 
         * @param tags
         *        Metadata, which can be used to manage the fleet metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata, which can be used to manage the fleet metric.
         * </p>
         * 
         * @param tags
         *        Metadata, which can be used to manage the fleet metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata, which can be used to manage the fleet metric.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iot.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.iot.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.iot.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String metricName;

        private String queryString;

        private AggregationType aggregationType;

        private Integer period;

        private String aggregationField;

        private String description;

        private String queryVersion;

        private String indexName;

        private String unit;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetMetricRequest model) {
            super(model);
            metricName(model.metricName);
            queryString(model.queryString);
            aggregationType(model.aggregationType);
            period(model.period);
            aggregationField(model.aggregationField);
            description(model.description);
            queryVersion(model.queryVersion);
            indexName(model.indexName);
            unit(model.unit);
            tags(model.tags);
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final AggregationType.Builder getAggregationType() {
            return aggregationType != null ? aggregationType.toBuilder() : null;
        }

        public final void setAggregationType(AggregationType.BuilderImpl aggregationType) {
            this.aggregationType = aggregationType != null ? aggregationType.build() : null;
        }

        @Override
        public final Builder aggregationType(AggregationType aggregationType) {
            this.aggregationType = aggregationType;
            return this;
        }

        public final Integer getPeriod() {
            return period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final String getAggregationField() {
            return aggregationField;
        }

        public final void setAggregationField(String aggregationField) {
            this.aggregationField = aggregationField;
        }

        @Override
        public final Builder aggregationField(String aggregationField) {
            this.aggregationField = aggregationField;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getQueryVersion() {
            return queryVersion;
        }

        public final void setQueryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
        }

        @Override
        public final Builder queryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(FleetMetricUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFleetMetricRequest build() {
            return new CreateFleetMetricRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
