/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEntityAggregatesForOrganizationResponse extends HealthResponse
        implements
        ToCopyableBuilder<DescribeEntityAggregatesForOrganizationResponse.Builder, DescribeEntityAggregatesForOrganizationResponse> {
    private static final SdkField<List<OrganizationEntityAggregate>> ORGANIZATION_ENTITY_AGGREGATES_FIELD = SdkField
            .<List<OrganizationEntityAggregate>> builder(MarshallingType.LIST)
            .memberName("organizationEntityAggregates")
            .getter(getter(DescribeEntityAggregatesForOrganizationResponse::organizationEntityAggregates))
            .setter(setter(Builder::organizationEntityAggregates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationEntityAggregates")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrganizationEntityAggregate> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrganizationEntityAggregate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ORGANIZATION_ENTITY_AGGREGATES_FIELD));

    private final List<OrganizationEntityAggregate> organizationEntityAggregates;

    private DescribeEntityAggregatesForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.organizationEntityAggregates = builder.organizationEntityAggregates;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrganizationEntityAggregates property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOrganizationEntityAggregates() {
        return organizationEntityAggregates != null && !(organizationEntityAggregates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of entity aggregates for each of the specified accounts that are affected by each of the specified
     * events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrganizationEntityAggregates} method.
     * </p>
     * 
     * @return The list of entity aggregates for each of the specified accounts that are affected by each of the
     *         specified events.
     */
    public final List<OrganizationEntityAggregate> organizationEntityAggregates() {
        return organizationEntityAggregates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOrganizationEntityAggregates() ? organizationEntityAggregates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEntityAggregatesForOrganizationResponse)) {
            return false;
        }
        DescribeEntityAggregatesForOrganizationResponse other = (DescribeEntityAggregatesForOrganizationResponse) obj;
        return hasOrganizationEntityAggregates() == other.hasOrganizationEntityAggregates()
                && Objects.equals(organizationEntityAggregates(), other.organizationEntityAggregates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEntityAggregatesForOrganizationResponse")
                .add("OrganizationEntityAggregates", hasOrganizationEntityAggregates() ? organizationEntityAggregates() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "organizationEntityAggregates":
            return Optional.ofNullable(clazz.cast(organizationEntityAggregates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEntityAggregatesForOrganizationResponse, T> g) {
        return obj -> g.apply((DescribeEntityAggregatesForOrganizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEntityAggregatesForOrganizationResponse> {
        /**
         * <p>
         * The list of entity aggregates for each of the specified accounts that are affected by each of the specified
         * events.
         * </p>
         * 
         * @param organizationEntityAggregates
         *        The list of entity aggregates for each of the specified accounts that are affected by each of the
         *        specified events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationEntityAggregates(Collection<OrganizationEntityAggregate> organizationEntityAggregates);

        /**
         * <p>
         * The list of entity aggregates for each of the specified accounts that are affected by each of the specified
         * events.
         * </p>
         * 
         * @param organizationEntityAggregates
         *        The list of entity aggregates for each of the specified accounts that are affected by each of the
         *        specified events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationEntityAggregates(OrganizationEntityAggregate... organizationEntityAggregates);

        /**
         * <p>
         * The list of entity aggregates for each of the specified accounts that are affected by each of the specified
         * events.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.health.model.OrganizationEntityAggregate.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.health.model.OrganizationEntityAggregate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.health.model.OrganizationEntityAggregate.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #organizationEntityAggregates(List<OrganizationEntityAggregate>)}.
         * 
         * @param organizationEntityAggregates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.health.model.OrganizationEntityAggregate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationEntityAggregates(java.util.Collection<OrganizationEntityAggregate>)
         */
        Builder organizationEntityAggregates(Consumer<OrganizationEntityAggregate.Builder>... organizationEntityAggregates);
    }

    static final class BuilderImpl extends HealthResponse.BuilderImpl implements Builder {
        private List<OrganizationEntityAggregate> organizationEntityAggregates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEntityAggregatesForOrganizationResponse model) {
            super(model);
            organizationEntityAggregates(model.organizationEntityAggregates);
        }

        public final List<OrganizationEntityAggregate.Builder> getOrganizationEntityAggregates() {
            List<OrganizationEntityAggregate.Builder> result = OrganizationEntityAggregatesListCopier
                    .copyToBuilder(this.organizationEntityAggregates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrganizationEntityAggregates(
                Collection<OrganizationEntityAggregate.BuilderImpl> organizationEntityAggregates) {
            this.organizationEntityAggregates = OrganizationEntityAggregatesListCopier
                    .copyFromBuilder(organizationEntityAggregates);
        }

        @Override
        public final Builder organizationEntityAggregates(Collection<OrganizationEntityAggregate> organizationEntityAggregates) {
            this.organizationEntityAggregates = OrganizationEntityAggregatesListCopier.copy(organizationEntityAggregates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationEntityAggregates(OrganizationEntityAggregate... organizationEntityAggregates) {
            organizationEntityAggregates(Arrays.asList(organizationEntityAggregates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationEntityAggregates(
                Consumer<OrganizationEntityAggregate.Builder>... organizationEntityAggregates) {
            organizationEntityAggregates(Stream.of(organizationEntityAggregates)
                    .map(c -> OrganizationEntityAggregate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeEntityAggregatesForOrganizationResponse build() {
            return new DescribeEntityAggregatesForOrganizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
