/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMatchmakingResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeMatchmakingResponse.Builder, DescribeMatchmakingResponse> {
    private static final SdkField<List<MatchmakingTicket>> TICKET_LIST_FIELD = SdkField
            .<List<MatchmakingTicket>> builder(MarshallingType.LIST)
            .memberName("TicketList")
            .getter(getter(DescribeMatchmakingResponse::ticketList))
            .setter(setter(Builder::ticketList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TicketList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MatchmakingTicket> builder(MarshallingType.SDK_POJO)
                                            .constructor(MatchmakingTicket::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TICKET_LIST_FIELD));

    private final List<MatchmakingTicket> ticketList;

    private DescribeMatchmakingResponse(BuilderImpl builder) {
        super(builder);
        this.ticketList = builder.ticketList;
    }

    /**
     * For responses, this returns true if the service returned a value for the TicketList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTicketList() {
        return ticketList != null && !(ticketList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of existing matchmaking ticket objects matching the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTicketList} method.
     * </p>
     * 
     * @return A collection of existing matchmaking ticket objects matching the request.
     */
    public final List<MatchmakingTicket> ticketList() {
        return ticketList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTicketList() ? ticketList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMatchmakingResponse)) {
            return false;
        }
        DescribeMatchmakingResponse other = (DescribeMatchmakingResponse) obj;
        return hasTicketList() == other.hasTicketList() && Objects.equals(ticketList(), other.ticketList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMatchmakingResponse").add("TicketList", hasTicketList() ? ticketList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TicketList":
            return Optional.ofNullable(clazz.cast(ticketList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMatchmakingResponse, T> g) {
        return obj -> g.apply((DescribeMatchmakingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeMatchmakingResponse> {
        /**
         * <p>
         * A collection of existing matchmaking ticket objects matching the request.
         * </p>
         * 
         * @param ticketList
         *        A collection of existing matchmaking ticket objects matching the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ticketList(Collection<MatchmakingTicket> ticketList);

        /**
         * <p>
         * A collection of existing matchmaking ticket objects matching the request.
         * </p>
         * 
         * @param ticketList
         *        A collection of existing matchmaking ticket objects matching the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ticketList(MatchmakingTicket... ticketList);

        /**
         * <p>
         * A collection of existing matchmaking ticket objects matching the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.MatchmakingTicket.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.gamelift.model.MatchmakingTicket#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.MatchmakingTicket.Builder#build()} is called
         * immediately and its result is passed to {@link #ticketList(List<MatchmakingTicket>)}.
         * 
         * @param ticketList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.MatchmakingTicket.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ticketList(java.util.Collection<MatchmakingTicket>)
         */
        Builder ticketList(Consumer<MatchmakingTicket.Builder>... ticketList);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private List<MatchmakingTicket> ticketList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMatchmakingResponse model) {
            super(model);
            ticketList(model.ticketList);
        }

        public final List<MatchmakingTicket.Builder> getTicketList() {
            List<MatchmakingTicket.Builder> result = MatchmakingTicketListCopier.copyToBuilder(this.ticketList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTicketList(Collection<MatchmakingTicket.BuilderImpl> ticketList) {
            this.ticketList = MatchmakingTicketListCopier.copyFromBuilder(ticketList);
        }

        @Override
        public final Builder ticketList(Collection<MatchmakingTicket> ticketList) {
            this.ticketList = MatchmakingTicketListCopier.copy(ticketList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ticketList(MatchmakingTicket... ticketList) {
            ticketList(Arrays.asList(ticketList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ticketList(Consumer<MatchmakingTicket.Builder>... ticketList) {
            ticketList(Stream.of(ticketList).map(c -> MatchmakingTicket.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeMatchmakingResponse build() {
            return new DescribeMatchmakingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
