/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response object for the <code>DeleteFileSystem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFileSystemResponse extends FSxResponse implements
        ToCopyableBuilder<DeleteFileSystemResponse.Builder, DeleteFileSystemResponse> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemId").getter(getter(DeleteFileSystemResponse::fileSystemId))
            .setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()).build();

    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Lifecycle").getter(getter(DeleteFileSystemResponse::lifecycleAsString))
            .setter(setter(Builder::lifecycle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final SdkField<DeleteFileSystemWindowsResponse> WINDOWS_RESPONSE_FIELD = SdkField
            .<DeleteFileSystemWindowsResponse> builder(MarshallingType.SDK_POJO).memberName("WindowsResponse")
            .getter(getter(DeleteFileSystemResponse::windowsResponse)).setter(setter(Builder::windowsResponse))
            .constructor(DeleteFileSystemWindowsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowsResponse").build()).build();

    private static final SdkField<DeleteFileSystemLustreResponse> LUSTRE_RESPONSE_FIELD = SdkField
            .<DeleteFileSystemLustreResponse> builder(MarshallingType.SDK_POJO).memberName("LustreResponse")
            .getter(getter(DeleteFileSystemResponse::lustreResponse)).setter(setter(Builder::lustreResponse))
            .constructor(DeleteFileSystemLustreResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LustreResponse").build()).build();

    private static final SdkField<DeleteFileSystemOpenZFSResponse> OPEN_ZFS_RESPONSE_FIELD = SdkField
            .<DeleteFileSystemOpenZFSResponse> builder(MarshallingType.SDK_POJO).memberName("OpenZFSResponse")
            .getter(getter(DeleteFileSystemResponse::openZFSResponse)).setter(setter(Builder::openZFSResponse))
            .constructor(DeleteFileSystemOpenZFSResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenZFSResponse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD,
            LIFECYCLE_FIELD, WINDOWS_RESPONSE_FIELD, LUSTRE_RESPONSE_FIELD, OPEN_ZFS_RESPONSE_FIELD));

    private final String fileSystemId;

    private final String lifecycle;

    private final DeleteFileSystemWindowsResponse windowsResponse;

    private final DeleteFileSystemLustreResponse lustreResponse;

    private final DeleteFileSystemOpenZFSResponse openZFSResponse;

    private DeleteFileSystemResponse(BuilderImpl builder) {
        super(builder);
        this.fileSystemId = builder.fileSystemId;
        this.lifecycle = builder.lifecycle;
        this.windowsResponse = builder.windowsResponse;
        this.lustreResponse = builder.lustreResponse;
        this.openZFSResponse = builder.openZFSResponse;
    }

    /**
     * <p>
     * The ID of the file system that's being deleted.
     * </p>
     * 
     * @return The ID of the file system that's being deleted.
     */
    public final String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * The file system lifecycle for the deletion request. If the <code>DeleteFileSystem</code> operation is successful,
     * this status is <code>DELETING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link FileSystemLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The file system lifecycle for the deletion request. If the <code>DeleteFileSystem</code> operation is
     *         successful, this status is <code>DELETING</code>.
     * @see FileSystemLifecycle
     */
    public final FileSystemLifecycle lifecycle() {
        return FileSystemLifecycle.fromValue(lifecycle);
    }

    /**
     * <p>
     * The file system lifecycle for the deletion request. If the <code>DeleteFileSystem</code> operation is successful,
     * this status is <code>DELETING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link FileSystemLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The file system lifecycle for the deletion request. If the <code>DeleteFileSystem</code> operation is
     *         successful, this status is <code>DELETING</code>.
     * @see FileSystemLifecycle
     */
    public final String lifecycleAsString() {
        return lifecycle;
    }

    /**
     * Returns the value of the WindowsResponse property for this object.
     * 
     * @return The value of the WindowsResponse property for this object.
     */
    public final DeleteFileSystemWindowsResponse windowsResponse() {
        return windowsResponse;
    }

    /**
     * Returns the value of the LustreResponse property for this object.
     * 
     * @return The value of the LustreResponse property for this object.
     */
    public final DeleteFileSystemLustreResponse lustreResponse() {
        return lustreResponse;
    }

    /**
     * <p>
     * The response object for the OpenZFS file system that's being deleted in the <code>DeleteFileSystem</code>
     * operation.
     * </p>
     * 
     * @return The response object for the OpenZFS file system that's being deleted in the <code>DeleteFileSystem</code>
     *         operation.
     */
    public final DeleteFileSystemOpenZFSResponse openZFSResponse() {
        return openZFSResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(windowsResponse());
        hashCode = 31 * hashCode + Objects.hashCode(lustreResponse());
        hashCode = 31 * hashCode + Objects.hashCode(openZFSResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFileSystemResponse)) {
            return false;
        }
        DeleteFileSystemResponse other = (DeleteFileSystemResponse) obj;
        return Objects.equals(fileSystemId(), other.fileSystemId())
                && Objects.equals(lifecycleAsString(), other.lifecycleAsString())
                && Objects.equals(windowsResponse(), other.windowsResponse())
                && Objects.equals(lustreResponse(), other.lustreResponse())
                && Objects.equals(openZFSResponse(), other.openZFSResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteFileSystemResponse").add("FileSystemId", fileSystemId())
                .add("Lifecycle", lifecycleAsString()).add("WindowsResponse", windowsResponse())
                .add("LustreResponse", lustreResponse()).add("OpenZFSResponse", openZFSResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycleAsString()));
        case "WindowsResponse":
            return Optional.ofNullable(clazz.cast(windowsResponse()));
        case "LustreResponse":
            return Optional.ofNullable(clazz.cast(lustreResponse()));
        case "OpenZFSResponse":
            return Optional.ofNullable(clazz.cast(openZFSResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFileSystemResponse, T> g) {
        return obj -> g.apply((DeleteFileSystemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteFileSystemResponse> {
        /**
         * <p>
         * The ID of the file system that's being deleted.
         * </p>
         * 
         * @param fileSystemId
         *        The ID of the file system that's being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * The file system lifecycle for the deletion request. If the <code>DeleteFileSystem</code> operation is
         * successful, this status is <code>DELETING</code>.
         * </p>
         * 
         * @param lifecycle
         *        The file system lifecycle for the deletion request. If the <code>DeleteFileSystem</code> operation is
         *        successful, this status is <code>DELETING</code>.
         * @see FileSystemLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileSystemLifecycle
         */
        Builder lifecycle(String lifecycle);

        /**
         * <p>
         * The file system lifecycle for the deletion request. If the <code>DeleteFileSystem</code> operation is
         * successful, this status is <code>DELETING</code>.
         * </p>
         * 
         * @param lifecycle
         *        The file system lifecycle for the deletion request. If the <code>DeleteFileSystem</code> operation is
         *        successful, this status is <code>DELETING</code>.
         * @see FileSystemLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileSystemLifecycle
         */
        Builder lifecycle(FileSystemLifecycle lifecycle);

        /**
         * Sets the value of the WindowsResponse property for this object.
         *
         * @param windowsResponse
         *        The new value for the WindowsResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowsResponse(DeleteFileSystemWindowsResponse windowsResponse);

        /**
         * Sets the value of the WindowsResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DeleteFileSystemWindowsResponse.Builder}
         * avoiding the need to create one manually via {@link DeleteFileSystemWindowsResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeleteFileSystemWindowsResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #windowsResponse(DeleteFileSystemWindowsResponse)}.
         * 
         * @param windowsResponse
         *        a consumer that will call methods on {@link DeleteFileSystemWindowsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #windowsResponse(DeleteFileSystemWindowsResponse)
         */
        default Builder windowsResponse(Consumer<DeleteFileSystemWindowsResponse.Builder> windowsResponse) {
            return windowsResponse(DeleteFileSystemWindowsResponse.builder().applyMutation(windowsResponse).build());
        }

        /**
         * Sets the value of the LustreResponse property for this object.
         *
         * @param lustreResponse
         *        The new value for the LustreResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lustreResponse(DeleteFileSystemLustreResponse lustreResponse);

        /**
         * Sets the value of the LustreResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DeleteFileSystemLustreResponse.Builder}
         * avoiding the need to create one manually via {@link DeleteFileSystemLustreResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeleteFileSystemLustreResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #lustreResponse(DeleteFileSystemLustreResponse)}.
         * 
         * @param lustreResponse
         *        a consumer that will call methods on {@link DeleteFileSystemLustreResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lustreResponse(DeleteFileSystemLustreResponse)
         */
        default Builder lustreResponse(Consumer<DeleteFileSystemLustreResponse.Builder> lustreResponse) {
            return lustreResponse(DeleteFileSystemLustreResponse.builder().applyMutation(lustreResponse).build());
        }

        /**
         * <p>
         * The response object for the OpenZFS file system that's being deleted in the <code>DeleteFileSystem</code>
         * operation.
         * </p>
         * 
         * @param openZFSResponse
         *        The response object for the OpenZFS file system that's being deleted in the
         *        <code>DeleteFileSystem</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openZFSResponse(DeleteFileSystemOpenZFSResponse openZFSResponse);

        /**
         * <p>
         * The response object for the OpenZFS file system that's being deleted in the <code>DeleteFileSystem</code>
         * operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeleteFileSystemOpenZFSResponse.Builder}
         * avoiding the need to create one manually via {@link DeleteFileSystemOpenZFSResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeleteFileSystemOpenZFSResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #openZFSResponse(DeleteFileSystemOpenZFSResponse)}.
         * 
         * @param openZFSResponse
         *        a consumer that will call methods on {@link DeleteFileSystemOpenZFSResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openZFSResponse(DeleteFileSystemOpenZFSResponse)
         */
        default Builder openZFSResponse(Consumer<DeleteFileSystemOpenZFSResponse.Builder> openZFSResponse) {
            return openZFSResponse(DeleteFileSystemOpenZFSResponse.builder().applyMutation(openZFSResponse).build());
        }
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private String fileSystemId;

        private String lifecycle;

        private DeleteFileSystemWindowsResponse windowsResponse;

        private DeleteFileSystemLustreResponse lustreResponse;

        private DeleteFileSystemOpenZFSResponse openZFSResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFileSystemResponse model) {
            super(model);
            fileSystemId(model.fileSystemId);
            lifecycle(model.lifecycle);
            windowsResponse(model.windowsResponse);
            lustreResponse(model.lustreResponse);
            openZFSResponse(model.openZFSResponse);
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getLifecycle() {
            return lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(FileSystemLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final DeleteFileSystemWindowsResponse.Builder getWindowsResponse() {
            return windowsResponse != null ? windowsResponse.toBuilder() : null;
        }

        public final void setWindowsResponse(DeleteFileSystemWindowsResponse.BuilderImpl windowsResponse) {
            this.windowsResponse = windowsResponse != null ? windowsResponse.build() : null;
        }

        @Override
        public final Builder windowsResponse(DeleteFileSystemWindowsResponse windowsResponse) {
            this.windowsResponse = windowsResponse;
            return this;
        }

        public final DeleteFileSystemLustreResponse.Builder getLustreResponse() {
            return lustreResponse != null ? lustreResponse.toBuilder() : null;
        }

        public final void setLustreResponse(DeleteFileSystemLustreResponse.BuilderImpl lustreResponse) {
            this.lustreResponse = lustreResponse != null ? lustreResponse.build() : null;
        }

        @Override
        public final Builder lustreResponse(DeleteFileSystemLustreResponse lustreResponse) {
            this.lustreResponse = lustreResponse;
            return this;
        }

        public final DeleteFileSystemOpenZFSResponse.Builder getOpenZFSResponse() {
            return openZFSResponse != null ? openZFSResponse.toBuilder() : null;
        }

        public final void setOpenZFSResponse(DeleteFileSystemOpenZFSResponse.BuilderImpl openZFSResponse) {
            this.openZFSResponse = openZFSResponse != null ? openZFSResponse.build() : null;
        }

        @Override
        public final Builder openZFSResponse(DeleteFileSystemOpenZFSResponse openZFSResponse) {
            this.openZFSResponse = openZFSResponse;
            return this;
        }

        @Override
        public DeleteFileSystemResponse build() {
            return new DeleteFileSystemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
