/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response object for the <code>DeleteBackup</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteBackupResponse extends FSxResponse implements
        ToCopyableBuilder<DeleteBackupResponse.Builder, DeleteBackupResponse> {
    private static final SdkField<String> BACKUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupId").getter(getter(DeleteBackupResponse::backupId)).setter(setter(Builder::backupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupId").build()).build();

    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Lifecycle").getter(getter(DeleteBackupResponse::lifecycleAsString)).setter(setter(Builder::lifecycle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_ID_FIELD,
            LIFECYCLE_FIELD));

    private final String backupId;

    private final String lifecycle;

    private DeleteBackupResponse(BuilderImpl builder) {
        super(builder);
        this.backupId = builder.backupId;
        this.lifecycle = builder.lifecycle;
    }

    /**
     * <p>
     * The ID of the backup that was deleted.
     * </p>
     * 
     * @return The ID of the backup that was deleted.
     */
    public final String backupId() {
        return backupId;
    }

    /**
     * <p>
     * The lifecycle status of the backup. If the <code>DeleteBackup</code> operation is successful, the status is
     * <code>DELETED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link BackupLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The lifecycle status of the backup. If the <code>DeleteBackup</code> operation is successful, the status
     *         is <code>DELETED</code>.
     * @see BackupLifecycle
     */
    public final BackupLifecycle lifecycle() {
        return BackupLifecycle.fromValue(lifecycle);
    }

    /**
     * <p>
     * The lifecycle status of the backup. If the <code>DeleteBackup</code> operation is successful, the status is
     * <code>DELETED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycle} will
     * return {@link BackupLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lifecycleAsString}.
     * </p>
     * 
     * @return The lifecycle status of the backup. If the <code>DeleteBackup</code> operation is successful, the status
     *         is <code>DELETED</code>.
     * @see BackupLifecycle
     */
    public final String lifecycleAsString() {
        return lifecycle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupId());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBackupResponse)) {
            return false;
        }
        DeleteBackupResponse other = (DeleteBackupResponse) obj;
        return Objects.equals(backupId(), other.backupId()) && Objects.equals(lifecycleAsString(), other.lifecycleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteBackupResponse").add("BackupId", backupId()).add("Lifecycle", lifecycleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupId":
            return Optional.ofNullable(clazz.cast(backupId()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteBackupResponse, T> g) {
        return obj -> g.apply((DeleteBackupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteBackupResponse> {
        /**
         * <p>
         * The ID of the backup that was deleted.
         * </p>
         * 
         * @param backupId
         *        The ID of the backup that was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupId(String backupId);

        /**
         * <p>
         * The lifecycle status of the backup. If the <code>DeleteBackup</code> operation is successful, the status is
         * <code>DELETED</code>.
         * </p>
         * 
         * @param lifecycle
         *        The lifecycle status of the backup. If the <code>DeleteBackup</code> operation is successful, the
         *        status is <code>DELETED</code>.
         * @see BackupLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupLifecycle
         */
        Builder lifecycle(String lifecycle);

        /**
         * <p>
         * The lifecycle status of the backup. If the <code>DeleteBackup</code> operation is successful, the status is
         * <code>DELETED</code>.
         * </p>
         * 
         * @param lifecycle
         *        The lifecycle status of the backup. If the <code>DeleteBackup</code> operation is successful, the
         *        status is <code>DELETED</code>.
         * @see BackupLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupLifecycle
         */
        Builder lifecycle(BackupLifecycle lifecycle);
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private String backupId;

        private String lifecycle;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBackupResponse model) {
            super(model);
            backupId(model.backupId);
            lifecycle(model.lifecycle);
        }

        public final String getBackupId() {
            return backupId;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final String getLifecycle() {
            return lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(BackupLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        @Override
        public DeleteBackupResponse build() {
            return new DeleteBackupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
