/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The snapshot configuration to use when creating an OpenZFS volume from a snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOpenZFSOriginSnapshotConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateOpenZFSOriginSnapshotConfiguration.Builder, CreateOpenZFSOriginSnapshotConfiguration> {
    private static final SdkField<String> SNAPSHOT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotARN").getter(getter(CreateOpenZFSOriginSnapshotConfiguration::snapshotARN))
            .setter(setter(Builder::snapshotARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotARN").build()).build();

    private static final SdkField<String> COPY_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CopyStrategy").getter(getter(CreateOpenZFSOriginSnapshotConfiguration::copyStrategyAsString))
            .setter(setter(Builder::copyStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyStrategy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ARN_FIELD,
            COPY_STRATEGY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String snapshotARN;

    private final String copyStrategy;

    private CreateOpenZFSOriginSnapshotConfiguration(BuilderImpl builder) {
        this.snapshotARN = builder.snapshotARN;
        this.copyStrategy = builder.copyStrategy;
    }

    /**
     * Returns the value of the SnapshotARN property for this object.
     * 
     * @return The value of the SnapshotARN property for this object.
     */
    public final String snapshotARN() {
        return snapshotARN;
    }

    /**
     * <p>
     * The strategy used when copying data from the snapshot to the new volume.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CLONE</code> - The new volume references the data in the origin snapshot. Cloning a snapshot is faster than
     * copying data from the snapshot to a new volume and doesn't consume disk throughput. However, the origin snapshot
     * can't be deleted if there is a volume using its copied data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FULL_COPY</code> - Copies all data from the snapshot to the new volume.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #copyStrategy} will
     * return {@link OpenZFSCopyStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #copyStrategyAsString}.
     * </p>
     * 
     * @return The strategy used when copying data from the snapshot to the new volume. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CLONE</code> - The new volume references the data in the origin snapshot. Cloning a snapshot is
     *         faster than copying data from the snapshot to a new volume and doesn't consume disk throughput. However,
     *         the origin snapshot can't be deleted if there is a volume using its copied data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FULL_COPY</code> - Copies all data from the snapshot to the new volume.
     *         </p>
     *         </li>
     * @see OpenZFSCopyStrategy
     */
    public final OpenZFSCopyStrategy copyStrategy() {
        return OpenZFSCopyStrategy.fromValue(copyStrategy);
    }

    /**
     * <p>
     * The strategy used when copying data from the snapshot to the new volume.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CLONE</code> - The new volume references the data in the origin snapshot. Cloning a snapshot is faster than
     * copying data from the snapshot to a new volume and doesn't consume disk throughput. However, the origin snapshot
     * can't be deleted if there is a volume using its copied data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FULL_COPY</code> - Copies all data from the snapshot to the new volume.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #copyStrategy} will
     * return {@link OpenZFSCopyStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #copyStrategyAsString}.
     * </p>
     * 
     * @return The strategy used when copying data from the snapshot to the new volume. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CLONE</code> - The new volume references the data in the origin snapshot. Cloning a snapshot is
     *         faster than copying data from the snapshot to a new volume and doesn't consume disk throughput. However,
     *         the origin snapshot can't be deleted if there is a volume using its copied data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FULL_COPY</code> - Copies all data from the snapshot to the new volume.
     *         </p>
     *         </li>
     * @see OpenZFSCopyStrategy
     */
    public final String copyStrategyAsString() {
        return copyStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshotARN());
        hashCode = 31 * hashCode + Objects.hashCode(copyStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOpenZFSOriginSnapshotConfiguration)) {
            return false;
        }
        CreateOpenZFSOriginSnapshotConfiguration other = (CreateOpenZFSOriginSnapshotConfiguration) obj;
        return Objects.equals(snapshotARN(), other.snapshotARN())
                && Objects.equals(copyStrategyAsString(), other.copyStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOpenZFSOriginSnapshotConfiguration").add("SnapshotARN", snapshotARN())
                .add("CopyStrategy", copyStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotARN":
            return Optional.ofNullable(clazz.cast(snapshotARN()));
        case "CopyStrategy":
            return Optional.ofNullable(clazz.cast(copyStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOpenZFSOriginSnapshotConfiguration, T> g) {
        return obj -> g.apply((CreateOpenZFSOriginSnapshotConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateOpenZFSOriginSnapshotConfiguration> {
        /**
         * Sets the value of the SnapshotARN property for this object.
         *
         * @param snapshotARN
         *        The new value for the SnapshotARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotARN(String snapshotARN);

        /**
         * <p>
         * The strategy used when copying data from the snapshot to the new volume.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CLONE</code> - The new volume references the data in the origin snapshot. Cloning a snapshot is faster
         * than copying data from the snapshot to a new volume and doesn't consume disk throughput. However, the origin
         * snapshot can't be deleted if there is a volume using its copied data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FULL_COPY</code> - Copies all data from the snapshot to the new volume.
         * </p>
         * </li>
         * </ul>
         * 
         * @param copyStrategy
         *        The strategy used when copying data from the snapshot to the new volume. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CLONE</code> - The new volume references the data in the origin snapshot. Cloning a snapshot is
         *        faster than copying data from the snapshot to a new volume and doesn't consume disk throughput.
         *        However, the origin snapshot can't be deleted if there is a volume using its copied data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FULL_COPY</code> - Copies all data from the snapshot to the new volume.
         *        </p>
         *        </li>
         * @see OpenZFSCopyStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenZFSCopyStrategy
         */
        Builder copyStrategy(String copyStrategy);

        /**
         * <p>
         * The strategy used when copying data from the snapshot to the new volume.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CLONE</code> - The new volume references the data in the origin snapshot. Cloning a snapshot is faster
         * than copying data from the snapshot to a new volume and doesn't consume disk throughput. However, the origin
         * snapshot can't be deleted if there is a volume using its copied data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FULL_COPY</code> - Copies all data from the snapshot to the new volume.
         * </p>
         * </li>
         * </ul>
         * 
         * @param copyStrategy
         *        The strategy used when copying data from the snapshot to the new volume. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CLONE</code> - The new volume references the data in the origin snapshot. Cloning a snapshot is
         *        faster than copying data from the snapshot to a new volume and doesn't consume disk throughput.
         *        However, the origin snapshot can't be deleted if there is a volume using its copied data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FULL_COPY</code> - Copies all data from the snapshot to the new volume.
         *        </p>
         *        </li>
         * @see OpenZFSCopyStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenZFSCopyStrategy
         */
        Builder copyStrategy(OpenZFSCopyStrategy copyStrategy);
    }

    static final class BuilderImpl implements Builder {
        private String snapshotARN;

        private String copyStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOpenZFSOriginSnapshotConfiguration model) {
            snapshotARN(model.snapshotARN);
            copyStrategy(model.copyStrategy);
        }

        public final String getSnapshotARN() {
            return snapshotARN;
        }

        public final void setSnapshotARN(String snapshotARN) {
            this.snapshotARN = snapshotARN;
        }

        @Override
        public final Builder snapshotARN(String snapshotARN) {
            this.snapshotARN = snapshotARN;
            return this;
        }

        public final String getCopyStrategy() {
            return copyStrategy;
        }

        public final void setCopyStrategy(String copyStrategy) {
            this.copyStrategy = copyStrategy;
        }

        @Override
        public final Builder copyStrategy(String copyStrategy) {
            this.copyStrategy = copyStrategy;
            return this;
        }

        @Override
        public final Builder copyStrategy(OpenZFSCopyStrategy copyStrategy) {
            this.copyStrategy(copyStrategy == null ? null : copyStrategy.toString());
            return this;
        }

        @Override
        public CreateOpenZFSOriginSnapshotConfiguration build() {
            return new CreateOpenZFSOriginSnapshotConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
