/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the Firewall Manager policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicySummary implements SdkPojo, Serializable, ToCopyableBuilder<PolicySummary.Builder, PolicySummary> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyArn").getter(getter(PolicySummary::policyArn)).setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()).build();

    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyId").getter(getter(PolicySummary::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()).build();

    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyName").getter(getter(PolicySummary::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(PolicySummary::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> SECURITY_SERVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityServiceType").getter(getter(PolicySummary::securityServiceTypeAsString))
            .setter(setter(Builder::securityServiceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityServiceType").build())
            .build();

    private static final SdkField<Boolean> REMEDIATION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RemediationEnabled").getter(getter(PolicySummary::remediationEnabled))
            .setter(setter(Builder::remediationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationEnabled").build())
            .build();

    private static final SdkField<Boolean> DELETE_UNUSED_FM_MANAGED_RESOURCES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteUnusedFMManagedResources")
            .getter(getter(PolicySummary::deleteUnusedFMManagedResources))
            .setter(setter(Builder::deleteUnusedFMManagedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteUnusedFMManagedResources")
                    .build()).build();

    private static final SdkField<String> POLICY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyStatus").getter(getter(PolicySummary::policyStatusAsString)).setter(setter(Builder::policyStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD,
            POLICY_ID_FIELD, POLICY_NAME_FIELD, RESOURCE_TYPE_FIELD, SECURITY_SERVICE_TYPE_FIELD, REMEDIATION_ENABLED_FIELD,
            DELETE_UNUSED_FM_MANAGED_RESOURCES_FIELD, POLICY_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String policyArn;

    private final String policyId;

    private final String policyName;

    private final String resourceType;

    private final String securityServiceType;

    private final Boolean remediationEnabled;

    private final Boolean deleteUnusedFMManagedResources;

    private final String policyStatus;

    private PolicySummary(BuilderImpl builder) {
        this.policyArn = builder.policyArn;
        this.policyId = builder.policyId;
        this.policyName = builder.policyName;
        this.resourceType = builder.resourceType;
        this.securityServiceType = builder.securityServiceType;
        this.remediationEnabled = builder.remediationEnabled;
        this.deleteUnusedFMManagedResources = builder.deleteUnusedFMManagedResources;
        this.policyStatus = builder.policyStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the specified policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the specified policy.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The ID of the specified policy.
     * </p>
     * 
     * @return The ID of the specified policy.
     */
    public final String policyId() {
        return policyId;
    }

    /**
     * <p>
     * The name of the specified policy.
     * </p>
     * 
     * @return The name of the specified policy.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The type of resource protected by or in scope of the policy. This is in the format shown in the <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon
     * Web Services Resource Types Reference</a>. For WAF and Shield Advanced, examples include
     * <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code> and <code>AWS::CloudFront::Distribution</code>. For a
     * security group common policy, valid values are <code>AWS::EC2::NetworkInterface</code> and
     * <code>AWS::EC2::Instance</code>. For a security group content audit policy, valid values are
     * <code>AWS::EC2::SecurityGroup</code>, <code>AWS::EC2::NetworkInterface</code>, and
     * <code>AWS::EC2::Instance</code>. For a security group usage audit policy, the value is
     * <code>AWS::EC2::SecurityGroup</code>. For an Network Firewall policy or DNS Firewall policy, the value is
     * <code>AWS::EC2::VPC</code>.
     * </p>
     * 
     * @return The type of resource protected by or in scope of the policy. This is in the format shown in the <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
     *         >Amazon Web Services Resource Types Reference</a>. For WAF and Shield Advanced, examples include
     *         <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code> and <code>AWS::CloudFront::Distribution</code>.
     *         For a security group common policy, valid values are <code>AWS::EC2::NetworkInterface</code> and
     *         <code>AWS::EC2::Instance</code>. For a security group content audit policy, valid values are
     *         <code>AWS::EC2::SecurityGroup</code>, <code>AWS::EC2::NetworkInterface</code>, and
     *         <code>AWS::EC2::Instance</code>. For a security group usage audit policy, the value is
     *         <code>AWS::EC2::SecurityGroup</code>. For an Network Firewall policy or DNS Firewall policy, the value is
     *         <code>AWS::EC2::VPC</code>.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The service that the policy is using to protect the resources. This specifies the type of policy that is created,
     * either an WAF policy, a Shield Advanced policy, or a security group policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #securityServiceType} will return {@link SecurityServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #securityServiceTypeAsString}.
     * </p>
     * 
     * @return The service that the policy is using to protect the resources. This specifies the type of policy that is
     *         created, either an WAF policy, a Shield Advanced policy, or a security group policy.
     * @see SecurityServiceType
     */
    public final SecurityServiceType securityServiceType() {
        return SecurityServiceType.fromValue(securityServiceType);
    }

    /**
     * <p>
     * The service that the policy is using to protect the resources. This specifies the type of policy that is created,
     * either an WAF policy, a Shield Advanced policy, or a security group policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #securityServiceType} will return {@link SecurityServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #securityServiceTypeAsString}.
     * </p>
     * 
     * @return The service that the policy is using to protect the resources. This specifies the type of policy that is
     *         created, either an WAF policy, a Shield Advanced policy, or a security group policy.
     * @see SecurityServiceType
     */
    public final String securityServiceTypeAsString() {
        return securityServiceType;
    }

    /**
     * <p>
     * Indicates if the policy should be automatically applied to new resources.
     * </p>
     * 
     * @return Indicates if the policy should be automatically applied to new resources.
     */
    public final Boolean remediationEnabled() {
        return remediationEnabled;
    }

    /**
     * <p>
     * Indicates whether Firewall Manager should automatically remove protections from resources that leave the policy
     * scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy
     * scope. For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected
     * customer resource when the customer resource leaves policy scope.
     * </p>
     * <p>
     * By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources.
     * </p>
     * <p>
     * This option is not available for Shield Advanced or WAF Classic policies.
     * </p>
     * 
     * @return Indicates whether Firewall Manager should automatically remove protections from resources that leave the
     *         policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts
     *         leave policy scope. For example, Firewall Manager will disassociate a Firewall Manager managed web ACL
     *         from a protected customer resource when the customer resource leaves policy scope. </p>
     *         <p>
     *         By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources.
     *         </p>
     *         <p>
     *         This option is not available for Shield Advanced or WAF Classic policies.
     */
    public final Boolean deleteUnusedFMManagedResources() {
        return deleteUnusedFMManagedResources;
    }

    /**
     * <p>
     * Indicates whether the policy is in or out of an admin's policy or Region scope.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The administrator can manage and delete the policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OUT_OF_ADMIN_SCOPE</code> - The administrator can view the policy, but they can't edit or delete the
     * policy. Existing policy protections stay in place. Any new resources that come into scope of the policy won't be
     * protected.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyStatus} will
     * return {@link CustomerPolicyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyStatusAsString}.
     * </p>
     * 
     * @return Indicates whether the policy is in or out of an admin's policy or Region scope.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The administrator can manage and delete the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OUT_OF_ADMIN_SCOPE</code> - The administrator can view the policy, but they can't edit or delete
     *         the policy. Existing policy protections stay in place. Any new resources that come into scope of the
     *         policy won't be protected.
     *         </p>
     *         </li>
     * @see CustomerPolicyStatus
     */
    public final CustomerPolicyStatus policyStatus() {
        return CustomerPolicyStatus.fromValue(policyStatus);
    }

    /**
     * <p>
     * Indicates whether the policy is in or out of an admin's policy or Region scope.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The administrator can manage and delete the policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OUT_OF_ADMIN_SCOPE</code> - The administrator can view the policy, but they can't edit or delete the
     * policy. Existing policy protections stay in place. Any new resources that come into scope of the policy won't be
     * protected.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyStatus} will
     * return {@link CustomerPolicyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyStatusAsString}.
     * </p>
     * 
     * @return Indicates whether the policy is in or out of an admin's policy or Region scope.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The administrator can manage and delete the policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OUT_OF_ADMIN_SCOPE</code> - The administrator can view the policy, but they can't edit or delete
     *         the policy. Existing policy protections stay in place. Any new resources that come into scope of the
     *         policy won't be protected.
     *         </p>
     *         </li>
     * @see CustomerPolicyStatus
     */
    public final String policyStatusAsString() {
        return policyStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(securityServiceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(remediationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(deleteUnusedFMManagedResources());
        hashCode = 31 * hashCode + Objects.hashCode(policyStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicySummary)) {
            return false;
        }
        PolicySummary other = (PolicySummary) obj;
        return Objects.equals(policyArn(), other.policyArn()) && Objects.equals(policyId(), other.policyId())
                && Objects.equals(policyName(), other.policyName()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(securityServiceTypeAsString(), other.securityServiceTypeAsString())
                && Objects.equals(remediationEnabled(), other.remediationEnabled())
                && Objects.equals(deleteUnusedFMManagedResources(), other.deleteUnusedFMManagedResources())
                && Objects.equals(policyStatusAsString(), other.policyStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicySummary").add("PolicyArn", policyArn()).add("PolicyId", policyId())
                .add("PolicyName", policyName()).add("ResourceType", resourceType())
                .add("SecurityServiceType", securityServiceTypeAsString()).add("RemediationEnabled", remediationEnabled())
                .add("DeleteUnusedFMManagedResources", deleteUnusedFMManagedResources())
                .add("PolicyStatus", policyStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "PolicyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "SecurityServiceType":
            return Optional.ofNullable(clazz.cast(securityServiceTypeAsString()));
        case "RemediationEnabled":
            return Optional.ofNullable(clazz.cast(remediationEnabled()));
        case "DeleteUnusedFMManagedResources":
            return Optional.ofNullable(clazz.cast(deleteUnusedFMManagedResources()));
        case "PolicyStatus":
            return Optional.ofNullable(clazz.cast(policyStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicySummary, T> g) {
        return obj -> g.apply((PolicySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicySummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the specified policy.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the specified policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The ID of the specified policy.
         * </p>
         * 
         * @param policyId
         *        The ID of the specified policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * The name of the specified policy.
         * </p>
         * 
         * @param policyName
         *        The name of the specified policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The type of resource protected by or in scope of the policy. This is in the format shown in the <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         * >Amazon Web Services Resource Types Reference</a>. For WAF and Shield Advanced, examples include
         * <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code> and <code>AWS::CloudFront::Distribution</code>. For a
         * security group common policy, valid values are <code>AWS::EC2::NetworkInterface</code> and
         * <code>AWS::EC2::Instance</code>. For a security group content audit policy, valid values are
         * <code>AWS::EC2::SecurityGroup</code>, <code>AWS::EC2::NetworkInterface</code>, and
         * <code>AWS::EC2::Instance</code>. For a security group usage audit policy, the value is
         * <code>AWS::EC2::SecurityGroup</code>. For an Network Firewall policy or DNS Firewall policy, the value is
         * <code>AWS::EC2::VPC</code>.
         * </p>
         * 
         * @param resourceType
         *        The type of resource protected by or in scope of the policy. This is in the format shown in the <a
         *        href
         *        ="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         *        >Amazon Web Services Resource Types Reference</a>. For WAF and Shield Advanced, examples include
         *        <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code> and <code>AWS::CloudFront::Distribution</code>.
         *        For a security group common policy, valid values are <code>AWS::EC2::NetworkInterface</code> and
         *        <code>AWS::EC2::Instance</code>. For a security group content audit policy, valid values are
         *        <code>AWS::EC2::SecurityGroup</code>, <code>AWS::EC2::NetworkInterface</code>, and
         *        <code>AWS::EC2::Instance</code>. For a security group usage audit policy, the value is
         *        <code>AWS::EC2::SecurityGroup</code>. For an Network Firewall policy or DNS Firewall policy, the value
         *        is <code>AWS::EC2::VPC</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The service that the policy is using to protect the resources. This specifies the type of policy that is
         * created, either an WAF policy, a Shield Advanced policy, or a security group policy.
         * </p>
         * 
         * @param securityServiceType
         *        The service that the policy is using to protect the resources. This specifies the type of policy that
         *        is created, either an WAF policy, a Shield Advanced policy, or a security group policy.
         * @see SecurityServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityServiceType
         */
        Builder securityServiceType(String securityServiceType);

        /**
         * <p>
         * The service that the policy is using to protect the resources. This specifies the type of policy that is
         * created, either an WAF policy, a Shield Advanced policy, or a security group policy.
         * </p>
         * 
         * @param securityServiceType
         *        The service that the policy is using to protect the resources. This specifies the type of policy that
         *        is created, either an WAF policy, a Shield Advanced policy, or a security group policy.
         * @see SecurityServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityServiceType
         */
        Builder securityServiceType(SecurityServiceType securityServiceType);

        /**
         * <p>
         * Indicates if the policy should be automatically applied to new resources.
         * </p>
         * 
         * @param remediationEnabled
         *        Indicates if the policy should be automatically applied to new resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationEnabled(Boolean remediationEnabled);

        /**
         * <p>
         * Indicates whether Firewall Manager should automatically remove protections from resources that leave the
         * policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave
         * policy scope. For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a
         * protected customer resource when the customer resource leaves policy scope.
         * </p>
         * <p>
         * By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources.
         * </p>
         * <p>
         * This option is not available for Shield Advanced or WAF Classic policies.
         * </p>
         * 
         * @param deleteUnusedFMManagedResources
         *        Indicates whether Firewall Manager should automatically remove protections from resources that leave
         *        the policy scope and clean up resources that Firewall Manager is managing for accounts when those
         *        accounts leave policy scope. For example, Firewall Manager will disassociate a Firewall Manager
         *        managed web ACL from a protected customer resource when the customer resource leaves policy scope.
         *        </p>
         *        <p>
         *        By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources.
         *        </p>
         *        <p>
         *        This option is not available for Shield Advanced or WAF Classic policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteUnusedFMManagedResources(Boolean deleteUnusedFMManagedResources);

        /**
         * <p>
         * Indicates whether the policy is in or out of an admin's policy or Region scope.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The administrator can manage and delete the policy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OUT_OF_ADMIN_SCOPE</code> - The administrator can view the policy, but they can't edit or delete the
         * policy. Existing policy protections stay in place. Any new resources that come into scope of the policy won't
         * be protected.
         * </p>
         * </li>
         * </ul>
         * 
         * @param policyStatus
         *        Indicates whether the policy is in or out of an admin's policy or Region scope.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The administrator can manage and delete the policy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OUT_OF_ADMIN_SCOPE</code> - The administrator can view the policy, but they can't edit or delete
         *        the policy. Existing policy protections stay in place. Any new resources that come into scope of the
         *        policy won't be protected.
         *        </p>
         *        </li>
         * @see CustomerPolicyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomerPolicyStatus
         */
        Builder policyStatus(String policyStatus);

        /**
         * <p>
         * Indicates whether the policy is in or out of an admin's policy or Region scope.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The administrator can manage and delete the policy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OUT_OF_ADMIN_SCOPE</code> - The administrator can view the policy, but they can't edit or delete the
         * policy. Existing policy protections stay in place. Any new resources that come into scope of the policy won't
         * be protected.
         * </p>
         * </li>
         * </ul>
         * 
         * @param policyStatus
         *        Indicates whether the policy is in or out of an admin's policy or Region scope.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The administrator can manage and delete the policy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OUT_OF_ADMIN_SCOPE</code> - The administrator can view the policy, but they can't edit or delete
         *        the policy. Existing policy protections stay in place. Any new resources that come into scope of the
         *        policy won't be protected.
         *        </p>
         *        </li>
         * @see CustomerPolicyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomerPolicyStatus
         */
        Builder policyStatus(CustomerPolicyStatus policyStatus);
    }

    static final class BuilderImpl implements Builder {
        private String policyArn;

        private String policyId;

        private String policyName;

        private String resourceType;

        private String securityServiceType;

        private Boolean remediationEnabled;

        private Boolean deleteUnusedFMManagedResources;

        private String policyStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicySummary model) {
            policyArn(model.policyArn);
            policyId(model.policyId);
            policyName(model.policyName);
            resourceType(model.resourceType);
            securityServiceType(model.securityServiceType);
            remediationEnabled(model.remediationEnabled);
            deleteUnusedFMManagedResources(model.deleteUnusedFMManagedResources);
            policyStatus(model.policyStatus);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getPolicyId() {
            return policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getSecurityServiceType() {
            return securityServiceType;
        }

        public final void setSecurityServiceType(String securityServiceType) {
            this.securityServiceType = securityServiceType;
        }

        @Override
        public final Builder securityServiceType(String securityServiceType) {
            this.securityServiceType = securityServiceType;
            return this;
        }

        @Override
        public final Builder securityServiceType(SecurityServiceType securityServiceType) {
            this.securityServiceType(securityServiceType == null ? null : securityServiceType.toString());
            return this;
        }

        public final Boolean getRemediationEnabled() {
            return remediationEnabled;
        }

        public final void setRemediationEnabled(Boolean remediationEnabled) {
            this.remediationEnabled = remediationEnabled;
        }

        @Override
        public final Builder remediationEnabled(Boolean remediationEnabled) {
            this.remediationEnabled = remediationEnabled;
            return this;
        }

        public final Boolean getDeleteUnusedFMManagedResources() {
            return deleteUnusedFMManagedResources;
        }

        public final void setDeleteUnusedFMManagedResources(Boolean deleteUnusedFMManagedResources) {
            this.deleteUnusedFMManagedResources = deleteUnusedFMManagedResources;
        }

        @Override
        public final Builder deleteUnusedFMManagedResources(Boolean deleteUnusedFMManagedResources) {
            this.deleteUnusedFMManagedResources = deleteUnusedFMManagedResources;
            return this;
        }

        public final String getPolicyStatus() {
            return policyStatus;
        }

        public final void setPolicyStatus(String policyStatus) {
            this.policyStatus = policyStatus;
        }

        @Override
        public final Builder policyStatus(String policyStatus) {
            this.policyStatus = policyStatus;
            return this;
        }

        @Override
        public final Builder policyStatus(CustomerPolicyStatus policyStatus) {
            this.policyStatus(policyStatus == null ? null : policyStatus.toString());
            return this;
        }

        @Override
        public PolicySummary build() {
            return new PolicySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
