/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeLoadBalancers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLoadBalancersRequest extends ElasticLoadBalancingRequest implements
        ToCopyableBuilder<DescribeLoadBalancersRequest.Builder, DescribeLoadBalancersRequest> {
    private static final SdkField<List<String>> LOAD_BALANCER_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LoadBalancerNames")
            .getter(getter(DescribeLoadBalancersRequest::loadBalancerNames))
            .setter(setter(Builder::loadBalancerNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeLoadBalancersRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(DescribeLoadBalancersRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAMES_FIELD,
            MARKER_FIELD, PAGE_SIZE_FIELD));

    private final List<String> loadBalancerNames;

    private final String marker;

    private final Integer pageSize;

    private DescribeLoadBalancersRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerNames = builder.loadBalancerNames;
        this.marker = builder.marker;
        this.pageSize = builder.pageSize;
    }

    /**
     * For responses, this returns true if the service returned a value for the LoadBalancerNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLoadBalancerNames() {
        return loadBalancerNames != null && !(loadBalancerNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the load balancers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoadBalancerNames} method.
     * </p>
     * 
     * @return The names of the load balancers.
     */
    public final List<String> loadBalancerNames() {
        return loadBalancerNames;
    }

    /**
     * <p>
     * The marker for the next set of results. (You received this marker from a previous call.)
     * </p>
     * 
     * @return The marker for the next set of results. (You received this marker from a previous call.)
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of results to return with this call (a number from 1 to 400). The default is 400.
     * </p>
     * 
     * @return The maximum number of results to return with this call (a number from 1 to 400). The default is 400.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLoadBalancerNames() ? loadBalancerNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancersRequest)) {
            return false;
        }
        DescribeLoadBalancersRequest other = (DescribeLoadBalancersRequest) obj;
        return hasLoadBalancerNames() == other.hasLoadBalancerNames()
                && Objects.equals(loadBalancerNames(), other.loadBalancerNames()) && Objects.equals(marker(), other.marker())
                && Objects.equals(pageSize(), other.pageSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLoadBalancersRequest")
                .add("LoadBalancerNames", hasLoadBalancerNames() ? loadBalancerNames() : null).add("Marker", marker())
                .add("PageSize", pageSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerNames":
            return Optional.ofNullable(clazz.cast(loadBalancerNames()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLoadBalancersRequest, T> g) {
        return obj -> g.apply((DescribeLoadBalancersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLoadBalancersRequest> {
        /**
         * <p>
         * The names of the load balancers.
         * </p>
         * 
         * @param loadBalancerNames
         *        The names of the load balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerNames(Collection<String> loadBalancerNames);

        /**
         * <p>
         * The names of the load balancers.
         * </p>
         * 
         * @param loadBalancerNames
         *        The names of the load balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerNames(String... loadBalancerNames);

        /**
         * <p>
         * The marker for the next set of results. (You received this marker from a previous call.)
         * </p>
         * 
         * @param marker
         *        The marker for the next set of results. (You received this marker from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of results to return with this call (a number from 1 to 400). The default is 400.
         * </p>
         * 
         * @param pageSize
         *        The maximum number of results to return with this call (a number from 1 to 400). The default is 400.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingRequest.BuilderImpl implements Builder {
        private List<String> loadBalancerNames = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancersRequest model) {
            super(model);
            loadBalancerNames(model.loadBalancerNames);
            marker(model.marker);
            pageSize(model.pageSize);
        }

        public final Collection<String> getLoadBalancerNames() {
            if (loadBalancerNames instanceof SdkAutoConstructList) {
                return null;
            }
            return loadBalancerNames;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
        }

        @Override
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerNames(String... loadBalancerNames) {
            loadBalancerNames(Arrays.asList(loadBalancerNames));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLoadBalancersRequest build() {
            return new DescribeLoadBalancersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
