/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resource lifecycle configuration for an application. Defines lifecycle settings for resources that belong to the
 * application, and the service role that AWS Elastic Beanstalk assumes in order to apply lifecycle settings. The
 * version lifecycle configuration defines lifecycle settings for application versions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationResourceLifecycleConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationResourceLifecycleConfig.Builder, ApplicationResourceLifecycleConfig> {
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceRole").getter(getter(ApplicationResourceLifecycleConfig::serviceRole))
            .setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()).build();

    private static final SdkField<ApplicationVersionLifecycleConfig> VERSION_LIFECYCLE_CONFIG_FIELD = SdkField
            .<ApplicationVersionLifecycleConfig> builder(MarshallingType.SDK_POJO).memberName("VersionLifecycleConfig")
            .getter(getter(ApplicationResourceLifecycleConfig::versionLifecycleConfig))
            .setter(setter(Builder::versionLifecycleConfig)).constructor(ApplicationVersionLifecycleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLifecycleConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ROLE_FIELD,
            VERSION_LIFECYCLE_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceRole;

    private final ApplicationVersionLifecycleConfig versionLifecycleConfig;

    private ApplicationResourceLifecycleConfig(BuilderImpl builder) {
        this.serviceRole = builder.serviceRole;
        this.versionLifecycleConfig = builder.versionLifecycleConfig;
    }

    /**
     * <p>
     * The ARN of an IAM service role that Elastic Beanstalk has permission to assume.
     * </p>
     * <p>
     * The <code>ServiceRole</code> property is required the first time that you provide a
     * <code>VersionLifecycleConfig</code> for the application in one of the supporting calls (
     * <code>CreateApplication</code> or <code>UpdateApplicationResourceLifecycle</code>). After you provide it once, in
     * either one of the calls, Elastic Beanstalk persists the Service Role with the application, and you don't need to
     * specify it again in subsequent <code>UpdateApplicationResourceLifecycle</code> calls. You can, however, specify
     * it in subsequent calls to change the Service Role to another value.
     * </p>
     * 
     * @return The ARN of an IAM service role that Elastic Beanstalk has permission to assume.</p>
     *         <p>
     *         The <code>ServiceRole</code> property is required the first time that you provide a
     *         <code>VersionLifecycleConfig</code> for the application in one of the supporting calls (
     *         <code>CreateApplication</code> or <code>UpdateApplicationResourceLifecycle</code>). After you provide it
     *         once, in either one of the calls, Elastic Beanstalk persists the Service Role with the application, and
     *         you don't need to specify it again in subsequent <code>UpdateApplicationResourceLifecycle</code> calls.
     *         You can, however, specify it in subsequent calls to change the Service Role to another value.
     */
    public final String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * Defines lifecycle settings for application versions.
     * </p>
     * 
     * @return Defines lifecycle settings for application versions.
     */
    public final ApplicationVersionLifecycleConfig versionLifecycleConfig() {
        return versionLifecycleConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(versionLifecycleConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationResourceLifecycleConfig)) {
            return false;
        }
        ApplicationResourceLifecycleConfig other = (ApplicationResourceLifecycleConfig) obj;
        return Objects.equals(serviceRole(), other.serviceRole())
                && Objects.equals(versionLifecycleConfig(), other.versionLifecycleConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationResourceLifecycleConfig").add("ServiceRole", serviceRole())
                .add("VersionLifecycleConfig", versionLifecycleConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "VersionLifecycleConfig":
            return Optional.ofNullable(clazz.cast(versionLifecycleConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationResourceLifecycleConfig, T> g) {
        return obj -> g.apply((ApplicationResourceLifecycleConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationResourceLifecycleConfig> {
        /**
         * <p>
         * The ARN of an IAM service role that Elastic Beanstalk has permission to assume.
         * </p>
         * <p>
         * The <code>ServiceRole</code> property is required the first time that you provide a
         * <code>VersionLifecycleConfig</code> for the application in one of the supporting calls (
         * <code>CreateApplication</code> or <code>UpdateApplicationResourceLifecycle</code>). After you provide it
         * once, in either one of the calls, Elastic Beanstalk persists the Service Role with the application, and you
         * don't need to specify it again in subsequent <code>UpdateApplicationResourceLifecycle</code> calls. You can,
         * however, specify it in subsequent calls to change the Service Role to another value.
         * </p>
         * 
         * @param serviceRole
         *        The ARN of an IAM service role that Elastic Beanstalk has permission to assume.</p>
         *        <p>
         *        The <code>ServiceRole</code> property is required the first time that you provide a
         *        <code>VersionLifecycleConfig</code> for the application in one of the supporting calls (
         *        <code>CreateApplication</code> or <code>UpdateApplicationResourceLifecycle</code>). After you provide
         *        it once, in either one of the calls, Elastic Beanstalk persists the Service Role with the application,
         *        and you don't need to specify it again in subsequent <code>UpdateApplicationResourceLifecycle</code>
         *        calls. You can, however, specify it in subsequent calls to change the Service Role to another value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * Defines lifecycle settings for application versions.
         * </p>
         * 
         * @param versionLifecycleConfig
         *        Defines lifecycle settings for application versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionLifecycleConfig(ApplicationVersionLifecycleConfig versionLifecycleConfig);

        /**
         * <p>
         * Defines lifecycle settings for application versions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ApplicationVersionLifecycleConfig.Builder} avoiding the need to create one manually via
         * {@link ApplicationVersionLifecycleConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationVersionLifecycleConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #versionLifecycleConfig(ApplicationVersionLifecycleConfig)}.
         * 
         * @param versionLifecycleConfig
         *        a consumer that will call methods on {@link ApplicationVersionLifecycleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #versionLifecycleConfig(ApplicationVersionLifecycleConfig)
         */
        default Builder versionLifecycleConfig(Consumer<ApplicationVersionLifecycleConfig.Builder> versionLifecycleConfig) {
            return versionLifecycleConfig(ApplicationVersionLifecycleConfig.builder().applyMutation(versionLifecycleConfig)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String serviceRole;

        private ApplicationVersionLifecycleConfig versionLifecycleConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationResourceLifecycleConfig model) {
            serviceRole(model.serviceRole);
            versionLifecycleConfig(model.versionLifecycleConfig);
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final ApplicationVersionLifecycleConfig.Builder getVersionLifecycleConfig() {
            return versionLifecycleConfig != null ? versionLifecycleConfig.toBuilder() : null;
        }

        public final void setVersionLifecycleConfig(ApplicationVersionLifecycleConfig.BuilderImpl versionLifecycleConfig) {
            this.versionLifecycleConfig = versionLifecycleConfig != null ? versionLifecycleConfig.build() : null;
        }

        @Override
        public final Builder versionLifecycleConfig(ApplicationVersionLifecycleConfig versionLifecycleConfig) {
            this.versionLifecycleConfig = versionLifecycleConfig;
            return this;
        }

        @Override
        public ApplicationResourceLifecycleConfig build() {
            return new ApplicationResourceLifecycleConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
