/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUserGroupsResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<DescribeUserGroupsResponse.Builder, DescribeUserGroupsResponse> {
    private static final SdkField<List<UserGroup>> USER_GROUPS_FIELD = SdkField
            .<List<UserGroup>> builder(MarshallingType.LIST)
            .memberName("UserGroups")
            .getter(getter(DescribeUserGroupsResponse::userGroups))
            .setter(setter(Builder::userGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeUserGroupsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_GROUPS_FIELD,
            MARKER_FIELD));

    private final List<UserGroup> userGroups;

    private final String marker;

    private DescribeUserGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.userGroups = builder.userGroups;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserGroups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUserGroups() {
        return userGroups != null && !(userGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of user groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserGroups} method.
     * </p>
     * 
     * @return Returns a list of user groups.
     */
    public final List<UserGroup> userGroups() {
        return userGroups;
    }

    /**
     * <p>
     * An optional marker returned from a prior request. Use this marker for pagination of results from this operation.
     * If this parameter is specified, the response includes only records beyond the marker, up to the value specified
     * by MaxRecords. &gt;
     * </p>
     * 
     * @return An optional marker returned from a prior request. Use this marker for pagination of results from this
     *         operation. If this parameter is specified, the response includes only records beyond the marker, up to
     *         the value specified by MaxRecords. &gt;
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUserGroups() ? userGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserGroupsResponse)) {
            return false;
        }
        DescribeUserGroupsResponse other = (DescribeUserGroupsResponse) obj;
        return hasUserGroups() == other.hasUserGroups() && Objects.equals(userGroups(), other.userGroups())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeUserGroupsResponse").add("UserGroups", hasUserGroups() ? userGroups() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserGroups":
            return Optional.ofNullable(clazz.cast(userGroups()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserGroupsResponse, T> g) {
        return obj -> g.apply((DescribeUserGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeUserGroupsResponse> {
        /**
         * <p>
         * Returns a list of user groups.
         * </p>
         * 
         * @param userGroups
         *        Returns a list of user groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroups(Collection<UserGroup> userGroups);

        /**
         * <p>
         * Returns a list of user groups.
         * </p>
         * 
         * @param userGroups
         *        Returns a list of user groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroups(UserGroup... userGroups);

        /**
         * <p>
         * Returns a list of user groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.UserGroup.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.elasticache.model.UserGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.UserGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #userGroups(List<UserGroup>)}.
         * 
         * @param userGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.UserGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userGroups(java.util.Collection<UserGroup>)
         */
        Builder userGroups(Consumer<UserGroup.Builder>... userGroups);

        /**
         * <p>
         * An optional marker returned from a prior request. Use this marker for pagination of results from this
         * operation. If this parameter is specified, the response includes only records beyond the marker, up to the
         * value specified by MaxRecords. &gt;
         * </p>
         * 
         * @param marker
         *        An optional marker returned from a prior request. Use this marker for pagination of results from this
         *        operation. If this parameter is specified, the response includes only records beyond the marker, up to
         *        the value specified by MaxRecords. &gt;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private List<UserGroup> userGroups = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserGroupsResponse model) {
            super(model);
            userGroups(model.userGroups);
            marker(model.marker);
        }

        public final List<UserGroup.Builder> getUserGroups() {
            List<UserGroup.Builder> result = UserGroupListCopier.copyToBuilder(this.userGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserGroups(Collection<UserGroup.BuilderImpl> userGroups) {
            this.userGroups = UserGroupListCopier.copyFromBuilder(userGroups);
        }

        @Override
        public final Builder userGroups(Collection<UserGroup> userGroups) {
            this.userGroups = UserGroupListCopier.copy(userGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroups(UserGroup... userGroups) {
            userGroups(Arrays.asList(userGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroups(Consumer<UserGroup.Builder>... userGroups) {
            userGroups(Stream.of(userGroups).map(c -> UserGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeUserGroupsResponse build() {
            return new DescribeUserGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
