/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVerifiedAccessEndpointPolicyResponse extends Ec2Response implements
        ToCopyableBuilder<ModifyVerifiedAccessEndpointPolicyResponse.Builder, ModifyVerifiedAccessEndpointPolicyResponse> {
    private static final SdkField<Boolean> POLICY_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PolicyEnabled")
            .getter(getter(ModifyVerifiedAccessEndpointPolicyResponse::policyEnabled))
            .setter(setter(Builder::policyEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyEnabled")
                    .unmarshallLocationName("policyEnabled").build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PolicyDocument")
            .getter(getter(ModifyVerifiedAccessEndpointPolicyResponse::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument")
                    .unmarshallLocationName("policyDocument").build()).build();

    private static final SdkField<VerifiedAccessSseSpecificationResponse> SSE_SPECIFICATION_FIELD = SdkField
            .<VerifiedAccessSseSpecificationResponse> builder(MarshallingType.SDK_POJO)
            .memberName("SseSpecification")
            .getter(getter(ModifyVerifiedAccessEndpointPolicyResponse::sseSpecification))
            .setter(setter(Builder::sseSpecification))
            .constructor(VerifiedAccessSseSpecificationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseSpecification")
                    .unmarshallLocationName("sseSpecification").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ENABLED_FIELD,
            POLICY_DOCUMENT_FIELD, SSE_SPECIFICATION_FIELD));

    private final Boolean policyEnabled;

    private final String policyDocument;

    private final VerifiedAccessSseSpecificationResponse sseSpecification;

    private ModifyVerifiedAccessEndpointPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyEnabled = builder.policyEnabled;
        this.policyDocument = builder.policyDocument;
        this.sseSpecification = builder.sseSpecification;
    }

    /**
     * <p>
     * The status of the Verified Access policy.
     * </p>
     * 
     * @return The status of the Verified Access policy.
     */
    public final Boolean policyEnabled() {
        return policyEnabled;
    }

    /**
     * <p>
     * The Verified Access policy document.
     * </p>
     * 
     * @return The Verified Access policy document.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * Describes the options in use for server side encryption.
     * </p>
     * 
     * @return Describes the options in use for server side encryption.
     */
    public final VerifiedAccessSseSpecificationResponse sseSpecification() {
        return sseSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(sseSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVerifiedAccessEndpointPolicyResponse)) {
            return false;
        }
        ModifyVerifiedAccessEndpointPolicyResponse other = (ModifyVerifiedAccessEndpointPolicyResponse) obj;
        return Objects.equals(policyEnabled(), other.policyEnabled()) && Objects.equals(policyDocument(), other.policyDocument())
                && Objects.equals(sseSpecification(), other.sseSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVerifiedAccessEndpointPolicyResponse").add("PolicyEnabled", policyEnabled())
                .add("PolicyDocument", policyDocument()).add("SseSpecification", sseSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyEnabled":
            return Optional.ofNullable(clazz.cast(policyEnabled()));
        case "PolicyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        case "SseSpecification":
            return Optional.ofNullable(clazz.cast(sseSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVerifiedAccessEndpointPolicyResponse, T> g) {
        return obj -> g.apply((ModifyVerifiedAccessEndpointPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyVerifiedAccessEndpointPolicyResponse> {
        /**
         * <p>
         * The status of the Verified Access policy.
         * </p>
         * 
         * @param policyEnabled
         *        The status of the Verified Access policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyEnabled(Boolean policyEnabled);

        /**
         * <p>
         * The Verified Access policy document.
         * </p>
         * 
         * @param policyDocument
         *        The Verified Access policy document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * Describes the options in use for server side encryption.
         * </p>
         * 
         * @param sseSpecification
         *        Describes the options in use for server side encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseSpecification(VerifiedAccessSseSpecificationResponse sseSpecification);

        /**
         * <p>
         * Describes the options in use for server side encryption.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VerifiedAccessSseSpecificationResponse.Builder} avoiding the need to create one manually via
         * {@link VerifiedAccessSseSpecificationResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VerifiedAccessSseSpecificationResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #sseSpecification(VerifiedAccessSseSpecificationResponse)}.
         * 
         * @param sseSpecification
         *        a consumer that will call methods on {@link VerifiedAccessSseSpecificationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseSpecification(VerifiedAccessSseSpecificationResponse)
         */
        default Builder sseSpecification(Consumer<VerifiedAccessSseSpecificationResponse.Builder> sseSpecification) {
            return sseSpecification(VerifiedAccessSseSpecificationResponse.builder().applyMutation(sseSpecification).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private Boolean policyEnabled;

        private String policyDocument;

        private VerifiedAccessSseSpecificationResponse sseSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVerifiedAccessEndpointPolicyResponse model) {
            super(model);
            policyEnabled(model.policyEnabled);
            policyDocument(model.policyDocument);
            sseSpecification(model.sseSpecification);
        }

        public final Boolean getPolicyEnabled() {
            return policyEnabled;
        }

        public final void setPolicyEnabled(Boolean policyEnabled) {
            this.policyEnabled = policyEnabled;
        }

        @Override
        public final Builder policyEnabled(Boolean policyEnabled) {
            this.policyEnabled = policyEnabled;
            return this;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final VerifiedAccessSseSpecificationResponse.Builder getSseSpecification() {
            return sseSpecification != null ? sseSpecification.toBuilder() : null;
        }

        public final void setSseSpecification(VerifiedAccessSseSpecificationResponse.BuilderImpl sseSpecification) {
            this.sseSpecification = sseSpecification != null ? sseSpecification.build() : null;
        }

        @Override
        public final Builder sseSpecification(VerifiedAccessSseSpecificationResponse sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        @Override
        public ModifyVerifiedAccessEndpointPolicyResponse build() {
            return new ModifyVerifiedAccessEndpointPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
