/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input to <a>ModifyDBInstance</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbInstanceRequest extends DocDbRequest implements
        ToCopyableBuilder<ModifyDbInstanceRequest.Builder, ModifyDbInstanceRequest> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(ModifyDbInstanceRequest::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceClass").getter(getter(ModifyDbInstanceRequest::dbInstanceClass))
            .setter(setter(Builder::dbInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()).build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ApplyImmediately").getter(getter(ModifyDbInstanceRequest::applyImmediately))
            .setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(ModifyDbInstanceRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(ModifyDbInstanceRequest::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<String> NEW_DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewDBInstanceIdentifier").getter(getter(ModifyDbInstanceRequest::newDBInstanceIdentifier))
            .setter(setter(Builder::newDBInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewDBInstanceIdentifier").build())
            .build();

    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CACertificateIdentifier").getter(getter(ModifyDbInstanceRequest::caCertificateIdentifier))
            .setter(setter(Builder::caCertificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CACertificateIdentifier").build())
            .build();

    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToSnapshot").getter(getter(ModifyDbInstanceRequest::copyTagsToSnapshot))
            .setter(setter(Builder::copyTagsToSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build())
            .build();

    private static final SdkField<Integer> PROMOTION_TIER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PromotionTier").getter(getter(ModifyDbInstanceRequest::promotionTier))
            .setter(setter(Builder::promotionTier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromotionTier").build()).build();

    private static final SdkField<Boolean> ENABLE_PERFORMANCE_INSIGHTS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("EnablePerformanceInsights")
            .getter(getter(ModifyDbInstanceRequest::enablePerformanceInsights))
            .setter(setter(Builder::enablePerformanceInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePerformanceInsights").build())
            .build();

    private static final SdkField<String> PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PerformanceInsightsKMSKeyId")
            .getter(getter(ModifyDbInstanceRequest::performanceInsightsKMSKeyId))
            .setter(setter(Builder::performanceInsightsKMSKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsKMSKeyId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD,
            DB_INSTANCE_CLASS_FIELD, APPLY_IMMEDIATELY_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD,
            AUTO_MINOR_VERSION_UPGRADE_FIELD, NEW_DB_INSTANCE_IDENTIFIER_FIELD, CA_CERTIFICATE_IDENTIFIER_FIELD,
            COPY_TAGS_TO_SNAPSHOT_FIELD, PROMOTION_TIER_FIELD, ENABLE_PERFORMANCE_INSIGHTS_FIELD,
            PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD));

    private final String dbInstanceIdentifier;

    private final String dbInstanceClass;

    private final Boolean applyImmediately;

    private final String preferredMaintenanceWindow;

    private final Boolean autoMinorVersionUpgrade;

    private final String newDBInstanceIdentifier;

    private final String caCertificateIdentifier;

    private final Boolean copyTagsToSnapshot;

    private final Integer promotionTier;

    private final Boolean enablePerformanceInsights;

    private final String performanceInsightsKMSKeyId;

    private ModifyDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.applyImmediately = builder.applyImmediately;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.newDBInstanceIdentifier = builder.newDBInstanceIdentifier;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.promotionTier = builder.promotionTier;
        this.enablePerformanceInsights = builder.enablePerformanceInsights;
        this.performanceInsightsKMSKeyId = builder.performanceInsightsKMSKeyId;
    }

    /**
     * <p>
     * The instance identifier. This value is stored as a lowercase string.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing <code>DBInstance</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The instance identifier. This value is stored as a lowercase string.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the identifier of an existing <code>DBInstance</code>.
     *         </p>
     *         </li>
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * The new compute and memory capacity of the instance; for example, <code>db.r5.large</code>. Not all instance
     * classes are available in all Amazon Web Services Regions.
     * </p>
     * <p>
     * If you modify the instance class, an outage occurs during the change. The change is applied during the next
     * maintenance window, unless <code>ApplyImmediately</code> is specified as <code>true</code> for this request.
     * </p>
     * <p>
     * Default: Uses existing setting.
     * </p>
     * 
     * @return The new compute and memory capacity of the instance; for example, <code>db.r5.large</code>. Not all
     *         instance classes are available in all Amazon Web Services Regions. </p>
     *         <p>
     *         If you modify the instance class, an outage occurs during the change. The change is applied during the
     *         next maintenance window, unless <code>ApplyImmediately</code> is specified as <code>true</code> for this
     *         request.
     *         </p>
     *         <p>
     *         Default: Uses existing setting.
     */
    public final String dbInstanceClass() {
        return dbInstanceClass;
    }

    /**
     * <p>
     * Specifies whether the modifications in this request and any pending modifications are asynchronously applied as
     * soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the instance.
     * </p>
     * <p>
     * If this parameter is set to <code>false</code>, changes to the instance are applied during the next maintenance
     * window. Some parameter changes can cause an outage and are applied on the next reboot.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Specifies whether the modifications in this request and any pending modifications are asynchronously
     *         applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the
     *         instance. </p>
     *         <p>
     *         If this parameter is set to <code>false</code>, changes to the instance are applied during the next
     *         maintenance window. Some parameter changes can cause an outage and are applied on the next reboot.
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean applyImmediately() {
        return applyImmediately;
    }

    /**
     * <p>
     * The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage.
     * Changing this parameter doesn't result in an outage except in the following situation, and the change is
     * asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the maintenance
     * window is changed to include the current time, changing this parameter causes a reboot of the instance. If you
     * are moving this window to the current time, there must be at least 30 minutes between the current time and end of
     * the window to ensure that pending changes are applied.
     * </p>
     * <p>
     * Default: Uses existing setting.
     * </p>
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * </p>
     * <p>
     * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
     * </p>
     * <p>
     * Constraints: Must be at least 30 minutes.
     * </p>
     * 
     * @return The weekly time range (in UTC) during which system maintenance can occur, which might result in an
     *         outage. Changing this parameter doesn't result in an outage except in the following situation, and the
     *         change is asynchronously applied as soon as possible. If there are pending actions that cause a reboot,
     *         and the maintenance window is changed to include the current time, changing this parameter causes a
     *         reboot of the instance. If you are moving this window to the current time, there must be at least 30
     *         minutes between the current time and end of the window to ensure that pending changes are applied.</p>
     *         <p>
     *         Default: Uses existing setting.
     *         </p>
     *         <p>
     *         Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     *         </p>
     *         <p>
     *         Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
     *         </p>
     *         <p>
     *         Constraints: Must be at least 30 minutes.
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades
     * regardless of the value set.
     * </p>
     * 
     * @return This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version
     *         upgrades regardless of the value set.
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * The new instance identifier for the instance when renaming an instance. When you change the instance identifier,
     * an instance reboot occurs immediately if you set <code>Apply Immediately</code> to <code>true</code>. It occurs
     * during the next maintenance window if you set <code>Apply Immediately</code> to <code>false</code>. This value is
     * stored as a lowercase string.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>mydbinstance</code>
     * </p>
     * 
     * @return The new instance identifier for the instance when renaming an instance. When you change the instance
     *         identifier, an instance reboot occurs immediately if you set <code>Apply Immediately</code> to
     *         <code>true</code>. It occurs during the next maintenance window if you set <code>Apply Immediately</code>
     *         to <code>false</code>. This value is stored as a lowercase string. </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>mydbinstance</code>
     */
    public final String newDBInstanceIdentifier() {
        return newDBInstanceIdentifier;
    }

    /**
     * <p>
     * Indicates the certificate that needs to be associated with the instance.
     * </p>
     * 
     * @return Indicates the certificate that needs to be associated with the instance.
     */
    public final String caCertificateIdentifier() {
        return caCertificateIdentifier;
    }

    /**
     * <p>
     * A value that indicates whether to copy all tags from the DB instance to snapshots of the DB instance. By default,
     * tags are not copied.
     * </p>
     * 
     * @return A value that indicates whether to copy all tags from the DB instance to snapshots of the DB instance. By
     *         default, tags are not copied.
     */
    public final Boolean copyTagsToSnapshot() {
        return copyTagsToSnapshot;
    }

    /**
     * <p>
     * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after
     * a failure of the existing primary instance.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * <p>
     * Valid values: 0-15
     * </p>
     * 
     * @return A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary
     *         instance after a failure of the existing primary instance.</p>
     *         <p>
     *         Default: 1
     *         </p>
     *         <p>
     *         Valid values: 0-15
     */
    public final Integer promotionTier() {
        return promotionTier;
    }

    /**
     * <p>
     * A value that indicates whether to enable Performance Insights for the DB Instance. For more information, see <a
     * href="https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html">Using Amazon
     * Performance Insights</a>.
     * </p>
     * 
     * @return A value that indicates whether to enable Performance Insights for the DB Instance. For more information,
     *         see <a
     *         href="https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html">Using
     *         Amazon Performance Insights</a>.
     */
    public final Boolean enablePerformanceInsights() {
        return enablePerformanceInsights;
    }

    /**
     * <p>
     * The KMS key identifier for encryption of Performance Insights data.
     * </p>
     * <p>
     * The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * </p>
     * <p>
     * If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon DocumentDB uses your default KMS key.
     * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different
     * default KMS key for each Amazon Web Services region.
     * </p>
     * 
     * @return The KMS key identifier for encryption of Performance Insights data.</p>
     *         <p>
     *         The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     *         </p>
     *         <p>
     *         If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon DocumentDB uses your default
     *         KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services
     *         account has a different default KMS key for each Amazon Web Services region.
     */
    public final String performanceInsightsKMSKeyId() {
        return performanceInsightsKMSKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(newDBInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(promotionTier());
        hashCode = 31 * hashCode + Objects.hashCode(enablePerformanceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsKMSKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbInstanceRequest)) {
            return false;
        }
        ModifyDbInstanceRequest other = (ModifyDbInstanceRequest) obj;
        return Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(dbInstanceClass(), other.dbInstanceClass())
                && Objects.equals(applyImmediately(), other.applyImmediately())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(newDBInstanceIdentifier(), other.newDBInstanceIdentifier())
                && Objects.equals(caCertificateIdentifier(), other.caCertificateIdentifier())
                && Objects.equals(copyTagsToSnapshot(), other.copyTagsToSnapshot())
                && Objects.equals(promotionTier(), other.promotionTier())
                && Objects.equals(enablePerformanceInsights(), other.enablePerformanceInsights())
                && Objects.equals(performanceInsightsKMSKeyId(), other.performanceInsightsKMSKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyDbInstanceRequest").add("DBInstanceIdentifier", dbInstanceIdentifier())
                .add("DBInstanceClass", dbInstanceClass()).add("ApplyImmediately", applyImmediately())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("NewDBInstanceIdentifier", newDBInstanceIdentifier())
                .add("CACertificateIdentifier", caCertificateIdentifier()).add("CopyTagsToSnapshot", copyTagsToSnapshot())
                .add("PromotionTier", promotionTier()).add("EnablePerformanceInsights", enablePerformanceInsights())
                .add("PerformanceInsightsKMSKeyId", performanceInsightsKMSKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "DBInstanceClass":
            return Optional.ofNullable(clazz.cast(dbInstanceClass()));
        case "ApplyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "NewDBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(newDBInstanceIdentifier()));
        case "CACertificateIdentifier":
            return Optional.ofNullable(clazz.cast(caCertificateIdentifier()));
        case "CopyTagsToSnapshot":
            return Optional.ofNullable(clazz.cast(copyTagsToSnapshot()));
        case "PromotionTier":
            return Optional.ofNullable(clazz.cast(promotionTier()));
        case "EnablePerformanceInsights":
            return Optional.ofNullable(clazz.cast(enablePerformanceInsights()));
        case "PerformanceInsightsKMSKeyId":
            return Optional.ofNullable(clazz.cast(performanceInsightsKMSKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbInstanceRequest, T> g) {
        return obj -> g.apply((ModifyDbInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DocDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDbInstanceRequest> {
        /**
         * <p>
         * The instance identifier. This value is stored as a lowercase string.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the identifier of an existing <code>DBInstance</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbInstanceIdentifier
         *        The instance identifier. This value is stored as a lowercase string.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the identifier of an existing <code>DBInstance</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * The new compute and memory capacity of the instance; for example, <code>db.r5.large</code>. Not all instance
         * classes are available in all Amazon Web Services Regions.
         * </p>
         * <p>
         * If you modify the instance class, an outage occurs during the change. The change is applied during the next
         * maintenance window, unless <code>ApplyImmediately</code> is specified as <code>true</code> for this request.
         * </p>
         * <p>
         * Default: Uses existing setting.
         * </p>
         * 
         * @param dbInstanceClass
         *        The new compute and memory capacity of the instance; for example, <code>db.r5.large</code>. Not all
         *        instance classes are available in all Amazon Web Services Regions. </p>
         *        <p>
         *        If you modify the instance class, an outage occurs during the change. The change is applied during the
         *        next maintenance window, unless <code>ApplyImmediately</code> is specified as <code>true</code> for
         *        this request.
         *        </p>
         *        <p>
         *        Default: Uses existing setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceClass(String dbInstanceClass);

        /**
         * <p>
         * Specifies whether the modifications in this request and any pending modifications are asynchronously applied
         * as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the instance.
         * </p>
         * <p>
         * If this parameter is set to <code>false</code>, changes to the instance are applied during the next
         * maintenance window. Some parameter changes can cause an outage and are applied on the next reboot.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param applyImmediately
         *        Specifies whether the modifications in this request and any pending modifications are asynchronously
         *        applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the
         *        instance. </p>
         *        <p>
         *        If this parameter is set to <code>false</code>, changes to the instance are applied during the next
         *        maintenance window. Some parameter changes can cause an outage and are applied on the next reboot.
         *        </p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        /**
         * <p>
         * The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage.
         * Changing this parameter doesn't result in an outage except in the following situation, and the change is
         * asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the
         * maintenance window is changed to include the current time, changing this parameter causes a reboot of the
         * instance. If you are moving this window to the current time, there must be at least 30 minutes between the
         * current time and end of the window to ensure that pending changes are applied.
         * </p>
         * <p>
         * Default: Uses existing setting.
         * </p>
         * <p>
         * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         * </p>
         * <p>
         * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
         * </p>
         * <p>
         * Constraints: Must be at least 30 minutes.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range (in UTC) during which system maintenance can occur, which might result in an
         *        outage. Changing this parameter doesn't result in an outage except in the following situation, and the
         *        change is asynchronously applied as soon as possible. If there are pending actions that cause a
         *        reboot, and the maintenance window is changed to include the current time, changing this parameter
         *        causes a reboot of the instance. If you are moving this window to the current time, there must be at
         *        least 30 minutes between the current time and end of the window to ensure that pending changes are
         *        applied.</p>
         *        <p>
         *        Default: Uses existing setting.
         *        </p>
         *        <p>
         *        Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         *        </p>
         *        <p>
         *        Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
         *        </p>
         *        <p>
         *        Constraints: Must be at least 30 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades
         * regardless of the value set.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version
         *        upgrades regardless of the value set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * The new instance identifier for the instance when renaming an instance. When you change the instance
         * identifier, an instance reboot occurs immediately if you set <code>Apply Immediately</code> to
         * <code>true</code>. It occurs during the next maintenance window if you set <code>Apply Immediately</code> to
         * <code>false</code>. This value is stored as a lowercase string.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>mydbinstance</code>
         * </p>
         * 
         * @param newDBInstanceIdentifier
         *        The new instance identifier for the instance when renaming an instance. When you change the instance
         *        identifier, an instance reboot occurs immediately if you set <code>Apply Immediately</code> to
         *        <code>true</code>. It occurs during the next maintenance window if you set
         *        <code>Apply Immediately</code> to <code>false</code>. This value is stored as a lowercase string. </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>mydbinstance</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newDBInstanceIdentifier(String newDBInstanceIdentifier);

        /**
         * <p>
         * Indicates the certificate that needs to be associated with the instance.
         * </p>
         * 
         * @param caCertificateIdentifier
         *        Indicates the certificate that needs to be associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateIdentifier(String caCertificateIdentifier);

        /**
         * <p>
         * A value that indicates whether to copy all tags from the DB instance to snapshots of the DB instance. By
         * default, tags are not copied.
         * </p>
         * 
         * @param copyTagsToSnapshot
         *        A value that indicates whether to copy all tags from the DB instance to snapshots of the DB instance.
         *        By default, tags are not copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot);

        /**
         * <p>
         * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance
         * after a failure of the existing primary instance.
         * </p>
         * <p>
         * Default: 1
         * </p>
         * <p>
         * Valid values: 0-15
         * </p>
         * 
         * @param promotionTier
         *        A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary
         *        instance after a failure of the existing primary instance.</p>
         *        <p>
         *        Default: 1
         *        </p>
         *        <p>
         *        Valid values: 0-15
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promotionTier(Integer promotionTier);

        /**
         * <p>
         * A value that indicates whether to enable Performance Insights for the DB Instance. For more information, see
         * <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html">Using Amazon
         * Performance Insights</a>.
         * </p>
         * 
         * @param enablePerformanceInsights
         *        A value that indicates whether to enable Performance Insights for the DB Instance. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html">Using
         *        Amazon Performance Insights</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePerformanceInsights(Boolean enablePerformanceInsights);

        /**
         * <p>
         * The KMS key identifier for encryption of Performance Insights data.
         * </p>
         * <p>
         * The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * </p>
         * <p>
         * If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon DocumentDB uses your default KMS
         * key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
         * different default KMS key for each Amazon Web Services region.
         * </p>
         * 
         * @param performanceInsightsKMSKeyId
         *        The KMS key identifier for encryption of Performance Insights data.</p>
         *        <p>
         *        The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         *        </p>
         *        <p>
         *        If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon DocumentDB uses your
         *        default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web
         *        Services account has a different default KMS key for each Amazon Web Services region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DocDbRequest.BuilderImpl implements Builder {
        private String dbInstanceIdentifier;

        private String dbInstanceClass;

        private Boolean applyImmediately;

        private String preferredMaintenanceWindow;

        private Boolean autoMinorVersionUpgrade;

        private String newDBInstanceIdentifier;

        private String caCertificateIdentifier;

        private Boolean copyTagsToSnapshot;

        private Integer promotionTier;

        private Boolean enablePerformanceInsights;

        private String performanceInsightsKMSKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbInstanceRequest model) {
            super(model);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            dbInstanceClass(model.dbInstanceClass);
            applyImmediately(model.applyImmediately);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            newDBInstanceIdentifier(model.newDBInstanceIdentifier);
            caCertificateIdentifier(model.caCertificateIdentifier);
            copyTagsToSnapshot(model.copyTagsToSnapshot);
            promotionTier(model.promotionTier);
            enablePerformanceInsights(model.enablePerformanceInsights);
            performanceInsightsKMSKeyId(model.performanceInsightsKMSKeyId);
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final String getDbInstanceClass() {
            return dbInstanceClass;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getNewDBInstanceIdentifier() {
            return newDBInstanceIdentifier;
        }

        public final void setNewDBInstanceIdentifier(String newDBInstanceIdentifier) {
            this.newDBInstanceIdentifier = newDBInstanceIdentifier;
        }

        @Override
        public final Builder newDBInstanceIdentifier(String newDBInstanceIdentifier) {
            this.newDBInstanceIdentifier = newDBInstanceIdentifier;
            return this;
        }

        public final String getCaCertificateIdentifier() {
            return caCertificateIdentifier;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return copyTagsToSnapshot;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final Integer getPromotionTier() {
            return promotionTier;
        }

        public final void setPromotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
        }

        @Override
        public final Builder promotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
            return this;
        }

        public final Boolean getEnablePerformanceInsights() {
            return enablePerformanceInsights;
        }

        public final void setEnablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
        }

        @Override
        public final Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        public final String getPerformanceInsightsKMSKeyId() {
            return performanceInsightsKMSKeyId;
        }

        public final void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
        }

        @Override
        public final Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbInstanceRequest build() {
            return new ModifyDbInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
