/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDirectConnectGatewayAssociationRequest extends DirectConnectRequest implements
        ToCopyableBuilder<CreateDirectConnectGatewayAssociationRequest.Builder, CreateDirectConnectGatewayAssociationRequest> {
    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("directConnectGatewayId")
            .getter(getter(CreateDirectConnectGatewayAssociationRequest::directConnectGatewayId))
            .setter(setter(Builder::directConnectGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayId").build())
            .build();

    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayId").getter(getter(CreateDirectConnectGatewayAssociationRequest::gatewayId))
            .setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayId").build()).build();

    private static final SdkField<List<RouteFilterPrefix>> ADD_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD = SdkField
            .<List<RouteFilterPrefix>> builder(MarshallingType.LIST)
            .memberName("addAllowedPrefixesToDirectConnectGateway")
            .getter(getter(CreateDirectConnectGatewayAssociationRequest::addAllowedPrefixesToDirectConnectGateway))
            .setter(setter(Builder::addAllowedPrefixesToDirectConnectGateway))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("addAllowedPrefixesToDirectConnectGateway").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteFilterPrefix> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteFilterPrefix::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VIRTUAL_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualGatewayId").getter(getter(CreateDirectConnectGatewayAssociationRequest::virtualGatewayId))
            .setter(setter(Builder::virtualGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DIRECT_CONNECT_GATEWAY_ID_FIELD, GATEWAY_ID_FIELD, ADD_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD,
            VIRTUAL_GATEWAY_ID_FIELD));

    private final String directConnectGatewayId;

    private final String gatewayId;

    private final List<RouteFilterPrefix> addAllowedPrefixesToDirectConnectGateway;

    private final String virtualGatewayId;

    private CreateDirectConnectGatewayAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.gatewayId = builder.gatewayId;
        this.addAllowedPrefixesToDirectConnectGateway = builder.addAllowedPrefixesToDirectConnectGateway;
        this.virtualGatewayId = builder.virtualGatewayId;
    }

    /**
     * <p>
     * The ID of the Direct Connect gateway.
     * </p>
     * 
     * @return The ID of the Direct Connect gateway.
     */
    public final String directConnectGatewayId() {
        return directConnectGatewayId;
    }

    /**
     * <p>
     * The ID of the virtual private gateway or transit gateway.
     * </p>
     * 
     * @return The ID of the virtual private gateway or transit gateway.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddAllowedPrefixesToDirectConnectGateway
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAddAllowedPrefixesToDirectConnectGateway() {
        return addAllowedPrefixesToDirectConnectGateway != null
                && !(addAllowedPrefixesToDirectConnectGateway instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon VPC prefixes to advertise to the Direct Connect gateway
     * </p>
     * <p>
     * This parameter is required when you create an association to a transit gateway.
     * </p>
     * <p>
     * For information about how to set the prefixes, see <a href=
     * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes"
     * >Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasAddAllowedPrefixesToDirectConnectGateway} method.
     * </p>
     * 
     * @return The Amazon VPC prefixes to advertise to the Direct Connect gateway</p>
     *         <p>
     *         This parameter is required when you create an association to a transit gateway.
     *         </p>
     *         <p>
     *         For information about how to set the prefixes, see <a href=
     *         "https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes"
     *         >Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.
     */
    public final List<RouteFilterPrefix> addAllowedPrefixesToDirectConnectGateway() {
        return addAllowedPrefixesToDirectConnectGateway;
    }

    /**
     * <p>
     * The ID of the virtual private gateway.
     * </p>
     * 
     * @return The ID of the virtual private gateway.
     */
    public final String virtualGatewayId() {
        return virtualGatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasAddAllowedPrefixesToDirectConnectGateway() ? addAllowedPrefixesToDirectConnectGateway()
                        : null);
        hashCode = 31 * hashCode + Objects.hashCode(virtualGatewayId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDirectConnectGatewayAssociationRequest)) {
            return false;
        }
        CreateDirectConnectGatewayAssociationRequest other = (CreateDirectConnectGatewayAssociationRequest) obj;
        return Objects.equals(directConnectGatewayId(), other.directConnectGatewayId())
                && Objects.equals(gatewayId(), other.gatewayId())
                && hasAddAllowedPrefixesToDirectConnectGateway() == other.hasAddAllowedPrefixesToDirectConnectGateway()
                && Objects.equals(addAllowedPrefixesToDirectConnectGateway(), other.addAllowedPrefixesToDirectConnectGateway())
                && Objects.equals(virtualGatewayId(), other.virtualGatewayId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateDirectConnectGatewayAssociationRequest")
                .add("DirectConnectGatewayId", directConnectGatewayId())
                .add("GatewayId", gatewayId())
                .add("AddAllowedPrefixesToDirectConnectGateway",
                        hasAddAllowedPrefixesToDirectConnectGateway() ? addAllowedPrefixesToDirectConnectGateway() : null)
                .add("VirtualGatewayId", virtualGatewayId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "directConnectGatewayId":
            return Optional.ofNullable(clazz.cast(directConnectGatewayId()));
        case "gatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "addAllowedPrefixesToDirectConnectGateway":
            return Optional.ofNullable(clazz.cast(addAllowedPrefixesToDirectConnectGateway()));
        case "virtualGatewayId":
            return Optional.ofNullable(clazz.cast(virtualGatewayId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDirectConnectGatewayAssociationRequest, T> g) {
        return obj -> g.apply((CreateDirectConnectGatewayAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDirectConnectGatewayAssociationRequest> {
        /**
         * <p>
         * The ID of the Direct Connect gateway.
         * </p>
         * 
         * @param directConnectGatewayId
         *        The ID of the Direct Connect gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGatewayId(String directConnectGatewayId);

        /**
         * <p>
         * The ID of the virtual private gateway or transit gateway.
         * </p>
         * 
         * @param gatewayId
         *        The ID of the virtual private gateway or transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The Amazon VPC prefixes to advertise to the Direct Connect gateway
         * </p>
         * <p>
         * This parameter is required when you create an association to a transit gateway.
         * </p>
         * <p>
         * For information about how to set the prefixes, see <a href=
         * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes"
         * >Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.
         * </p>
         * 
         * @param addAllowedPrefixesToDirectConnectGateway
         *        The Amazon VPC prefixes to advertise to the Direct Connect gateway</p>
         *        <p>
         *        This parameter is required when you create an association to a transit gateway.
         *        </p>
         *        <p>
         *        For information about how to set the prefixes, see <a href=
         *        "https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes"
         *        >Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addAllowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix> addAllowedPrefixesToDirectConnectGateway);

        /**
         * <p>
         * The Amazon VPC prefixes to advertise to the Direct Connect gateway
         * </p>
         * <p>
         * This parameter is required when you create an association to a transit gateway.
         * </p>
         * <p>
         * For information about how to set the prefixes, see <a href=
         * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes"
         * >Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.
         * </p>
         * 
         * @param addAllowedPrefixesToDirectConnectGateway
         *        The Amazon VPC prefixes to advertise to the Direct Connect gateway</p>
         *        <p>
         *        This parameter is required when you create an association to a transit gateway.
         *        </p>
         *        <p>
         *        For information about how to set the prefixes, see <a href=
         *        "https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes"
         *        >Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addAllowedPrefixesToDirectConnectGateway(RouteFilterPrefix... addAllowedPrefixesToDirectConnectGateway);

        /**
         * <p>
         * The Amazon VPC prefixes to advertise to the Direct Connect gateway
         * </p>
         * <p>
         * This parameter is required when you create an association to a transit gateway.
         * </p>
         * <p>
         * For information about how to set the prefixes, see <a href=
         * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes"
         * >Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #addAllowedPrefixesToDirectConnectGateway(List<RouteFilterPrefix>)}.
         * 
         * @param addAllowedPrefixesToDirectConnectGateway
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addAllowedPrefixesToDirectConnectGateway(java.util.Collection<RouteFilterPrefix>)
         */
        Builder addAllowedPrefixesToDirectConnectGateway(
                Consumer<RouteFilterPrefix.Builder>... addAllowedPrefixesToDirectConnectGateway);

        /**
         * <p>
         * The ID of the virtual private gateway.
         * </p>
         * 
         * @param virtualGatewayId
         *        The ID of the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualGatewayId(String virtualGatewayId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private String directConnectGatewayId;

        private String gatewayId;

        private List<RouteFilterPrefix> addAllowedPrefixesToDirectConnectGateway = DefaultSdkAutoConstructList.getInstance();

        private String virtualGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDirectConnectGatewayAssociationRequest model) {
            super(model);
            directConnectGatewayId(model.directConnectGatewayId);
            gatewayId(model.gatewayId);
            addAllowedPrefixesToDirectConnectGateway(model.addAllowedPrefixesToDirectConnectGateway);
            virtualGatewayId(model.virtualGatewayId);
        }

        public final String getDirectConnectGatewayId() {
            return directConnectGatewayId;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final List<RouteFilterPrefix.Builder> getAddAllowedPrefixesToDirectConnectGateway() {
            List<RouteFilterPrefix.Builder> result = RouteFilterPrefixListCopier
                    .copyToBuilder(this.addAllowedPrefixesToDirectConnectGateway);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddAllowedPrefixesToDirectConnectGateway(
                Collection<RouteFilterPrefix.BuilderImpl> addAllowedPrefixesToDirectConnectGateway) {
            this.addAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier
                    .copyFromBuilder(addAllowedPrefixesToDirectConnectGateway);
        }

        @Override
        public final Builder addAllowedPrefixesToDirectConnectGateway(
                Collection<RouteFilterPrefix> addAllowedPrefixesToDirectConnectGateway) {
            this.addAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier
                    .copy(addAllowedPrefixesToDirectConnectGateway);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addAllowedPrefixesToDirectConnectGateway(
                RouteFilterPrefix... addAllowedPrefixesToDirectConnectGateway) {
            addAllowedPrefixesToDirectConnectGateway(Arrays.asList(addAllowedPrefixesToDirectConnectGateway));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addAllowedPrefixesToDirectConnectGateway(
                Consumer<RouteFilterPrefix.Builder>... addAllowedPrefixesToDirectConnectGateway) {
            addAllowedPrefixesToDirectConnectGateway(Stream.of(addAllowedPrefixesToDirectConnectGateway)
                    .map(c -> RouteFilterPrefix.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVirtualGatewayId() {
            return virtualGatewayId;
        }

        public final void setVirtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
        }

        @Override
        public final Builder virtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDirectConnectGatewayAssociationRequest build() {
            return new CreateDirectConnectGatewayAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
