/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStorageSystemResourcesResponse extends DataSyncResponse implements
        ToCopyableBuilder<DescribeStorageSystemResourcesResponse.Builder, DescribeStorageSystemResourcesResponse> {
    private static final SdkField<ResourceDetails> RESOURCE_DETAILS_FIELD = SdkField
            .<ResourceDetails> builder(MarshallingType.SDK_POJO).memberName("ResourceDetails")
            .getter(getter(DescribeStorageSystemResourcesResponse::resourceDetails)).setter(setter(Builder::resourceDetails))
            .constructor(ResourceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDetails").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeStorageSystemResourcesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_DETAILS_FIELD,
            NEXT_TOKEN_FIELD));

    private final ResourceDetails resourceDetails;

    private final String nextToken;

    private DescribeStorageSystemResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceDetails = builder.resourceDetails;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The information collected about your storage system's resources. A response can also include Amazon Web Services
     * storage service recommendations.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-findings.html">storage resource
     * information</a> collected by and <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html"
     * >recommendations</a> provided by DataSync Discovery.
     * </p>
     * 
     * @return The information collected about your storage system's resources. A response can also include Amazon Web
     *         Services storage service recommendations.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-findings.html">storage
     *         resource information</a> collected by and <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html"
     *         >recommendations</a> provided by DataSync Discovery.
     */
    public final ResourceDetails resourceDetails() {
        return resourceDetails;
    }

    /**
     * <p>
     * The opaque string that indicates the position to begin the next list of results in the response.
     * </p>
     * 
     * @return The opaque string that indicates the position to begin the next list of results in the response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStorageSystemResourcesResponse)) {
            return false;
        }
        DescribeStorageSystemResourcesResponse other = (DescribeStorageSystemResourcesResponse) obj;
        return Objects.equals(resourceDetails(), other.resourceDetails()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStorageSystemResourcesResponse").add("ResourceDetails", resourceDetails())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceDetails":
            return Optional.ofNullable(clazz.cast(resourceDetails()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStorageSystemResourcesResponse, T> g) {
        return obj -> g.apply((DescribeStorageSystemResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStorageSystemResourcesResponse> {
        /**
         * <p>
         * The information collected about your storage system's resources. A response can also include Amazon Web
         * Services storage service recommendations.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-findings.html">storage
         * resource information</a> collected by and <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html"
         * >recommendations</a> provided by DataSync Discovery.
         * </p>
         * 
         * @param resourceDetails
         *        The information collected about your storage system's resources. A response can also include Amazon
         *        Web Services storage service recommendations.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-findings.html"
         *        >storage resource information</a> collected by and <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html"
         *        >recommendations</a> provided by DataSync Discovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDetails(ResourceDetails resourceDetails);

        /**
         * <p>
         * The information collected about your storage system's resources. A response can also include Amazon Web
         * Services storage service recommendations.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-findings.html">storage
         * resource information</a> collected by and <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html"
         * >recommendations</a> provided by DataSync Discovery.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceDetails.Builder} avoiding the
         * need to create one manually via {@link ResourceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceDetails(ResourceDetails)}.
         * 
         * @param resourceDetails
         *        a consumer that will call methods on {@link ResourceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceDetails(ResourceDetails)
         */
        default Builder resourceDetails(Consumer<ResourceDetails.Builder> resourceDetails) {
            return resourceDetails(ResourceDetails.builder().applyMutation(resourceDetails).build());
        }

        /**
         * <p>
         * The opaque string that indicates the position to begin the next list of results in the response.
         * </p>
         * 
         * @param nextToken
         *        The opaque string that indicates the position to begin the next list of results in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private ResourceDetails resourceDetails;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStorageSystemResourcesResponse model) {
            super(model);
            resourceDetails(model.resourceDetails);
            nextToken(model.nextToken);
        }

        public final ResourceDetails.Builder getResourceDetails() {
            return resourceDetails != null ? resourceDetails.toBuilder() : null;
        }

        public final void setResourceDetails(ResourceDetails.BuilderImpl resourceDetails) {
            this.resourceDetails = resourceDetails != null ? resourceDetails.build() : null;
        }

        @Override
        public final Builder resourceDetails(ResourceDetails resourceDetails) {
            this.resourceDetails = resourceDetails;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeStorageSystemResourcesResponse build() {
            return new DescribeStorageSystemResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
