/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyEventSubscriptionResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<ModifyEventSubscriptionResponse.Builder, ModifyEventSubscriptionResponse> {
    private static final SdkField<EventSubscription> EVENT_SUBSCRIPTION_FIELD = SdkField
            .<EventSubscription> builder(MarshallingType.SDK_POJO).memberName("EventSubscription")
            .getter(getter(ModifyEventSubscriptionResponse::eventSubscription)).setter(setter(Builder::eventSubscription))
            .constructor(EventSubscription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSubscription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_SUBSCRIPTION_FIELD));

    private final EventSubscription eventSubscription;

    private ModifyEventSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.eventSubscription = builder.eventSubscription;
    }

    /**
     * <p>
     * The modified event subscription.
     * </p>
     * 
     * @return The modified event subscription.
     */
    public final EventSubscription eventSubscription() {
        return eventSubscription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventSubscription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyEventSubscriptionResponse)) {
            return false;
        }
        ModifyEventSubscriptionResponse other = (ModifyEventSubscriptionResponse) obj;
        return Objects.equals(eventSubscription(), other.eventSubscription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyEventSubscriptionResponse").add("EventSubscription", eventSubscription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventSubscription":
            return Optional.ofNullable(clazz.cast(eventSubscription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyEventSubscriptionResponse, T> g) {
        return obj -> g.apply((ModifyEventSubscriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyEventSubscriptionResponse> {
        /**
         * <p>
         * The modified event subscription.
         * </p>
         * 
         * @param eventSubscription
         *        The modified event subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSubscription(EventSubscription eventSubscription);

        /**
         * <p>
         * The modified event subscription.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventSubscription.Builder} avoiding the
         * need to create one manually via {@link EventSubscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventSubscription.Builder#build()} is called immediately and its
         * result is passed to {@link #eventSubscription(EventSubscription)}.
         * 
         * @param eventSubscription
         *        a consumer that will call methods on {@link EventSubscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventSubscription(EventSubscription)
         */
        default Builder eventSubscription(Consumer<EventSubscription.Builder> eventSubscription) {
            return eventSubscription(EventSubscription.builder().applyMutation(eventSubscription).build());
        }
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private EventSubscription eventSubscription;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyEventSubscriptionResponse model) {
            super(model);
            eventSubscription(model.eventSubscription);
        }

        public final EventSubscription.Builder getEventSubscription() {
            return eventSubscription != null ? eventSubscription.toBuilder() : null;
        }

        public final void setEventSubscription(EventSubscription.BuilderImpl eventSubscription) {
            this.eventSubscription = eventSubscription != null ? eventSubscription.build() : null;
        }

        @Override
        public final Builder eventSubscription(EventSubscription eventSubscription) {
            this.eventSubscription = eventSubscription;
            return this;
        }

        @Override
        public ModifyEventSubscriptionResponse build() {
            return new ModifyEventSubscriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
