/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReplicationConfigRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<CreateReplicationConfigRequest.Builder, CreateReplicationConfigRequest> {
    private static final SdkField<String> REPLICATION_CONFIG_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationConfigIdentifier")
            .getter(getter(CreateReplicationConfigRequest::replicationConfigIdentifier))
            .setter(setter(Builder::replicationConfigIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigIdentifier")
                    .build()).build();

    private static final SdkField<String> SOURCE_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceEndpointArn").getter(getter(CreateReplicationConfigRequest::sourceEndpointArn))
            .setter(setter(Builder::sourceEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEndpointArn").build()).build();

    private static final SdkField<String> TARGET_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetEndpointArn").getter(getter(CreateReplicationConfigRequest::targetEndpointArn))
            .setter(setter(Builder::targetEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEndpointArn").build()).build();

    private static final SdkField<ComputeConfig> COMPUTE_CONFIG_FIELD = SdkField
            .<ComputeConfig> builder(MarshallingType.SDK_POJO).memberName("ComputeConfig")
            .getter(getter(CreateReplicationConfigRequest::computeConfig)).setter(setter(Builder::computeConfig))
            .constructor(ComputeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeConfig").build()).build();

    private static final SdkField<String> REPLICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationType").getter(getter(CreateReplicationConfigRequest::replicationTypeAsString))
            .setter(setter(Builder::replicationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationType").build()).build();

    private static final SdkField<String> TABLE_MAPPINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableMappings").getter(getter(CreateReplicationConfigRequest::tableMappings))
            .setter(setter(Builder::tableMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMappings").build()).build();

    private static final SdkField<String> REPLICATION_SETTINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationSettings").getter(getter(CreateReplicationConfigRequest::replicationSettings))
            .setter(setter(Builder::replicationSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSettings").build())
            .build();

    private static final SdkField<String> SUPPLEMENTAL_SETTINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupplementalSettings").getter(getter(CreateReplicationConfigRequest::supplementalSettings))
            .setter(setter(Builder::supplementalSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplementalSettings").build())
            .build();

    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceIdentifier").getter(getter(CreateReplicationConfigRequest::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateReplicationConfigRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLICATION_CONFIG_IDENTIFIER_FIELD, SOURCE_ENDPOINT_ARN_FIELD, TARGET_ENDPOINT_ARN_FIELD, COMPUTE_CONFIG_FIELD,
            REPLICATION_TYPE_FIELD, TABLE_MAPPINGS_FIELD, REPLICATION_SETTINGS_FIELD, SUPPLEMENTAL_SETTINGS_FIELD,
            RESOURCE_IDENTIFIER_FIELD, TAGS_FIELD));

    private final String replicationConfigIdentifier;

    private final String sourceEndpointArn;

    private final String targetEndpointArn;

    private final ComputeConfig computeConfig;

    private final String replicationType;

    private final String tableMappings;

    private final String replicationSettings;

    private final String supplementalSettings;

    private final String resourceIdentifier;

    private final List<Tag> tags;

    private CreateReplicationConfigRequest(BuilderImpl builder) {
        super(builder);
        this.replicationConfigIdentifier = builder.replicationConfigIdentifier;
        this.sourceEndpointArn = builder.sourceEndpointArn;
        this.targetEndpointArn = builder.targetEndpointArn;
        this.computeConfig = builder.computeConfig;
        this.replicationType = builder.replicationType;
        this.tableMappings = builder.tableMappings;
        this.replicationSettings = builder.replicationSettings;
        this.supplementalSettings = builder.supplementalSettings;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique identifier that you want to use to create a <code>ReplicationConfigArn</code> that is returned as part
     * of the output from this action. You can then pass this output <code>ReplicationConfigArn</code> as the value of
     * the <code>ReplicationConfigArn</code> option for other actions to identify both DMS Serverless replications and
     * replication configurations that you want those actions to operate on. For some actions, you can also use either
     * this unique identifier or a corresponding ARN in action filters to identify the specific replication and
     * replication configuration to operate on.
     * </p>
     * 
     * @return A unique identifier that you want to use to create a <code>ReplicationConfigArn</code> that is returned
     *         as part of the output from this action. You can then pass this output <code>ReplicationConfigArn</code>
     *         as the value of the <code>ReplicationConfigArn</code> option for other actions to identify both DMS
     *         Serverless replications and replication configurations that you want those actions to operate on. For
     *         some actions, you can also use either this unique identifier or a corresponding ARN in action filters to
     *         identify the specific replication and replication configuration to operate on.
     */
    public final String replicationConfigIdentifier() {
        return replicationConfigIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source endpoint for this DMS Serverless replication configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source endpoint for this DMS Serverless replication configuration.
     */
    public final String sourceEndpointArn() {
        return sourceEndpointArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the target endpoint for this DMS serverless replication configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the target endpoint for this DMS serverless replication configuration.
     */
    public final String targetEndpointArn() {
        return targetEndpointArn;
    }

    /**
     * <p>
     * Configuration parameters for provisioning an DMS Serverless replication.
     * </p>
     * 
     * @return Configuration parameters for provisioning an DMS Serverless replication.
     */
    public final ComputeConfig computeConfig() {
        return computeConfig;
    }

    /**
     * <p>
     * The type of DMS Serverless replication to provision using this replication configuration.
     * </p>
     * <p>
     * Possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"full-load"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"cdc"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"full-load-and-cdc"</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationType}
     * will return {@link MigrationTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicationTypeAsString}.
     * </p>
     * 
     * @return The type of DMS Serverless replication to provision using this replication configuration.</p>
     *         <p>
     *         Possible values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>"full-load"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"cdc"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"full-load-and-cdc"</code>
     *         </p>
     *         </li>
     * @see MigrationTypeValue
     */
    public final MigrationTypeValue replicationType() {
        return MigrationTypeValue.fromValue(replicationType);
    }

    /**
     * <p>
     * The type of DMS Serverless replication to provision using this replication configuration.
     * </p>
     * <p>
     * Possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"full-load"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"cdc"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"full-load-and-cdc"</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationType}
     * will return {@link MigrationTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicationTypeAsString}.
     * </p>
     * 
     * @return The type of DMS Serverless replication to provision using this replication configuration.</p>
     *         <p>
     *         Possible values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>"full-load"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"cdc"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"full-load-and-cdc"</code>
     *         </p>
     *         </li>
     * @see MigrationTypeValue
     */
    public final String replicationTypeAsString() {
        return replicationType;
    }

    /**
     * <p>
     * JSON table mappings for DMS Serverless replications that are provisioned using this replication configuration.
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.SelectionTransformation.html"
     * > Specifying table selection and transformations rules using JSON</a>.
     * </p>
     * 
     * @return JSON table mappings for DMS Serverless replications that are provisioned using this replication
     *         configuration. For more information, see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.SelectionTransformation.html"
     *         > Specifying table selection and transformations rules using JSON</a>.
     */
    public final String tableMappings() {
        return tableMappings;
    }

    /**
     * <p>
     * Optional JSON settings for DMS Serverless replications that are provisioned using this replication configuration.
     * For example, see <a href=
     * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.ChangeProcessingTuning.html"
     * > Change processing tuning settings</a>.
     * </p>
     * 
     * @return Optional JSON settings for DMS Serverless replications that are provisioned using this replication
     *         configuration. For example, see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.ChangeProcessingTuning.html"
     *         > Change processing tuning settings</a>.
     */
    public final String replicationSettings() {
        return replicationSettings;
    }

    /**
     * <p>
     * Optional JSON settings for specifying supplemental data. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html"> Specifying supplemental data
     * for task settings</a>.
     * </p>
     * 
     * @return Optional JSON settings for specifying supplemental data. For more information, see <a
     *         href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html"> Specifying supplemental
     *         data for task settings</a>.
     */
    public final String supplementalSettings() {
        return supplementalSettings;
    }

    /**
     * <p>
     * Optional unique value or name that you set for a given resource that can be used to construct an Amazon Resource
     * Name (ARN) for that resource. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.FineGrainedAccess">
     * Fine-grained access control using resource names and tags</a>.
     * </p>
     * 
     * @return Optional unique value or name that you set for a given resource that can be used to construct an Amazon
     *         Resource Name (ARN) for that resource. For more information, see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.FineGrainedAccess">
     *         Fine-grained access control using resource names and tags</a>.
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more optional tags associated with resources used by the DMS Serverless replication. For more information,
     * see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tagging.html"> Tagging resources in Database
     * Migration Service</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return One or more optional tags associated with resources used by the DMS Serverless replication. For more
     *         information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tagging.html"> Tagging
     *         resources in Database Migration Service</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationConfigIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(computeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tableMappings());
        hashCode = 31 * hashCode + Objects.hashCode(replicationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(supplementalSettings());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationConfigRequest)) {
            return false;
        }
        CreateReplicationConfigRequest other = (CreateReplicationConfigRequest) obj;
        return Objects.equals(replicationConfigIdentifier(), other.replicationConfigIdentifier())
                && Objects.equals(sourceEndpointArn(), other.sourceEndpointArn())
                && Objects.equals(targetEndpointArn(), other.targetEndpointArn())
                && Objects.equals(computeConfig(), other.computeConfig())
                && Objects.equals(replicationTypeAsString(), other.replicationTypeAsString())
                && Objects.equals(tableMappings(), other.tableMappings())
                && Objects.equals(replicationSettings(), other.replicationSettings())
                && Objects.equals(supplementalSettings(), other.supplementalSettings())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateReplicationConfigRequest")
                .add("ReplicationConfigIdentifier", replicationConfigIdentifier()).add("SourceEndpointArn", sourceEndpointArn())
                .add("TargetEndpointArn", targetEndpointArn()).add("ComputeConfig", computeConfig())
                .add("ReplicationType", replicationTypeAsString()).add("TableMappings", tableMappings())
                .add("ReplicationSettings", replicationSettings()).add("SupplementalSettings", supplementalSettings())
                .add("ResourceIdentifier", resourceIdentifier()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationConfigIdentifier":
            return Optional.ofNullable(clazz.cast(replicationConfigIdentifier()));
        case "SourceEndpointArn":
            return Optional.ofNullable(clazz.cast(sourceEndpointArn()));
        case "TargetEndpointArn":
            return Optional.ofNullable(clazz.cast(targetEndpointArn()));
        case "ComputeConfig":
            return Optional.ofNullable(clazz.cast(computeConfig()));
        case "ReplicationType":
            return Optional.ofNullable(clazz.cast(replicationTypeAsString()));
        case "TableMappings":
            return Optional.ofNullable(clazz.cast(tableMappings()));
        case "ReplicationSettings":
            return Optional.ofNullable(clazz.cast(replicationSettings()));
        case "SupplementalSettings":
            return Optional.ofNullable(clazz.cast(supplementalSettings()));
        case "ResourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicationConfigRequest, T> g) {
        return obj -> g.apply((CreateReplicationConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateReplicationConfigRequest> {
        /**
         * <p>
         * A unique identifier that you want to use to create a <code>ReplicationConfigArn</code> that is returned as
         * part of the output from this action. You can then pass this output <code>ReplicationConfigArn</code> as the
         * value of the <code>ReplicationConfigArn</code> option for other actions to identify both DMS Serverless
         * replications and replication configurations that you want those actions to operate on. For some actions, you
         * can also use either this unique identifier or a corresponding ARN in action filters to identify the specific
         * replication and replication configuration to operate on.
         * </p>
         * 
         * @param replicationConfigIdentifier
         *        A unique identifier that you want to use to create a <code>ReplicationConfigArn</code> that is
         *        returned as part of the output from this action. You can then pass this output
         *        <code>ReplicationConfigArn</code> as the value of the <code>ReplicationConfigArn</code> option for
         *        other actions to identify both DMS Serverless replications and replication configurations that you
         *        want those actions to operate on. For some actions, you can also use either this unique identifier or
         *        a corresponding ARN in action filters to identify the specific replication and replication
         *        configuration to operate on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationConfigIdentifier(String replicationConfigIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source endpoint for this DMS Serverless replication configuration.
         * </p>
         * 
         * @param sourceEndpointArn
         *        The Amazon Resource Name (ARN) of the source endpoint for this DMS Serverless replication
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEndpointArn(String sourceEndpointArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the target endpoint for this DMS serverless replication configuration.
         * </p>
         * 
         * @param targetEndpointArn
         *        The Amazon Resource Name (ARN) of the target endpoint for this DMS serverless replication
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetEndpointArn(String targetEndpointArn);

        /**
         * <p>
         * Configuration parameters for provisioning an DMS Serverless replication.
         * </p>
         * 
         * @param computeConfig
         *        Configuration parameters for provisioning an DMS Serverless replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeConfig(ComputeConfig computeConfig);

        /**
         * <p>
         * Configuration parameters for provisioning an DMS Serverless replication.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputeConfig.Builder} avoiding the need
         * to create one manually via {@link ComputeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #computeConfig(ComputeConfig)}.
         * 
         * @param computeConfig
         *        a consumer that will call methods on {@link ComputeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeConfig(ComputeConfig)
         */
        default Builder computeConfig(Consumer<ComputeConfig.Builder> computeConfig) {
            return computeConfig(ComputeConfig.builder().applyMutation(computeConfig).build());
        }

        /**
         * <p>
         * The type of DMS Serverless replication to provision using this replication configuration.
         * </p>
         * <p>
         * Possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>"full-load"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"cdc"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"full-load-and-cdc"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param replicationType
         *        The type of DMS Serverless replication to provision using this replication configuration.</p>
         *        <p>
         *        Possible values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>"full-load"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"cdc"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"full-load-and-cdc"</code>
         *        </p>
         *        </li>
         * @see MigrationTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationTypeValue
         */
        Builder replicationType(String replicationType);

        /**
         * <p>
         * The type of DMS Serverless replication to provision using this replication configuration.
         * </p>
         * <p>
         * Possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>"full-load"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"cdc"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"full-load-and-cdc"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param replicationType
         *        The type of DMS Serverless replication to provision using this replication configuration.</p>
         *        <p>
         *        Possible values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>"full-load"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"cdc"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"full-load-and-cdc"</code>
         *        </p>
         *        </li>
         * @see MigrationTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationTypeValue
         */
        Builder replicationType(MigrationTypeValue replicationType);

        /**
         * <p>
         * JSON table mappings for DMS Serverless replications that are provisioned using this replication
         * configuration. For more information, see <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.SelectionTransformation.html"
         * > Specifying table selection and transformations rules using JSON</a>.
         * </p>
         * 
         * @param tableMappings
         *        JSON table mappings for DMS Serverless replications that are provisioned using this replication
         *        configuration. For more information, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.SelectionTransformation.html"
         *        > Specifying table selection and transformations rules using JSON</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableMappings(String tableMappings);

        /**
         * <p>
         * Optional JSON settings for DMS Serverless replications that are provisioned using this replication
         * configuration. For example, see <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.ChangeProcessingTuning.html"
         * > Change processing tuning settings</a>.
         * </p>
         * 
         * @param replicationSettings
         *        Optional JSON settings for DMS Serverless replications that are provisioned using this replication
         *        configuration. For example, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.ChangeProcessingTuning.html"
         *        > Change processing tuning settings</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSettings(String replicationSettings);

        /**
         * <p>
         * Optional JSON settings for specifying supplemental data. For more information, see <a
         * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html"> Specifying supplemental
         * data for task settings</a>.
         * </p>
         * 
         * @param supplementalSettings
         *        Optional JSON settings for specifying supplemental data. For more information, see <a
         *        href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html"> Specifying
         *        supplemental data for task settings</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supplementalSettings(String supplementalSettings);

        /**
         * <p>
         * Optional unique value or name that you set for a given resource that can be used to construct an Amazon
         * Resource Name (ARN) for that resource. For more information, see <a
         * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.FineGrainedAccess">
         * Fine-grained access control using resource names and tags</a>.
         * </p>
         * 
         * @param resourceIdentifier
         *        Optional unique value or name that you set for a given resource that can be used to construct an
         *        Amazon Resource Name (ARN) for that resource. For more information, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.FineGrainedAccess">
         *        Fine-grained access control using resource names and tags</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * One or more optional tags associated with resources used by the DMS Serverless replication. For more
         * information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tagging.html"> Tagging
         * resources in Database Migration Service</a>.
         * </p>
         * 
         * @param tags
         *        One or more optional tags associated with resources used by the DMS Serverless replication. For more
         *        information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tagging.html"> Tagging
         *        resources in Database Migration Service</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more optional tags associated with resources used by the DMS Serverless replication. For more
         * information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tagging.html"> Tagging
         * resources in Database Migration Service</a>.
         * </p>
         * 
         * @param tags
         *        One or more optional tags associated with resources used by the DMS Serverless replication. For more
         *        information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tagging.html"> Tagging
         *        resources in Database Migration Service</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * One or more optional tags associated with resources used by the DMS Serverless replication. For more
         * information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tagging.html"> Tagging
         * resources in Database Migration Service</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.databasemigration.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String replicationConfigIdentifier;

        private String sourceEndpointArn;

        private String targetEndpointArn;

        private ComputeConfig computeConfig;

        private String replicationType;

        private String tableMappings;

        private String replicationSettings;

        private String supplementalSettings;

        private String resourceIdentifier;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationConfigRequest model) {
            super(model);
            replicationConfigIdentifier(model.replicationConfigIdentifier);
            sourceEndpointArn(model.sourceEndpointArn);
            targetEndpointArn(model.targetEndpointArn);
            computeConfig(model.computeConfig);
            replicationType(model.replicationType);
            tableMappings(model.tableMappings);
            replicationSettings(model.replicationSettings);
            supplementalSettings(model.supplementalSettings);
            resourceIdentifier(model.resourceIdentifier);
            tags(model.tags);
        }

        public final String getReplicationConfigIdentifier() {
            return replicationConfigIdentifier;
        }

        public final void setReplicationConfigIdentifier(String replicationConfigIdentifier) {
            this.replicationConfigIdentifier = replicationConfigIdentifier;
        }

        @Override
        public final Builder replicationConfigIdentifier(String replicationConfigIdentifier) {
            this.replicationConfigIdentifier = replicationConfigIdentifier;
            return this;
        }

        public final String getSourceEndpointArn() {
            return sourceEndpointArn;
        }

        public final void setSourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
        }

        @Override
        public final Builder sourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
            return this;
        }

        public final String getTargetEndpointArn() {
            return targetEndpointArn;
        }

        public final void setTargetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
        }

        @Override
        public final Builder targetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
            return this;
        }

        public final ComputeConfig.Builder getComputeConfig() {
            return computeConfig != null ? computeConfig.toBuilder() : null;
        }

        public final void setComputeConfig(ComputeConfig.BuilderImpl computeConfig) {
            this.computeConfig = computeConfig != null ? computeConfig.build() : null;
        }

        @Override
        public final Builder computeConfig(ComputeConfig computeConfig) {
            this.computeConfig = computeConfig;
            return this;
        }

        public final String getReplicationType() {
            return replicationType;
        }

        public final void setReplicationType(String replicationType) {
            this.replicationType = replicationType;
        }

        @Override
        public final Builder replicationType(String replicationType) {
            this.replicationType = replicationType;
            return this;
        }

        @Override
        public final Builder replicationType(MigrationTypeValue replicationType) {
            this.replicationType(replicationType == null ? null : replicationType.toString());
            return this;
        }

        public final String getTableMappings() {
            return tableMappings;
        }

        public final void setTableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
        }

        @Override
        public final Builder tableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
            return this;
        }

        public final String getReplicationSettings() {
            return replicationSettings;
        }

        public final void setReplicationSettings(String replicationSettings) {
            this.replicationSettings = replicationSettings;
        }

        @Override
        public final Builder replicationSettings(String replicationSettings) {
            this.replicationSettings = replicationSettings;
            return this;
        }

        public final String getSupplementalSettings() {
            return supplementalSettings;
        }

        public final void setSupplementalSettings(String supplementalSettings) {
            this.supplementalSettings = supplementalSettings;
        }

        @Override
        public final Builder supplementalSettings(String supplementalSettings) {
            this.supplementalSettings = supplementalSettings;
            return this;
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplicationConfigRequest build() {
            return new CreateReplicationConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
