/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCostCategoryDefinitionsRequest extends CostExplorerRequest implements
        ToCopyableBuilder<ListCostCategoryDefinitionsRequest.Builder, ListCostCategoryDefinitionsRequest> {
    private static final SdkField<String> EFFECTIVE_ON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EffectiveOn").getter(getter(ListCostCategoryDefinitionsRequest::effectiveOn))
            .setter(setter(Builder::effectiveOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveOn").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCostCategoryDefinitionsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListCostCategoryDefinitionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFFECTIVE_ON_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String effectiveOn;

    private final String nextToken;

    private final Integer maxResults;

    private ListCostCategoryDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.effectiveOn = builder.effectiveOn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The date when the Cost Category was effective.
     * </p>
     * 
     * @return The date when the Cost Category was effective.
     */
    public final String effectiveOn() {
        return effectiveOn;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a
     * previous call has more results than the maximum page size.
     * </p>
     * 
     * @return The token to retrieve the next set of results. Amazon Web Services provides the token when the response
     *         from a previous call has more results than the maximum page size.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The number of entries a paginated response contains.
     * </p>
     * 
     * @return The number of entries a paginated response contains.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(effectiveOn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCostCategoryDefinitionsRequest)) {
            return false;
        }
        ListCostCategoryDefinitionsRequest other = (ListCostCategoryDefinitionsRequest) obj;
        return Objects.equals(effectiveOn(), other.effectiveOn()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCostCategoryDefinitionsRequest").add("EffectiveOn", effectiveOn())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EffectiveOn":
            return Optional.ofNullable(clazz.cast(effectiveOn()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCostCategoryDefinitionsRequest, T> g) {
        return obj -> g.apply((ListCostCategoryDefinitionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCostCategoryDefinitionsRequest> {
        /**
         * <p>
         * The date when the Cost Category was effective.
         * </p>
         * 
         * @param effectiveOn
         *        The date when the Cost Category was effective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveOn(String effectiveOn);

        /**
         * <p>
         * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from
         * a previous call has more results than the maximum page size.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results. Amazon Web Services provides the token when the
         *        response from a previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The number of entries a paginated response contains.
         * </p>
         * 
         * @param maxResults
         *        The number of entries a paginated response contains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String effectiveOn;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCostCategoryDefinitionsRequest model) {
            super(model);
            effectiveOn(model.effectiveOn);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getEffectiveOn() {
            return effectiveOn;
        }

        public final void setEffectiveOn(String effectiveOn) {
            this.effectiveOn = effectiveOn;
        }

        @Override
        public final Builder effectiveOn(String effectiveOn) {
            this.effectiveOn = effectiveOn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCostCategoryDefinitionsRequest build() {
            return new ListCostCategoryDefinitionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
