/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A view resource object. Contains metadata and content necessary to render the view.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class View implements SdkPojo, Serializable, ToCopyableBuilder<View.Builder, View> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(View::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(View::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(View::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(View::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(View::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(View::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Version").getter(getter(View::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionDescription").getter(getter(View::versionDescription))
            .setter(setter(Builder::versionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build())
            .build();

    private static final SdkField<ViewContent> CONTENT_FIELD = SdkField.<ViewContent> builder(MarshallingType.SDK_POJO)
            .memberName("Content").getter(getter(View::content)).setter(setter(Builder::content))
            .constructor(ViewContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(View::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(View::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(View::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> VIEW_CONTENT_SHA256_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViewContentSha256").getter(getter(View::viewContentSha256)).setter(setter(Builder::viewContentSha256))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewContentSha256").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, STATUS_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, VERSION_FIELD, VERSION_DESCRIPTION_FIELD, CONTENT_FIELD,
            TAGS_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, VIEW_CONTENT_SHA256_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final String status;

    private final String type;

    private final String description;

    private final Integer version;

    private final String versionDescription;

    private final ViewContent content;

    private final Map<String, String> tags;

    private final Instant createdTime;

    private final Instant lastModifiedTime;

    private final String viewContentSha256;

    private View(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.status = builder.status;
        this.type = builder.type;
        this.description = builder.description;
        this.version = builder.version;
        this.versionDescription = builder.versionDescription;
        this.content = builder.content;
        this.tags = builder.tags;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.viewContentSha256 = builder.viewContentSha256;
    }

    /**
     * <p>
     * The identifier of the view.
     * </p>
     * 
     * @return The identifier of the view.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the view.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the view.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the view.
     * </p>
     * 
     * @return The name of the view.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The <code>PUBLISHED</code>
     * status will initiate validation on the content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ViewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The
     *         <code>PUBLISHED</code> status will initiate validation on the content.
     * @see ViewStatus
     */
    public final ViewStatus status() {
        return ViewStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The <code>PUBLISHED</code>
     * status will initiate validation on the content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ViewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The
     *         <code>PUBLISHED</code> status will initiate validation on the content.
     * @see ViewStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The type of the view - <code>CUSTOMER_MANAGED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ViewType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the view - <code>CUSTOMER_MANAGED</code>.
     * @see ViewType
     */
    public final ViewType type() {
        return ViewType.fromValue(type);
    }

    /**
     * <p>
     * The type of the view - <code>CUSTOMER_MANAGED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ViewType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the view - <code>CUSTOMER_MANAGED</code>.
     * @see ViewType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The description of the view.
     * </p>
     * 
     * @return The description of the view.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Current version of the view.
     * </p>
     * 
     * @return Current version of the view.
     */
    public final Integer version() {
        return version;
    }

    /**
     * <p>
     * The description of the version.
     * </p>
     * 
     * @return The description of the version.
     */
    public final String versionDescription() {
        return versionDescription;
    }

    /**
     * <p>
     * View content containing all content necessary to render a view except for runtime input data.
     * </p>
     * 
     * @return View content containing all content necessary to render a view except for runtime input data.
     */
    public final ViewContent content() {
        return content;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags associated with the view resource (not specific to view version).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the view resource (not specific to view version).
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The timestamp of when the view was created.
     * </p>
     * 
     * @return The timestamp of when the view was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * Latest timestamp of the <code>UpdateViewContent</code> or <code>CreateViewVersion</code> operations.
     * </p>
     * 
     * @return Latest timestamp of the <code>UpdateViewContent</code> or <code>CreateViewVersion</code> operations.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * Indicates the checksum value of the latest published view content.
     * </p>
     * 
     * @return Indicates the checksum value of the latest published view content.
     */
    public final String viewContentSha256() {
        return viewContentSha256;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(viewContentSha256());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof View)) {
            return false;
        }
        View other = (View) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(description(), other.description())
                && Objects.equals(version(), other.version()) && Objects.equals(versionDescription(), other.versionDescription())
                && Objects.equals(content(), other.content()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(viewContentSha256(), other.viewContentSha256());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("View").add("Id", id()).add("Arn", arn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Status", statusAsString())
                .add("Type", typeAsString()).add("Description", description()).add("Version", version())
                .add("VersionDescription", versionDescription()).add("Content", content()).add("Tags", hasTags() ? tags() : null)
                .add("CreatedTime", createdTime()).add("LastModifiedTime", lastModifiedTime())
                .add("ViewContentSha256", viewContentSha256()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "VersionDescription":
            return Optional.ofNullable(clazz.cast(versionDescription()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "ViewContentSha256":
            return Optional.ofNullable(clazz.cast(viewContentSha256()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<View, T> g) {
        return obj -> g.apply((View) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, View> {
        /**
         * <p>
         * The identifier of the view.
         * </p>
         * 
         * @param id
         *        The identifier of the view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the view.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the view.
         * </p>
         * 
         * @param name
         *        The name of the view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The <code>PUBLISHED</code>
         * status will initiate validation on the content.
         * </p>
         * 
         * @param status
         *        Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The
         *        <code>PUBLISHED</code> status will initiate validation on the content.
         * @see ViewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The <code>PUBLISHED</code>
         * status will initiate validation on the content.
         * </p>
         * 
         * @param status
         *        Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The
         *        <code>PUBLISHED</code> status will initiate validation on the content.
         * @see ViewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewStatus
         */
        Builder status(ViewStatus status);

        /**
         * <p>
         * The type of the view - <code>CUSTOMER_MANAGED</code>.
         * </p>
         * 
         * @param type
         *        The type of the view - <code>CUSTOMER_MANAGED</code>.
         * @see ViewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the view - <code>CUSTOMER_MANAGED</code>.
         * </p>
         * 
         * @param type
         *        The type of the view - <code>CUSTOMER_MANAGED</code>.
         * @see ViewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewType
         */
        Builder type(ViewType type);

        /**
         * <p>
         * The description of the view.
         * </p>
         * 
         * @param description
         *        The description of the view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Current version of the view.
         * </p>
         * 
         * @param version
         *        Current version of the view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);

        /**
         * <p>
         * The description of the version.
         * </p>
         * 
         * @param versionDescription
         *        The description of the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionDescription(String versionDescription);

        /**
         * <p>
         * View content containing all content necessary to render a view except for runtime input data.
         * </p>
         * 
         * @param content
         *        View content containing all content necessary to render a view except for runtime input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(ViewContent content);

        /**
         * <p>
         * View content containing all content necessary to render a view except for runtime input data.
         * </p>
         * This is a convenience method that creates an instance of the {@link ViewContent.Builder} avoiding the need to
         * create one manually via {@link ViewContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ViewContent.Builder#build()} is called immediately and its result
         * is passed to {@link #content(ViewContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link ViewContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(ViewContent)
         */
        default Builder content(Consumer<ViewContent.Builder> content) {
            return content(ViewContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The tags associated with the view resource (not specific to view version).
         * </p>
         * 
         * @param tags
         *        The tags associated with the view resource (not specific to view version).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The timestamp of when the view was created.
         * </p>
         * 
         * @param createdTime
         *        The timestamp of when the view was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * Latest timestamp of the <code>UpdateViewContent</code> or <code>CreateViewVersion</code> operations.
         * </p>
         * 
         * @param lastModifiedTime
         *        Latest timestamp of the <code>UpdateViewContent</code> or <code>CreateViewVersion</code> operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * Indicates the checksum value of the latest published view content.
         * </p>
         * 
         * @param viewContentSha256
         *        Indicates the checksum value of the latest published view content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewContentSha256(String viewContentSha256);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String status;

        private String type;

        private String description;

        private Integer version;

        private String versionDescription;

        private ViewContent content;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Instant createdTime;

        private Instant lastModifiedTime;

        private String viewContentSha256;

        private BuilderImpl() {
        }

        private BuilderImpl(View model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            status(model.status);
            type(model.type);
            description(model.description);
            version(model.version);
            versionDescription(model.versionDescription);
            content(model.content);
            tags(model.tags);
            createdTime(model.createdTime);
            lastModifiedTime(model.lastModifiedTime);
            viewContentSha256(model.viewContentSha256);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ViewStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ViewType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getVersion() {
            return version;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final String getVersionDescription() {
            return versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final ViewContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(ViewContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(ViewContent content) {
            this.content = content;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getViewContentSha256() {
            return viewContentSha256;
        }

        public final void setViewContentSha256(String viewContentSha256) {
            this.viewContentSha256 = viewContentSha256;
        }

        @Override
        public final Builder viewContentSha256(String viewContentSha256) {
            this.viewContentSha256 = viewContentSha256;
            return this;
        }

        @Override
        public View build() {
            return new View(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
