/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitorContactRequest extends ConnectRequest implements
        ToCopyableBuilder<MonitorContactRequest.Builder, MonitorContactRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(MonitorContactRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(MonitorContactRequest::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(MonitorContactRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<List<String>> ALLOWED_MONITOR_CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedMonitorCapabilities")
            .getter(getter(MonitorContactRequest::allowedMonitorCapabilitiesAsStrings))
            .setter(setter(Builder::allowedMonitorCapabilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedMonitorCapabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(MonitorContactRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CONTACT_ID_FIELD, USER_ID_FIELD, ALLOWED_MONITOR_CAPABILITIES_FIELD, CLIENT_TOKEN_FIELD));

    private final String instanceId;

    private final String contactId;

    private final String userId;

    private final List<String> allowedMonitorCapabilities;

    private final String clientToken;

    private MonitorContactRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactId = builder.contactId;
        this.userId = builder.userId;
        this.allowedMonitorCapabilities = builder.allowedMonitorCapabilities;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the contact.
     * </p>
     * 
     * @return The identifier of the contact.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * The identifier of the user account.
     * </p>
     * 
     * @return The identifier of the user account.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed to
     * escalate from silent monitoring to barge.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedMonitorCapabilities} method.
     * </p>
     * 
     * @return Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed to
     *         escalate from silent monitoring to barge.
     */
    public final List<MonitorCapability> allowedMonitorCapabilities() {
        return AllowedMonitorCapabilitiesCopier.copyStringToEnum(allowedMonitorCapabilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedMonitorCapabilities property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAllowedMonitorCapabilities() {
        return allowedMonitorCapabilities != null && !(allowedMonitorCapabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed to
     * escalate from silent monitoring to barge.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedMonitorCapabilities} method.
     * </p>
     * 
     * @return Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed to
     *         escalate from silent monitoring to barge.
     */
    public final List<String> allowedMonitorCapabilitiesAsStrings() {
        return allowedMonitorCapabilities;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAllowedMonitorCapabilities() ? allowedMonitorCapabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitorContactRequest)) {
            return false;
        }
        MonitorContactRequest other = (MonitorContactRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(contactId(), other.contactId())
                && Objects.equals(userId(), other.userId())
                && hasAllowedMonitorCapabilities() == other.hasAllowedMonitorCapabilities()
                && Objects.equals(allowedMonitorCapabilitiesAsStrings(), other.allowedMonitorCapabilitiesAsStrings())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("MonitorContactRequest")
                .add("InstanceId", instanceId())
                .add("ContactId", contactId())
                .add("UserId", userId())
                .add("AllowedMonitorCapabilities", hasAllowedMonitorCapabilities() ? allowedMonitorCapabilitiesAsStrings() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "AllowedMonitorCapabilities":
            return Optional.ofNullable(clazz.cast(allowedMonitorCapabilitiesAsStrings()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitorContactRequest, T> g) {
        return obj -> g.apply((MonitorContactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, MonitorContactRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the contact.
         * </p>
         * 
         * @param contactId
         *        The identifier of the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * The identifier of the user account.
         * </p>
         * 
         * @param userId
         *        The identifier of the user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed to
         * escalate from silent monitoring to barge.
         * </p>
         * 
         * @param allowedMonitorCapabilities
         *        Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed
         *        to escalate from silent monitoring to barge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedMonitorCapabilitiesWithStrings(Collection<String> allowedMonitorCapabilities);

        /**
         * <p>
         * Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed to
         * escalate from silent monitoring to barge.
         * </p>
         * 
         * @param allowedMonitorCapabilities
         *        Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed
         *        to escalate from silent monitoring to barge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedMonitorCapabilitiesWithStrings(String... allowedMonitorCapabilities);

        /**
         * <p>
         * Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed to
         * escalate from silent monitoring to barge.
         * </p>
         * 
         * @param allowedMonitorCapabilities
         *        Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed
         *        to escalate from silent monitoring to barge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedMonitorCapabilities(Collection<MonitorCapability> allowedMonitorCapabilities);

        /**
         * <p>
         * Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed to
         * escalate from silent monitoring to barge.
         * </p>
         * 
         * @param allowedMonitorCapabilities
         *        Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed
         *        to escalate from silent monitoring to barge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedMonitorCapabilities(MonitorCapability... allowedMonitorCapabilities);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String contactId;

        private String userId;

        private List<String> allowedMonitorCapabilities = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitorContactRequest model) {
            super(model);
            instanceId(model.instanceId);
            contactId(model.contactId);
            userId(model.userId);
            allowedMonitorCapabilitiesWithStrings(model.allowedMonitorCapabilities);
            clientToken(model.clientToken);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Collection<String> getAllowedMonitorCapabilities() {
            if (allowedMonitorCapabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedMonitorCapabilities;
        }

        public final void setAllowedMonitorCapabilities(Collection<String> allowedMonitorCapabilities) {
            this.allowedMonitorCapabilities = AllowedMonitorCapabilitiesCopier.copy(allowedMonitorCapabilities);
        }

        @Override
        public final Builder allowedMonitorCapabilitiesWithStrings(Collection<String> allowedMonitorCapabilities) {
            this.allowedMonitorCapabilities = AllowedMonitorCapabilitiesCopier.copy(allowedMonitorCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedMonitorCapabilitiesWithStrings(String... allowedMonitorCapabilities) {
            allowedMonitorCapabilitiesWithStrings(Arrays.asList(allowedMonitorCapabilities));
            return this;
        }

        @Override
        public final Builder allowedMonitorCapabilities(Collection<MonitorCapability> allowedMonitorCapabilities) {
            this.allowedMonitorCapabilities = AllowedMonitorCapabilitiesCopier.copyEnumToString(allowedMonitorCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedMonitorCapabilities(MonitorCapability... allowedMonitorCapabilities) {
            allowedMonitorCapabilities(Arrays.asList(allowedMonitorCapabilities));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MonitorContactRequest build() {
            return new MonitorContactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
