/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrafficDistributionGroupUsersResponse extends ConnectResponse implements
        ToCopyableBuilder<ListTrafficDistributionGroupUsersResponse.Builder, ListTrafficDistributionGroupUsersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTrafficDistributionGroupUsersResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<TrafficDistributionGroupUserSummary>> TRAFFIC_DISTRIBUTION_GROUP_USER_SUMMARY_LIST_FIELD = SdkField
            .<List<TrafficDistributionGroupUserSummary>> builder(MarshallingType.LIST)
            .memberName("TrafficDistributionGroupUserSummaryList")
            .getter(getter(ListTrafficDistributionGroupUsersResponse::trafficDistributionGroupUserSummaryList))
            .setter(setter(Builder::trafficDistributionGroupUserSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("TrafficDistributionGroupUserSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrafficDistributionGroupUserSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrafficDistributionGroupUserSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            TRAFFIC_DISTRIBUTION_GROUP_USER_SUMMARY_LIST_FIELD));

    private final String nextToken;

    private final List<TrafficDistributionGroupUserSummary> trafficDistributionGroupUserSummaryList;

    private ListTrafficDistributionGroupUsersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.trafficDistributionGroupUserSummaryList = builder.trafficDistributionGroupUserSummaryList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrafficDistributionGroupUserSummaryList
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasTrafficDistributionGroupUserSummaryList() {
        return trafficDistributionGroupUserSummaryList != null
                && !(trafficDistributionGroupUserSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of traffic distribution group users.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasTrafficDistributionGroupUserSummaryList} method.
     * </p>
     * 
     * @return A list of traffic distribution group users.
     */
    public final List<TrafficDistributionGroupUserSummary> trafficDistributionGroupUserSummaryList() {
        return trafficDistributionGroupUserSummaryList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasTrafficDistributionGroupUserSummaryList() ? trafficDistributionGroupUserSummaryList()
                        : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficDistributionGroupUsersResponse)) {
            return false;
        }
        ListTrafficDistributionGroupUsersResponse other = (ListTrafficDistributionGroupUsersResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasTrafficDistributionGroupUserSummaryList() == other.hasTrafficDistributionGroupUserSummaryList()
                && Objects.equals(trafficDistributionGroupUserSummaryList(), other.trafficDistributionGroupUserSummaryList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListTrafficDistributionGroupUsersResponse")
                .add("NextToken", nextToken())
                .add("TrafficDistributionGroupUserSummaryList",
                        hasTrafficDistributionGroupUserSummaryList() ? trafficDistributionGroupUserSummaryList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TrafficDistributionGroupUserSummaryList":
            return Optional.ofNullable(clazz.cast(trafficDistributionGroupUserSummaryList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrafficDistributionGroupUsersResponse, T> g) {
        return obj -> g.apply((ListTrafficDistributionGroupUsersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTrafficDistributionGroupUsersResponse> {
        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of traffic distribution group users.
         * </p>
         * 
         * @param trafficDistributionGroupUserSummaryList
         *        A list of traffic distribution group users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficDistributionGroupUserSummaryList(
                Collection<TrafficDistributionGroupUserSummary> trafficDistributionGroupUserSummaryList);

        /**
         * <p>
         * A list of traffic distribution group users.
         * </p>
         * 
         * @param trafficDistributionGroupUserSummaryList
         *        A list of traffic distribution group users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficDistributionGroupUserSummaryList(
                TrafficDistributionGroupUserSummary... trafficDistributionGroupUserSummaryList);

        /**
         * <p>
         * A list of traffic distribution group users.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.TrafficDistributionGroupUserSummary.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.TrafficDistributionGroupUserSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.TrafficDistributionGroupUserSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #trafficDistributionGroupUserSummaryList(List<TrafficDistributionGroupUserSummary>)}.
         * 
         * @param trafficDistributionGroupUserSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.TrafficDistributionGroupUserSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficDistributionGroupUserSummaryList(java.util.Collection<TrafficDistributionGroupUserSummary>)
         */
        Builder trafficDistributionGroupUserSummaryList(
                Consumer<TrafficDistributionGroupUserSummary.Builder>... trafficDistributionGroupUserSummaryList);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<TrafficDistributionGroupUserSummary> trafficDistributionGroupUserSummaryList = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficDistributionGroupUsersResponse model) {
            super(model);
            nextToken(model.nextToken);
            trafficDistributionGroupUserSummaryList(model.trafficDistributionGroupUserSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TrafficDistributionGroupUserSummary.Builder> getTrafficDistributionGroupUserSummaryList() {
            List<TrafficDistributionGroupUserSummary.Builder> result = TrafficDistributionGroupUserSummaryListCopier
                    .copyToBuilder(this.trafficDistributionGroupUserSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrafficDistributionGroupUserSummaryList(
                Collection<TrafficDistributionGroupUserSummary.BuilderImpl> trafficDistributionGroupUserSummaryList) {
            this.trafficDistributionGroupUserSummaryList = TrafficDistributionGroupUserSummaryListCopier
                    .copyFromBuilder(trafficDistributionGroupUserSummaryList);
        }

        @Override
        public final Builder trafficDistributionGroupUserSummaryList(
                Collection<TrafficDistributionGroupUserSummary> trafficDistributionGroupUserSummaryList) {
            this.trafficDistributionGroupUserSummaryList = TrafficDistributionGroupUserSummaryListCopier
                    .copy(trafficDistributionGroupUserSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficDistributionGroupUserSummaryList(
                TrafficDistributionGroupUserSummary... trafficDistributionGroupUserSummaryList) {
            trafficDistributionGroupUserSummaryList(Arrays.asList(trafficDistributionGroupUserSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficDistributionGroupUserSummaryList(
                Consumer<TrafficDistributionGroupUserSummary.Builder>... trafficDistributionGroupUserSummaryList) {
            trafficDistributionGroupUserSummaryList(Stream.of(trafficDistributionGroupUserSummaryList)
                    .map(c -> TrafficDistributionGroupUserSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTrafficDistributionGroupUsersResponse build() {
            return new ListTrafficDistributionGroupUsersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
